/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.mass_spectrometry.spectra;

import com.compomics.util.experiment.biology.ions.Charge;
import com.compomics.util.experiment.biology.ions.impl.ElementaryIon;
import com.compomics.util.experiment.personalization.ExperimentObject;
import java.util.Arrays;
import java.util.stream.Collectors;

public class Precursor
extends ExperimentObject {
    public final double rt;
    public final double mz;
    public final double intensity;
    public final int[] possibleCharges;

    public Precursor() {
        this.rt = Double.NaN;
        this.mz = Double.NaN;
        this.intensity = Double.NaN;
        this.possibleCharges = new int[0];
    }

    public Precursor(double rt, double mz, int[] possibleCharges) {
        this.rt = rt;
        this.mz = mz;
        this.intensity = Double.NaN;
        this.possibleCharges = new int[possibleCharges.length];
        System.arraycopy(possibleCharges, 0, this.possibleCharges, 0, possibleCharges.length);
    }

    public Precursor(double rt, double mz, double intensity, int[] possibleCharges) {
        this.rt = rt;
        this.mz = mz;
        this.intensity = intensity;
        this.possibleCharges = new int[possibleCharges.length];
        System.arraycopy(possibleCharges, 0, this.possibleCharges, 0, possibleCharges.length);
    }

    public Precursor(double mz, double intensity, int[] possibleCharges, double rtMin, double rtMax) {
        this.rt = (rtMin + rtMax) / 2.0;
        this.mz = mz;
        this.intensity = intensity;
        this.possibleCharges = new int[possibleCharges.length];
        System.arraycopy(possibleCharges, 0, this.possibleCharges, 0, possibleCharges.length);
    }

    public double getRtInMinutes() {
        return this.rt / 60.0;
    }

    public String getPossibleChargesAsString() {
        return Arrays.stream(this.possibleCharges).mapToObj(charge -> Charge.toString(charge)).collect(Collectors.joining(", "));
    }

    public double getMass(int chargeValue) {
        return this.mz * (double)chargeValue - (double)chargeValue * ElementaryIon.proton.getTheoreticMass();
    }

    public boolean isSameAs(Precursor otherPrecursor) {
        if (this.possibleCharges.length != otherPrecursor.possibleCharges.length) {
            return false;
        }
        for (int i = 0; i < this.possibleCharges.length; ++i) {
            if (this.possibleCharges[i] == otherPrecursor.possibleCharges[i]) continue;
            return false;
        }
        if (Double.isNaN(this.mz) && !Double.isNaN(otherPrecursor.mz) || !Double.isNaN(this.mz) && Double.isNaN(otherPrecursor.mz) || !Double.isNaN(this.mz) && !Double.isNaN(otherPrecursor.mz) && this.mz != otherPrecursor.mz) {
            return false;
        }
        if (Double.isNaN(this.intensity) && !Double.isNaN(otherPrecursor.intensity) || !Double.isNaN(this.intensity) && Double.isNaN(otherPrecursor.intensity) || !Double.isNaN(this.intensity) && !Double.isNaN(otherPrecursor.intensity) && this.intensity != otherPrecursor.intensity) {
            return false;
        }
        return !(Double.isNaN(this.rt) && !Double.isNaN(otherPrecursor.rt) || !Double.isNaN(this.rt) && Double.isNaN(otherPrecursor.rt)) && (Double.isNaN(this.rt) || Double.isNaN(otherPrecursor.rt) || this.rt == otherPrecursor.rt);
    }
}

