/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui;

import com.compomics.util.experiment.biology.aminoacids.AminoAcid;
import com.compomics.util.experiment.mass_spectrometry.utils.StandardMasses;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class AaMass
extends JDialog {
    private JLabel daLbl;
    private JLabel massLbl;
    private JTextField massTxt;
    private JLabel sequenceLbl;
    private JTextField sequenceTxt;

    public AaMass(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.sequenceLbl = new JLabel();
        this.sequenceTxt = new JTextField();
        this.massLbl = new JLabel();
        this.massTxt = new JTextField();
        this.daLbl = new JLabel();
        this.setDefaultCloseOperation(2);
        this.sequenceLbl.setText("Sequence");
        this.sequenceTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                AaMass.this.sequenceTxtKeyReleased(evt);
            }
        });
        this.massLbl.setText("Mass");
        this.massTxt.setEditable(false);
        this.daLbl.setText("Da");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sequenceLbl).addComponent(this.massLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.massTxt, -1, 300, Short.MAX_VALUE).addComponent(this.sequenceTxt)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.daLbl).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sequenceLbl).addComponent(this.sequenceTxt, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.massLbl).addComponent(this.massTxt, -2, -1, -2).addComponent(this.daLbl)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void sequenceTxtKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.processInput();
        }
    }

    private void processInput() {
        String input = this.sequenceTxt.getText().trim();
        double mass = StandardMasses.h2o.mass + input.chars().mapToDouble(aa -> AminoAcid.getAminoAcid((char)aa).getMonoisotopicMass()).sum();
        this.massTxt.setText(mass + "");
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(AaMass.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(AaMass.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(AaMass.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(AaMass.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AaMass dialog = new AaMass((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

