/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui;

import com.compomics.util.AlternateRowColoursJTable;
import com.compomics.util.gui.JFrameForBytes;
import com.compomics.util.gui.renderers.ByteArrayRenderer;
import com.compomics.util.gui.renderers.TimestampRenderer;
import com.compomics.util.sun.TableSorter;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Timestamp;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JTableForDB
extends AlternateRowColoursJTable {
    Logger logger = LogManager.getLogger(JTableForDB.class);
    private String iDateTimeFormat = "dd-MM-yyyy HH:mm:ss";
    private Vector iFrames = new Vector(5, 2);

    public JTableForDB() {
        this.setRenderers();
    }

    public JTableForDB(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.setRenderers();
    }

    public JTableForDB(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.setRenderers();
    }

    public JTableForDB(TableModel dm) {
        super(dm);
        this.setRenderers();
    }

    public JTableForDB(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.setRenderers();
    }

    public JTableForDB(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
        this.setRenderers();
    }

    public JTableForDB(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.setRenderers();
    }

    public void setDateTimeFormat(String aFormat) {
        this.iDateTimeFormat = aFormat;
    }

    public void setModel(TableModel aModel, boolean aSortable) {
        TableModel tempModel = aModel;
        if (aSortable) {
            TableModel oldModel = super.getModel();
            TableSorter sorter = new TableSorter(aModel);
            if (sorter != null) {
                if (oldModel != null && oldModel instanceof TableSorter) {
                    ((TableSorter)oldModel).removeMouseListenerToHeaderInTable(this);
                }
                sorter.addMouseListenerToHeaderInTable(this);
            }
            tempModel = sorter;
        }
        super.setModel(tempModel);
    }

    @Override
    public void setModel(TableModel aModel) {
        if (aModel != null) {
            this.setModel(aModel, true);
        } else {
            this.setModel(aModel, false);
        }
    }

    private void setRenderers() {
        this.setDefaultRenderer(Timestamp.class, new TimestampRenderer());
        this.setDefaultRenderer(byte[].class, new ByteArrayRenderer());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point compLoc = e.getPoint();
                int col = JTableForDB.this.columnAtPoint(compLoc);
                int row = JTableForDB.this.rowAtPoint(compLoc);
                TableCellRenderer comp = JTableForDB.this.getCellRenderer(row, col);
                if (e.getModifiersEx() == 4096 || e.getModifiersEx() == 2048) {
                    if (JTableForDB.this.rowSelectionAllowed) {
                        JTableForDB.this.setRowSelectionInterval(row, row);
                    } else {
                        JTableForDB.this.setColumnSelectionInterval(row, row);
                    }
                } else if (e.getClickCount() >= 2) {
                    if (comp instanceof ByteArrayRenderer) {
                        int modelCol = JTableForDB.this.convertColumnIndexToModel(col);
                        JFrameForBytes frame = new JFrameForBytes("Display for byte[]", (byte[])JTableForDB.this.getModel().getValueAt(row, modelCol));
                        JTableForDB.this.iFrames.add(frame);
                        frame.setLocation(JTableForDB.this.getLocation().x + 50, JTableForDB.this.getLocation().x + 50);
                        frame.setVisible(true);
                    } else if (JTableForDB.this.getColumnName(col) != null && JTableForDB.this.getColumnName(col).toLowerCase().trim().equalsIgnoreCase("accession")) {
                        String accession = ((String)JTableForDB.this.getValueAt(row, col)).trim();
                        String url = null;
                        String upper = accession.toUpperCase();
                        if (upper.startsWith("Q") || upper.startsWith("O") || upper.startsWith("P")) {
                            url = "http://us.expasy.org/cgi-bin/niceprot.pl?" + accession;
                        } else if (Character.isDigit(accession.charAt(0))) {
                            url = "\"http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=protein&cmd=search&term=" + accession + "\"";
                        } else if (accession.toLowerCase().startsWith("ipi")) {
                            String tempAccession = accession;
                            url = "http://srs.ebi.ac.uk/srsbin/cgi-bin/wgetz?-e+[IPI:'" + tempAccession + "']";
                        }
                        try {
                            Runtime.getRuntime().exec("startIexplore.cmd " + url);
                        }
                        catch (Exception exc) {
                            JTableForDB.this.logger.error(exc.getMessage(), (Throwable)exc);
                            JOptionPane.showMessageDialog((Component)((Object)comp), "Unable to open internet view of selected entry: " + exc.getMessage() + ".", "Unable to open browser window", 0);
                        }
                    }
                }
                super.mouseClicked(e);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isShiftDown() && e.getKeyCode() == 67) {
                    int col = JTableForDB.this.getSelectedColumn();
                    int row = JTableForDB.this.getSelectedRow();
                    if (col >= 0 && row >= 0) {
                        String value = JTableForDB.this.getValueAt(row, col).toString();
                        StringSelection temp = new StringSelection(value);
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(temp, temp);
                    }
                } else {
                    super.keyPressed(e);
                }
            }
        });
    }

    protected void finalize() throws Throwable {
        int liSize = this.iFrames.size();
        for (int i = 0; i < liSize; ++i) {
            JFrame lFrame = (JFrame)this.iFrames.elementAt(i);
            if (lFrame == null) continue;
            lFrame.setVisible(false);
            lFrame.dispose();
        }
        super.finalize();
    }
}

