/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui;

import com.compomics.util.gui.tablemodels.SelfUpdatingTableModel;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JTable;

public class TableMouseWheelListener
implements MouseWheelListener {
    private final JTable table;
    private long lastScrollEvent = System.currentTimeMillis();
    private final int scrollingTableUpdateDelay = 1500;

    public TableMouseWheelListener(JTable table) {
        this.table = table;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        long now = System.currentTimeMillis();
        ((SelfUpdatingTableModel)this.table.getModel()).setIsScrolling(true);
        this.table.revalidate();
        this.table.repaint();
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                long now = System.currentTimeMillis();
                if (now - TableMouseWheelListener.this.lastScrollEvent > 800L) {
                    ((SelfUpdatingTableModel)TableMouseWheelListener.this.table.getModel()).setIsScrolling(false);
                    TableMouseWheelListener.this.table.revalidate();
                    TableMouseWheelListener.this.table.repaint();
                }
            }
        }, 1500L);
        this.lastScrollEvent = now;
    }
}

