/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui;

import com.compomics.util.gui.UtilitiesGUIDefaults;
import com.compomics.util.gui.VennDiagramLegendLocationDialog;
import com.compomics.util.gui.VennDiagramPanel;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.export.graphics.ExportGraphicsDialog;
import com.compomics.util.io.file.LastSelectedFolder;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class VennDiagramDialog
extends JDialog {
    private final Frame dialogParent;
    private LastSelectedFolder lastSelectedFolder;
    private final Image normalIcon;
    private final Image waitingIcon;
    private VennDiagramPanel vennDiagramPanel;
    private JPanel backgroundPanel;
    private JPanel contextMenuPlotBackgroundPanel;
    private JPanel dataPanel;
    private JPanel datasetAColorJPanel;
    private JScrollPane datasetAScrollPane;
    private JTextArea datasetATextArea;
    private JTextField datasetATextField;
    private JPanel datasetBColorJPanel;
    private JScrollPane datasetBScrollPane;
    private JTextArea datasetBTextArea;
    private JTextField datasetBTextField;
    private JPanel datasetCColorJPanel;
    private JScrollPane datasetCScrollPane;
    private JTextArea datasetCTextArea;
    private JTextField datasetCTextField;
    private JPanel datasetDColorJPanel;
    private JScrollPane datasetDScrollPane;
    private JTextArea datasetDTextArea;
    private JTextField datasetDTextField;
    private JMenuItem exportPlotMenuItem;
    private JMenu fontSizeMenu;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JCheckBoxMenuItem legendCheckBoxMenuItem;
    private JMenuItem legendFontSizeMenuItem;
    private JMenuItem legendLocationMenuItem;
    private JButton plotHelpJButton;
    private JLayeredPane plotLayeredPane;
    private JButton plotOptionsJButton;
    private JPopupMenu plotPopupMenu;
    private JMenuItem valueFontSizeMenuItem;
    private JPanel xyPlotPanel;

    public VennDiagramDialog(Frame dialogParent, Image normalIcon, Image waitingIcon, boolean modal) {
        super(dialogParent, modal);
        this.initComponents();
        this.dialogParent = dialogParent;
        this.normalIcon = normalIcon;
        this.waitingIcon = waitingIcon;
        int alphaLevel = 150;
        this.datasetAColorJPanel.setBackground(new Color(0, 0, 255, alphaLevel));
        this.datasetBColorJPanel.setBackground(new Color(0, 255, 0, alphaLevel));
        this.datasetCColorJPanel.setBackground(new Color(255, 255, 0, alphaLevel));
        this.datasetDColorJPanel.setBackground(new Color(255, 0, 0, alphaLevel));
        this.setUpGUI();
        this.setLocationRelativeTo(dialogParent);
        this.plotLayeredPaneComponentResized(null);
        this.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            UtilitiesGUIDefaults.setLookAndFeel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        new VennDiagramDialog((Frame)new JFrame(), null, null, true);
    }

    private void setUpGUI() {
        String datasetD;
        String datasetC;
        String datasetB;
        ArrayList<String> a = new ArrayList<String>();
        ArrayList<String> b = new ArrayList<String>();
        ArrayList<String> c = new ArrayList<String>();
        ArrayList<String> d = new ArrayList<String>();
        String datasetA = this.datasetATextArea.getText();
        if (datasetA.trim().length() > 0) {
            String[] lines = datasetA.split("\n");
            a.addAll(Arrays.asList(lines));
        }
        if ((datasetB = this.datasetBTextArea.getText()).trim().length() > 0) {
            String[] lines = datasetB.split("\n");
            b.addAll(Arrays.asList(lines));
        }
        if ((datasetC = this.datasetCTextArea.getText()).trim().length() > 0) {
            String[] lines = datasetC.split("\n");
            c.addAll(Arrays.asList(lines));
        }
        if ((datasetD = this.datasetDTextArea.getText()).trim().length() > 0) {
            String[] lines = datasetD.split("\n");
            d.addAll(Arrays.asList(lines));
        }
        this.vennDiagramPanel = new VennDiagramPanel(a, b, c, d, this.datasetATextField.getText(), this.datasetBTextField.getText(), this.datasetCTextField.getText(), this.datasetDTextField.getText(), this.datasetAColorJPanel.getBackground(), this.datasetBColorJPanel.getBackground(), this.datasetCColorJPanel.getBackground(), this.datasetDColorJPanel.getBackground());
        this.xyPlotPanel.removeAll();
        this.xyPlotPanel.add(this.vennDiagramPanel);
    }

    private void initComponents() {
        this.plotPopupMenu = new JPopupMenu();
        this.exportPlotMenuItem = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.legendCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.legendLocationMenuItem = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.fontSizeMenu = new JMenu();
        this.valueFontSizeMenuItem = new JMenuItem();
        this.legendFontSizeMenuItem = new JMenuItem();
        this.backgroundPanel = new JPanel();
        this.plotLayeredPane = new JLayeredPane();
        this.xyPlotPanel = new JPanel();
        this.plotOptionsJButton = new JButton();
        this.plotHelpJButton = new JButton();
        this.contextMenuPlotBackgroundPanel = new JPanel();
        this.dataPanel = new JPanel();
        this.datasetAScrollPane = new JScrollPane();
        this.datasetATextArea = new JTextArea();
        this.datasetBScrollPane = new JScrollPane();
        this.datasetBTextArea = new JTextArea();
        this.datasetCScrollPane = new JScrollPane();
        this.datasetCTextArea = new JTextArea();
        this.datasetDScrollPane = new JScrollPane();
        this.datasetDTextArea = new JTextArea();
        this.datasetATextField = new JTextField();
        this.datasetBTextField = new JTextField();
        this.datasetCTextField = new JTextField();
        this.datasetDTextField = new JTextField();
        this.datasetAColorJPanel = new JPanel();
        this.datasetBColorJPanel = new JPanel();
        this.datasetCColorJPanel = new JPanel();
        this.datasetDColorJPanel = new JPanel();
        this.exportPlotMenuItem.setText("Export");
        this.exportPlotMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VennDiagramDialog.this.exportPlotMenuItemActionPerformed(evt);
            }
        });
        this.plotPopupMenu.add(this.exportPlotMenuItem);
        this.plotPopupMenu.add(this.jSeparator1);
        this.legendCheckBoxMenuItem.setSelected(true);
        this.legendCheckBoxMenuItem.setText("Show Legend");
        this.legendCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VennDiagramDialog.this.legendCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.plotPopupMenu.add(this.legendCheckBoxMenuItem);
        this.legendLocationMenuItem.setText("Legend Location");
        this.legendLocationMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VennDiagramDialog.this.legendLocationMenuItemActionPerformed(evt);
            }
        });
        this.plotPopupMenu.add(this.legendLocationMenuItem);
        this.plotPopupMenu.add(this.jSeparator2);
        this.fontSizeMenu.setText("Font Size");
        this.valueFontSizeMenuItem.setText("Values");
        this.valueFontSizeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VennDiagramDialog.this.valueFontSizeMenuItemActionPerformed(evt);
            }
        });
        this.fontSizeMenu.add(this.valueFontSizeMenuItem);
        this.legendFontSizeMenuItem.setText("Legend");
        this.legendFontSizeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VennDiagramDialog.this.legendFontSizeMenuItemActionPerformed(evt);
            }
        });
        this.fontSizeMenu.add(this.legendFontSizeMenuItem);
        this.plotPopupMenu.add(this.fontSizeMenu);
        this.setDefaultCloseOperation(2);
        this.setTitle("Statistics");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                VennDiagramDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(255, 255, 255));
        this.backgroundPanel.setPreferredSize(new Dimension(600, 600));
        this.plotLayeredPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                VennDiagramDialog.this.plotLayeredPaneComponentResized(evt);
            }
        });
        this.xyPlotPanel.setBorder(BorderFactory.createTitledBorder("Venn Diagram"));
        this.xyPlotPanel.setOpaque(false);
        this.xyPlotPanel.setLayout(new BoxLayout(this.xyPlotPanel, 1));
        this.plotLayeredPane.add(this.xyPlotPanel);
        this.xyPlotPanel.setBounds(0, 0, 580, 360);
        this.plotOptionsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/contextual_menu_gray.png")));
        this.plotOptionsJButton.setToolTipText("Plot Options");
        this.plotOptionsJButton.setBorder(null);
        this.plotOptionsJButton.setBorderPainted(false);
        this.plotOptionsJButton.setContentAreaFilled(false);
        this.plotOptionsJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/contextual_menu_black.png")));
        this.plotOptionsJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                VennDiagramDialog.this.plotOptionsJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                VennDiagramDialog.this.plotOptionsJButtonMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                VennDiagramDialog.this.plotOptionsJButtonMouseReleased(evt);
            }
        });
        this.plotLayeredPane.add(this.plotOptionsJButton);
        this.plotOptionsJButton.setBounds(550, 5, 10, 19);
        this.plotLayeredPane.setLayer(this.plotOptionsJButton, JLayeredPane.POPUP_LAYER);
        this.plotHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.plotHelpJButton.setToolTipText("Help");
        this.plotHelpJButton.setBorder(null);
        this.plotHelpJButton.setBorderPainted(false);
        this.plotHelpJButton.setContentAreaFilled(false);
        this.plotHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.plotHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                VennDiagramDialog.this.plotHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                VennDiagramDialog.this.plotHelpJButtonMouseExited(evt);
            }
        });
        this.plotHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VennDiagramDialog.this.plotHelpJButtonActionPerformed(evt);
            }
        });
        this.plotLayeredPane.add(this.plotHelpJButton);
        this.plotHelpJButton.setBounds(570, 0, 10, 19);
        this.plotLayeredPane.setLayer(this.plotHelpJButton, JLayeredPane.POPUP_LAYER);
        this.contextMenuPlotBackgroundPanel.setBackground(new Color(255, 255, 255));
        GroupLayout contextMenuPlotBackgroundPanelLayout = new GroupLayout(this.contextMenuPlotBackgroundPanel);
        this.contextMenuPlotBackgroundPanel.setLayout(contextMenuPlotBackgroundPanelLayout);
        contextMenuPlotBackgroundPanelLayout.setHorizontalGroup(contextMenuPlotBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 30, Short.MAX_VALUE));
        contextMenuPlotBackgroundPanelLayout.setVerticalGroup(contextMenuPlotBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.plotLayeredPane.add(this.contextMenuPlotBackgroundPanel);
        this.contextMenuPlotBackgroundPanel.setBounds(550, 0, 30, 19);
        this.plotLayeredPane.setLayer(this.contextMenuPlotBackgroundPanel, JLayeredPane.POPUP_LAYER);
        this.dataPanel.setBorder(BorderFactory.createTitledBorder("Data"));
        this.dataPanel.setOpaque(false);
        this.datasetATextArea.setTabSize(4);
        this.datasetATextArea.setText("1\n2\n3\n4\n5");
        this.datasetATextArea.setToolTipText("");
        this.datasetATextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                VennDiagramDialog.this.datasetATextAreaKeyReleased(evt);
            }
        });
        this.datasetAScrollPane.setViewportView(this.datasetATextArea);
        this.datasetBTextArea.setTabSize(4);
        this.datasetBTextArea.setText("3\n5\n6");
        this.datasetBTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                VennDiagramDialog.this.datasetBTextAreaKeyReleased(evt);
            }
        });
        this.datasetBScrollPane.setViewportView(this.datasetBTextArea);
        this.datasetCTextArea.setColumns(2);
        this.datasetCTextArea.setTabSize(4);
        this.datasetCTextArea.setText("3\n6\n7");
        this.datasetCTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                VennDiagramDialog.this.datasetCTextAreaKeyReleased(evt);
            }
        });
        this.datasetCScrollPane.setViewportView(this.datasetCTextArea);
        this.datasetDTextArea.setColumns(2);
        this.datasetDTextArea.setTabSize(4);
        this.datasetDTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                VennDiagramDialog.this.datasetDTextAreaKeyReleased(evt);
            }
        });
        this.datasetDScrollPane.setViewportView(this.datasetDTextArea);
        this.datasetATextField.setText("Dataset A");
        this.datasetATextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                VennDiagramDialog.this.datasetATextFieldKeyReleased(evt);
            }
        });
        this.datasetBTextField.setText("Dataset B");
        this.datasetBTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                VennDiagramDialog.this.datasetBTextFieldKeyReleased(evt);
            }
        });
        this.datasetCTextField.setText("Dataset C");
        this.datasetCTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                VennDiagramDialog.this.datasetCTextFieldKeyReleased(evt);
            }
        });
        this.datasetDTextField.setText("Dataset D");
        this.datasetDTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                VennDiagramDialog.this.datasetDTextFieldKeyReleased(evt);
            }
        });
        this.datasetAColorJPanel.setBackground(new Color(0, 0, 255));
        this.datasetAColorJPanel.setBorder(BorderFactory.createEtchedBorder());
        this.datasetAColorJPanel.setToolTipText("The color used for Peptide A");
        this.datasetAColorJPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                VennDiagramDialog.this.datasetAColorJPanelMouseClicked(evt);
            }
        });
        GroupLayout datasetAColorJPanelLayout = new GroupLayout(this.datasetAColorJPanel);
        this.datasetAColorJPanel.setLayout(datasetAColorJPanelLayout);
        datasetAColorJPanelLayout.setHorizontalGroup(datasetAColorJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 13, Short.MAX_VALUE));
        datasetAColorJPanelLayout.setVerticalGroup(datasetAColorJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 12, Short.MAX_VALUE));
        this.datasetBColorJPanel.setBackground(new Color(0, 255, 0));
        this.datasetBColorJPanel.setBorder(BorderFactory.createEtchedBorder());
        this.datasetBColorJPanel.setToolTipText("The color used for Peptide A");
        this.datasetBColorJPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                VennDiagramDialog.this.datasetBColorJPanelMouseClicked(evt);
            }
        });
        GroupLayout datasetBColorJPanelLayout = new GroupLayout(this.datasetBColorJPanel);
        this.datasetBColorJPanel.setLayout(datasetBColorJPanelLayout);
        datasetBColorJPanelLayout.setHorizontalGroup(datasetBColorJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 13, Short.MAX_VALUE));
        datasetBColorJPanelLayout.setVerticalGroup(datasetBColorJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 12, Short.MAX_VALUE));
        this.datasetCColorJPanel.setBackground(new Color(255, 255, 0));
        this.datasetCColorJPanel.setBorder(BorderFactory.createEtchedBorder());
        this.datasetCColorJPanel.setToolTipText("The color used for Peptide A");
        this.datasetCColorJPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                VennDiagramDialog.this.datasetCColorJPanelMouseClicked(evt);
            }
        });
        GroupLayout datasetCColorJPanelLayout = new GroupLayout(this.datasetCColorJPanel);
        this.datasetCColorJPanel.setLayout(datasetCColorJPanelLayout);
        datasetCColorJPanelLayout.setHorizontalGroup(datasetCColorJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 13, Short.MAX_VALUE));
        datasetCColorJPanelLayout.setVerticalGroup(datasetCColorJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 12, Short.MAX_VALUE));
        this.datasetDColorJPanel.setBackground(new Color(255, 0, 0));
        this.datasetDColorJPanel.setBorder(BorderFactory.createEtchedBorder());
        this.datasetDColorJPanel.setToolTipText("The color used for Peptide A");
        this.datasetDColorJPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                VennDiagramDialog.this.datasetDColorJPanelMouseClicked(evt);
            }
        });
        GroupLayout datasetDColorJPanelLayout = new GroupLayout(this.datasetDColorJPanel);
        this.datasetDColorJPanel.setLayout(datasetDColorJPanelLayout);
        datasetDColorJPanelLayout.setHorizontalGroup(datasetDColorJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 13, Short.MAX_VALUE));
        datasetDColorJPanelLayout.setVerticalGroup(datasetDColorJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 12, Short.MAX_VALUE));
        GroupLayout dataPanelLayout = new GroupLayout(this.dataPanel);
        this.dataPanel.setLayout(dataPanelLayout);
        dataPanelLayout.setHorizontalGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dataPanelLayout.createSequentialGroup().addContainerGap().addGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.datasetAScrollPane).addGroup(dataPanelLayout.createSequentialGroup().addComponent(this.datasetATextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.datasetAColorJPanel, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.datasetBScrollPane).addGroup(dataPanelLayout.createSequentialGroup().addComponent(this.datasetBTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.datasetBColorJPanel, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.datasetCScrollPane).addGroup(dataPanelLayout.createSequentialGroup().addComponent(this.datasetCTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.datasetCColorJPanel, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.datasetDScrollPane).addGroup(dataPanelLayout.createSequentialGroup().addComponent(this.datasetDTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.datasetDColorJPanel, -2, -1, -2))).addContainerGap()));
        dataPanelLayout.setVerticalGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dataPanelLayout.createSequentialGroup().addContainerGap().addGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.datasetATextField).addComponent(this.datasetAColorJPanel, -2, -1, -2).addComponent(this.datasetBTextField).addComponent(this.datasetCTextField).addComponent(this.datasetDTextField).addComponent(this.datasetBColorJPanel, -2, -1, -2).addComponent(this.datasetCColorJPanel, -2, -1, -2).addComponent(this.datasetDColorJPanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.datasetAScrollPane, -2, 137, -2).addComponent(this.datasetBScrollPane, -2, 137, -2).addComponent(this.datasetCScrollPane, -2, 137, -2).addComponent(this.datasetDScrollPane, GroupLayout.Alignment.TRAILING, -2, 137, -2)).addContainerGap()));
        dataPanelLayout.linkSize(1, this.datasetATextField, this.datasetBTextField, this.datasetCTextField, this.datasetDTextField);
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.plotLayeredPane, -1, 580, Short.MAX_VALUE).addComponent(this.dataPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.plotLayeredPane, -1, 364, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataPanel, -2, -1, -2).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        this.pack();
    }

    private void plotOptionsJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void plotOptionsJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void plotOptionsJButtonMouseReleased(MouseEvent evt) {
        this.plotPopupMenu.show(this.plotOptionsJButton, evt.getX(), evt.getY());
    }

    private void exportPlotMenuItemActionPerformed(ActionEvent evt) {
        new ExportGraphicsDialog((JDialog)this, this.getNormalIcon(), this.getWaitingIcon(), true, this.vennDiagramPanel.getChartPanel(), this.lastSelectedFolder);
    }

    private void plotHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void plotHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void plotHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, this.getClass().getResource("/helpFiles/VennDiagramDialog.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), "Statistics - Help");
        this.setCursor(new Cursor(0));
    }

    private void formWindowClosing(WindowEvent evt) {
        System.exit(0);
    }

    private void plotLayeredPaneComponentResized(ComponentEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VennDiagramDialog.this.plotLayeredPane.getComponent(0).setBounds(VennDiagramDialog.this.plotLayeredPane.getWidth() - VennDiagramDialog.this.plotLayeredPane.getComponent(0).getWidth() - 22, -2, VennDiagramDialog.this.plotLayeredPane.getComponent(0).getWidth(), VennDiagramDialog.this.plotLayeredPane.getComponent(0).getHeight());
                VennDiagramDialog.this.plotLayeredPane.getComponent(1).setBounds(VennDiagramDialog.this.plotLayeredPane.getWidth() - VennDiagramDialog.this.plotLayeredPane.getComponent(1).getWidth() - 10, -4, VennDiagramDialog.this.plotLayeredPane.getComponent(1).getWidth(), VennDiagramDialog.this.plotLayeredPane.getComponent(1).getHeight());
                VennDiagramDialog.this.plotLayeredPane.getComponent(2).setBounds(VennDiagramDialog.this.plotLayeredPane.getWidth() - VennDiagramDialog.this.plotLayeredPane.getComponent(2).getWidth() - 5, -3, VennDiagramDialog.this.plotLayeredPane.getComponent(2).getWidth(), VennDiagramDialog.this.plotLayeredPane.getComponent(2).getHeight());
                VennDiagramDialog.this.plotLayeredPane.getComponent(3).setBounds(0, 0, VennDiagramDialog.this.plotLayeredPane.getWidth(), VennDiagramDialog.this.plotLayeredPane.getHeight());
                if (VennDiagramDialog.this.vennDiagramPanel != null) {
                    VennDiagramDialog.this.vennDiagramPanel.resizePlot(VennDiagramDialog.this.plotLayeredPane.getWidth(), VennDiagramDialog.this.plotLayeredPane.getHeight());
                }
                VennDiagramDialog.this.plotLayeredPane.revalidate();
                VennDiagramDialog.this.plotLayeredPane.repaint();
            }
        });
    }

    private void datasetATextAreaKeyReleased(KeyEvent evt) {
        this.setUpGUI();
        this.vennDiagramPanel.updatePlot();
        this.plotLayeredPaneComponentResized(null);
    }

    private void datasetCTextAreaKeyReleased(KeyEvent evt) {
        this.datasetATextAreaKeyReleased(null);
    }

    private void datasetDTextAreaKeyReleased(KeyEvent evt) {
        this.datasetATextAreaKeyReleased(null);
    }

    private void datasetATextFieldKeyReleased(KeyEvent evt) {
        this.datasetATextAreaKeyReleased(null);
    }

    private void datasetBTextFieldKeyReleased(KeyEvent evt) {
        this.datasetATextAreaKeyReleased(null);
    }

    private void datasetCTextFieldKeyReleased(KeyEvent evt) {
        this.datasetATextAreaKeyReleased(null);
    }

    private void datasetDTextFieldKeyReleased(KeyEvent evt) {
        this.datasetATextAreaKeyReleased(null);
    }

    private void datasetAColorJPanelMouseClicked(MouseEvent evt) {
        Color newColor = JColorChooser.showDialog(this, "Pick a Color", this.datasetAColorJPanel.getBackground());
        if (newColor != null) {
            this.datasetAColorJPanel.setBackground(newColor);
            this.vennDiagramPanel.updatePlot();
        }
    }

    private void datasetBColorJPanelMouseClicked(MouseEvent evt) {
        Color newColor = JColorChooser.showDialog(this, "Pick a Color", this.datasetBColorJPanel.getBackground());
        if (newColor != null) {
            this.datasetBColorJPanel.setBackground(newColor);
            this.vennDiagramPanel.updatePlot();
        }
    }

    private void datasetCColorJPanelMouseClicked(MouseEvent evt) {
        Color newColor = JColorChooser.showDialog(this, "Pick a Color", this.datasetCColorJPanel.getBackground());
        if (newColor != null) {
            this.datasetCColorJPanel.setBackground(newColor);
            this.vennDiagramPanel.updatePlot();
        }
    }

    private void datasetDColorJPanelMouseClicked(MouseEvent evt) {
        Color newColor = JColorChooser.showDialog(this, "Pick a Color", this.datasetDColorJPanel.getBackground());
        if (newColor != null) {
            this.datasetDColorJPanel.setBackground(newColor);
            this.vennDiagramPanel.updatePlot();
        }
    }

    private void legendCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.vennDiagramPanel.setShowLegend(this.legendCheckBoxMenuItem.isSelected());
        this.vennDiagramPanel.updatePlot();
    }

    private void valueFontSizeMenuItemActionPerformed(ActionEvent evt) {
        String value = JOptionPane.showInputDialog(this, "Values Font Size:", this.vennDiagramPanel.getFontSize());
        if (value != null) {
            try {
                this.vennDiagramPanel.setFontSize(Integer.parseInt(value));
                this.vennDiagramPanel.updatePlot();
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "Font size has to be an integer!", "Font Error", 1);
            }
        }
    }

    private void legendFontSizeMenuItemActionPerformed(ActionEvent evt) {
        String value = JOptionPane.showInputDialog(this, "Legend Font Size:", this.vennDiagramPanel.getFontSizeLegend());
        if (value != null) {
            try {
                this.vennDiagramPanel.setFontSizeLegend(Integer.parseInt(value));
                this.vennDiagramPanel.updatePlot();
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "Font size has to be an integer!", "Font Error", 1);
            }
        }
    }

    private void datasetBTextAreaKeyReleased(KeyEvent evt) {
        this.datasetATextAreaKeyReleased(null);
    }

    private void legendLocationMenuItemActionPerformed(ActionEvent evt) {
        new VennDiagramLegendLocationDialog(this, true);
    }

    public void setSelectedExportFolder(LastSelectedFolder selectedFolder) {
        this.lastSelectedFolder = selectedFolder;
    }

    public LastSelectedFolder getDefaultExportFolder() {
        return this.lastSelectedFolder;
    }

    public Image getNormalIcon() {
        return Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/compomics-utilities.png"));
    }

    public Image getWaitingIcon() {
        return Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/compomics-utilities.png"));
    }

    public VennDiagramPanel getVennDiagramPanel() {
        return this.vennDiagramPanel;
    }
}

