/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.atoms;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.atoms.Atom;
import com.compomics.util.gui.atoms.AtomChainDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AtomPanel
extends JPanel {
    private HashMap<String, Integer> isotopesMap;
    private final AtomChainDialog atomChainDialog;
    private final int panelIndex;
    private JLabel addLabel;
    private JComboBox atomCmb;
    private JComboBox isotopeCmb;
    private JSpinner occurenceSpinner;
    private JLabel removeLabel;

    public AtomPanel(AtomChainDialog atomChainDialog, Atom atom, int isotope, int occurrence, int panelIndex, boolean addOnly) {
        this.initComponents();
        this.atomChainDialog = atomChainDialog;
        this.panelIndex = panelIndex;
        this.atomCmb.setModel(new DefaultComboBoxModel<String>(Atom.getImplementedAtoms(true)));
        this.updateIsotopes();
        if (addOnly) {
            ((SpinnerNumberModel)this.occurenceSpinner.getModel()).setMinimum(Integer.valueOf(0));
        }
        this.updateSelection(atom, isotope, occurrence);
        this.atomCmb.setRenderer(new AlignedListCellRenderer(0));
        this.isotopeCmb.setRenderer(new AlignedListCellRenderer(0));
    }

    private void updateSelection(Atom atom, int isotope, int occurrence) {
        if (atom != null) {
            this.atomCmb.setSelectedItem(atom.getLetter());
            this.updateIsotopes();
            for (String istopeString : this.isotopesMap.keySet()) {
                if (this.isotopesMap.get(istopeString) != isotope) continue;
                this.isotopeCmb.setSelectedItem(istopeString);
            }
            this.occurenceSpinner.setValue(occurrence);
            this.atomChainDialog.updateAtomComposition();
        }
    }

    private void updateIsotopes() {
        if (this.atomCmb.getSelectedIndex() != 0) {
            String atomShortName = (String)this.atomCmb.getSelectedItem();
            Atom atom = Atom.getAtom(atomShortName);
            ArrayList<Integer> isotopesList = atom.getImplementedIsotopes();
            Collections.sort(isotopesList);
            this.isotopesMap = new HashMap(isotopesList.size());
            String[] itemsArray = new String[isotopesList.size()];
            int zeroIndex = 0;
            for (int i = 0; i < isotopesList.size(); ++i) {
                String isotopeName;
                Integer isotope = isotopesList.get(i);
                if (isotope == 0) {
                    zeroIndex = i;
                    isotopeName = "0";
                } else {
                    isotopeName = isotope > 0 ? "+" + isotope : isotope + "";
                }
                Double mass = atom.getIsotopeMass(isotope);
                mass = Util.roundDouble(mass, 2);
                String display = isotopeName + " (" + mass + " Da)";
                this.isotopesMap.put(display, isotope);
                itemsArray[i] = display;
            }
            this.isotopeCmb.setModel(new DefaultComboBoxModel<String>(itemsArray));
            this.isotopeCmb.setSelectedIndex(zeroIndex);
        } else {
            String[] itemsArray = new String[]{"- Select -"};
            this.isotopeCmb.setModel(new DefaultComboBoxModel<String>(itemsArray));
        }
        this.isotopeCmb.setEnabled(this.atomCmb.getSelectedIndex() != 0);
        this.occurenceSpinner.setEnabled(this.atomCmb.getSelectedIndex() != 0);
    }

    public Atom getAtom() {
        if (this.atomCmb.getSelectedIndex() > 0) {
            return Atom.getAtom((String)this.atomCmb.getSelectedItem());
        }
        return null;
    }

    public Integer getIsotope() {
        if (!((String)this.isotopeCmb.getSelectedItem()).equals("- Select -")) {
            return this.isotopesMap.get((String)this.isotopeCmb.getSelectedItem());
        }
        return null;
    }

    public int getOccurrence() {
        return (Integer)this.occurenceSpinner.getValue();
    }

    private void initComponents() {
        this.atomCmb = new JComboBox();
        this.isotopeCmb = new JComboBox();
        this.occurenceSpinner = new JSpinner();
        this.removeLabel = new JLabel();
        this.addLabel = new JLabel();
        this.setOpaque(false);
        this.atomCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.atomCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AtomPanel.this.atomCmbActionPerformed(evt);
            }
        });
        this.isotopeCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.isotopeCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AtomPanel.this.isotopeCmbActionPerformed(evt);
            }
        });
        this.occurenceSpinner.setModel(new SpinnerNumberModel((Number)1, null, null, (Number)1));
        this.occurenceSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                AtomPanel.this.occurenceSpinnerStateChanged(evt);
            }
        });
        this.removeLabel.setText("<html><a href>Remove</a></html>");
        this.removeLabel.setToolTipText("Remove the row");
        this.removeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                AtomPanel.this.removeLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                AtomPanel.this.removeLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                AtomPanel.this.removeLabelMouseReleased(evt);
            }
        });
        this.addLabel.setText("<html><a href>Add Row</a></html>");
        this.addLabel.setToolTipText("Add a new row");
        this.addLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                AtomPanel.this.addLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                AtomPanel.this.addLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                AtomPanel.this.addLabelMouseReleased(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.atomCmb, -2, 116, -2).addGap(18, 18, 18).addComponent(this.isotopeCmb, -2, 103, -2).addGap(18, 18, 18).addComponent(this.occurenceSpinner, -2, 90, -2).addGap(18, 18, 18).addComponent(this.addLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeLabel, -2, -1, -2)));
        layout.linkSize(0, this.atomCmb, this.isotopeCmb, this.occurenceSpinner);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.atomCmb, -2, -1, -2).addComponent(this.isotopeCmb, -2, -1, -2).addComponent(this.occurenceSpinner, -2, -1, -2).addComponent(this.removeLabel, -2, -1, -2).addComponent(this.addLabel, -2, -1, -2)));
    }

    private void atomCmbActionPerformed(ActionEvent evt) {
        this.updateIsotopes();
        this.atomChainDialog.updateAtomComposition();
    }

    private void isotopeCmbActionPerformed(ActionEvent evt) {
        this.atomChainDialog.updateAtomComposition();
    }

    private void addLabelMouseReleased(MouseEvent evt) {
        this.atomChainDialog.addElementsPanel();
    }

    private void removeLabelMouseReleased(MouseEvent evt) {
        this.atomChainDialog.removeElementsPanel(this.panelIndex);
    }

    private void occurenceSpinnerStateChanged(ChangeEvent evt) {
        this.atomChainDialog.updateAtomComposition();
    }

    private void addLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void addLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void removeLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void removeLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    public int getPanelIndex() {
        return this.panelIndex;
    }
}

