/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.file_handling;

import com.compomics.util.gui.file_handling.FileAndFileFilter;
import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class FileChooserUtil {
    public static File getUserSelectedFile(Component parent, String aFileEnding, String aFileFormatDescription, String aDialogTitle, String lastSelectedFolder, String aSuggestedFileName, boolean openDialog) {
        int returnVal;
        final String fileEnding = aFileEnding;
        final String fileFormatDescription = aFileFormatDescription;
        JFileChooser fileChooser = new JFileChooser(lastSelectedFolder);
        fileChooser.setDialogTitle(aDialogTitle);
        fileChooser.setMultiSelectionEnabled(false);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                return myFile.getName().toLowerCase().endsWith(fileEnding) || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return fileFormatDescription;
            }
        };
        fileChooser.setFileFilter(filter);
        if (openDialog) {
            returnVal = fileChooser.showOpenDialog(parent);
        } else {
            if (aSuggestedFileName != null) {
                fileChooser.setSelectedFile(new File(lastSelectedFolder, aSuggestedFileName));
            }
            returnVal = fileChooser.showSaveDialog(parent);
        }
        if (returnVal == 0) {
            String selectedFile = fileChooser.getSelectedFile().getPath();
            if (!openDialog && !selectedFile.endsWith(fileEnding)) {
                selectedFile = selectedFile + fileEnding;
            }
            File newFile = new File(selectedFile);
            int outcome = 0;
            if (!openDialog && newFile.exists()) {
                outcome = JOptionPane.showConfirmDialog(parent, "Should " + selectedFile + " be overwritten?", "Selected File Already Exists", 0, 2);
            } else if (openDialog && !newFile.exists()) {
                JOptionPane.showMessageDialog(parent, "The file '" + newFile.getAbsolutePath() + "' does not exist!", "File Not Found.", 0);
                return null;
            }
            if (outcome != 0) {
                return null;
            }
            return newFile;
        }
        return null;
    }

    public static FileAndFileFilter getUserSelectedFile(Component parent, String[] fileEndings, String[] fileFormatDescriptions, String aDialogTitle, String lastSelectedFolder, String aSuggestedFileName, boolean openDialog, boolean formatSelectedByUser, boolean showAllFilesOption, int defaultFilterIndex) {
        int returnVal;
        JFileChooser fileChooser = new JFileChooser(lastSelectedFolder);
        fileChooser.setDialogTitle(aDialogTitle);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setAcceptAllFileFilterUsed(showAllFilesOption);
        if (formatSelectedByUser) {
            for (int i = 0; i < fileEndings.length; ++i) {
                final String fileEnding = fileEndings[i];
                String description = "";
                if (i < fileFormatDescriptions.length && fileFormatDescriptions[i] != null) {
                    description = fileFormatDescriptions[i];
                }
                final String filterDescription = description;
                FileFilter filter = new FileFilter(){

                    @Override
                    public boolean accept(File myFile) {
                        return myFile.getName().toLowerCase().endsWith(fileEnding) || myFile.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return filterDescription;
                    }
                };
                fileChooser.addChoosableFileFilter(filter);
                if (i != defaultFilterIndex) continue;
                fileChooser.setFileFilter(filter);
            }
        } else {
            final String[] filterExtensionList = (String[])fileEndings.clone();
            String description = "";
            for (int i = 0; i < fileEndings.length; ++i) {
                if (i < fileFormatDescriptions.length && fileFormatDescriptions[i] != null) {
                    if (!description.equals("")) {
                        description = description + ", ";
                    }
                    description = description + fileFormatDescriptions[i];
                    continue;
                }
                if (!description.equals("")) {
                    description = description + ", ";
                }
                description = description + "Unkown";
            }
            final String filterDescription = description;
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File myFile) {
                    if (myFile.isDirectory()) {
                        return true;
                    }
                    for (String fileEnding : filterExtensionList) {
                        if (!myFile.getName().toLowerCase().endsWith(fileEnding)) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public String getDescription() {
                    return filterDescription;
                }
            };
            fileChooser.setFileFilter(filter);
        }
        if (openDialog) {
            returnVal = fileChooser.showOpenDialog(parent);
        } else {
            if (aSuggestedFileName != null) {
                fileChooser.setSelectedFile(new File(lastSelectedFolder, aSuggestedFileName));
            }
            returnVal = fileChooser.showSaveDialog(parent);
        }
        if (returnVal == 0) {
            String selectedFile = fileChooser.getSelectedFile().getPath();
            String fileFormatDescription = fileChooser.getFileFilter().getDescription();
            String wantedFileEnding = null;
            for (int i = 0; i < fileFormatDescriptions.length && wantedFileEnding == null; ++i) {
                if (!fileFormatDescriptions[i].equalsIgnoreCase(fileFormatDescription)) continue;
                wantedFileEnding = fileEndings[i];
            }
            if (!openDialog && !selectedFile.endsWith(wantedFileEnding)) {
                selectedFile = selectedFile + wantedFileEnding;
            }
            File newFile = new File(selectedFile);
            int outcome = 0;
            if (!openDialog && newFile.exists()) {
                outcome = JOptionPane.showConfirmDialog(parent, "Should " + selectedFile + " be overwritten?", "Selected File Already Exists", 0, 2);
            } else if (openDialog && !newFile.exists()) {
                JOptionPane.showMessageDialog(parent, "The file'" + newFile.getAbsolutePath() + "' does not exist!", "File Not Found.", 0);
                return null;
            }
            if (outcome != 0) {
                return null;
            }
            return new FileAndFileFilter(newFile, fileChooser.getFileFilter());
        }
        return null;
    }

    public static File getUserSelectedFolder(Component parent, String aDialogTitle, String lastSelectedFolder, String aFolderDescription, String approveButtonText, boolean openDialog) {
        JFileChooser fileChooser = new JFileChooser(lastSelectedFolder);
        final String folderDescription = aFolderDescription;
        fileChooser.setDialogTitle(aDialogTitle);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(1);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                return myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return folderDescription;
            }
        };
        fileChooser.setFileFilter(filter);
        int returnVal = fileChooser.showDialog(parent, approveButtonText);
        if (returnVal == 0) {
            File selectedFolder = fileChooser.getSelectedFile();
            if (!selectedFolder.exists()) {
                if (openDialog) {
                    JOptionPane.showMessageDialog(parent, "The folder '" + selectedFolder.getAbsolutePath() + "' does not exist.\nPlease choose an existing folder.", "Folder Error", 0);
                    return null;
                }
                int value = JOptionPane.showConfirmDialog(parent, "The folder '" + selectedFolder.getAbsolutePath() + "' does not exist.\nDo you want to create it?", "Create Folder?", 0);
                if (value == 1) {
                    return null;
                }
                boolean success = selectedFolder.mkdir();
                if (!success) {
                    JOptionPane.showMessageDialog(parent, "Failed to create the folder. Please create it manually and then select it.", "File Error", 1);
                    return null;
                }
            }
            return selectedFolder;
        }
        return null;
    }
}

