/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.filtering;

import com.compomics.util.experiment.identification.filtering.MatchFilter;
import com.compomics.util.experiment.identification.filtering.PeptideFilter;
import com.compomics.util.experiment.identification.filtering.ProteinFilter;
import com.compomics.util.experiment.identification.filtering.PsmFilter;
import com.compomics.util.experiment.personalization.ExperimentObject;
import java.util.HashMap;

public class FilterParameters
extends ExperimentObject {
    private HashMap<String, ProteinFilter> proteinStarFilters = new HashMap();
    private HashMap<String, ProteinFilter> proteinHideFilters = new HashMap();
    private HashMap<String, PeptideFilter> peptideStarFilters = new HashMap();
    private HashMap<String, PeptideFilter> peptideHideFilters = new HashMap();
    private HashMap<String, PsmFilter> psmStarFilters = new HashMap();
    private HashMap<String, PsmFilter> psmHideFilters = new HashMap();

    public HashMap<String, ProteinFilter> getProteinHideFilters() {
        return this.proteinHideFilters;
    }

    public void setProteinHideFilters(HashMap<String, ProteinFilter> proteinHideFilters) {
        this.proteinHideFilters = proteinHideFilters;
    }

    public HashMap<String, ProteinFilter> getProteinStarFilters() {
        return this.proteinStarFilters;
    }

    public void setProteinStarFilters(HashMap<String, ProteinFilter> proteinStarFilters) {
        this.proteinStarFilters = proteinStarFilters;
    }

    public HashMap<String, PeptideFilter> getPeptideHideFilters() {
        return this.peptideHideFilters;
    }

    public void setPeptideHideFilters(HashMap<String, PeptideFilter> peptideHideFilters) {
        this.peptideHideFilters = peptideHideFilters;
    }

    public HashMap<String, PeptideFilter> getPeptideStarFilters() {
        return this.peptideStarFilters;
    }

    public void setPeptideStarFilters(HashMap<String, PeptideFilter> peptideStarFilters) {
        this.peptideStarFilters = peptideStarFilters;
    }

    public HashMap<String, PsmFilter> getPsmHideFilters() {
        return this.psmHideFilters;
    }

    public void setPsmHideFilters(HashMap<String, PsmFilter> psmHideFilters) {
        this.psmHideFilters = psmHideFilters;
    }

    public HashMap<String, PsmFilter> getPsmStarFilters() {
        return this.psmStarFilters;
    }

    public void setPsmStarFilters(HashMap<String, PsmFilter> psmStarFilters) {
        this.psmStarFilters = psmStarFilters;
    }

    public void addStarringFilter(MatchFilter matchFilter) {
        if (matchFilter.getType().equals((Object)MatchFilter.FilterType.PROTEIN)) {
            this.proteinStarFilters.put(matchFilter.getName(), (ProteinFilter)matchFilter);
        } else if (matchFilter.getType().equals((Object)MatchFilter.FilterType.PEPTIDE)) {
            this.peptideStarFilters.put(matchFilter.getName(), (PeptideFilter)matchFilter);
        } else if (matchFilter.getType().equals((Object)MatchFilter.FilterType.PSM)) {
            this.psmStarFilters.put(matchFilter.getName(), (PsmFilter)matchFilter);
        }
    }

    public void addHidingFilter(MatchFilter matchFilter) {
        if (matchFilter.getType().equals((Object)MatchFilter.FilterType.PROTEIN)) {
            this.proteinHideFilters.put(matchFilter.getName(), (ProteinFilter)matchFilter);
        } else if (matchFilter.getType().equals((Object)MatchFilter.FilterType.PEPTIDE)) {
            this.peptideHideFilters.put(matchFilter.getName(), (PeptideFilter)matchFilter);
        } else if (matchFilter.getType().equals((Object)MatchFilter.FilterType.PSM)) {
            this.psmHideFilters.put(matchFilter.getName(), (PsmFilter)matchFilter);
        }
    }

    public boolean filterExists(String filtername) {
        return this.proteinHideFilters.containsKey(filtername) || this.proteinStarFilters.containsKey(filtername) || this.peptideHideFilters.containsKey(filtername) || this.peptideStarFilters.containsKey(filtername) || this.psmHideFilters.containsKey(filtername) || this.psmStarFilters.containsKey(filtername);
    }
}

