/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification;

import com.compomics.util.experiment.biology.ions.IonFactory;
import com.compomics.util.experiment.identification.filtering.PeptideAssumptionFilter;
import com.compomics.util.experiment.identification.identification_parameters.IdentificationParametersFactory;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.io.biology.protein.FastaParameters;
import com.compomics.util.gui.file_handling.FileChooserUtil;
import com.compomics.util.gui.parameters.identification.advanced.AnnotationParametersDialog;
import com.compomics.util.gui.parameters.identification.advanced.FractionParametersDialog;
import com.compomics.util.gui.parameters.identification.advanced.GeneParametersDialog;
import com.compomics.util.gui.parameters.identification.advanced.MatchesImportParametersDialog;
import com.compomics.util.gui.parameters.identification.advanced.ModificationLocalizationParametersDialog;
import com.compomics.util.gui.parameters.identification.advanced.PeptideVariantsParametersDialog;
import com.compomics.util.gui.parameters.identification.advanced.ProteinInferenceParametersDialog;
import com.compomics.util.gui.parameters.identification.advanced.PsmScoringParametersDialog;
import com.compomics.util.gui.parameters.identification.advanced.SequenceMatchingParametersDialog;
import com.compomics.util.gui.parameters.identification.advanced.ValidationParametersDialog;
import com.compomics.util.gui.parameters.identification.advanced.ValidationQCParametersDialog;
import com.compomics.util.gui.parameters.identification.search.SearchParametersDialog;
import com.compomics.util.gui.protein.FastaParametersDialog;
import com.compomics.util.io.file.LastSelectedFolder;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.FractionParameters;
import com.compomics.util.parameters.identification.advanced.GeneParameters;
import com.compomics.util.parameters.identification.advanced.IdMatchValidationParameters;
import com.compomics.util.parameters.identification.advanced.ModificationLocalizationParameters;
import com.compomics.util.parameters.identification.advanced.PeptideVariantsParameters;
import com.compomics.util.parameters.identification.advanced.ProteinInferenceParameters;
import com.compomics.util.parameters.identification.advanced.PsmScoringParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.advanced.ValidationQcParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class IdentificationParametersEditionDialog
extends JDialog {
    private final Frame parentFrame;
    private boolean canceled = false;
    private final Image normalIcon;
    private final Image waitingIcon;
    private final LastSelectedFolder lastSelectedFolder;
    private final boolean editable;
    private AnnotationParameters annotationSettings;
    private SearchParameters searchParameters;
    private SequenceMatchingParameters sequenceMatchingPreferences;
    private PeptideVariantsParameters peptideVariantsPreferences;
    private GeneParameters genePreferences;
    private PsmScoringParameters psmScoringPreferences;
    private PeptideAssumptionFilter peptideAssumptionFilter = new PeptideAssumptionFilter();
    private ModificationLocalizationParameters ptmScoringPreferences = new ModificationLocalizationParameters();
    private ProteinInferenceParameters proteinInferencePreferences;
    private IdMatchValidationParameters idValidationPreferences = new IdMatchValidationParameters();
    private FastaParameters fastaPreferences = new FastaParameters();
    private FractionParameters fractionSettings;
    private boolean showAdvancedSettings = false;
    private IdentificationParametersFactory identificationParametersFactory = IdentificationParametersFactory.getInstance();
    private JLabel advancedSettingsLabel;
    private JPanel attributesPanel;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JButton databaseProcessingButton;
    private JLabel exportLabel;
    private JButton fractionsButton;
    private JButton geneMappingButton;
    private JLabel importLabel;
    private JButton matchesFiltersButton;
    private JLabel nameLabel;
    private JTextField nameTxt;
    private JButton peptideVariantsButton;
    private JButton proteinInferenceButton;
    private JButton psmScoringButton;
    private JButton ptmLocalizationButton;
    private JButton qualityControlButton;
    private JButton saveButton;
    private JScrollPane scrollPane;
    private JButton sequenceMatchingButton;
    private JPanel settingsOuterPanel;
    private JPanel settingsPanel;
    private JButton spectrumAnnotationButton;
    private JButton spectrumMatchingButton;
    private JButton validationButton;

    public IdentificationParametersEditionDialog() {
        this.parentFrame = null;
        this.normalIcon = null;
        this.waitingIcon = null;
        this.lastSelectedFolder = null;
        this.editable = false;
    }

    public IdentificationParametersEditionDialog(Frame parentFrame, IdentificationParameters identificationParameters, Image normalIcon, Image waitingIcon, LastSelectedFolder lastSelectedFolder, boolean editable) {
        super(parentFrame, true);
        this.parentFrame = parentFrame;
        if (identificationParameters != null) {
            this.extractParameters(identificationParameters);
        }
        this.normalIcon = normalIcon;
        this.waitingIcon = waitingIcon;
        this.lastSelectedFolder = lastSelectedFolder;
        this.editable = editable;
        this.initComponents();
        this.setUpGui();
        if (identificationParameters != null) {
            this.nameTxt.setText(identificationParameters.getName());
            this.updateGUI();
        } else {
            this.clearGUI();
            this.saveButton.setEnabled(false);
        }
        this.setLocationRelativeTo(parentFrame);
        this.setVisible(true);
    }

    public IdentificationParametersEditionDialog(Dialog owner, Frame parentFrame, IdentificationParameters identificationParameters, Image normalIcon, Image waitingIcon, LastSelectedFolder lastSelectedFolder, boolean editable) {
        super(owner, true);
        this.parentFrame = parentFrame;
        if (identificationParameters != null) {
            this.extractParameters(identificationParameters);
        }
        this.normalIcon = normalIcon;
        this.waitingIcon = waitingIcon;
        this.lastSelectedFolder = lastSelectedFolder;
        this.editable = editable;
        this.initComponents();
        this.setUpGui();
        if (identificationParameters != null) {
            this.nameTxt.setText(identificationParameters.getName());
            this.updateGUI();
        } else {
            this.clearGUI();
            this.saveButton.setEnabled(false);
        }
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.nameTxt.setEditable(this.editable);
        this.updateAdvancedSettings();
    }

    private void extractParameters(IdentificationParameters identificationParameters) {
        this.annotationSettings = identificationParameters.getAnnotationParameters();
        this.searchParameters = identificationParameters.getSearchParameters();
        this.sequenceMatchingPreferences = identificationParameters.getSequenceMatchingParameters();
        this.peptideVariantsPreferences = identificationParameters.getPeptideVariantsParameters();
        this.genePreferences = identificationParameters.getGeneParameters();
        this.psmScoringPreferences = identificationParameters.getPsmScoringParameters();
        this.peptideAssumptionFilter = identificationParameters.getPeptideAssumptionFilter();
        this.ptmScoringPreferences = identificationParameters.getModificationLocalizationParameters();
        this.proteinInferencePreferences = identificationParameters.getProteinInferenceParameters();
        this.idValidationPreferences = identificationParameters.getIdValidationParameters();
        this.fractionSettings = identificationParameters.getFractionParameters();
        this.fastaPreferences = identificationParameters.getFastaParameters();
    }

    public void updateGUI() {
        int columnWidth = 150;
        int maxDescriptionLength = 150;
        this.spectrumMatchingButton.setText("<html><table><tr><td width=\"" + columnWidth + "\"><b>Spectrum Matching</b></td><td><font size=2>" + this.formatDescription(this.searchParameters.getShortDescription(), maxDescriptionLength) + "</font></td></tr></table></html>");
        this.geneMappingButton.setText("<html><table><tr><td width=\"" + columnWidth + "\"><b>Gene Annotation</b></td><td><font size=2>" + this.formatDescription(this.genePreferences.getShortDescription(), maxDescriptionLength) + "</font></td></tr></table></html>");
        this.spectrumAnnotationButton.setText("<html><table><tr><td width=\"" + columnWidth + "\"><b>Spectrum Annotation</b></td><td><font size=2>" + this.formatDescription(this.annotationSettings.getShortDescription(), maxDescriptionLength) + "</font></td></tr></table></html>");
        this.sequenceMatchingButton.setText("<html><table><tr><td width=\"" + columnWidth + "\"><b>Sequence Matching</b></td><td><font size=2>" + this.formatDescription(this.sequenceMatchingPreferences.getShortDescription(), maxDescriptionLength) + "</font></td></tr></table></html>");
        this.peptideVariantsButton.setText("<html><table><tr><td width=\"" + columnWidth + "\"><b>Peptide Variants</b></td><td><font size=2>" + this.formatDescription(this.peptideVariantsPreferences.getShortDescription(), maxDescriptionLength) + "</font></td></tr></table></html>");
        this.matchesFiltersButton.setText("<html><table><tr><td width=\"" + columnWidth + "\"><b>Import Filters</b></td><td><font size=2>" + this.formatDescription(this.peptideAssumptionFilter.getShortDescription(), maxDescriptionLength) + "</font></td></tr></table></html>");
        this.psmScoringButton.setText("<html><table><tr><td width=\"" + columnWidth + "\"><b>PSM Scoring</b></td><td><font size=2>" + this.formatDescription(this.psmScoringPreferences.getShortDescription(), maxDescriptionLength) + "</font></td></tr></table></html>");
        this.ptmLocalizationButton.setText("<html><table><tr><td width=\"" + columnWidth + "\"><b>PTM Localization</b></td><td><font size=2>" + this.formatDescription(this.ptmScoringPreferences.getShortDescription(), maxDescriptionLength) + "</font></td></tr></table></html>");
        this.proteinInferenceButton.setText("<html><table><tr><td width=\"" + columnWidth + "\"><b>Protein Inference</b></td><td><font size=2>" + this.formatDescription(this.proteinInferencePreferences.getShortDescription(), maxDescriptionLength) + "</font></td></tr></table></html>");
        this.validationButton.setText("<html><table><tr><td width=\"" + columnWidth + "\"><b>Validation Levels</b></td><td><font size=2>" + this.formatDescription(this.idValidationPreferences.getShortDescription(), maxDescriptionLength) + "</font></td></tr></table></html>");
        this.fractionsButton.setText("<html><table><tr><td width=\"" + columnWidth + "\"><b>Fraction Analysis</b></td><td><font size=2>" + this.formatDescription(this.fractionSettings.getShortDescription(), maxDescriptionLength) + "</font></td></tr></table></html>");
        this.qualityControlButton.setText("<html><table><tr><td width=\"" + columnWidth + "\"><b>Quality Control</b></td><td><font size=2>" + this.formatDescription(this.idValidationPreferences.getValidationQCParameters().getShortDescription(), maxDescriptionLength) + "</font></td></tr></table></html>");
        this.databaseProcessingButton.setText("<html><table><tr><td width=\"" + columnWidth + "\"><b>Database Processing</b></td><td><font size=2>" + this.formatDescription(this.fastaPreferences.getShortDescription(), maxDescriptionLength) + "</font></td></tr></table></html>");
        this.geneMappingButton.setEnabled(true);
        this.spectrumAnnotationButton.setEnabled(true);
        this.sequenceMatchingButton.setEnabled(true);
        this.matchesFiltersButton.setEnabled(true);
        this.psmScoringButton.setEnabled(true);
        this.ptmLocalizationButton.setEnabled(true);
        this.proteinInferenceButton.setEnabled(true);
        this.validationButton.setEnabled(true);
        this.fractionsButton.setEnabled(true);
        this.qualityControlButton.setEnabled(true);
        this.peptideVariantsButton.setEnabled(true);
        this.databaseProcessingButton.setEnabled(true);
        this.validateInput();
    }

    private void clearGUI() {
        this.nameTxt.setText(null);
        int columnWidth = 150;
        this.spectrumMatchingButton.setText("<html><table><tr><td width=\"" + columnWidth + "\"><b>Spectrum Matching</b></td><td><font size=2>-- please click to edit --</font></td></tr></table></html>");
        this.geneMappingButton.setText("<html><table><tr><td width=\"" + columnWidth + "\"><b>Gene Annotation</b></td><td><font size=2></font></td></tr></table></html>");
        this.spectrumAnnotationButton.setText("<html><table><tr><td width=\"" + columnWidth + "\"><b>Spectrum Annotation</b></td><td><font size=2></font></td></tr></table></html>");
        this.sequenceMatchingButton.setText("<html><table><tr><td width=\"" + columnWidth + "\"><b>Sequence Matching</b></td><td><font size=2></font></td></tr></table></html>");
        this.peptideVariantsButton.setText("<html><table><tr><td width=\"" + columnWidth + "\"><b>Peptide Variants</b></td><td><font size=2></font></td></tr></table></html>");
        this.matchesFiltersButton.setText("<html><table><tr><td width=\"" + columnWidth + "\"><b>Import Filters</b></td><td><font size=2></font></td></tr></table></html>");
        this.psmScoringButton.setText("<html><table><tr><td width=\"" + columnWidth + "\"><b>PSM Scoring</b></td><td><font size=2>(not yet available)</font></td></tr></table></html>");
        this.ptmLocalizationButton.setText("<html><table><tr><td width=\"" + columnWidth + "\"><b>PTM Localization</b></td><td><font size=2></font></td></tr></table></html>");
        this.proteinInferenceButton.setText("<html><table><tr><td width=\"" + columnWidth + "\"><b>Protein Inference</b></td><td><font size=2></font></td></tr></table></html>");
        this.validationButton.setText("<html><table><tr><td width=\"" + columnWidth + "\"><b>Validation Levels</b></td><td><font size=2></font></td></tr></table></html>");
        this.fractionsButton.setText("<html><table><tr><td width=\"" + columnWidth + "\"><b>Fraction Analysis</b></td><td><font size=2></font></td></tr></table></html>");
        this.qualityControlButton.setText("<html><table><tr><td width=\"" + columnWidth + "\"><b>Quality Control</b></td><td><font size=2></font></td></tr></table></html>");
        this.databaseProcessingButton.setText("<html><table><tr><td width=\"" + columnWidth + "\"><b>Database Processing</b></td><td><font size=2></font></td></tr></table></html>");
        this.geneMappingButton.setEnabled(false);
        this.spectrumAnnotationButton.setEnabled(false);
        this.sequenceMatchingButton.setEnabled(false);
        this.peptideVariantsButton.setEnabled(false);
        this.matchesFiltersButton.setEnabled(false);
        this.psmScoringButton.setEnabled(false);
        this.ptmLocalizationButton.setEnabled(false);
        this.proteinInferenceButton.setEnabled(false);
        this.validationButton.setEnabled(false);
        this.fractionsButton.setEnabled(false);
        this.qualityControlButton.setEnabled(false);
        this.databaseProcessingButton.setEnabled(false);
        this.validateInput();
    }

    private String formatDescription(String description, int maxDescriptionLength) {
        if (description.length() > maxDescriptionLength) {
            description = description.substring(0, maxDescriptionLength) + "...";
        }
        return description;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public IdentificationParameters getIdentificationParameters() {
        IdentificationParameters identificationParameters = new IdentificationParameters();
        identificationParameters.setName(this.nameTxt.getText());
        identificationParameters.setDescription(this.searchParameters.getShortDescription(), true);
        identificationParameters.setAnnotationParameters(this.annotationSettings);
        identificationParameters.setSearchParameters(this.searchParameters);
        identificationParameters.setSequenceMatchingParameters(this.sequenceMatchingPreferences);
        identificationParameters.setGeneParameters(this.genePreferences);
        identificationParameters.setPeptideAssumptionFilter(this.peptideAssumptionFilter);
        identificationParameters.setPsmScoringParameters(this.psmScoringPreferences);
        identificationParameters.setModificationLocalizationParameters(this.ptmScoringPreferences);
        identificationParameters.setPeptideVariantsParameters(this.peptideVariantsPreferences);
        identificationParameters.setProteinInferenceParameters(this.proteinInferencePreferences);
        identificationParameters.setIdValidationParameters(this.idValidationPreferences);
        identificationParameters.setFractionParameters(this.fractionSettings);
        identificationParameters.setFastaParameters(this.fastaPreferences);
        return identificationParameters;
    }

    public boolean validateInput() {
        boolean valid = true;
        if (this.nameTxt.getText().isEmpty()) {
            valid = false;
        }
        if (valid) {
            String name = this.nameTxt.getText();
            for (char character : name.toCharArray()) {
                String charAsString = character + "";
                if (!charAsString.matches("[^\\dA-Za-z _-]")) continue;
                JOptionPane.showMessageDialog(this, "Unsupported character in parameters name (" + character + "). Please avoid special characters in parameters name.", "Special Character", 1);
                valid = false;
                break;
            }
        }
        if (valid) {
            this.nameLabel.setForeground(Color.BLACK);
            this.nameLabel.setToolTipText(null);
            this.nameTxt.setToolTipText(null);
        } else {
            this.nameLabel.setForeground(Color.RED);
            this.nameLabel.setToolTipText("Please provide a settings file name");
            this.nameTxt.setToolTipText("Please provide a settings file name");
        }
        if (valid) {
            valid = this.validateParametersInput(false);
        }
        this.saveButton.setEnabled(valid);
        if (this.searchParameters != null) {
            IdentificationParameters currentParameters = this.getIdentificationParameters();
            if (!this.identificationParametersFactory.getParametersList().contains(currentParameters.getName()) || this.identificationParametersFactory.getParametersList().contains(currentParameters.getName()) && !this.identificationParametersFactory.getIdentificationParameters(currentParameters.getName()).equals(currentParameters)) {
                this.saveButton.setText("Save");
            } else {
                this.saveButton.setText("OK");
            }
        }
        return valid;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.saveButton = new JButton();
        this.cancelButton = new JButton();
        this.scrollPane = new JScrollPane();
        this.settingsOuterPanel = new JPanel();
        this.attributesPanel = new JPanel();
        this.nameTxt = new JTextField();
        this.nameLabel = new JLabel();
        this.settingsPanel = new JPanel();
        this.validationButton = new JButton();
        this.qualityControlButton = new JButton();
        this.sequenceMatchingButton = new JButton();
        this.spectrumAnnotationButton = new JButton();
        this.psmScoringButton = new JButton();
        this.ptmLocalizationButton = new JButton();
        this.geneMappingButton = new JButton();
        this.spectrumMatchingButton = new JButton();
        this.proteinInferenceButton = new JButton();
        this.matchesFiltersButton = new JButton();
        this.fractionsButton = new JButton();
        this.advancedSettingsLabel = new JLabel();
        this.peptideVariantsButton = new JButton();
        this.databaseProcessingButton = new JButton();
        this.exportLabel = new JLabel();
        this.importLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Identification Settings");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                IdentificationParametersEditionDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.saveButton.setText("Save");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersEditionDialog.this.saveButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersEditionDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.scrollPane.setBorder(null);
        this.settingsOuterPanel.setBackground(new Color(230, 230, 230));
        this.attributesPanel.setBorder(BorderFactory.createTitledBorder("Settings Description"));
        this.attributesPanel.setOpaque(false);
        this.nameTxt.setHorizontalAlignment(0);
        this.nameTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                IdentificationParametersEditionDialog.this.nameTxtKeyReleased(evt);
            }
        });
        this.nameLabel.setText("Name");
        GroupLayout attributesPanelLayout = new GroupLayout(this.attributesPanel);
        this.attributesPanel.setLayout(attributesPanelLayout);
        attributesPanelLayout.setHorizontalGroup(attributesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, attributesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.nameLabel).addGap(18, 18, 18).addComponent(this.nameTxt).addContainerGap()));
        attributesPanelLayout.setVerticalGroup(attributesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(attributesPanelLayout.createSequentialGroup().addContainerGap().addGroup(attributesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameTxt, -2, -1, -2).addComponent(this.nameLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.settingsPanel.setBorder(BorderFactory.createTitledBorder("Identification Settings"));
        this.settingsPanel.setOpaque(false);
        this.validationButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/edit_gray.png")));
        this.validationButton.setText("Validation Levels");
        this.validationButton.setHorizontalAlignment(2);
        this.validationButton.setIconTextGap(15);
        this.validationButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/edit.png")));
        this.validationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersEditionDialog.this.validationButtonActionPerformed(evt);
            }
        });
        this.qualityControlButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/edit_gray.png")));
        this.qualityControlButton.setText("Quality Control");
        this.qualityControlButton.setHorizontalAlignment(2);
        this.qualityControlButton.setIconTextGap(15);
        this.qualityControlButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/edit.png")));
        this.qualityControlButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersEditionDialog.this.qualityControlButtonActionPerformed(evt);
            }
        });
        this.sequenceMatchingButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/edit_gray.png")));
        this.sequenceMatchingButton.setText("Sequence Matching");
        this.sequenceMatchingButton.setHorizontalAlignment(2);
        this.sequenceMatchingButton.setIconTextGap(15);
        this.sequenceMatchingButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/edit.png")));
        this.sequenceMatchingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersEditionDialog.this.sequenceMatchingButtonActionPerformed(evt);
            }
        });
        this.spectrumAnnotationButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/edit_gray.png")));
        this.spectrumAnnotationButton.setText("Spectrum Annotation");
        this.spectrumAnnotationButton.setHorizontalAlignment(2);
        this.spectrumAnnotationButton.setIconTextGap(15);
        this.spectrumAnnotationButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/edit.png")));
        this.spectrumAnnotationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersEditionDialog.this.spectrumAnnotationButtonActionPerformed(evt);
            }
        });
        this.psmScoringButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/edit_gray.png")));
        this.psmScoringButton.setText("PSM Scoring");
        this.psmScoringButton.setHorizontalAlignment(2);
        this.psmScoringButton.setIconTextGap(15);
        this.psmScoringButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/edit.png")));
        this.psmScoringButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersEditionDialog.this.psmScoringButtonActionPerformed(evt);
            }
        });
        this.ptmLocalizationButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/edit_gray.png")));
        this.ptmLocalizationButton.setText("PTM Localization");
        this.ptmLocalizationButton.setHorizontalAlignment(2);
        this.ptmLocalizationButton.setIconTextGap(15);
        this.ptmLocalizationButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/edit.png")));
        this.ptmLocalizationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersEditionDialog.this.ptmLocalizationButtonActionPerformed(evt);
            }
        });
        this.geneMappingButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/edit_gray.png")));
        this.geneMappingButton.setText("Gene Annotation");
        this.geneMappingButton.setHorizontalAlignment(2);
        this.geneMappingButton.setIconTextGap(15);
        this.geneMappingButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/edit.png")));
        this.geneMappingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersEditionDialog.this.geneMappingButtonActionPerformed(evt);
            }
        });
        this.spectrumMatchingButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/edit_gray.png")));
        this.spectrumMatchingButton.setText("Spectrum Matching");
        this.spectrumMatchingButton.setHorizontalAlignment(2);
        this.spectrumMatchingButton.setIconTextGap(15);
        this.spectrumMatchingButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/edit.png")));
        this.spectrumMatchingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersEditionDialog.this.spectrumMatchingButtonActionPerformed(evt);
            }
        });
        this.proteinInferenceButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/edit_gray.png")));
        this.proteinInferenceButton.setText("Protein Inference");
        this.proteinInferenceButton.setHorizontalAlignment(2);
        this.proteinInferenceButton.setIconTextGap(15);
        this.proteinInferenceButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/edit.png")));
        this.proteinInferenceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersEditionDialog.this.proteinInferenceButtonActionPerformed(evt);
            }
        });
        this.matchesFiltersButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/edit_gray.png")));
        this.matchesFiltersButton.setText("Import Filters");
        this.matchesFiltersButton.setHorizontalAlignment(2);
        this.matchesFiltersButton.setIconTextGap(15);
        this.matchesFiltersButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/edit.png")));
        this.matchesFiltersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersEditionDialog.this.matchesFiltersButtonActionPerformed(evt);
            }
        });
        this.fractionsButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/edit_gray.png")));
        this.fractionsButton.setText("Fraction Analysis");
        this.fractionsButton.setHorizontalAlignment(2);
        this.fractionsButton.setIconTextGap(15);
        this.fractionsButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/edit.png")));
        this.fractionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersEditionDialog.this.fractionsButtonActionPerformed(evt);
            }
        });
        this.advancedSettingsLabel.setText("<html><a href>Hide Advanced Settings</a></html>");
        this.advancedSettingsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                IdentificationParametersEditionDialog.this.advancedSettingsLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                IdentificationParametersEditionDialog.this.advancedSettingsLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                IdentificationParametersEditionDialog.this.advancedSettingsLabelMouseReleased(evt);
            }
        });
        this.peptideVariantsButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/edit_gray.png")));
        this.peptideVariantsButton.setText("Peptide Variants");
        this.peptideVariantsButton.setHorizontalAlignment(2);
        this.peptideVariantsButton.setIconTextGap(15);
        this.peptideVariantsButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/edit.png")));
        this.peptideVariantsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersEditionDialog.this.peptideVariantsButtonActionPerformed(evt);
            }
        });
        this.databaseProcessingButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/edit_gray.png")));
        this.databaseProcessingButton.setText("Database Processing");
        this.databaseProcessingButton.setHorizontalAlignment(2);
        this.databaseProcessingButton.setIconTextGap(15);
        this.databaseProcessingButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/edit.png")));
        this.databaseProcessingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersEditionDialog.this.databaseProcessingButtonActionPerformed(evt);
            }
        });
        GroupLayout settingsPanelLayout = new GroupLayout(this.settingsPanel);
        this.settingsPanel.setLayout(settingsPanelLayout);
        settingsPanelLayout.setHorizontalGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.advancedSettingsLabel, -2, -1, -2)).addComponent(this.spectrumAnnotationButton, GroupLayout.Alignment.TRAILING, -1, 661, Short.MAX_VALUE).addComponent(this.sequenceMatchingButton, -1, 661, Short.MAX_VALUE).addComponent(this.matchesFiltersButton, GroupLayout.Alignment.TRAILING, -1, 661, Short.MAX_VALUE).addComponent(this.spectrumMatchingButton, GroupLayout.Alignment.TRAILING, -1, 661, Short.MAX_VALUE).addComponent(this.psmScoringButton, -1, 661, Short.MAX_VALUE).addComponent(this.ptmLocalizationButton, -1, 661, Short.MAX_VALUE).addComponent(this.proteinInferenceButton, -1, 661, Short.MAX_VALUE).addComponent(this.validationButton, -1, 661, Short.MAX_VALUE).addComponent(this.fractionsButton, -1, 661, Short.MAX_VALUE).addComponent(this.qualityControlButton, -1, 661, Short.MAX_VALUE).addComponent(this.geneMappingButton, -1, 661, Short.MAX_VALUE).addComponent(this.peptideVariantsButton, -1, 661, Short.MAX_VALUE).addComponent(this.databaseProcessingButton, GroupLayout.Alignment.TRAILING, -1, 661, Short.MAX_VALUE)).addContainerGap()));
        settingsPanelLayout.setVerticalGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsPanelLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.spectrumMatchingButton, -2, 43, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.advancedSettingsLabel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.spectrumAnnotationButton, -2, 43, -2).addGap(0, 0, 0).addComponent(this.sequenceMatchingButton, -2, 43, -2).addGap(0, 0, 0).addComponent(this.peptideVariantsButton, -2, 43, -2).addGap(0, 0, 0).addComponent(this.matchesFiltersButton, -2, 43, -2).addGap(0, 0, 0).addComponent(this.psmScoringButton, -2, 43, -2).addGap(0, 0, 0).addComponent(this.ptmLocalizationButton, -2, 43, -2).addGap(0, 0, 0).addComponent(this.geneMappingButton, -2, 43, -2).addGap(0, 0, 0).addComponent(this.proteinInferenceButton, -2, 43, -2).addGap(0, 0, 0).addComponent(this.validationButton, -2, 43, -2).addGap(0, 0, 0).addComponent(this.fractionsButton, -2, 43, -2).addGap(0, 0, 0).addComponent(this.qualityControlButton, -2, 43, -2).addGap(0, 0, 0).addComponent(this.databaseProcessingButton, -2, 43, -2).addContainerGap()));
        GroupLayout settingsOuterPanelLayout = new GroupLayout(this.settingsOuterPanel);
        this.settingsOuterPanel.setLayout(settingsOuterPanelLayout);
        settingsOuterPanelLayout.setHorizontalGroup(settingsOuterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsOuterPanelLayout.createSequentialGroup().addContainerGap().addGroup(settingsOuterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.settingsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.attributesPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        settingsOuterPanelLayout.setVerticalGroup(settingsOuterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsOuterPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.attributesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.settingsPanel, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        this.scrollPane.setViewportView(this.settingsOuterPanel);
        this.exportLabel.setText("<html> <a href>Export to File</a> </html>");
        this.exportLabel.setToolTipText("Export the identification settings to a file");
        this.exportLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                IdentificationParametersEditionDialog.this.exportLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                IdentificationParametersEditionDialog.this.exportLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                IdentificationParametersEditionDialog.this.exportLabelMouseReleased(evt);
            }
        });
        this.importLabel.setText("<html> <a href>Import from File</a> </html>");
        this.importLabel.setToolTipText("Import identification settings from a file");
        this.importLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                IdentificationParametersEditionDialog.this.importLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                IdentificationParametersEditionDialog.this.importLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                IdentificationParametersEditionDialog.this.importLabelMouseReleased(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(28, 28, 28).addComponent(this.exportLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.importLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.saveButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addContainerGap()).addComponent(this.scrollPane));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.saveButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addComponent(this.scrollPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.saveButton).addComponent(this.exportLabel, -2, -1, -2).addComponent(this.importLabel, -2, -1, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void spectrumAnnotationButtonActionPerformed(ActionEvent evt) {
        HashSet<String> neutralLosses = IonFactory.getNeutralLosses(this.searchParameters.getModificationParameters());
        ArrayList<Integer> reporterIons = new ArrayList<Integer>(IonFactory.getReporterIons(this.searchParameters.getModificationParameters()));
        AnnotationParametersDialog annotationSettingsDialog = new AnnotationParametersDialog(this, this.parentFrame, this.annotationSettings, this.searchParameters.getFragmentIonAccuracy(), neutralLosses, reporterIons, this.editable);
        if (!annotationSettingsDialog.isCanceled()) {
            this.annotationSettings = annotationSettingsDialog.getAnnotationSettings();
            this.updateGUI();
        }
    }

    private void spectrumMatchingButtonActionPerformed(ActionEvent evt) {
        String name = this.nameTxt.getText();
        SearchParametersDialog searchSettingsDialog = new SearchParametersDialog(this, this.parentFrame, this.searchParameters, this.normalIcon, this.waitingIcon, true, true, this.lastSelectedFolder, name, this.editable);
        if (!searchSettingsDialog.isCanceled()) {
            int value;
            SearchParameters oldSearchParameters = this.searchParameters;
            this.searchParameters = searchSettingsDialog.getSearchParameters();
            boolean extactParameters = false;
            if (oldSearchParameters == null) {
                extactParameters = true;
            } else if (!this.searchParameters.equals(oldSearchParameters) && (value = JOptionPane.showConfirmDialog(this, "Spectrum matching settings changed. Update advanced settings accordingly?", "Update Advanced Parameters?", 0)) == 0) {
                extactParameters = true;
            }
            if (extactParameters) {
                IdentificationParameters identificationParameters = new IdentificationParameters(this.searchParameters);
                this.extractParameters(identificationParameters);
            }
            if (!this.nameTxt.getText().isEmpty()) {
                this.saveButton.setEnabled(true);
            }
            this.updateGUI();
            this.validateInput();
        }
    }

    private void sequenceMatchingButtonActionPerformed(ActionEvent evt) {
        SequenceMatchingParametersDialog sequenceMatchingSettingsDialog = new SequenceMatchingParametersDialog((Dialog)this, this.parentFrame, this.sequenceMatchingPreferences, this.editable);
        if (!sequenceMatchingSettingsDialog.isCanceled()) {
            this.sequenceMatchingPreferences = sequenceMatchingSettingsDialog.getSequenceMatchingPreferences();
            this.updateGUI();
        }
    }

    private void geneMappingButtonActionPerformed(ActionEvent evt) {
        GeneParametersDialog genePreferencesDialog = new GeneParametersDialog(this, this.parentFrame, this.genePreferences, this.searchParameters, this.editable);
        if (!genePreferencesDialog.isCanceled()) {
            this.genePreferences = genePreferencesDialog.getGeneParameters();
            this.updateGUI();
        }
    }

    private void matchesFiltersButtonActionPerformed(ActionEvent evt) {
        MatchesImportParametersDialog matchesImportFiltersDialog = new MatchesImportParametersDialog((Dialog)this, this.parentFrame, this.peptideAssumptionFilter, this.editable);
        if (!matchesImportFiltersDialog.isCanceled()) {
            this.peptideAssumptionFilter = matchesImportFiltersDialog.getFilter();
            this.updateGUI();
        }
    }

    private void psmScoringButtonActionPerformed(ActionEvent evt) {
        PsmScoringParametersDialog psmScoringSettingsDialog = new PsmScoringParametersDialog((Dialog)this, this.parentFrame, this.psmScoringPreferences, this.editable);
        if (!psmScoringSettingsDialog.isCanceled()) {
            this.psmScoringPreferences = psmScoringSettingsDialog.getPsmScoringPreferences();
            this.updateGUI();
        }
    }

    private void ptmLocalizationButtonActionPerformed(ActionEvent evt) {
        ModificationLocalizationParametersDialog ptmLocalizationParametersDialog = new ModificationLocalizationParametersDialog((Dialog)this, this.parentFrame, this.ptmScoringPreferences, this.editable);
        if (!ptmLocalizationParametersDialog.isCanceled()) {
            this.ptmScoringPreferences = ptmLocalizationParametersDialog.getPtmScoringPreferences();
            this.updateGUI();
        }
    }

    private void proteinInferenceButtonActionPerformed(ActionEvent evt) {
        ProteinInferenceParametersDialog proteinInferenceSettingsDialog = new ProteinInferenceParametersDialog(this, this.parentFrame, this.proteinInferencePreferences, this.normalIcon, this.waitingIcon, this.editable);
        if (!proteinInferenceSettingsDialog.isCanceled()) {
            this.proteinInferencePreferences = proteinInferenceSettingsDialog.getProteinInferencePreferences();
            this.updateGUI();
        }
    }

    private void validationButtonActionPerformed(ActionEvent evt) {
        ValidationParametersDialog validationSettingsDialog = new ValidationParametersDialog((Dialog)this, this.parentFrame, this.idValidationPreferences, this.editable);
        if (!validationSettingsDialog.isCanceled()) {
            ValidationQcParameters validationQCPreferences = this.idValidationPreferences.getValidationQCParameters();
            this.idValidationPreferences = validationSettingsDialog.getIdMatchValidationPreferences();
            this.idValidationPreferences.setValidationQCParameters(validationQCPreferences);
            this.updateGUI();
        }
    }

    private void qualityControlButtonActionPerformed(ActionEvent evt) {
        ValidationQcParameters validationQCPreferences = this.idValidationPreferences.getValidationQCParameters();
        ValidationQCParametersDialog validationQCPreferencesDialog = new ValidationQCParametersDialog(this, this.parentFrame, validationQCPreferences, this.searchParameters.getModificationParameters().getAllModifications(), this.editable);
        if (!validationQCPreferencesDialog.isCanceled()) {
            this.idValidationPreferences = new IdMatchValidationParameters(this.idValidationPreferences);
            this.idValidationPreferences.setValidationQCParameters(validationQCPreferencesDialog.getValidationQCParameters());
            this.updateGUI();
        }
    }

    private void fractionsButtonActionPerformed(ActionEvent evt) {
        FractionParametersDialog fractionSettingsDialog = new FractionParametersDialog((Dialog)this, this.parentFrame, this.fractionSettings, this.editable);
        if (!fractionSettingsDialog.isCanceled()) {
            this.fractionSettings = fractionSettingsDialog.getFractionSettings();
            this.updateGUI();
        }
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput()) {
            IdentificationParameters newParameters = this.getIdentificationParameters();
            try {
                if (this.identificationParametersFactory.getParametersList().contains(newParameters.getName()) && !this.identificationParametersFactory.getIdentificationParameters(newParameters.getName()).equals(newParameters)) {
                    int value = JOptionPane.showConfirmDialog(this, "A settings file with the same name already exists. Overwrite file?", "Overwrite File?", 1);
                    if (value != 0) {
                        return;
                    }
                    this.identificationParametersFactory.addIdentificationParameters(newParameters);
                    this.dispose();
                } else {
                    this.identificationParametersFactory.addIdentificationParameters(newParameters);
                    this.dispose();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "Error occurred while saving " + newParameters.getName() + ". Please verify the settings.", "File Error", 0);
            }
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void advancedSettingsLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void advancedSettingsLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void advancedSettingsLabelMouseReleased(MouseEvent evt) {
        this.showAdvancedSettings = !this.showAdvancedSettings;
        this.updateAdvancedSettings();
    }

    private void nameTxtKeyReleased(KeyEvent evt) {
        if (evt.getKeyChar() != '\n') {
            this.validateInput();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.canceled = true;
    }

    private void exportLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exportLabelMouseReleased(MouseEvent evt) {
        File selectedFile = FileChooserUtil.getUserSelectedFile(this, ".par", "Identification settings file (.par)", "Export Identification Settings", this.lastSelectedFolder.getLastSelectedFolder(), null, false);
        if (selectedFile != null) {
            try {
                IdentificationParameters.saveIdentificationParameters(this.getIdentificationParameters(), selectedFile);
                JOptionPane.showMessageDialog(null, "Identification settings saved to " + selectedFile.getAbsolutePath() + ".", "Settings Saved", 1);
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "Error occurred while saving " + selectedFile + ". Please verify the file.", "File Error", 0);
            }
        }
    }

    private void importLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void importLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void importLabelMouseReleased(MouseEvent evt) {
        File selectedFile = FileChooserUtil.getUserSelectedFile(this, ".par", "Identification settings file (.par)", "Import Identification Settings File", this.lastSelectedFolder.getLastSelectedFolder(), null, true);
        if (selectedFile != null) {
            this.lastSelectedFolder.setLastSelectedFolder(selectedFile.getAbsolutePath());
            try {
                IdentificationParameters identificationParameters = IdentificationParameters.getIdentificationParameters(selectedFile);
                this.extractParameters(identificationParameters);
                this.nameTxt.setText(identificationParameters.getName());
                this.saveButton.setEnabled(true);
                this.updateGUI();
                this.validateParametersInput(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "Error occurred while reading " + selectedFile + ". Please verify the file.", "File Error", 0);
            }
        }
        this.validateInput();
    }

    private void peptideVariantsButtonActionPerformed(ActionEvent evt) {
        PeptideVariantsParametersDialog peptideVariantsSettingsDialog = new PeptideVariantsParametersDialog((Dialog)this, this.parentFrame, this.peptideVariantsPreferences, this.editable);
        if (!peptideVariantsSettingsDialog.isCanceled()) {
            this.peptideVariantsPreferences = peptideVariantsSettingsDialog.getPeptideVariantsPreferences();
            this.updateGUI();
        }
    }

    private void databaseProcessingButtonActionPerformed(ActionEvent evt) {
        FastaParametersDialog fastaSettingsDialog = new FastaParametersDialog((Dialog)this, this.parentFrame, this.fastaPreferences, this.editable);
        if (!fastaSettingsDialog.isCanceled()) {
            this.fastaPreferences = fastaSettingsDialog.getFastaSettings();
            this.updateGUI();
        }
    }

    private void updateAdvancedSettings() {
        this.geneMappingButton.setVisible(this.showAdvancedSettings);
        this.spectrumAnnotationButton.setVisible(this.showAdvancedSettings);
        this.sequenceMatchingButton.setVisible(this.showAdvancedSettings);
        this.peptideVariantsButton.setVisible(this.showAdvancedSettings);
        this.matchesFiltersButton.setVisible(this.showAdvancedSettings);
        this.psmScoringButton.setVisible(this.showAdvancedSettings);
        this.ptmLocalizationButton.setVisible(this.showAdvancedSettings);
        this.proteinInferenceButton.setVisible(this.showAdvancedSettings);
        this.validationButton.setVisible(this.showAdvancedSettings);
        this.fractionsButton.setVisible(this.showAdvancedSettings);
        this.qualityControlButton.setVisible(this.showAdvancedSettings);
        this.databaseProcessingButton.setVisible(this.showAdvancedSettings);
        this.repaint();
        if (this.showAdvancedSettings) {
            this.advancedSettingsLabel.setText("<html><a href>Hide Advanced Settings</a></html>");
        } else {
            this.advancedSettingsLabel.setText("<html><a href>Show Advanced Settings</a></html>");
        }
    }

    public boolean validateParametersInput(boolean showMessage) {
        if (this.searchParameters == null) {
            return false;
        }
        String name = this.nameTxt.getText();
        SearchParametersDialog searchSettingsDialog = new SearchParametersDialog(this, this.parentFrame, this.searchParameters, this.normalIcon, this.waitingIcon, false, true, this.lastSelectedFolder, name, this.editable);
        boolean valid = searchSettingsDialog.validateParametersInput(false);
        int columnWidth = 150;
        int maxDescriptionLength = 150;
        if (!valid) {
            this.spectrumMatchingButton.setText("<html><table><tr><td width=\"" + columnWidth + "\"><b><font color=\"red\">Spectrum Matching</font></b></td><td><font size=2>" + this.formatDescription(this.searchParameters.getShortDescription(), maxDescriptionLength) + "</font></td></tr></table></html>");
            this.spectrumMatchingButton.setToolTipText("Please check the search settings");
            if (showMessage) {
                searchSettingsDialog.validateParametersInput(true);
                searchSettingsDialog.setVisible(true);
                if (!searchSettingsDialog.isCanceled()) {
                    this.searchParameters = searchSettingsDialog.getSearchParameters();
                }
            }
        } else {
            this.spectrumMatchingButton.setText("<html><table><tr><td width=\"" + columnWidth + "\"><b>Spectrum Matching</b></td><td><font size=2>" + this.formatDescription(this.searchParameters.getShortDescription(), maxDescriptionLength) + "</font></td></tr></table></html>");
            this.spectrumMatchingButton.setToolTipText("Please check the search settings");
            this.spectrumMatchingButton.setToolTipText(null);
        }
        return valid;
    }
}

