/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification.advanced;

import com.compomics.util.experiment.biology.ions.Ion;
import com.compomics.util.experiment.biology.ions.NeutralLoss;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpectrumAnnotator;
import com.compomics.util.gui.error_handlers.HelpDialog;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.extra.NimbusCheckBoxRenderer;
import no.uib.jsparklines.extra.TrueFalseIconRenderer;

public class AnnotationParametersDialog
extends JDialog {
    private Frame parentFrame;
    private boolean canceled = false;
    private ArrayList<Integer> reporterIons;
    private HashMap<String, Boolean> neutralLossesMap;
    private boolean editable;
    private double maxFragmentIonAccuracy;
    private JCheckBox aBox;
    private JSpinner accuracySpinner;
    private JLabel annotationLevelLabel;
    private JLabel annotationLevelPercentLabel;
    private JButton annotationPreferencesHelpJButton;
    private JCheckBox bBox;
    private JPanel backgroundPanel;
    private JCheckBox cBox;
    private JButton cancelButton;
    private JLabel fragmentIonAccuracyLabel;
    private JLabel fragmentIonAccuracyTypeLabel;
    private JCheckBox highResolutionBox;
    private JCheckBox immoniumBox;
    private JSpinner intensitySpinner;
    private JComboBox intensityThresholdCmb;
    private JPanel ionsPanel;
    private JPanel neutralLossPanel;
    private JScrollPane neutralLossScrollPane;
    private JTable neutralLossesTable;
    private JButton okButton;
    private JPanel peakMatchingPanel;
    private JCheckBox precursorBox;
    private JCheckBox relatedBox;
    private JCheckBox reporterBox;
    private JCheckBox xBox;
    private JCheckBox yBox;
    private JCheckBox zBox;

    public AnnotationParametersDialog() {
    }

    public AnnotationParametersDialog(Frame parentFrame, AnnotationParameters annotationSettings, double maxFragmentIonAccuracy, HashSet<String> possibleNeutralLosses, ArrayList<Integer> reporterIons, boolean editable) {
        super(parentFrame, true);
        this.parentFrame = parentFrame;
        this.reporterIons = reporterIons;
        this.editable = editable;
        this.maxFragmentIonAccuracy = maxFragmentIonAccuracy;
        this.initComponents();
        this.setUpGui();
        this.populateGui(annotationSettings, possibleNeutralLosses);
        this.setLocationRelativeTo(parentFrame);
        this.setVisible(true);
    }

    public AnnotationParametersDialog(Dialog owner, Frame parentFrame, AnnotationParameters annotationSettings, double maxFragmentIonAccuracy, HashSet<String> possibleNeutralLosses, ArrayList<Integer> reporterIons, boolean editable) {
        super(owner, true);
        this.parentFrame = parentFrame;
        this.reporterIons = reporterIons;
        this.editable = editable;
        this.maxFragmentIonAccuracy = maxFragmentIonAccuracy;
        this.initComponents();
        this.setUpGui();
        this.populateGui(annotationSettings, possibleNeutralLosses);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.neutralLossesTable.getTableHeader().setReorderingAllowed(false);
        this.neutralLossScrollPane.getViewport().setOpaque(false);
        this.neutralLossesTable.getColumn(" ").setMaxWidth(50);
        this.neutralLossesTable.getColumn(" ").setMinWidth(50);
        this.neutralLossesTable.getColumn("  ").setMaxWidth(30);
        this.neutralLossesTable.getColumn("  ").setMinWidth(30);
        this.neutralLossesTable.getColumn("  ").setCellRenderer((TableCellRenderer)new NimbusCheckBoxRenderer());
        this.neutralLossesTable.getColumn("  ").setCellRenderer((TableCellRenderer)new TrueFalseIconRenderer(new ImageIcon(this.getClass().getResource("/icons/selected_green-new.png")), null, "Selected", null));
        this.aBox.setEnabled(this.editable);
        this.bBox.setEnabled(this.editable);
        this.cBox.setEnabled(this.editable);
        this.xBox.setEnabled(this.editable);
        this.yBox.setEnabled(this.editable);
        this.zBox.setEnabled(this.editable);
        this.precursorBox.setEnabled(this.editable);
        this.immoniumBox.setEnabled(this.editable);
        this.reporterBox.setEnabled(this.editable);
        this.relatedBox.setEnabled(this.editable);
        this.intensitySpinner.setEnabled(this.editable);
        this.intensityThresholdCmb.setEnabled(this.editable);
        this.accuracySpinner.setEnabled(this.editable);
        this.highResolutionBox.setEnabled(this.editable);
    }

    private void populateGui(AnnotationParameters annotationSettings, HashSet<String> possibleNeutralLosses) {
        this.neutralLossesMap = new HashMap(possibleNeutralLosses.size());
        ArrayList<NeutralLoss> selectedNeutralLosses = annotationSettings.getNeutralLosses();
        HashSet selectedNeutralLossesNames = selectedNeutralLosses.stream().map(neutralLoss -> neutralLoss.name).collect(Collectors.toCollection(HashSet::new));
        for (String nlName : possibleNeutralLosses) {
            this.neutralLossesMap.put(nlName, selectedNeutralLossesNames.contains(nlName));
        }
        ((NeutralLossesTableModel)this.neutralLossesTable.getModel()).updateData();
        this.intensityThresholdCmb.setSelectedItem((Object)annotationSettings.getIntensityThresholdType());
        this.intensitySpinner.setValue((int)(annotationSettings.getAnnotationIntensityLimit() * 100.0));
        double fragmentIonAccuracy = annotationSettings.getFragmentIonAccuracy();
        double stepSize = fragmentIonAccuracy > 10.0 ? 1.0 : (fragmentIonAccuracy > 1.0 ? 0.1 : (fragmentIonAccuracy > 0.1 ? 0.01 : 0.001));
        this.accuracySpinner.setModel(new SpinnerNumberModel(fragmentIonAccuracy, 0.0, this.maxFragmentIonAccuracy, stepSize));
        if (annotationSettings.isFragmentIonPpm()) {
            this.fragmentIonAccuracyTypeLabel.setText("ppm");
        } else {
            this.fragmentIonAccuracyTypeLabel.setText("Da");
        }
        this.aBox.setSelected(false);
        this.bBox.setSelected(false);
        this.cBox.setSelected(false);
        this.xBox.setSelected(false);
        this.yBox.setSelected(false);
        this.zBox.setSelected(false);
        this.precursorBox.setSelected(false);
        this.immoniumBox.setSelected(false);
        this.reporterBox.setSelected(annotationSettings.getReporterIons());
        this.reporterBox.setSelected(false);
        block16: for (Ion.IonType ionType : annotationSettings.getIonTypes().keySet()) {
            if (null == ionType) continue;
            switch (ionType) {
                case IMMONIUM_ION: {
                    this.immoniumBox.setSelected(true);
                    break;
                }
                case PEPTIDE_FRAGMENT_ION: {
                    for (int subType : annotationSettings.getIonTypes().get((Object)ionType)) {
                        switch (subType) {
                            case 0: {
                                this.aBox.setSelected(true);
                                break;
                            }
                            case 1: {
                                this.bBox.setSelected(true);
                                break;
                            }
                            case 2: {
                                this.cBox.setSelected(true);
                                break;
                            }
                            case 3: {
                                this.xBox.setSelected(true);
                                break;
                            }
                            case 4: {
                                this.yBox.setSelected(true);
                                break;
                            }
                            case 5: {
                                this.zBox.setSelected(true);
                                break;
                            }
                        }
                    }
                    continue block16;
                }
                case PRECURSOR_ION: {
                    this.precursorBox.setSelected(true);
                    break;
                }
                case REPORTER_ION: {
                    this.reporterBox.setSelected(true);
                    break;
                }
                case RELATED_ION: {
                    this.relatedBox.setSelected(true);
                    break;
                }
            }
        }
        this.highResolutionBox.setSelected(annotationSettings.getTiesResolution() == SpectrumAnnotator.TiesResolution.mostAccurateMz);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public AnnotationParameters getAnnotationSettings() {
        AnnotationParameters annotationSettings = new AnnotationParameters();
        if (this.aBox.isSelected()) {
            annotationSettings.addIonType(Ion.IonType.PEPTIDE_FRAGMENT_ION, 0);
            annotationSettings.addIonType(Ion.IonType.TAG_FRAGMENT_ION, 0);
        }
        if (this.bBox.isSelected()) {
            annotationSettings.addIonType(Ion.IonType.PEPTIDE_FRAGMENT_ION, 1);
            annotationSettings.addIonType(Ion.IonType.TAG_FRAGMENT_ION, 1);
        }
        if (this.cBox.isSelected()) {
            annotationSettings.addIonType(Ion.IonType.PEPTIDE_FRAGMENT_ION, 2);
            annotationSettings.addIonType(Ion.IonType.TAG_FRAGMENT_ION, 2);
        }
        if (this.xBox.isSelected()) {
            annotationSettings.addIonType(Ion.IonType.PEPTIDE_FRAGMENT_ION, 3);
            annotationSettings.addIonType(Ion.IonType.TAG_FRAGMENT_ION, 3);
        }
        if (this.yBox.isSelected()) {
            annotationSettings.addIonType(Ion.IonType.PEPTIDE_FRAGMENT_ION, 4);
            annotationSettings.addIonType(Ion.IonType.TAG_FRAGMENT_ION, 4);
        }
        if (this.zBox.isSelected()) {
            annotationSettings.addIonType(Ion.IonType.PEPTIDE_FRAGMENT_ION, 5);
            annotationSettings.addIonType(Ion.IonType.TAG_FRAGMENT_ION, 5);
        }
        if (this.precursorBox.isSelected()) {
            annotationSettings.addIonType(Ion.IonType.PRECURSOR_ION);
        }
        if (this.immoniumBox.isSelected()) {
            annotationSettings.addIonType(Ion.IonType.IMMONIUM_ION);
        }
        if (this.reporterBox.isSelected()) {
            for (Integer reporterIonSubType : this.reporterIons) {
                annotationSettings.addIonType(Ion.IonType.REPORTER_ION, reporterIonSubType);
            }
        }
        if (this.relatedBox.isSelected()) {
            annotationSettings.addIonType(Ion.IonType.RELATED_ION);
        }
        annotationSettings.setIntensityThresholdType((AnnotationParameters.IntensityThresholdType)((Object)this.intensityThresholdCmb.getSelectedItem()));
        annotationSettings.setIntensityLimit((double)((Integer)this.intensitySpinner.getValue()).intValue() / 100.0);
        annotationSettings.setFragmentIonAccuracy((Double)this.accuracySpinner.getValue());
        SpectrumAnnotator.TiesResolution tiesResolution = this.highResolutionBox.isSelected() ? SpectrumAnnotator.TiesResolution.mostAccurateMz : SpectrumAnnotator.TiesResolution.mostIntense;
        annotationSettings.setTiesResolution(tiesResolution);
        for (Map.Entry<String, Boolean> entry : this.neutralLossesMap.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            annotationSettings.addNeutralLoss(NeutralLoss.getNeutralLoss(entry.getKey()));
        }
        return annotationSettings;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.annotationPreferencesHelpJButton = new JButton();
        this.ionsPanel = new JPanel();
        this.aBox = new JCheckBox();
        this.bBox = new JCheckBox();
        this.cBox = new JCheckBox();
        this.xBox = new JCheckBox();
        this.yBox = new JCheckBox();
        this.zBox = new JCheckBox();
        this.precursorBox = new JCheckBox();
        this.immoniumBox = new JCheckBox();
        this.reporterBox = new JCheckBox();
        this.relatedBox = new JCheckBox();
        this.neutralLossPanel = new JPanel();
        this.neutralLossScrollPane = new JScrollPane();
        this.neutralLossesTable = new JTable();
        this.peakMatchingPanel = new JPanel();
        this.fragmentIonAccuracyLabel = new JLabel();
        this.fragmentIonAccuracyTypeLabel = new JLabel();
        this.intensitySpinner = new JSpinner();
        this.annotationLevelPercentLabel = new JLabel();
        this.annotationLevelLabel = new JLabel();
        this.accuracySpinner = new JSpinner();
        this.highResolutionBox = new JCheckBox();
        this.intensityThresholdCmb = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Spectrum Annotation");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AnnotationParametersDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnotationParametersDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnotationParametersDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.annotationPreferencesHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.annotationPreferencesHelpJButton.setToolTipText("Help");
        this.annotationPreferencesHelpJButton.setBorder(null);
        this.annotationPreferencesHelpJButton.setBorderPainted(false);
        this.annotationPreferencesHelpJButton.setContentAreaFilled(false);
        this.annotationPreferencesHelpJButton.setFocusable(false);
        this.annotationPreferencesHelpJButton.setHorizontalTextPosition(0);
        this.annotationPreferencesHelpJButton.setVerticalTextPosition(3);
        this.annotationPreferencesHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                AnnotationParametersDialog.this.annotationPreferencesHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                AnnotationParametersDialog.this.annotationPreferencesHelpJButtonMouseExited(evt);
            }
        });
        this.annotationPreferencesHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnotationParametersDialog.this.annotationPreferencesHelpJButtonActionPerformed(evt);
            }
        });
        this.ionsPanel.setBorder(BorderFactory.createTitledBorder("Ion Types"));
        this.ionsPanel.setOpaque(false);
        this.aBox.setText("a-ion");
        this.aBox.setIconTextGap(10);
        this.bBox.setText("b-ion");
        this.bBox.setIconTextGap(10);
        this.cBox.setText("c-ion");
        this.cBox.setIconTextGap(10);
        this.xBox.setText("x-ion");
        this.xBox.setIconTextGap(10);
        this.yBox.setText("y-ion");
        this.yBox.setIconTextGap(10);
        this.zBox.setText("z-ion");
        this.zBox.setIconTextGap(10);
        this.precursorBox.setText("Precursor");
        this.precursorBox.setToolTipText("Precursor ions");
        this.precursorBox.setIconTextGap(10);
        this.immoniumBox.setText("Immonium");
        this.immoniumBox.setToolTipText("Immonium ions");
        this.immoniumBox.setIconTextGap(10);
        this.reporterBox.setText("Reporter");
        this.reporterBox.setToolTipText("Report ions");
        this.reporterBox.setIconTextGap(10);
        this.relatedBox.setText("Related");
        this.relatedBox.setToolTipText("Related ions");
        this.relatedBox.setIconTextGap(10);
        GroupLayout ionsPanelLayout = new GroupLayout(this.ionsPanel);
        this.ionsPanel.setLayout(ionsPanelLayout);
        ionsPanelLayout.setHorizontalGroup(ionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ionsPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(ionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.aBox).addComponent(this.bBox).addComponent(this.cBox)).addGap(50, 50, 50).addGroup(ionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.yBox).addComponent(this.xBox).addComponent(this.zBox)).addGap(50, 50, 50).addGroup(ionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.reporterBox).addComponent(this.immoniumBox).addGroup(ionsPanelLayout.createSequentialGroup().addComponent(this.precursorBox).addGap(50, 50, 50).addComponent(this.relatedBox))).addGap(25, 25, 25)));
        ionsPanelLayout.linkSize(0, this.aBox, this.bBox, this.cBox, this.immoniumBox, this.precursorBox, this.xBox, this.yBox, this.zBox);
        ionsPanelLayout.setVerticalGroup(ionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(ionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.aBox).addComponent(this.xBox).addComponent(this.precursorBox).addComponent(this.relatedBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(ionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bBox).addComponent(this.yBox, -2, 23, -2).addComponent(this.immoniumBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(ionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cBox).addComponent(this.zBox).addComponent(this.reporterBox)).addContainerGap(-1, Short.MAX_VALUE)));
        this.neutralLossPanel.setBorder(BorderFactory.createTitledBorder("Neutral Loss"));
        this.neutralLossPanel.setOpaque(false);
        this.neutralLossesTable.setModel(new NeutralLossesTableModel());
        this.neutralLossesTable.setOpaque(false);
        this.neutralLossScrollPane.setViewportView(this.neutralLossesTable);
        GroupLayout neutralLossPanelLayout = new GroupLayout(this.neutralLossPanel);
        this.neutralLossPanel.setLayout(neutralLossPanelLayout);
        neutralLossPanelLayout.setHorizontalGroup(neutralLossPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(neutralLossPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.neutralLossScrollPane).addContainerGap()));
        neutralLossPanelLayout.setVerticalGroup(neutralLossPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(neutralLossPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.neutralLossScrollPane, -1, 93, Short.MAX_VALUE).addContainerGap()));
        this.peakMatchingPanel.setBorder(BorderFactory.createTitledBorder("Peak Matching"));
        this.peakMatchingPanel.setOpaque(false);
        this.fragmentIonAccuracyLabel.setText("Fragment Ion Accuracy");
        this.fragmentIonAccuracyLabel.setToolTipText("Fragment ion annotation accuracy ");
        this.fragmentIonAccuracyTypeLabel.setText("Da");
        this.intensitySpinner.setModel(new SpinnerNumberModel(25, 0, 100, 1));
        this.intensitySpinner.setToolTipText("<html>\nDisplay a certain percent of the<br>\npossible annotations relative<br>\nto the most intense peak\n</html>");
        this.annotationLevelPercentLabel.setText("%");
        this.annotationLevelLabel.setText("Annotation Level");
        this.annotationLevelLabel.setToolTipText("<html>\nDisplay a certain percent of the<br>\npossible annotations relative<br>\nto the most intense peak\n</html>");
        this.accuracySpinner.setModel(new SpinnerNumberModel(0.05, 0.0, 0.05, 0.001));
        this.accuracySpinner.setToolTipText("Fragment ion annotation accuracy");
        this.highResolutionBox.setSelected(true);
        this.highResolutionBox.setText("High Resolution");
        this.highResolutionBox.setIconTextGap(10);
        this.intensityThresholdCmb.setModel(new DefaultComboBoxModel<AnnotationParameters.IntensityThresholdType>(AnnotationParameters.IntensityThresholdType.values()));
        GroupLayout peakMatchingPanelLayout = new GroupLayout(this.peakMatchingPanel);
        this.peakMatchingPanel.setLayout(peakMatchingPanelLayout);
        peakMatchingPanelLayout.setHorizontalGroup(peakMatchingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peakMatchingPanelLayout.createSequentialGroup().addContainerGap().addGroup(peakMatchingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fragmentIonAccuracyLabel).addComponent(this.annotationLevelLabel)).addGap(18, 18, 18).addGroup(peakMatchingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.intensitySpinner).addComponent(this.accuracySpinner)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(peakMatchingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fragmentIonAccuracyTypeLabel).addComponent(this.annotationLevelPercentLabel, GroupLayout.Alignment.TRAILING)).addGap(35, 35, 35).addGroup(peakMatchingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peakMatchingPanelLayout.createSequentialGroup().addComponent(this.highResolutionBox).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.intensityThresholdCmb, 0, -1, Short.MAX_VALUE)).addContainerGap()));
        peakMatchingPanelLayout.linkSize(0, this.annotationLevelPercentLabel, this.fragmentIonAccuracyTypeLabel);
        peakMatchingPanelLayout.setVerticalGroup(peakMatchingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peakMatchingPanelLayout.createSequentialGroup().addContainerGap().addGroup(peakMatchingPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.annotationLevelLabel).addComponent(this.intensitySpinner, -2, -1, -2).addComponent(this.annotationLevelPercentLabel).addComponent(this.intensityThresholdCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(peakMatchingPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.fragmentIonAccuracyLabel).addComponent(this.accuracySpinner, -2, -1, -2).addComponent(this.fragmentIonAccuracyTypeLabel).addComponent(this.highResolutionBox)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ionsPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.annotationPreferencesHelpJButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.peakMatchingPanel, -1, -1, Short.MAX_VALUE).addComponent(this.neutralLossPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.ionsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.neutralLossPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.peakMatchingPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.okButton).addComponent(this.cancelButton).addComponent(this.annotationPreferencesHelpJButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void annotationPreferencesHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this.parentFrame, this.getClass().getResource("/helpFiles/AnnotationPreferences.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Spectrum Annotation - Help");
        this.setCursor(new Cursor(0));
    }

    private void annotationPreferencesHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void annotationPreferencesHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.canceled = true;
    }

    private class NeutralLossesTableModel
    extends DefaultTableModel {
        private String[] nlNames = new String[0];

        public NeutralLossesTableModel() {
            this.updateData();
        }

        public void updateData() {
            if (AnnotationParametersDialog.this.neutralLossesMap != null) {
                this.nlNames = (String[])AnnotationParametersDialog.this.neutralLossesMap.keySet().stream().sorted().toArray(String[]::new);
            }
        }

        @Override
        public int getRowCount() {
            if (this.nlNames == null) {
                return 0;
            }
            return this.nlNames.length;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Neutral Loss";
                }
                case 2: {
                    return "  ";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return this.nlNames[row];
                }
                case 2: {
                    String name = this.nlNames[row];
                    return AnnotationParametersDialog.this.neutralLossesMap.get(name);
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 2 && AnnotationParametersDialog.this.editable;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            String name = this.nlNames[row];
            AnnotationParametersDialog.this.neutralLossesMap.put(name, (Boolean)AnnotationParametersDialog.this.neutralLossesMap.get(name) == false);
        }
    }
}

