/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification.advanced;

import com.compomics.util.gui.GuiUtilities;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;

public class SequenceMatchingParametersDialog
extends JDialog {
    private Frame parentFrame;
    private boolean canceled = false;
    private boolean editable;
    private JButton annotationPreferencesHelpJButton;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JComboBox matchingCmb;
    private JLabel matchingMethodLbl;
    private JLabel maxPtmsPerTagLbl;
    private JTextField maxPtmsPerTagTextField;
    private JLabel minAaScoreLbl;
    private JSpinner minAaScoreSpinner;
    private JLabel minTagLengthLbl;
    private JTextField minTagLengthTextField;
    private JButton okButton;
    private JPanel sequenceMatchingPanel;
    private JComboBox tagMatchingCmb;
    private JLabel tagMatchingLbl;
    private JLabel xLbl;
    private JSpinner xSpinner;

    public SequenceMatchingParametersDialog(Frame parentFrame, SequenceMatchingParameters sequenceMatchingPreferences, boolean editable) {
        super(parentFrame, true);
        this.parentFrame = parentFrame;
        this.editable = editable;
        this.initComponents();
        this.setUpGui();
        this.populateGUI(sequenceMatchingPreferences);
        this.setLocationRelativeTo(parentFrame);
        this.setVisible(true);
    }

    public SequenceMatchingParametersDialog(Dialog owner, Frame parentFrame, SequenceMatchingParameters sequenceMatchingPreferences, boolean editable) {
        super(owner, true);
        this.parentFrame = parentFrame;
        this.editable = editable;
        this.initComponents();
        this.setUpGui();
        this.populateGUI(sequenceMatchingPreferences);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.matchingCmb.setRenderer(new AlignedListCellRenderer(0));
        this.tagMatchingCmb.setRenderer(new AlignedListCellRenderer(0));
        this.matchingCmb.setEnabled(this.editable);
        this.xSpinner.setEnabled(this.editable);
        this.tagMatchingCmb.setEnabled(this.editable);
        this.maxPtmsPerTagTextField.setEnabled(this.editable);
    }

    private void populateGUI(SequenceMatchingParameters sequenceMatchingPreferences) {
        SequenceMatchingParameters.MatchingType matchingType = sequenceMatchingPreferences.getSequenceMatchingType();
        this.matchingCmb.setSelectedItem((Object)matchingType);
        this.xSpinner.setValue(sequenceMatchingPreferences.getLimitX());
        if (sequenceMatchingPreferences.isEnzymaticTagsOnly()) {
            this.tagMatchingCmb.setSelectedIndex(1);
        } else {
            this.tagMatchingCmb.setSelectedIndex(0);
        }
        this.maxPtmsPerTagTextField.setText(sequenceMatchingPreferences.getMaxPtmsPerTagPeptide() + "");
        this.minAaScoreSpinner.setValue(sequenceMatchingPreferences.getMinAminoAcidScore());
        this.minTagLengthTextField.setText(sequenceMatchingPreferences.getMinTagLength() + "");
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public SequenceMatchingParameters getSequenceMatchingPreferences() {
        SequenceMatchingParameters sequenceMatchingPreferences = new SequenceMatchingParameters();
        sequenceMatchingPreferences.setSequenceMatchingType((SequenceMatchingParameters.MatchingType)((Object)this.matchingCmb.getSelectedItem()));
        sequenceMatchingPreferences.setLimitX((Double)this.xSpinner.getValue());
        sequenceMatchingPreferences.setEnzymaticTagsOnly(this.tagMatchingCmb.getSelectedIndex() == 1);
        sequenceMatchingPreferences.setMaxPtmsPerTagPeptide(Integer.parseInt(this.maxPtmsPerTagTextField.getText()));
        sequenceMatchingPreferences.setMinAminoAcidScore((Integer)this.minAaScoreSpinner.getValue());
        sequenceMatchingPreferences.setMinTagLength(Integer.parseInt(this.minTagLengthTextField.getText()));
        return sequenceMatchingPreferences;
    }

    public boolean validateInput(boolean showMessage) {
        boolean valid = true;
        valid = GuiUtilities.validateIntegerInput(this, this.maxPtmsPerTagLbl, this.maxPtmsPerTagTextField, "max PTMs per tag", "Max PTMs per Tag Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.minTagLengthLbl, this.minTagLengthTextField, "min tag length", "Min Tag Length Error", true, showMessage, valid);
        this.okButton.setEnabled(valid);
        return valid;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.sequenceMatchingPanel = new JPanel();
        this.matchingMethodLbl = new JLabel();
        this.xLbl = new JLabel();
        this.matchingCmb = new JComboBox();
        this.xSpinner = new JSpinner();
        this.tagMatchingLbl = new JLabel();
        this.tagMatchingCmb = new JComboBox();
        this.maxPtmsPerTagLbl = new JLabel();
        this.maxPtmsPerTagTextField = new JTextField();
        this.minAaScoreLbl = new JLabel();
        this.minAaScoreSpinner = new JSpinner();
        this.minTagLengthLbl = new JLabel();
        this.minTagLengthTextField = new JTextField();
        this.annotationPreferencesHelpJButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Sequence Matching");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SequenceMatchingParametersDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceMatchingParametersDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceMatchingParametersDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.sequenceMatchingPanel.setBorder(BorderFactory.createTitledBorder("Settings"));
        this.sequenceMatchingPanel.setOpaque(false);
        this.matchingMethodLbl.setText("Matching Method");
        this.xLbl.setText("Maximum Share of X's");
        this.matchingCmb.setModel(new DefaultComboBoxModel<SequenceMatchingParameters.MatchingType>(SequenceMatchingParameters.MatchingType.values()));
        this.xSpinner.setModel(new SpinnerNumberModel(0.25, 0.0, 1.0, 0.1));
        this.tagMatchingLbl.setText("Tag Matching");
        this.tagMatchingCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"All", "Enzymatic"}));
        this.maxPtmsPerTagLbl.setText("Max PTMs per Tag");
        this.maxPtmsPerTagLbl.setToolTipText("Maximum number of PTMs considered when mapping tags to peptides");
        this.maxPtmsPerTagTextField.setHorizontalAlignment(0);
        this.maxPtmsPerTagTextField.setText("3");
        this.maxPtmsPerTagTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SequenceMatchingParametersDialog.this.maxPtmsPerTagTextFieldKeyReleased(evt);
            }
        });
        this.minAaScoreLbl.setText("Min Amino Acid Score");
        this.minAaScoreSpinner.setModel(new SpinnerNumberModel(30, 0, 100, 1));
        this.minTagLengthLbl.setText("Min Tag Length");
        this.minTagLengthLbl.setToolTipText("Maximum number of PTMs considered when mapping tags to peptides");
        this.minTagLengthTextField.setHorizontalAlignment(0);
        this.minTagLengthTextField.setText("3");
        this.minTagLengthTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SequenceMatchingParametersDialog.this.minTagLengthTextFieldKeyReleased(evt);
            }
        });
        GroupLayout sequenceMatchingPanelLayout = new GroupLayout(this.sequenceMatchingPanel);
        this.sequenceMatchingPanel.setLayout(sequenceMatchingPanelLayout);
        sequenceMatchingPanelLayout.setHorizontalGroup(sequenceMatchingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sequenceMatchingPanelLayout.createSequentialGroup().addContainerGap().addGroup(sequenceMatchingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.matchingMethodLbl).addComponent(this.xLbl).addComponent(this.tagMatchingLbl).addComponent(this.maxPtmsPerTagLbl).addComponent(this.minAaScoreLbl).addComponent(this.minTagLengthLbl)).addGap(18, 18, 18).addGroup(sequenceMatchingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.minTagLengthTextField).addComponent(this.minAaScoreSpinner).addComponent(this.tagMatchingCmb, 0, -1, Short.MAX_VALUE).addComponent(this.matchingCmb, 0, -1, Short.MAX_VALUE).addComponent(this.xSpinner, -1, 295, Short.MAX_VALUE).addComponent(this.maxPtmsPerTagTextField)).addContainerGap()));
        sequenceMatchingPanelLayout.setVerticalGroup(sequenceMatchingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sequenceMatchingPanelLayout.createSequentialGroup().addContainerGap().addGroup(sequenceMatchingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.matchingMethodLbl).addComponent(this.matchingCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(sequenceMatchingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.xLbl).addComponent(this.xSpinner, -2, -1, -2)).addGap(0, 0, 0).addGroup(sequenceMatchingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tagMatchingLbl).addComponent(this.tagMatchingCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(sequenceMatchingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxPtmsPerTagTextField, -2, -1, -2).addComponent(this.maxPtmsPerTagLbl)).addGap(0, 0, 0).addGroup(sequenceMatchingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minAaScoreLbl).addComponent(this.minAaScoreSpinner, -2, -1, -2)).addGap(0, 0, 0).addGroup(sequenceMatchingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minTagLengthTextField, -2, -1, -2).addComponent(this.minTagLengthLbl)).addContainerGap()));
        this.annotationPreferencesHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.annotationPreferencesHelpJButton.setToolTipText("Help");
        this.annotationPreferencesHelpJButton.setBorder(null);
        this.annotationPreferencesHelpJButton.setBorderPainted(false);
        this.annotationPreferencesHelpJButton.setContentAreaFilled(false);
        this.annotationPreferencesHelpJButton.setFocusable(false);
        this.annotationPreferencesHelpJButton.setHorizontalTextPosition(0);
        this.annotationPreferencesHelpJButton.setVerticalTextPosition(3);
        this.annotationPreferencesHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SequenceMatchingParametersDialog.this.annotationPreferencesHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SequenceMatchingParametersDialog.this.annotationPreferencesHelpJButtonMouseExited(evt);
            }
        });
        this.annotationPreferencesHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceMatchingParametersDialog.this.annotationPreferencesHelpJButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.annotationPreferencesHelpJButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.sequenceMatchingPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.sequenceMatchingPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.annotationPreferencesHelpJButton).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput(true)) {
            this.dispose();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.canceled = true;
    }

    private void annotationPreferencesHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void annotationPreferencesHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void annotationPreferencesHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this.parentFrame, this.getClass().getResource("/helpFiles/SequenceMatchingPreferences.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Sequence Matching - Help");
        this.setCursor(new Cursor(0));
    }

    private void maxPtmsPerTagTextFieldKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void minTagLengthTextFieldKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }
}

