/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification.algorithm;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.biology.modifications.ModificationCategory;
import com.compomics.util.gui.GuiUtilities;
import com.compomics.util.gui.parameters.identification.AlgorithmParametersDialog;
import com.compomics.util.gui.parameters.identification.IdentificationAlgorithmParameter;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.parameters.identification.tool_specific.MetaMorpheusParameters;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.extra.NimbusCheckBoxRenderer;

public class MetaMorpheusParametersDialog
extends JDialog
implements AlgorithmParametersDialog {
    private boolean cancelled = false;
    private boolean editable;
    private JLabel advancedSettingsWarningLabel;
    private JPanel backgroundPanel;
    private JButton closeButton;
    private JLabel deconvIntRatioLbl;
    private JTextField deconvIntRatioTxt;
    private JLabel deconvMassToleranceLbl;
    private JTextField deconvMassToleranceTxt;
    private JComboBox deconvMassToleranceTypeCmb;
    private JLabel deconvMassToleranceTypeLbl;
    private JComboBox decoyTypeCmb;
    private JLabel decoyTypeLbl;
    private JPanel deisotopingPanel;
    private JComboBox dissociationTypeCombo;
    private JLabel dissociationTypeLbl;
    private JComboBox doPrecDeconvCmb;
    private JLabel doPrecDeconvLbl;
    private JComboBox excludeOneHitWondersCmb;
    private JLabel excludeOneHitWondersLbl;
    private JComboBox fragmentationTerminusCmb;
    private JLabel fragmentationTerminusLbl;
    private JScrollPane gPtmScrollPane;
    private JTable gPtmTable;
    private JPanel gptmPanel;
    private JPanel inSilicoDigestionPanel;
    private JComboBox intitiatorMethBehaviorCombo;
    private JLabel intitiatorMethBehaviorLabel;
    private JSeparator jSeparator1;
    private JComboBox massDiffAcceptorTypeCmb;
    private JLabel massDiffAcceptorTypeLbl;
    private JLabel maxFragmentSizeLbl;
    private JTextField maxFragmentSizeTxt;
    private JLabel maxHetroVariantsLbl;
    private JTextField maxHetroVariantsTxt;
    private JLabel maxModIsoformsLbl;
    private JTextField maxModIsoformsTxt;
    private JLabel maxNumModPeptideLbl;
    private JTextField maxNumModPeptideTxt;
    private JTextField maxPepLengthTxt;
    private JLabel minAllowedIntensityRatioToBasePeakLbl;
    private JTextField minAllowedIntensityRatioToBasePeakTxt;
    private JTextField minPepLengthTxt;
    private JLabel minVariantDepthLabel;
    private JTextField minVariantDepthTxt;
    private JLabel minimumAllowedInternalFragmentLengthLbl;
    private JTextField minimumAllowedInternalFragmentLengthTxt;
    private JComboBox modifiedPeptidesAreDifferentCmb;
    private JLabel modifiedPeptidesAreDifferentLbl;
    private JComboBox normalizePeaksAcrossAllWindowsCmb;
    private JLabel normalizePeaksAcrossAllWindowsLbl;
    private JLabel numPeaksPerWindowLbl;
    private JTextField numPeaksPerWindowTxt;
    private JLabel numberOfPartitionsLbl;
    private JTextField numberOfPartitionsTxt;
    private JLabel numberOfWindowsLbl;
    private JTextField numberOfWindowsTxt;
    private JButton okButton;
    private JButton openDialogHelpJButton;
    private JPanel outputPanel;
    private JPanel peakTrimmingPanel;
    private JLabel peptideLengthDividerLabel;
    private JLabel peptideLengthJLabel;
    private JPanel proteinGroupingPanel;
    private JLabel runGptmLbl;
    private JComboBox runGtpmCmb;
    private JLabel scoreCutoffLabel;
    private JTextField scoreCutoffTxt;
    private JPanel searchPanel;
    private JComboBox searchTargetComboBox;
    private JLabel searchTargetLabel;
    private JComboBox searchTypeCombo;
    private JLabel searchTypeLabel;
    private JTabbedPane tabbedPane;
    private JComboBox trimMs1Cmb;
    private JLabel trimMs1Lbl;
    private JComboBox trimMsMsCmb;
    private JLabel trimMsMsLbl;
    private JComboBox useDeltaScoreCmb;
    private JLabel useDeltaScoreLbl;
    private JComboBox useProvidedPrecCmb;
    private JLabel useProvidedPrecLabel;
    private JLabel windowWidthThompsonLbl;
    private JTextField windowWidthThompsonTxt;
    private JComboBox writeMzidCmb;
    private JLabel writeMzidLbl;
    private JComboBox writePepXmlCmb;
    private JLabel writePepXmlLbl;

    public MetaMorpheusParametersDialog(Frame parent, MetaMorpheusParameters metaMorpheusParameters, boolean editable) {
        super(parent, true);
        this.editable = editable;
        this.initComponents();
        this.setUpGui();
        this.populateGUI(metaMorpheusParameters);
        this.validateInput(false);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public MetaMorpheusParametersDialog(Dialog owner, Frame parent, MetaMorpheusParameters metaMorpheusParameters, boolean editable) {
        super(owner, true);
        this.editable = editable;
        this.initComponents();
        this.setUpGui();
        this.populateGUI(metaMorpheusParameters);
        this.validateInput(false);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.searchTypeCombo.setRenderer(new AlignedListCellRenderer(0));
        this.dissociationTypeCombo.setRenderer(new AlignedListCellRenderer(0));
        this.intitiatorMethBehaviorCombo.setRenderer(new AlignedListCellRenderer(0));
        this.useDeltaScoreCmb.setRenderer(new AlignedListCellRenderer(0));
        this.massDiffAcceptorTypeCmb.setRenderer(new AlignedListCellRenderer(0));
        this.writeMzidCmb.setRenderer(new AlignedListCellRenderer(0));
        this.writePepXmlCmb.setRenderer(new AlignedListCellRenderer(0));
        this.useProvidedPrecCmb.setRenderer(new AlignedListCellRenderer(0));
        this.doPrecDeconvCmb.setRenderer(new AlignedListCellRenderer(0));
        this.deconvMassToleranceTypeCmb.setRenderer(new AlignedListCellRenderer(0));
        this.trimMs1Cmb.setRenderer(new AlignedListCellRenderer(0));
        this.trimMsMsCmb.setRenderer(new AlignedListCellRenderer(0));
        this.normalizePeaksAcrossAllWindowsCmb.setRenderer(new AlignedListCellRenderer(0));
        this.modifiedPeptidesAreDifferentCmb.setRenderer(new AlignedListCellRenderer(0));
        this.excludeOneHitWondersCmb.setRenderer(new AlignedListCellRenderer(0));
        this.fragmentationTerminusCmb.setRenderer(new AlignedListCellRenderer(0));
        this.searchTargetComboBox.setRenderer(new AlignedListCellRenderer(0));
        this.decoyTypeCmb.setRenderer(new AlignedListCellRenderer(0));
        this.runGtpmCmb.setRenderer(new AlignedListCellRenderer(0));
        this.searchTypeCombo.setEnabled(this.editable);
        this.numberOfPartitionsTxt.setEditable(this.editable);
        this.numberOfPartitionsTxt.setEnabled(this.editable);
        this.dissociationTypeCombo.setEnabled(this.editable);
        this.maxNumModPeptideTxt.setEditable(this.editable);
        this.maxNumModPeptideTxt.setEnabled(this.editable);
        this.intitiatorMethBehaviorCombo.setEnabled(this.editable);
        this.scoreCutoffTxt.setEditable(this.editable);
        this.scoreCutoffTxt.setEnabled(this.editable);
        this.useDeltaScoreCmb.setEnabled(this.editable);
        this.massDiffAcceptorTypeCmb.setEnabled(this.editable);
        this.minPepLengthTxt.setEditable(this.editable);
        this.minPepLengthTxt.setEnabled(this.editable);
        this.maxPepLengthTxt.setEditable(this.editable);
        this.maxPepLengthTxt.setEnabled(this.editable);
        this.writeMzidCmb.setEnabled(this.editable);
        this.writePepXmlCmb.setEnabled(this.editable);
        this.useProvidedPrecCmb.setEnabled(this.editable);
        this.doPrecDeconvCmb.setEnabled(this.editable);
        this.deconvIntRatioTxt.setEditable(this.editable);
        this.deconvIntRatioTxt.setEnabled(this.editable);
        this.deconvMassToleranceTxt.setEditable(this.editable);
        this.deconvMassToleranceTxt.setEnabled(this.editable);
        this.deconvMassToleranceTypeCmb.setEnabled(this.editable);
        this.trimMs1Cmb.setEnabled(this.editable);
        this.trimMsMsCmb.setEnabled(this.editable);
        this.numPeaksPerWindowTxt.setEditable(this.editable);
        this.numPeaksPerWindowTxt.setEnabled(this.editable);
        this.minAllowedIntensityRatioToBasePeakTxt.setEditable(this.editable);
        this.minAllowedIntensityRatioToBasePeakTxt.setEnabled(this.editable);
        this.windowWidthThompsonTxt.setEditable(this.editable);
        this.windowWidthThompsonTxt.setEnabled(this.editable);
        this.numberOfWindowsTxt.setEditable(this.editable);
        this.numberOfWindowsTxt.setEnabled(this.editable);
        this.normalizePeaksAcrossAllWindowsCmb.setEnabled(this.editable);
        this.modifiedPeptidesAreDifferentCmb.setEnabled(this.editable);
        this.excludeOneHitWondersCmb.setEnabled(this.editable);
        this.fragmentationTerminusCmb.setEnabled(this.editable);
        this.maxFragmentSizeTxt.setEditable(this.editable);
        this.maxFragmentSizeTxt.setEnabled(this.editable);
        this.searchTargetComboBox.setEnabled(this.editable);
        this.decoyTypeCmb.setEnabled(this.editable);
        this.maxModIsoformsTxt.setEditable(this.editable);
        this.maxModIsoformsTxt.setEnabled(this.editable);
        this.minVariantDepthTxt.setEditable(this.editable);
        this.minVariantDepthTxt.setEnabled(this.editable);
        this.maxHetroVariantsTxt.setEditable(this.editable);
        this.maxHetroVariantsTxt.setEnabled(this.editable);
        this.runGtpmCmb.setEnabled(this.editable);
        this.gPtmTable.setEnabled(this.editable);
        this.gPtmScrollPane.getViewport().setOpaque(false);
        this.gPtmTable.getTableHeader().setReorderingAllowed(false);
        this.gPtmTable.getColumn(" ").setMaxWidth(35);
        this.gPtmTable.getColumn(" ").setMinWidth(35);
        this.gPtmTable.getColumn("  ").setMaxWidth(35);
        this.gPtmTable.getColumn("  ").setMinWidth(35);
        this.gPtmTable.getColumn("  ").setCellRenderer((TableCellRenderer)new NimbusCheckBoxRenderer());
        this.gPtmTable.getColumn("  ").setCellRenderer((TableCellRenderer)new NimbusCheckBoxRenderer());
    }

    private void populateGUI(MetaMorpheusParameters metaMorpheusParameters) {
        this.searchTypeCombo.setSelectedItem((Object)metaMorpheusParameters.getSearchType());
        this.numberOfPartitionsTxt.setText(metaMorpheusParameters.getTotalPartitions() + "");
        this.dissociationTypeCombo.setSelectedItem((Object)metaMorpheusParameters.getDissociationType());
        this.maxNumModPeptideTxt.setText(metaMorpheusParameters.getMaxModsForPeptide() + "");
        this.intitiatorMethBehaviorCombo.setSelectedItem((Object)metaMorpheusParameters.getInitiatorMethionineBehavior());
        this.scoreCutoffTxt.setText(metaMorpheusParameters.getScoreCutoff() + "");
        if (metaMorpheusParameters.getUseDeltaScore()) {
            this.useDeltaScoreCmb.setSelectedIndex(0);
        } else {
            this.useDeltaScoreCmb.setSelectedIndex(1);
        }
        this.massDiffAcceptorTypeCmb.setSelectedItem((Object)metaMorpheusParameters.getMassDiffAcceptorType());
        this.minPepLengthTxt.setText(metaMorpheusParameters.getMinPeptideLength() + "");
        this.maxPepLengthTxt.setText(metaMorpheusParameters.getMaxPeptideLength() + "");
        this.minimumAllowedInternalFragmentLengthTxt.setText(metaMorpheusParameters.getMinAllowedInternalFragmentLength() + "");
        if (metaMorpheusParameters.getWriteMzId().booleanValue()) {
            this.writeMzidCmb.setSelectedIndex(0);
        } else {
            this.writeMzidCmb.setSelectedIndex(1);
        }
        if (metaMorpheusParameters.getWritePepXml().booleanValue()) {
            this.writePepXmlCmb.setSelectedIndex(0);
        } else {
            this.writePepXmlCmb.setSelectedIndex(1);
        }
        if (metaMorpheusParameters.getUseProvidedPrecursorInfo().booleanValue()) {
            this.useProvidedPrecCmb.setSelectedIndex(0);
        } else {
            this.useProvidedPrecCmb.setSelectedIndex(1);
        }
        if (metaMorpheusParameters.getDoPrecursorDeconvolution().booleanValue()) {
            this.doPrecDeconvCmb.setSelectedIndex(0);
        } else {
            this.doPrecDeconvCmb.setSelectedIndex(1);
        }
        this.deconvIntRatioTxt.setText(metaMorpheusParameters.getDeconvolutionIntensityRatio() + "");
        this.deconvMassToleranceTxt.setText(metaMorpheusParameters.getDeconvolutionMassTolerance() + "");
        this.deconvMassToleranceTypeCmb.setSelectedItem((Object)metaMorpheusParameters.getDeconvolutionMassToleranceType());
        if (metaMorpheusParameters.getTrimMs1Peaks().booleanValue()) {
            this.trimMs1Cmb.setSelectedIndex(0);
        } else {
            this.trimMs1Cmb.setSelectedIndex(1);
        }
        if (metaMorpheusParameters.getTrimMsMsPeaks().booleanValue()) {
            this.trimMsMsCmb.setSelectedIndex(0);
        } else {
            this.trimMsMsCmb.setSelectedIndex(1);
        }
        this.numPeaksPerWindowTxt.setText(metaMorpheusParameters.getNumberOfPeaksToKeepPerWindow() + "");
        this.minAllowedIntensityRatioToBasePeakTxt.setText(metaMorpheusParameters.getMinAllowedIntensityRatioToBasePeak() + "");
        if (metaMorpheusParameters.getWindowWidthThomsons() != null) {
            this.windowWidthThompsonTxt.setText(metaMorpheusParameters.getWindowWidthThomsons() + "");
        }
        if (metaMorpheusParameters.getNumberOfWindows() != null) {
            this.numberOfWindowsTxt.setText(metaMorpheusParameters.getNumberOfWindows() + "");
        }
        if (metaMorpheusParameters.getNormalizePeaksAcrossAllWindows().booleanValue()) {
            this.normalizePeaksAcrossAllWindowsCmb.setSelectedIndex(0);
        } else {
            this.normalizePeaksAcrossAllWindowsCmb.setSelectedIndex(1);
        }
        if (metaMorpheusParameters.getModPeptidesAreDifferent().booleanValue()) {
            this.modifiedPeptidesAreDifferentCmb.setSelectedIndex(0);
        } else {
            this.modifiedPeptidesAreDifferentCmb.setSelectedIndex(1);
        }
        if (metaMorpheusParameters.getNoOneHitWonders().booleanValue()) {
            this.excludeOneHitWondersCmb.setSelectedIndex(0);
        } else {
            this.excludeOneHitWondersCmb.setSelectedIndex(1);
        }
        this.fragmentationTerminusCmb.setSelectedItem((Object)metaMorpheusParameters.getFragmentationTerminus());
        this.maxFragmentSizeTxt.setText(metaMorpheusParameters.getMaxFragmentSize() + "");
        if (metaMorpheusParameters.getSearchTarget().booleanValue()) {
            this.searchTargetComboBox.setSelectedIndex(0);
        } else {
            this.searchTargetComboBox.setSelectedIndex(1);
        }
        this.decoyTypeCmb.setSelectedItem((Object)metaMorpheusParameters.getDecoyType());
        this.maxModIsoformsTxt.setText(metaMorpheusParameters.getMaxModificationIsoforms() + "");
        this.minVariantDepthTxt.setText(metaMorpheusParameters.getMinVariantDepth() + "");
        this.maxHetroVariantsTxt.setText(metaMorpheusParameters.getMaxHeterozygousVariants() + "");
        if (metaMorpheusParameters.runGptm()) {
            this.runGtpmCmb.setSelectedIndex(0);
        } else {
            this.runGtpmCmb.setSelectedIndex(1);
        }
        for (int i = 0; i < ModificationCategory.values().length; ++i) {
            ModificationCategory tempModCategory = ModificationCategory.values()[i];
            ((DefaultTableModel)this.gPtmTable.getModel()).addRow(new Object[]{i + 1, tempModCategory, metaMorpheusParameters.getGPtmCategories().contains((Object)tempModCategory)});
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public IdentificationAlgorithmParameter getParameters() {
        return this.getInput();
    }

    public MetaMorpheusParameters getInput() {
        MetaMorpheusParameters tempMetaMorpheusParameters = new MetaMorpheusParameters();
        tempMetaMorpheusParameters.setSearchType((MetaMorpheusParameters.MetaMorpheusSearchType)((Object)this.searchTypeCombo.getSelectedItem()));
        String input = this.numberOfPartitionsTxt.getText().trim();
        tempMetaMorpheusParameters.setTotalPartitions(Integer.valueOf(input));
        tempMetaMorpheusParameters.setDissociationType((MetaMorpheusParameters.MetaMorpheusDissociationType)((Object)this.dissociationTypeCombo.getSelectedItem()));
        input = this.maxNumModPeptideTxt.getText().trim();
        tempMetaMorpheusParameters.setMaxModsForPeptide(Integer.valueOf(input));
        tempMetaMorpheusParameters.setInitiatorMethionineBehavior((MetaMorpheusParameters.MetaMorpheusInitiatorMethionineBehaviorType)((Object)this.intitiatorMethBehaviorCombo.getSelectedItem()));
        input = this.scoreCutoffTxt.getText().trim();
        tempMetaMorpheusParameters.setScoreCutoff(Double.valueOf(input));
        tempMetaMorpheusParameters.setUseDeltaScore(this.useDeltaScoreCmb.getSelectedIndex() == 0);
        tempMetaMorpheusParameters.setMassDiffAcceptorType((MetaMorpheusParameters.MetaMorpheusMassDiffAcceptorType)((Object)this.massDiffAcceptorTypeCmb.getSelectedItem()));
        input = this.minPepLengthTxt.getText().trim();
        tempMetaMorpheusParameters.setMinPeptideLength(Integer.valueOf(input));
        input = this.maxPepLengthTxt.getText().trim();
        tempMetaMorpheusParameters.setMaxPeptideLength(Integer.valueOf(input));
        input = this.minimumAllowedInternalFragmentLengthTxt.getText().trim();
        tempMetaMorpheusParameters.setMinAllowedInternalFragmentLength(Integer.valueOf(input));
        tempMetaMorpheusParameters.setWriteMzId(this.writeMzidCmb.getSelectedIndex() == 0);
        tempMetaMorpheusParameters.setWritePepXml(this.writePepXmlCmb.getSelectedIndex() == 0);
        tempMetaMorpheusParameters.setUseProvidedPrecursorInfo(this.useProvidedPrecCmb.getSelectedIndex() == 0);
        tempMetaMorpheusParameters.setDoPrecursorDeconvolution(this.doPrecDeconvCmb.getSelectedIndex() == 0);
        input = this.deconvIntRatioTxt.getText().trim();
        tempMetaMorpheusParameters.setDeconvolutionIntensityRatio(Double.valueOf(input));
        input = this.deconvMassToleranceTxt.getText().trim();
        tempMetaMorpheusParameters.setDeconvolutionMassTolerance(Double.valueOf(input));
        tempMetaMorpheusParameters.setDeconvolutionMassToleranceType((MetaMorpheusParameters.MetaMorpheusToleranceType)((Object)this.deconvMassToleranceTypeCmb.getSelectedItem()));
        tempMetaMorpheusParameters.setTrimMs1Peaks(this.trimMs1Cmb.getSelectedIndex() == 0);
        tempMetaMorpheusParameters.setTrimMsMsPeaks(this.trimMsMsCmb.getSelectedIndex() == 0);
        input = this.numPeaksPerWindowTxt.getText().trim();
        tempMetaMorpheusParameters.setNumberOfPeaksToKeepPerWindow(Integer.valueOf(input));
        input = this.minAllowedIntensityRatioToBasePeakTxt.getText().trim();
        tempMetaMorpheusParameters.setMinAllowedIntensityRatioToBasePeak(Double.valueOf(input));
        input = this.windowWidthThompsonTxt.getText().trim();
        if (!input.equals("")) {
            tempMetaMorpheusParameters.setWindowWidthThomsons(Double.valueOf(input));
        }
        if (!(input = this.numberOfWindowsTxt.getText().trim()).equals("")) {
            tempMetaMorpheusParameters.setNumberOfWindows(Integer.valueOf(input));
        }
        tempMetaMorpheusParameters.setNormalizePeaksAcrossAllWindows(this.normalizePeaksAcrossAllWindowsCmb.getSelectedIndex() == 0);
        tempMetaMorpheusParameters.setModPeptidesAreDifferent(this.modifiedPeptidesAreDifferentCmb.getSelectedIndex() == 0);
        tempMetaMorpheusParameters.setNoOneHitWonders(this.excludeOneHitWondersCmb.getSelectedIndex() == 0);
        tempMetaMorpheusParameters.setFragmentationTerminus((MetaMorpheusParameters.MetaMorpheusFragmentationTerminusType)((Object)this.fragmentationTerminusCmb.getSelectedItem()));
        input = this.maxFragmentSizeTxt.getText().trim();
        tempMetaMorpheusParameters.setMaxFragmentSize(Double.valueOf(input));
        tempMetaMorpheusParameters.setSearchTarget(this.searchTargetComboBox.getSelectedIndex() == 0);
        tempMetaMorpheusParameters.setDecoyType((MetaMorpheusParameters.MetaMorpheusDecoyType)((Object)this.decoyTypeCmb.getSelectedItem()));
        input = this.maxModIsoformsTxt.getText().trim();
        tempMetaMorpheusParameters.setMaxModificationIsoforms(Integer.valueOf(input));
        input = this.minVariantDepthTxt.getText().trim();
        tempMetaMorpheusParameters.setMinVariantDepth(Integer.valueOf(input));
        input = this.maxHetroVariantsTxt.getText().trim();
        tempMetaMorpheusParameters.setMaxHeterozygousVariants(Integer.valueOf(input));
        tempMetaMorpheusParameters.setRunGptm(this.runGtpmCmb.getSelectedIndex() == 0);
        ArrayList<ModificationCategory> gPtmCategories = new ArrayList<ModificationCategory>();
        for (int i = 0; i < this.gPtmTable.getRowCount(); ++i) {
            if (!((Boolean)this.gPtmTable.getValueAt(i, 2)).booleanValue()) continue;
            gPtmCategories.add((ModificationCategory)((Object)this.gPtmTable.getValueAt(i, 1)));
        }
        tempMetaMorpheusParameters.setGPtmCategories(gPtmCategories);
        return tempMetaMorpheusParameters;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.openDialogHelpJButton = new JButton();
        this.okButton = new JButton();
        this.closeButton = new JButton();
        this.advancedSettingsWarningLabel = new JLabel();
        this.tabbedPane = new JTabbedPane();
        this.searchPanel = new JPanel();
        this.searchTypeLabel = new JLabel();
        this.searchTypeCombo = new JComboBox();
        this.numberOfPartitionsLbl = new JLabel();
        this.numberOfPartitionsTxt = new JTextField();
        this.dissociationTypeLbl = new JLabel();
        this.dissociationTypeCombo = new JComboBox();
        this.maxNumModPeptideLbl = new JLabel();
        this.maxNumModPeptideTxt = new JTextField();
        this.intitiatorMethBehaviorLabel = new JLabel();
        this.intitiatorMethBehaviorCombo = new JComboBox();
        this.scoreCutoffLabel = new JLabel();
        this.scoreCutoffTxt = new JTextField();
        this.useDeltaScoreLbl = new JLabel();
        this.useDeltaScoreCmb = new JComboBox();
        this.massDiffAcceptorTypeLbl = new JLabel();
        this.massDiffAcceptorTypeCmb = new JComboBox();
        this.peptideLengthJLabel = new JLabel();
        this.minPepLengthTxt = new JTextField();
        this.peptideLengthDividerLabel = new JLabel();
        this.maxPepLengthTxt = new JTextField();
        this.minimumAllowedInternalFragmentLengthLbl = new JLabel();
        this.minimumAllowedInternalFragmentLengthTxt = new JTextField();
        this.outputPanel = new JPanel();
        this.writeMzidLbl = new JLabel();
        this.writeMzidCmb = new JComboBox();
        this.writePepXmlLbl = new JLabel();
        this.writePepXmlCmb = new JComboBox();
        this.deisotopingPanel = new JPanel();
        this.useProvidedPrecLabel = new JLabel();
        this.useProvidedPrecCmb = new JComboBox();
        this.doPrecDeconvLbl = new JLabel();
        this.doPrecDeconvCmb = new JComboBox();
        this.deconvIntRatioLbl = new JLabel();
        this.deconvIntRatioTxt = new JTextField();
        this.deconvMassToleranceLbl = new JLabel();
        this.deconvMassToleranceTxt = new JTextField();
        this.deconvMassToleranceTypeLbl = new JLabel();
        this.deconvMassToleranceTypeCmb = new JComboBox();
        this.peakTrimmingPanel = new JPanel();
        this.trimMs1Lbl = new JLabel();
        this.trimMs1Cmb = new JComboBox();
        this.trimMsMsLbl = new JLabel();
        this.trimMsMsCmb = new JComboBox();
        this.numPeaksPerWindowLbl = new JLabel();
        this.numPeaksPerWindowTxt = new JTextField();
        this.minAllowedIntensityRatioToBasePeakLbl = new JLabel();
        this.minAllowedIntensityRatioToBasePeakTxt = new JTextField();
        this.windowWidthThompsonLbl = new JLabel();
        this.windowWidthThompsonTxt = new JTextField();
        this.numberOfWindowsLbl = new JLabel();
        this.numberOfWindowsTxt = new JTextField();
        this.normalizePeaksAcrossAllWindowsLbl = new JLabel();
        this.normalizePeaksAcrossAllWindowsCmb = new JComboBox();
        this.proteinGroupingPanel = new JPanel();
        this.modifiedPeptidesAreDifferentLbl = new JLabel();
        this.modifiedPeptidesAreDifferentCmb = new JComboBox();
        this.excludeOneHitWondersLbl = new JLabel();
        this.excludeOneHitWondersCmb = new JComboBox();
        this.inSilicoDigestionPanel = new JPanel();
        this.fragmentationTerminusLbl = new JLabel();
        this.fragmentationTerminusCmb = new JComboBox();
        this.maxFragmentSizeLbl = new JLabel();
        this.maxFragmentSizeTxt = new JTextField();
        this.searchTargetLabel = new JLabel();
        this.searchTargetComboBox = new JComboBox();
        this.decoyTypeLbl = new JLabel();
        this.decoyTypeCmb = new JComboBox();
        this.maxModIsoformsLbl = new JLabel();
        this.maxModIsoformsTxt = new JTextField();
        this.minVariantDepthLabel = new JLabel();
        this.minVariantDepthTxt = new JTextField();
        this.maxHetroVariantsLbl = new JLabel();
        this.maxHetroVariantsTxt = new JTextField();
        this.gptmPanel = new JPanel();
        this.runGptmLbl = new JLabel();
        this.runGtpmCmb = new JComboBox();
        this.gPtmScrollPane = new JScrollPane();
        this.gPtmTable = new JTable();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setTitle("MetaMorpheus Advanced Settings");
        this.setMinimumSize(new Dimension(600, 500));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MetaMorpheusParametersDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.openDialogHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.openDialogHelpJButton.setToolTipText("Help");
        this.openDialogHelpJButton.setBorder(null);
        this.openDialogHelpJButton.setBorderPainted(false);
        this.openDialogHelpJButton.setContentAreaFilled(false);
        this.openDialogHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                MetaMorpheusParametersDialog.this.openDialogHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                MetaMorpheusParametersDialog.this.openDialogHelpJButtonMouseExited(evt);
            }
        });
        this.openDialogHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MetaMorpheusParametersDialog.this.openDialogHelpJButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MetaMorpheusParametersDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MetaMorpheusParametersDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.advancedSettingsWarningLabel.setText("Click to open the MetaMorpheus help page.");
        this.tabbedPane.setBackground(new Color(230, 230, 230));
        this.tabbedPane.setOpaque(true);
        this.tabbedPane.setPreferredSize(new Dimension(616, 180));
        this.searchPanel.setBackground(new Color(230, 230, 230));
        this.searchPanel.setPreferredSize(new Dimension(518, 143));
        this.searchTypeLabel.setText("Search Type");
        this.searchTypeCombo.setModel(new DefaultComboBoxModel<MetaMorpheusParameters.MetaMorpheusSearchType>(MetaMorpheusParameters.MetaMorpheusSearchType.values()));
        this.numberOfPartitionsLbl.setText("Number of Partitions");
        this.numberOfPartitionsTxt.setHorizontalAlignment(0);
        this.numberOfPartitionsTxt.setText("1");
        this.numberOfPartitionsTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MetaMorpheusParametersDialog.this.numberOfPartitionsTxtKeyReleased(evt);
            }
        });
        this.dissociationTypeLbl.setText("Dissociation Type");
        this.dissociationTypeCombo.setModel(new DefaultComboBoxModel<MetaMorpheusParameters.MetaMorpheusDissociationType>(MetaMorpheusParameters.MetaMorpheusDissociationType.values()));
        this.maxNumModPeptideLbl.setText("Maximum Number of Modifications per Peptide");
        this.maxNumModPeptideTxt.setHorizontalAlignment(0);
        this.maxNumModPeptideTxt.setText("2");
        this.maxNumModPeptideTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MetaMorpheusParametersDialog.this.maxNumModPeptideTxtKeyReleased(evt);
            }
        });
        this.intitiatorMethBehaviorLabel.setText("Initiator Methionine Behavior");
        this.intitiatorMethBehaviorCombo.setModel(new DefaultComboBoxModel<MetaMorpheusParameters.MetaMorpheusInitiatorMethionineBehaviorType>(MetaMorpheusParameters.MetaMorpheusInitiatorMethionineBehaviorType.values()));
        this.scoreCutoffLabel.setText("Score Cut-off");
        this.scoreCutoffTxt.setHorizontalAlignment(0);
        this.scoreCutoffTxt.setText("5.0");
        this.scoreCutoffTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MetaMorpheusParametersDialog.this.scoreCutoffTxtKeyReleased(evt);
            }
        });
        this.useDeltaScoreLbl.setText("Use Delta Score");
        this.useDeltaScoreCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.useDeltaScoreCmb.setSelectedIndex(1);
        this.massDiffAcceptorTypeLbl.setText("Mass Difference Acceptor Type");
        this.massDiffAcceptorTypeCmb.setModel(new DefaultComboBoxModel<MetaMorpheusParameters.MetaMorpheusMassDiffAcceptorType>(MetaMorpheusParameters.MetaMorpheusMassDiffAcceptorType.values()));
        this.peptideLengthJLabel.setText("Peptide Length (min - max)");
        this.minPepLengthTxt.setHorizontalAlignment(0);
        this.minPepLengthTxt.setText("8");
        this.minPepLengthTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MetaMorpheusParametersDialog.this.minPepLengthTxtKeyReleased(evt);
            }
        });
        this.peptideLengthDividerLabel.setText("-");
        this.maxPepLengthTxt.setHorizontalAlignment(0);
        this.maxPepLengthTxt.setText("30");
        this.maxPepLengthTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MetaMorpheusParametersDialog.this.maxPepLengthTxtKeyReleased(evt);
            }
        });
        this.minimumAllowedInternalFragmentLengthLbl.setText("Minimum Allowed Internal Fragment Length");
        this.minimumAllowedInternalFragmentLengthTxt.setHorizontalAlignment(0);
        this.minimumAllowedInternalFragmentLengthTxt.setText("0");
        this.minimumAllowedInternalFragmentLengthTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MetaMorpheusParametersDialog.this.minimumAllowedInternalFragmentLengthTxtKeyReleased(evt);
            }
        });
        GroupLayout searchPanelLayout = new GroupLayout(this.searchPanel);
        this.searchPanel.setLayout(searchPanelLayout);
        searchPanelLayout.setHorizontalGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchPanelLayout.createSequentialGroup().addGap(25, 25, 25).addComponent(this.searchTypeLabel, -1, -1, Short.MAX_VALUE).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, searchPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.minimumAllowedInternalFragmentLengthLbl, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.minimumAllowedInternalFragmentLengthTxt, -2, 185, -2)).addGroup(searchPanelLayout.createSequentialGroup().addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.peptideLengthJLabel, -2, 345, -2).addComponent(this.dissociationTypeLbl, -2, 370, -2).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.maxNumModPeptideLbl, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.intitiatorMethBehaviorLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addComponent(this.numberOfPartitionsLbl, -2, 370, -2).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.massDiffAcceptorTypeLbl, -1, -1, Short.MAX_VALUE).addComponent(this.useDeltaScoreLbl, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.scoreCutoffLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addGap(18, 18, 18).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.massDiffAcceptorTypeCmb, GroupLayout.Alignment.TRAILING, -2, 185, -2).addComponent(this.useDeltaScoreCmb, GroupLayout.Alignment.TRAILING, -2, 185, -2).addComponent(this.scoreCutoffTxt, GroupLayout.Alignment.TRAILING, -2, 185, -2).addComponent(this.intitiatorMethBehaviorCombo, GroupLayout.Alignment.TRAILING, -2, 185, -2).addComponent(this.maxNumModPeptideTxt, GroupLayout.Alignment.TRAILING, -2, 185, -2))).addComponent(this.numberOfPartitionsTxt, -2, 185, -2).addComponent(this.searchTypeCombo, -2, 185, -2).addComponent(this.dissociationTypeCombo, -2, 185, -2).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.minPepLengthTxt, -2, 70, -2).addGap(18, 18, 18).addComponent(this.peptideLengthDividerLabel, -2, 4, -2).addGap(18, 18, 18).addComponent(this.maxPepLengthTxt, -2, 75, -2))).addGap(25, 25, 25)));
        searchPanelLayout.linkSize(0, this.dissociationTypeCombo, this.intitiatorMethBehaviorCombo, this.massDiffAcceptorTypeCmb, this.maxNumModPeptideTxt, this.numberOfPartitionsTxt, this.scoreCutoffTxt, this.searchTypeCombo, this.useDeltaScoreCmb);
        searchPanelLayout.setVerticalGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchTypeLabel).addComponent(this.searchTypeCombo, -2, -1, -2)).addGap(0, 0, 0).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numberOfPartitionsLbl).addComponent(this.numberOfPartitionsTxt, -2, -1, -2)).addGap(0, 0, 0).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dissociationTypeLbl).addComponent(this.dissociationTypeCombo, -2, -1, -2)).addGap(0, 0, 0).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxNumModPeptideLbl).addComponent(this.maxNumModPeptideTxt, -2, -1, -2)).addGap(0, 0, 0).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.intitiatorMethBehaviorLabel).addComponent(this.intitiatorMethBehaviorCombo, -2, -1, -2)).addGap(0, 0, 0).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scoreCutoffLabel).addComponent(this.scoreCutoffTxt, -2, -1, -2)).addGap(0, 0, 0).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.useDeltaScoreLbl).addComponent(this.useDeltaScoreCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.massDiffAcceptorTypeLbl).addComponent(this.massDiffAcceptorTypeCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.peptideLengthJLabel).addComponent(this.minPepLengthTxt, -2, -1, -2).addComponent(this.maxPepLengthTxt, -2, -1, -2).addComponent(this.peptideLengthDividerLabel)).addGap(0, 0, 0).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minimumAllowedInternalFragmentLengthLbl).addComponent(this.minimumAllowedInternalFragmentLengthTxt, -2, -1, -2)).addContainerGap()));
        this.tabbedPane.addTab("Search", this.searchPanel);
        this.outputPanel.setBackground(new Color(230, 230, 230));
        this.writeMzidLbl.setText("Write mzIdentML");
        this.writeMzidCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.writePepXmlLbl.setText("Write pepXML");
        this.writePepXmlCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.writePepXmlCmb.setSelectedIndex(1);
        GroupLayout outputPanelLayout = new GroupLayout(this.outputPanel);
        this.outputPanel.setLayout(outputPanelLayout);
        outputPanelLayout.setHorizontalGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outputPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.writeMzidLbl, -2, 370, -2).addComponent(this.writePepXmlLbl, -2, 370, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 18, Short.MAX_VALUE).addGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.writeMzidCmb, 0, 185, Short.MAX_VALUE).addComponent(this.writePepXmlCmb, 0, -1, Short.MAX_VALUE)).addGap(25, 25, 25)));
        outputPanelLayout.setVerticalGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, outputPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.writeMzidLbl).addComponent(this.writeMzidCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.writePepXmlLbl).addComponent(this.writePepXmlCmb, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.tabbedPane.addTab("Output", this.outputPanel);
        this.deisotopingPanel.setBackground(new Color(230, 230, 230));
        this.deisotopingPanel.setPreferredSize(new Dimension(518, 143));
        this.useProvidedPrecLabel.setText("Use Provided Precursor Info");
        this.useProvidedPrecCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.doPrecDeconvLbl.setText("Do Precursor Deconvolution");
        this.doPrecDeconvCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.deconvIntRatioLbl.setText("Deconvolution Intensity Ratio");
        this.deconvIntRatioTxt.setHorizontalAlignment(0);
        this.deconvIntRatioTxt.setText("3.0");
        this.deconvIntRatioTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MetaMorpheusParametersDialog.this.deconvIntRatioTxtKeyReleased(evt);
            }
        });
        this.deconvMassToleranceLbl.setText("Deconvolution Mass Tolerance");
        this.deconvMassToleranceTxt.setHorizontalAlignment(0);
        this.deconvMassToleranceTxt.setText("4.0");
        this.deconvMassToleranceTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MetaMorpheusParametersDialog.this.deconvMassToleranceTxtKeyReleased(evt);
            }
        });
        this.deconvMassToleranceTypeLbl.setText("Deconvolution Mass Tolerance Type");
        this.deconvMassToleranceTypeCmb.setModel(new DefaultComboBoxModel<MetaMorpheusParameters.MetaMorpheusToleranceType>(MetaMorpheusParameters.MetaMorpheusToleranceType.values()));
        GroupLayout deisotopingPanelLayout = new GroupLayout(this.deisotopingPanel);
        this.deisotopingPanel.setLayout(deisotopingPanelLayout);
        deisotopingPanelLayout.setHorizontalGroup(deisotopingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(deisotopingPanelLayout.createSequentialGroup().addGroup(deisotopingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(deisotopingPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(deisotopingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.useProvidedPrecLabel, -2, 370, -2).addComponent(this.deconvIntRatioLbl, -2, 370, -2).addComponent(this.doPrecDeconvLbl, -2, 370, -2).addComponent(this.deconvMassToleranceLbl, -2, 370, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 18, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, deisotopingPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.deconvMassToleranceTypeLbl, -2, 376, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED))).addGroup(deisotopingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.useProvidedPrecCmb, GroupLayout.Alignment.TRAILING, 0, 185, Short.MAX_VALUE).addComponent(this.doPrecDeconvCmb, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.deconvIntRatioTxt, GroupLayout.Alignment.TRAILING).addComponent(this.deconvMassToleranceTxt, GroupLayout.Alignment.TRAILING).addComponent(this.deconvMassToleranceTypeCmb, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE)).addGap(25, 25, 25)));
        deisotopingPanelLayout.setVerticalGroup(deisotopingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, deisotopingPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(deisotopingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.useProvidedPrecLabel).addComponent(this.useProvidedPrecCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(deisotopingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.doPrecDeconvLbl).addComponent(this.doPrecDeconvCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(deisotopingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deconvIntRatioLbl).addComponent(this.deconvIntRatioTxt, -2, -1, -2)).addGap(0, 0, 0).addGroup(deisotopingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deconvMassToleranceLbl).addComponent(this.deconvMassToleranceTxt, -2, -1, -2)).addGap(0, 0, 0).addGroup(deisotopingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deconvMassToleranceTypeLbl).addComponent(this.deconvMassToleranceTypeCmb, -2, -1, -2)).addGap(99, 99, 99)));
        this.tabbedPane.addTab("Deisotoping", this.deisotopingPanel);
        this.peakTrimmingPanel.setBackground(new Color(230, 230, 230));
        this.trimMs1Lbl.setText("Trim MS1 Peaks");
        this.trimMs1Cmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.trimMs1Cmb.setSelectedIndex(1);
        this.trimMsMsLbl.setText("Trim MSMS Peaks");
        this.trimMsMsCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.numPeaksPerWindowLbl.setText("Number of Peaks to Keep per Window");
        this.numPeaksPerWindowTxt.setHorizontalAlignment(0);
        this.numPeaksPerWindowTxt.setText("200");
        this.numPeaksPerWindowTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MetaMorpheusParametersDialog.this.numPeaksPerWindowTxtKeyReleased(evt);
            }
        });
        this.minAllowedIntensityRatioToBasePeakLbl.setText("Minimum Allowed Intensity Ratio to Base Peak ");
        this.minAllowedIntensityRatioToBasePeakTxt.setHorizontalAlignment(0);
        this.minAllowedIntensityRatioToBasePeakTxt.setText("0.01");
        this.minAllowedIntensityRatioToBasePeakTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MetaMorpheusParametersDialog.this.minAllowedIntensityRatioToBasePeakTxtKeyReleased(evt);
            }
        });
        this.windowWidthThompsonLbl.setText("Window Width in Thomson");
        this.windowWidthThompsonTxt.setHorizontalAlignment(0);
        this.windowWidthThompsonTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MetaMorpheusParametersDialog.this.windowWidthThompsonTxtKeyReleased(evt);
            }
        });
        this.numberOfWindowsLbl.setText("Number of Windows");
        this.numberOfWindowsTxt.setHorizontalAlignment(0);
        this.numberOfWindowsTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MetaMorpheusParametersDialog.this.numberOfWindowsTxtKeyReleased(evt);
            }
        });
        this.normalizePeaksAcrossAllWindowsLbl.setText("Normalize Peaks Accross All Windows");
        this.normalizePeaksAcrossAllWindowsCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.normalizePeaksAcrossAllWindowsCmb.setSelectedIndex(1);
        GroupLayout peakTrimmingPanelLayout = new GroupLayout(this.peakTrimmingPanel);
        this.peakTrimmingPanel.setLayout(peakTrimmingPanelLayout);
        peakTrimmingPanelLayout.setHorizontalGroup(peakTrimmingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, peakTrimmingPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(peakTrimmingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peakTrimmingPanelLayout.createSequentialGroup().addComponent(this.normalizePeaksAcrossAllWindowsLbl, -1, -1, Short.MAX_VALUE).addGap(38, 38, 38)).addGroup(peakTrimmingPanelLayout.createSequentialGroup().addComponent(this.numberOfWindowsLbl, -1, -1, Short.MAX_VALUE).addGap(51, 51, 51)).addGroup(peakTrimmingPanelLayout.createSequentialGroup().addGroup(peakTrimmingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.windowWidthThompsonLbl, -2, 355, -2).addComponent(this.trimMs1Lbl, -2, 370, -2).addComponent(this.trimMsMsLbl, -2, 374, -2).addComponent(this.numPeaksPerWindowLbl, -2, 374, -2).addComponent(this.minAllowedIntensityRatioToBasePeakLbl, -2, 374, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE))).addGroup(peakTrimmingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.trimMs1Cmb, GroupLayout.Alignment.TRAILING, -2, 185, -2).addComponent(this.trimMsMsCmb, GroupLayout.Alignment.TRAILING, -2, 185, -2).addComponent(this.numPeaksPerWindowTxt, GroupLayout.Alignment.TRAILING, -2, 185, -2).addComponent(this.minAllowedIntensityRatioToBasePeakTxt, GroupLayout.Alignment.TRAILING, -2, 185, -2).addComponent(this.windowWidthThompsonTxt, GroupLayout.Alignment.TRAILING, -2, 185, -2).addComponent(this.numberOfWindowsTxt, GroupLayout.Alignment.TRAILING, -2, 185, -2).addComponent(this.normalizePeaksAcrossAllWindowsCmb, GroupLayout.Alignment.TRAILING, -2, 185, -2)).addGap(25, 25, 25)));
        peakTrimmingPanelLayout.linkSize(0, this.minAllowedIntensityRatioToBasePeakTxt, this.numPeaksPerWindowTxt, this.numberOfWindowsTxt, this.windowWidthThompsonTxt);
        peakTrimmingPanelLayout.setVerticalGroup(peakTrimmingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peakTrimmingPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(peakTrimmingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.trimMs1Lbl).addComponent(this.trimMs1Cmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(peakTrimmingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.trimMsMsLbl).addComponent(this.trimMsMsCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(peakTrimmingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numPeaksPerWindowLbl).addComponent(this.numPeaksPerWindowTxt, -2, -1, -2)).addGap(0, 0, 0).addGroup(peakTrimmingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minAllowedIntensityRatioToBasePeakLbl).addComponent(this.minAllowedIntensityRatioToBasePeakTxt, -2, -1, -2)).addGap(0, 0, 0).addGroup(peakTrimmingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.windowWidthThompsonLbl).addComponent(this.windowWidthThompsonTxt, -2, -1, -2)).addGap(0, 0, 0).addGroup(peakTrimmingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numberOfWindowsLbl).addComponent(this.numberOfWindowsTxt, -2, -1, -2)).addGap(0, 0, 0).addGroup(peakTrimmingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.normalizePeaksAcrossAllWindowsLbl).addComponent(this.normalizePeaksAcrossAllWindowsCmb, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.tabbedPane.addTab("Peak Trimming", this.peakTrimmingPanel);
        this.proteinGroupingPanel.setBackground(new Color(230, 230, 230));
        this.modifiedPeptidesAreDifferentLbl.setText("Modified Peptides Are Different");
        this.modifiedPeptidesAreDifferentCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.modifiedPeptidesAreDifferentCmb.setSelectedIndex(1);
        this.excludeOneHitWondersLbl.setText("Exlude One Hit Wonders");
        this.excludeOneHitWondersCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.excludeOneHitWondersCmb.setSelectedIndex(1);
        GroupLayout proteinGroupingPanelLayout = new GroupLayout(this.proteinGroupingPanel);
        this.proteinGroupingPanel.setLayout(proteinGroupingPanelLayout);
        proteinGroupingPanelLayout.setHorizontalGroup(proteinGroupingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proteinGroupingPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(proteinGroupingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.modifiedPeptidesAreDifferentLbl, -2, 370, -2).addComponent(this.excludeOneHitWondersLbl, -2, 370, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 18, Short.MAX_VALUE).addGroup(proteinGroupingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.modifiedPeptidesAreDifferentCmb, 0, 185, Short.MAX_VALUE).addComponent(this.excludeOneHitWondersCmb, 0, -1, Short.MAX_VALUE)).addGap(25, 25, 25)));
        proteinGroupingPanelLayout.setVerticalGroup(proteinGroupingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, proteinGroupingPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(proteinGroupingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.modifiedPeptidesAreDifferentLbl).addComponent(this.modifiedPeptidesAreDifferentCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(proteinGroupingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.excludeOneHitWondersLbl).addComponent(this.excludeOneHitWondersCmb, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.tabbedPane.addTab("Protein Grouping", this.proteinGroupingPanel);
        this.inSilicoDigestionPanel.setBackground(new Color(230, 230, 230));
        this.fragmentationTerminusLbl.setText("Fragmentation Terminus");
        this.fragmentationTerminusCmb.setModel(new DefaultComboBoxModel<MetaMorpheusParameters.MetaMorpheusFragmentationTerminusType>(MetaMorpheusParameters.MetaMorpheusFragmentationTerminusType.values()));
        this.maxFragmentSizeLbl.setText("Max Fragment Size");
        this.maxFragmentSizeTxt.setHorizontalAlignment(0);
        this.maxFragmentSizeTxt.setText("30000");
        this.maxFragmentSizeTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MetaMorpheusParametersDialog.this.maxFragmentSizeTxtKeyReleased(evt);
            }
        });
        this.searchTargetLabel.setText("Search Target");
        this.searchTargetComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.decoyTypeLbl.setText("Decoy Type");
        this.decoyTypeCmb.setModel(new DefaultComboBoxModel<MetaMorpheusParameters.MetaMorpheusDecoyType>(MetaMorpheusParameters.MetaMorpheusDecoyType.values()));
        this.maxModIsoformsLbl.setText("Max Modification Isoforms");
        this.maxModIsoformsTxt.setHorizontalAlignment(0);
        this.maxModIsoformsTxt.setText("1024");
        this.maxModIsoformsTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MetaMorpheusParametersDialog.this.maxModIsoformsTxtKeyReleased(evt);
            }
        });
        this.minVariantDepthLabel.setText("Minimum Variant Depth");
        this.minVariantDepthTxt.setHorizontalAlignment(0);
        this.minVariantDepthTxt.setText("1");
        this.minVariantDepthTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MetaMorpheusParametersDialog.this.minVariantDepthTxtKeyReleased(evt);
            }
        });
        this.maxHetroVariantsLbl.setText("Maximum Heterozygous Variants");
        this.maxHetroVariantsTxt.setHorizontalAlignment(0);
        this.maxHetroVariantsTxt.setText("4");
        this.maxHetroVariantsTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MetaMorpheusParametersDialog.this.maxHetroVariantsTxtKeyReleased(evt);
            }
        });
        GroupLayout inSilicoDigestionPanelLayout = new GroupLayout(this.inSilicoDigestionPanel);
        this.inSilicoDigestionPanel.setLayout(inSilicoDigestionPanelLayout);
        inSilicoDigestionPanelLayout.setHorizontalGroup(inSilicoDigestionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, inSilicoDigestionPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(inSilicoDigestionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.searchTargetLabel, -2, 370, -2).addComponent(this.maxFragmentSizeLbl, -2, 370, -2).addComponent(this.fragmentationTerminusLbl, -2, 370, -2).addComponent(this.minVariantDepthLabel, GroupLayout.Alignment.TRAILING, -2, 370, -2).addComponent(this.maxModIsoformsLbl, -2, 370, -2).addComponent(this.decoyTypeLbl, -2, 370, -2).addComponent(this.maxHetroVariantsLbl, -2, 351, -2)).addGap(18, 18, 18).addGroup(inSilicoDigestionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fragmentationTerminusCmb, GroupLayout.Alignment.TRAILING, -2, 185, -2).addComponent(this.maxFragmentSizeTxt, GroupLayout.Alignment.TRAILING, -2, 185, -2).addComponent(this.searchTargetComboBox, GroupLayout.Alignment.TRAILING, -2, 185, -2).addComponent(this.decoyTypeCmb, GroupLayout.Alignment.TRAILING, -2, 185, -2).addComponent(this.maxModIsoformsTxt, GroupLayout.Alignment.TRAILING, -2, 185, -2).addComponent(this.minVariantDepthTxt, GroupLayout.Alignment.TRAILING, -2, 185, -2).addComponent(this.maxHetroVariantsTxt, GroupLayout.Alignment.TRAILING, -2, 185, -2)).addGap(25, 25, 25)));
        inSilicoDigestionPanelLayout.setVerticalGroup(inSilicoDigestionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, inSilicoDigestionPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(inSilicoDigestionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fragmentationTerminusLbl).addComponent(this.fragmentationTerminusCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(inSilicoDigestionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxFragmentSizeLbl).addComponent(this.maxFragmentSizeTxt, -2, -1, -2)).addGap(0, 0, 0).addGroup(inSilicoDigestionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchTargetComboBox, -2, -1, -2).addComponent(this.searchTargetLabel)).addGap(0, 0, 0).addGroup(inSilicoDigestionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.decoyTypeLbl).addComponent(this.decoyTypeCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(inSilicoDigestionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxModIsoformsLbl).addComponent(this.maxModIsoformsTxt, -2, -1, -2)).addGap(0, 0, 0).addGroup(inSilicoDigestionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minVariantDepthLabel).addComponent(this.minVariantDepthTxt, -2, -1, -2)).addGap(0, 0, 0).addGroup(inSilicoDigestionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxHetroVariantsLbl).addComponent(this.maxHetroVariantsTxt, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.tabbedPane.addTab("In Silico Digestion", this.inSilicoDigestionPanel);
        this.gptmPanel.setBackground(new Color(230, 230, 230));
        this.runGptmLbl.setText("Run G-PTM Search");
        this.runGtpmCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.runGtpmCmb.setSelectedIndex(1);
        this.runGtpmCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MetaMorpheusParametersDialog.this.runGtpmCmbActionPerformed(evt);
            }
        });
        this.gPtmTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Category", "  "}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, String.class, Boolean.class};
                this.canEdit = new boolean[]{false, false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.gPtmTable.setSelectionMode(0);
        this.gPtmScrollPane.setViewportView(this.gPtmTable);
        GroupLayout gptmPanelLayout = new GroupLayout(this.gptmPanel);
        this.gptmPanel.setLayout(gptmPanelLayout);
        gptmPanelLayout.setHorizontalGroup(gptmPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, gptmPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(gptmPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.gPtmScrollPane).addGroup(gptmPanelLayout.createSequentialGroup().addComponent(this.runGptmLbl, -2, 370, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 18, Short.MAX_VALUE).addComponent(this.runGtpmCmb, -2, 185, -2))).addGap(25, 25, 25)));
        gptmPanelLayout.setVerticalGroup(gptmPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, gptmPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(gptmPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.runGptmLbl).addComponent(this.runGtpmCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.gPtmScrollPane, -1, 296, Short.MAX_VALUE).addContainerGap()));
        this.tabbedPane.addTab("G-PTM Search", this.gptmPanel);
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane, -1, 623, Short.MAX_VALUE).addComponent(this.jSeparator1).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.openDialogHelpJButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.advancedSettingsWarningLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane, -1, 395, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.openDialogHelpJButton).addComponent(this.advancedSettingsWarningLabel).addComponent(this.okButton).addComponent(this.closeButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput(true)) {
            this.dispose();
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.cancelled = true;
        this.dispose();
    }

    private void openDialogHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void openDialogHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void openDialogHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://github.com/smith-chem-wisc/MetaMorpheus/wiki");
        this.setCursor(new Cursor(0));
    }

    private void maxFragmentSizeTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxPepLengthTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void minPepLengthTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void numPeaksPerWindowTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void deconvIntRatioTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void deconvMassToleranceTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxNumModPeptideTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void numberOfPartitionsTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeButtonActionPerformed(null);
    }

    private void minAllowedIntensityRatioToBasePeakTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void windowWidthThompsonTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void numberOfWindowsTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxModIsoformsTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxHetroVariantsTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void scoreCutoffTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void minVariantDepthTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void runGtpmCmbActionPerformed(ActionEvent evt) {
        this.gPtmTable.setEnabled(this.runGtpmCmb.getSelectedIndex() == 0);
    }

    private void minimumAllowedInternalFragmentLengthTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    public boolean validateInput(boolean showMessage) {
        boolean valid = true;
        valid = GuiUtilities.validateIntegerInput(this, this.numberOfPartitionsLbl, this.numberOfPartitionsTxt, "number of partitions", "Number of Partitions Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.maxNumModPeptideLbl, this.maxNumModPeptideTxt, "number of modifictions per peptide", "Number of Modifications Error", false, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.scoreCutoffLabel, this.scoreCutoffTxt, "score cut-off", "Score Cut-off Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.peptideLengthJLabel, this.minPepLengthTxt, "minimim peptide length", "Peptide Length Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.peptideLengthJLabel, this.maxPepLengthTxt, "maximum peptide length", "Peptide Length Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.deconvIntRatioLbl, this.deconvIntRatioTxt, "deconvolution intensity ratio", "Deconvolution Itensity Ratio Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.deconvMassToleranceLbl, this.deconvMassToleranceTxt, "deconvolution mass tolerance", "Deconvolution Mass Tolerance Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.numPeaksPerWindowLbl, this.numPeaksPerWindowTxt, "number of peaks per window", "Number of Peaks per Window Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.minAllowedIntensityRatioToBasePeakLbl, this.minAllowedIntensityRatioToBasePeakTxt, "minimum allowed intensity ratio", "Minimum Intensity Ratio Error", true, showMessage, valid);
        if (!this.windowWidthThompsonTxt.getText().isEmpty()) {
            valid = GuiUtilities.validateDoubleInput(this, this.windowWidthThompsonLbl, this.windowWidthThompsonTxt, "window with in Thompson", "Window Thompson Width Error", true, showMessage, valid);
        }
        if (!this.numberOfWindowsTxt.getText().isEmpty()) {
            valid = GuiUtilities.validateIntegerInput(this, this.numberOfWindowsLbl, this.numberOfWindowsTxt, "number of windows", "Number of Windows Error", true, showMessage, valid);
        }
        valid = GuiUtilities.validateDoubleInput(this, this.maxFragmentSizeLbl, this.maxFragmentSizeTxt, "maximum fragment size", "Maximum Fragment Size Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.maxModIsoformsLbl, this.maxModIsoformsTxt, "maximum modification isoforms", "Maximum Modification Isoforms Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.minVariantDepthLabel, this.minVariantDepthTxt, "minimum variant depth", "Minimum Variant Depth Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.maxHetroVariantsLbl, this.maxHetroVariantsTxt, "maximum hetrozygous variants", "Maximum Hetrozygous Variants Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.minimumAllowedInternalFragmentLengthLbl, this.minimumAllowedInternalFragmentLengthTxt, "minimum allowed internal fragment length", "Minimum Allowed Internal Fragment Length Error", true, showMessage, valid);
        try {
            double lowValue = Double.parseDouble(this.minPepLengthTxt.getText().trim());
            double highValue = Double.parseDouble(this.maxPepLengthTxt.getText().trim());
            if (lowValue > highValue) {
                if (showMessage && valid) {
                    JOptionPane.showMessageDialog(this, "The lower range value has to be smaller than the upper range value.", "Peptide Length Error", 2);
                }
                valid = false;
                this.peptideLengthJLabel.setForeground(Color.RED);
                this.peptideLengthJLabel.setToolTipText("Please select a valid range (upper <= higher)");
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.okButton.setEnabled(valid);
        return valid;
    }
}

