/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification.algorithm;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.gui.GuiUtilities;
import com.compomics.util.gui.parameters.identification.AlgorithmParametersDialog;
import com.compomics.util.gui.parameters.identification.IdentificationAlgorithmParameter;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.parameters.identification.tool_specific.SageParameters;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class SageParametersDialog
extends JDialog
implements AlgorithmParametersDialog {
    private boolean cancelled = false;
    private boolean editable;
    private JPanel advancedSearchSettingsPanel;
    private JLabel advancedSettingsWarningLabel;
    private JPanel backgroundPanel;
    private JLabel batchSizeLabel;
    private JTextField batchSizeTxt;
    private JLabel bucketSizeLabel;
    private JTextField bucketSizeTxt;
    private JComboBox chimericSpectraCmb;
    private JLabel chimericSpectraLabel;
    private JButton closeButton;
    private JComboBox combineChargeStatesCmb;
    private JLabel combineChargeStatesLabel;
    private JComboBox deisotopeCmb;
    private JLabel deisotopeLabel;
    private JLabel fragmentMzDividerLabel;
    private JLabel fragmentMzLabel;
    private JComboBox generateDecoysCmb;
    private JLabel generateDecoysLabel;
    private JComboBox lfqCmb;
    private JComboBox lfqIntegrationCmb;
    private JLabel lfqIntegrationLabel;
    private JLabel lfqLabel;
    private JComboBox lfqPeakScoringCmb;
    private JLabel lfqPeakScoringLabel;
    private JLabel lfqPpmToleranceLabel;
    private JTextField lfqPpmToleranceTxt;
    private JLabel lfqSpectraAngleLabel;
    private JTextField lfqSpectralAngleTxt;
    private JLabel maxFragmentChargeLabel;
    private JTextField maxFragmentChargeTxt;
    private JTextField maxFragmentMzTxt;
    private JTextField maxNumberOfPeaksTxt;
    private JTextField maxPepLengthTxt;
    private JTextField maxPeptideMassTxt;
    private JLabel maxVariableModsLabel;
    private JTextField maxVariableModsTxt;
    private JTextField minFragmentMzTxt;
    private JLabel minIonIndexLabel;
    private JTextField minIonIndexTxt;
    private JLabel minMatchedPeaksLabel;
    private JTextField minMatchedPeaksTxt;
    private JTextField minNumberOfPeaksTxt;
    private JTextField minPepLengthTxt;
    private JTextField minPeptideMassTxt;
    private JLabel numberOfPeaksDividerLabel;
    private JLabel numberOfPeaksLabel;
    private JLabel numberOfPsmsPerSpectrumLabel;
    private JTextField numberOfPsmsPerSpectrumTxt;
    private JButton okButton;
    private JButton openDialogHelpJButton;
    private JLabel peptideLengthDividerLabel;
    private JLabel peptideLengthLabel;
    private JLabel peptideMassDividerLabel;
    private JLabel peptideMassLabel;
    private JComboBox predictRtCmb;
    private JLabel predictRtLabel;
    private JPanel quantificationSettingsPanel;
    private JTabbedPane tabbedPane;
    private JComboBox tmtLevelCmb;
    private JLabel tmtLevelLabel;
    private JComboBox tmtSnCmb;
    private JLabel tmtSnLabel;
    private JComboBox tmtTypeCmb;
    private JLabel tmtTypeLabel;
    private JComboBox wideWindowCmb;
    private JLabel wideWindowLabel;

    public SageParametersDialog(Frame parent, SageParameters sageParameters, boolean editable) {
        super(parent, true);
        this.editable = editable;
        this.initComponents();
        this.setUpGUI();
        this.populateGUI(sageParameters);
        this.validateInput(false);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public SageParametersDialog(Dialog owner, Frame parent, SageParameters sageParameters, boolean editable) {
        super(owner, true);
        this.editable = editable;
        this.initComponents();
        this.setUpGUI();
        this.populateGUI(sageParameters);
        this.validateInput(false);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGUI() {
        this.generateDecoysCmb.setRenderer(new AlignedListCellRenderer(0));
        this.tmtTypeCmb.setRenderer(new AlignedListCellRenderer(0));
        this.tmtLevelCmb.setRenderer(new AlignedListCellRenderer(0));
        this.tmtSnCmb.setRenderer(new AlignedListCellRenderer(0));
        this.lfqCmb.setRenderer(new AlignedListCellRenderer(0));
        this.deisotopeCmb.setRenderer(new AlignedListCellRenderer(0));
        this.chimericSpectraCmb.setRenderer(new AlignedListCellRenderer(0));
        this.predictRtCmb.setRenderer(new AlignedListCellRenderer(0));
        this.wideWindowCmb.setRenderer(new AlignedListCellRenderer(0));
        this.lfqPeakScoringCmb.setRenderer(new AlignedListCellRenderer(0));
        this.lfqIntegrationCmb.setRenderer(new AlignedListCellRenderer(0));
        this.combineChargeStatesCmb.setRenderer(new AlignedListCellRenderer(0));
        this.generateDecoysCmb.setEnabled(this.editable);
        this.tmtTypeCmb.setEnabled(this.editable);
        this.tmtLevelCmb.setEnabled(this.editable);
        this.tmtSnCmb.setEnabled(this.editable);
        this.lfqCmb.setEnabled(this.editable);
        this.deisotopeCmb.setEnabled(this.editable);
        this.chimericSpectraCmb.setEnabled(this.editable);
        this.predictRtCmb.setEnabled(this.editable);
        this.wideWindowCmb.setEnabled(this.editable);
        this.lfqPeakScoringCmb.setEnabled(this.editable);
        this.lfqIntegrationCmb.setEnabled(this.editable);
        this.combineChargeStatesCmb.setEnabled(this.editable);
        this.bucketSizeTxt.setEditable(this.editable);
        this.bucketSizeTxt.setEnabled(this.editable);
        this.minPepLengthTxt.setEditable(this.editable);
        this.minPepLengthTxt.setEnabled(this.editable);
        this.maxPepLengthTxt.setEditable(this.editable);
        this.maxPepLengthTxt.setEnabled(this.editable);
        this.minFragmentMzTxt.setEditable(this.editable);
        this.minFragmentMzTxt.setEnabled(this.editable);
        this.maxFragmentMzTxt.setEditable(this.editable);
        this.maxFragmentMzTxt.setEnabled(this.editable);
        this.minPepLengthTxt.setEditable(this.editable);
        this.minPepLengthTxt.setEnabled(this.editable);
        this.maxPepLengthTxt.setEditable(this.editable);
        this.maxPepLengthTxt.setEnabled(this.editable);
        this.minIonIndexTxt.setEditable(this.editable);
        this.minIonIndexTxt.setEnabled(this.editable);
        this.maxVariableModsTxt.setEditable(this.editable);
        this.maxVariableModsTxt.setEnabled(this.editable);
        this.minNumberOfPeaksTxt.setEditable(this.editable);
        this.minNumberOfPeaksTxt.setEnabled(this.editable);
        this.maxNumberOfPeaksTxt.setEditable(this.editable);
        this.maxNumberOfPeaksTxt.setEnabled(this.editable);
        this.maxFragmentChargeTxt.setEditable(this.editable);
        this.maxFragmentChargeTxt.setEnabled(this.editable);
        this.numberOfPsmsPerSpectrumTxt.setEditable(this.editable);
        this.numberOfPsmsPerSpectrumTxt.setEnabled(this.editable);
        this.batchSizeTxt.setEditable(this.editable);
        this.batchSizeTxt.setEnabled(this.editable);
        this.lfqSpectralAngleTxt.setEditable(this.editable);
        this.lfqSpectralAngleTxt.setEnabled(this.editable);
        this.lfqPpmToleranceTxt.setEditable(this.editable);
        this.lfqPpmToleranceTxt.setEnabled(this.editable);
    }

    private void populateGUI(SageParameters sageParameters) {
        if (sageParameters.getBucketSize() != null) {
            this.bucketSizeTxt.setText(sageParameters.getBucketSize() + "");
        }
        if (sageParameters.getMinPeptideLength() != null) {
            this.minPepLengthTxt.setText(sageParameters.getMinPeptideLength() + "");
        }
        if (sageParameters.getMaxPeptideLength() != null) {
            this.maxPepLengthTxt.setText(sageParameters.getMaxPeptideLength() + "");
        }
        if (sageParameters.getMinFragmentMz() != null) {
            this.minFragmentMzTxt.setText(sageParameters.getMinFragmentMz() + "");
        }
        if (sageParameters.getMaxFragmentMz() != null) {
            this.maxFragmentMzTxt.setText(sageParameters.getMaxFragmentMz() + "");
        }
        if (sageParameters.getMinPeptideMass() != null) {
            this.minPeptideMassTxt.setText(sageParameters.getMinPeptideMass() + "");
        }
        if (sageParameters.getMaxPeptideMass() != null) {
            this.maxPeptideMassTxt.setText(sageParameters.getMaxPeptideMass() + "");
        }
        if (sageParameters.getMinIonIndex() != null) {
            this.minIonIndexTxt.setText(sageParameters.getMinIonIndex() + "");
        }
        if (sageParameters.getGenerateDecoys().booleanValue()) {
            this.generateDecoysCmb.setSelectedIndex(0);
        } else {
            this.generateDecoysCmb.setSelectedIndex(1);
        }
        if (sageParameters.getMaxVariableMods() != null) {
            this.maxVariableModsTxt.setText(sageParameters.getMaxVariableMods() + "");
        }
        if (sageParameters.getTmtType() != null) {
            this.tmtTypeCmb.setSelectedItem(sageParameters.getTmtType());
        } else {
            this.tmtTypeCmb.setSelectedItem("None");
        }
        if (sageParameters.getTmtLevel() != null) {
            this.tmtLevelCmb.setSelectedItem(sageParameters.getTmtLevel());
        } else {
            this.tmtLevelCmb.setSelectedItem("3");
        }
        if (sageParameters.getTmtSn().booleanValue()) {
            this.tmtSnCmb.setSelectedIndex(0);
        } else {
            this.tmtSnCmb.setSelectedIndex(1);
        }
        if (sageParameters.getPerformLfq().booleanValue()) {
            this.lfqCmb.setSelectedIndex(0);
        } else {
            this.lfqCmb.setSelectedIndex(1);
        }
        if (sageParameters.getLfqPeakScoring() != null) {
            this.lfqPeakScoringCmb.setSelectedItem(sageParameters.getLfqPeakScoring());
        } else {
            this.lfqPeakScoringCmb.setSelectedItem("Hybrid");
        }
        if (sageParameters.getLfqIntergration() != null) {
            this.lfqIntegrationCmb.setSelectedItem(sageParameters.getLfqIntergration());
        } else {
            this.lfqIntegrationCmb.setSelectedItem("Sum");
        }
        if (sageParameters.getLfqSpectralAngle() != null) {
            this.lfqSpectralAngleTxt.setText(sageParameters.getLfqSpectralAngle() + "");
        }
        if (sageParameters.getLfqPpmTolerance() != null) {
            this.lfqPpmToleranceTxt.setText(sageParameters.getLfqPpmTolerance() + "");
        }
        if (sageParameters.getCombineChargeStates().booleanValue()) {
            this.combineChargeStatesCmb.setSelectedIndex(0);
        } else {
            this.combineChargeStatesCmb.setSelectedIndex(1);
        }
        if (sageParameters.getDeisotope().booleanValue()) {
            this.deisotopeCmb.setSelectedIndex(0);
        } else {
            this.deisotopeCmb.setSelectedIndex(1);
        }
        if (sageParameters.getChimera().booleanValue()) {
            this.chimericSpectraCmb.setSelectedIndex(0);
        } else {
            this.chimericSpectraCmb.setSelectedIndex(1);
        }
        if (sageParameters.getWideWindow().booleanValue()) {
            this.wideWindowCmb.setSelectedIndex(0);
        } else {
            this.wideWindowCmb.setSelectedIndex(1);
        }
        if (sageParameters.getPredictRt().booleanValue()) {
            this.predictRtCmb.setSelectedIndex(0);
        } else {
            this.predictRtCmb.setSelectedIndex(1);
        }
        if (sageParameters.getMinPeaks() != null) {
            this.minNumberOfPeaksTxt.setText(sageParameters.getMinPeaks() + "");
        }
        if (sageParameters.getMaxPeaks() != null) {
            this.maxNumberOfPeaksTxt.setText(sageParameters.getMaxPeaks() + "");
        }
        if (sageParameters.getMinMatchedPeaks() != null) {
            this.minMatchedPeaksTxt.setText(sageParameters.getMinMatchedPeaks() + "");
        }
        if (sageParameters.getMaxFragmentCharge() != null) {
            this.maxFragmentChargeTxt.setText(sageParameters.getMaxFragmentCharge() + "");
        }
        if (sageParameters.getNumPsmsPerSpectrum() != null) {
            this.numberOfPsmsPerSpectrumTxt.setText(sageParameters.getNumPsmsPerSpectrum() + "");
        }
        if (sageParameters.getBatchSize() != null) {
            this.batchSizeTxt.setText(sageParameters.getBatchSize() + "");
        } else {
            this.batchSizeTxt.setText("");
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public IdentificationAlgorithmParameter getParameters() {
        return this.getInput();
    }

    public SageParameters getInput() {
        SageParameters result = new SageParameters();
        String input = this.bucketSizeTxt.getText().trim();
        if (!input.equals("")) {
            result.setBucketSize(Integer.valueOf(input));
        }
        if (!(input = this.minPepLengthTxt.getText().trim()).equals("")) {
            result.setMinPeptideLength(Integer.parseInt(input));
        }
        if (!(input = this.maxPepLengthTxt.getText().trim()).equals("")) {
            result.setMaxPeptideLength(Integer.parseInt(input));
        }
        if (!(input = this.minFragmentMzTxt.getText().trim()).equals("")) {
            result.setMinFragmentMz(Double.valueOf(input));
        }
        if (!(input = this.maxFragmentMzTxt.getText().trim()).equals("")) {
            result.setMaxFragmentMz(Double.valueOf(input));
        }
        if (!(input = this.minPeptideMassTxt.getText().trim()).equals("")) {
            result.setMinPeptideMass(Double.valueOf(input));
        }
        if (!(input = this.maxPeptideMassTxt.getText().trim()).equals("")) {
            result.setMaxPeptideMass(Double.valueOf(input));
        }
        if (!(input = this.minIonIndexTxt.getText().trim()).equals("")) {
            result.setMinIonIndex(Integer.valueOf(input));
        }
        if (!(input = this.maxVariableModsTxt.getText().trim()).equals("")) {
            result.setMaxVariableMods(Integer.valueOf(input));
        }
        result.setGenerateDecoys(this.generateDecoysCmb.getSelectedIndex() == 0);
        if (this.tmtTypeCmb.getSelectedIndex() != 0) {
            result.setTmtType((String)this.tmtTypeCmb.getSelectedItem());
        } else {
            result.setTmtType(null);
        }
        result.setTmtLevel(Integer.valueOf((String)this.tmtLevelCmb.getSelectedItem()));
        result.setTmtSn(this.tmtSnCmb.getSelectedIndex() == 0);
        result.setPerformLfq(this.lfqCmb.getSelectedIndex() == 0);
        result.setDeisotope(this.deisotopeCmb.getSelectedIndex() == 0);
        result.setChimera(this.chimericSpectraCmb.getSelectedIndex() == 0);
        result.setPredictRt(this.predictRtCmb.getSelectedIndex() == 0);
        result.setCombineChargeStates(this.combineChargeStatesCmb.getSelectedIndex() == 0);
        input = this.minNumberOfPeaksTxt.getText().trim();
        if (!input.equals("")) {
            result.setMinPeaks(Integer.valueOf(input));
        }
        if (!(input = this.maxNumberOfPeaksTxt.getText().trim()).equals("")) {
            result.setMaxPeaks(Integer.valueOf(input));
        }
        if (!(input = this.minMatchedPeaksTxt.getText().trim()).equals("")) {
            result.setMinMatchedPeaks(Integer.valueOf(input));
        }
        if (!(input = this.maxFragmentChargeTxt.getText().trim()).equals("")) {
            result.setMaxFragmentCharge(Integer.valueOf(input));
        }
        if (!(input = this.numberOfPsmsPerSpectrumTxt.getText().trim()).equals("")) {
            result.setNumPsmsPerSpectrum(Integer.valueOf(input));
        }
        if (!(input = this.batchSizeTxt.getText().trim()).equals("")) {
            result.setBatchSize(Integer.valueOf(input));
        }
        return result;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.okButton = new JButton();
        this.closeButton = new JButton();
        this.openDialogHelpJButton = new JButton();
        this.advancedSettingsWarningLabel = new JLabel();
        this.tabbedPane = new JTabbedPane();
        this.advancedSearchSettingsPanel = new JPanel();
        this.predictRtCmb = new JComboBox();
        this.batchSizeLabel = new JLabel();
        this.predictRtLabel = new JLabel();
        this.chimericSpectraLabel = new JLabel();
        this.chimericSpectraCmb = new JComboBox();
        this.deisotopeLabel = new JLabel();
        this.deisotopeCmb = new JComboBox();
        this.minPepLengthTxt = new JTextField();
        this.peptideLengthDividerLabel = new JLabel();
        this.maxPepLengthTxt = new JTextField();
        this.peptideLengthLabel = new JLabel();
        this.minIonIndexLabel = new JLabel();
        this.minIonIndexTxt = new JTextField();
        this.generateDecoysLabel = new JLabel();
        this.generateDecoysCmb = new JComboBox();
        this.bucketSizeLabel = new JLabel();
        this.bucketSizeTxt = new JTextField();
        this.fragmentMzLabel = new JLabel();
        this.minFragmentMzTxt = new JTextField();
        this.fragmentMzDividerLabel = new JLabel();
        this.maxFragmentMzTxt = new JTextField();
        this.peptideMassLabel = new JLabel();
        this.minPeptideMassTxt = new JTextField();
        this.peptideMassDividerLabel = new JLabel();
        this.maxPeptideMassTxt = new JTextField();
        this.numberOfPeaksLabel = new JLabel();
        this.minNumberOfPeaksTxt = new JTextField();
        this.numberOfPeaksDividerLabel = new JLabel();
        this.maxNumberOfPeaksTxt = new JTextField();
        this.maxFragmentChargeLabel = new JLabel();
        this.maxFragmentChargeTxt = new JTextField();
        this.numberOfPsmsPerSpectrumLabel = new JLabel();
        this.numberOfPsmsPerSpectrumTxt = new JTextField();
        this.maxVariableModsLabel = new JLabel();
        this.maxVariableModsTxt = new JTextField();
        this.minMatchedPeaksLabel = new JLabel();
        this.minMatchedPeaksTxt = new JTextField();
        this.batchSizeTxt = new JTextField();
        this.wideWindowLabel = new JLabel();
        this.wideWindowCmb = new JComboBox();
        this.quantificationSettingsPanel = new JPanel();
        this.tmtTypeLabel = new JLabel();
        this.tmtTypeCmb = new JComboBox();
        this.tmtLevelLabel = new JLabel();
        this.tmtLevelCmb = new JComboBox();
        this.tmtSnCmb = new JComboBox();
        this.tmtSnLabel = new JLabel();
        this.lfqLabel = new JLabel();
        this.lfqCmb = new JComboBox();
        this.lfqPeakScoringLabel = new JLabel();
        this.lfqPeakScoringCmb = new JComboBox();
        this.lfqIntegrationLabel = new JLabel();
        this.lfqIntegrationCmb = new JComboBox();
        this.lfqSpectraAngleLabel = new JLabel();
        this.lfqPpmToleranceLabel = new JLabel();
        this.lfqSpectralAngleTxt = new JTextField();
        this.lfqPpmToleranceTxt = new JTextField();
        this.combineChargeStatesLabel = new JLabel();
        this.combineChargeStatesCmb = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Sage Advanced Settings");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SageParametersDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SageParametersDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.openDialogHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.openDialogHelpJButton.setToolTipText("Help");
        this.openDialogHelpJButton.setBorder(null);
        this.openDialogHelpJButton.setBorderPainted(false);
        this.openDialogHelpJButton.setContentAreaFilled(false);
        this.openDialogHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SageParametersDialog.this.openDialogHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SageParametersDialog.this.openDialogHelpJButtonMouseExited(evt);
            }
        });
        this.openDialogHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SageParametersDialog.this.openDialogHelpJButtonActionPerformed(evt);
            }
        });
        this.advancedSettingsWarningLabel.setText("Click to open the Sage web page");
        this.advancedSearchSettingsPanel.setBorder(null);
        this.advancedSearchSettingsPanel.setOpaque(false);
        this.predictRtCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.batchSizeLabel.setText("Batch Size (if not set: CPUs/2)");
        this.predictRtLabel.setText("Predict Retention Time");
        this.chimericSpectraLabel.setText("Chimeric Spectra");
        this.chimericSpectraCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.chimericSpectraCmb.setSelectedIndex(1);
        this.deisotopeLabel.setText("Deisotope");
        this.deisotopeCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.deisotopeCmb.setSelectedIndex(1);
        this.minPepLengthTxt.setHorizontalAlignment(0);
        this.minPepLengthTxt.setText("8");
        this.minPepLengthTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SageParametersDialog.this.minPepLengthTxtKeyReleased(evt);
            }
        });
        this.peptideLengthDividerLabel.setHorizontalAlignment(0);
        this.peptideLengthDividerLabel.setText("-");
        this.maxPepLengthTxt.setHorizontalAlignment(0);
        this.maxPepLengthTxt.setText("30");
        this.maxPepLengthTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SageParametersDialog.this.maxPepLengthTxtKeyReleased(evt);
            }
        });
        this.peptideLengthLabel.setText("Peptide Length (min - max)");
        this.minIonIndexLabel.setText("Minimum Ion Index");
        this.minIonIndexTxt.setHorizontalAlignment(0);
        this.minIonIndexTxt.setText("2");
        this.minIonIndexTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SageParametersDialog.this.minIonIndexTxtKeyReleased(evt);
            }
        });
        this.generateDecoysLabel.setText("Generate Decoys");
        this.generateDecoysCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.generateDecoysCmb.setSelectedIndex(1);
        this.bucketSizeLabel.setText("Bucket Size");
        this.bucketSizeTxt.setHorizontalAlignment(0);
        this.bucketSizeTxt.setText("32768");
        this.bucketSizeTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SageParametersDialog.this.bucketSizeTxtKeyReleased(evt);
            }
        });
        this.fragmentMzLabel.setText("Fragment m/z (min - max)");
        this.minFragmentMzTxt.setHorizontalAlignment(0);
        this.minFragmentMzTxt.setText("200");
        this.minFragmentMzTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SageParametersDialog.this.minFragmentMzTxtKeyReleased(evt);
            }
        });
        this.fragmentMzDividerLabel.setHorizontalAlignment(0);
        this.fragmentMzDividerLabel.setText("-");
        this.maxFragmentMzTxt.setHorizontalAlignment(0);
        this.maxFragmentMzTxt.setText("2000");
        this.maxFragmentMzTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SageParametersDialog.this.maxFragmentMzTxtKeyReleased(evt);
            }
        });
        this.peptideMassLabel.setText("Peptide Mass (min - max)");
        this.minPeptideMassTxt.setHorizontalAlignment(0);
        this.minPeptideMassTxt.setText("600");
        this.minPeptideMassTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SageParametersDialog.this.minPeptideMassTxtKeyReleased(evt);
            }
        });
        this.peptideMassDividerLabel.setHorizontalAlignment(0);
        this.peptideMassDividerLabel.setText("-");
        this.maxPeptideMassTxt.setHorizontalAlignment(0);
        this.maxPeptideMassTxt.setText("5000");
        this.maxPeptideMassTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SageParametersDialog.this.maxPeptideMassTxtKeyReleased(evt);
            }
        });
        this.numberOfPeaksLabel.setText("Number of Peaks (min - max)");
        this.minNumberOfPeaksTxt.setHorizontalAlignment(0);
        this.minNumberOfPeaksTxt.setText("15");
        this.minNumberOfPeaksTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SageParametersDialog.this.minNumberOfPeaksTxtKeyReleased(evt);
            }
        });
        this.numberOfPeaksDividerLabel.setHorizontalAlignment(0);
        this.numberOfPeaksDividerLabel.setText("-");
        this.maxNumberOfPeaksTxt.setHorizontalAlignment(0);
        this.maxNumberOfPeaksTxt.setText("150");
        this.maxNumberOfPeaksTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SageParametersDialog.this.maxNumberOfPeaksTxtKeyReleased(evt);
            }
        });
        this.maxFragmentChargeLabel.setText("Maximum Fragment Charge");
        this.maxFragmentChargeTxt.setHorizontalAlignment(0);
        this.maxFragmentChargeTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SageParametersDialog.this.maxFragmentChargeTxtKeyReleased(evt);
            }
        });
        this.numberOfPsmsPerSpectrumLabel.setText("Number of PSMs per Spectrum");
        this.numberOfPsmsPerSpectrumTxt.setHorizontalAlignment(0);
        this.numberOfPsmsPerSpectrumTxt.setText("1");
        this.numberOfPsmsPerSpectrumTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SageParametersDialog.this.numberOfPsmsPerSpectrumTxtKeyReleased(evt);
            }
        });
        this.maxVariableModsLabel.setText("Maximum Variable Modifications");
        this.maxVariableModsTxt.setHorizontalAlignment(0);
        this.maxVariableModsTxt.setText("2");
        this.maxVariableModsTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SageParametersDialog.this.maxVariableModsTxtKeyReleased(evt);
            }
        });
        this.minMatchedPeaksLabel.setText("Minimum Matched Peaks");
        this.minMatchedPeaksTxt.setHorizontalAlignment(0);
        this.minMatchedPeaksTxt.setText("4");
        this.minMatchedPeaksTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SageParametersDialog.this.minMatchedPeaksTxtKeyReleased(evt);
            }
        });
        this.batchSizeTxt.setHorizontalAlignment(0);
        this.batchSizeTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SageParametersDialog.this.batchSizeTxtKeyReleased(evt);
            }
        });
        this.wideWindowLabel.setText("Wide Window");
        this.wideWindowCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.wideWindowCmb.setSelectedIndex(1);
        GroupLayout advancedSearchSettingsPanelLayout = new GroupLayout(this.advancedSearchSettingsPanel);
        this.advancedSearchSettingsPanel.setLayout(advancedSearchSettingsPanelLayout);
        advancedSearchSettingsPanelLayout.setHorizontalGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.predictRtLabel, -2, 200, -2).addComponent(this.batchSizeLabel, -2, 200, -2).addComponent(this.chimericSpectraLabel, -2, 200, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chimericSpectraCmb, 0, -1, Short.MAX_VALUE).addComponent(this.predictRtCmb, 0, -1, Short.MAX_VALUE).addComponent(this.batchSizeTxt, GroupLayout.Alignment.TRAILING))).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.deisotopeLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deisotopeCmb, 0, -1, Short.MAX_VALUE)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.minIonIndexLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minIonIndexTxt)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.generateDecoysLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.generateDecoysCmb, 0, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.bucketSizeLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bucketSizeTxt)).addGroup(GroupLayout.Alignment.TRAILING, advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.maxFragmentChargeLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxFragmentChargeTxt)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.numberOfPsmsPerSpectrumLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.numberOfPsmsPerSpectrumTxt)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.peptideMassLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minPeptideMassTxt)).addGroup(GroupLayout.Alignment.LEADING, advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.fragmentMzLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minFragmentMzTxt, -2, 79, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fragmentMzDividerLabel, -2, 27, -2).addComponent(this.peptideMassDividerLabel, -2, 27, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 18, Short.MAX_VALUE).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.maxPeptideMassTxt, -1, 86, Short.MAX_VALUE).addComponent(this.maxFragmentMzTxt))).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.peptideLengthLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minPepLengthTxt, -2, 71, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.peptideLengthDividerLabel, -2, 27, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.maxPepLengthTxt, -2, 94, -2)).addGroup(GroupLayout.Alignment.TRAILING, advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.numberOfPeaksLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minNumberOfPeaksTxt, -2, 79, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.numberOfPeaksDividerLabel, -2, 27, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.maxNumberOfPeaksTxt, -2, 80, -2)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.maxVariableModsLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxVariableModsTxt)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.minMatchedPeaksLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minMatchedPeaksTxt)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.wideWindowLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.wideWindowCmb, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        advancedSearchSettingsPanelLayout.linkSize(0, this.maxFragmentMzTxt, this.maxNumberOfPeaksTxt, this.maxPepLengthTxt, this.maxPeptideMassTxt, this.minFragmentMzTxt, this.minNumberOfPeaksTxt, this.minPepLengthTxt, this.minPeptideMassTxt);
        advancedSearchSettingsPanelLayout.setVerticalGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bucketSizeLabel).addComponent(this.bucketSizeTxt, -2, -1, -2)).addGap(0, 0, 0).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minPepLengthTxt, -2, -1, -2).addComponent(this.maxPepLengthTxt, -2, -1, -2).addComponent(this.peptideLengthDividerLabel).addComponent(this.peptideLengthLabel)).addGap(0, 0, 0).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minFragmentMzTxt, -2, -1, -2).addComponent(this.maxFragmentMzTxt, -2, -1, -2).addComponent(this.fragmentMzDividerLabel).addComponent(this.fragmentMzLabel)).addGap(0, 0, 0).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minPeptideMassTxt, -2, -1, -2).addComponent(this.maxPeptideMassTxt, -2, -1, -2).addComponent(this.peptideMassDividerLabel).addComponent(this.peptideMassLabel)).addGap(0, 0, 0).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minIonIndexLabel).addComponent(this.minIonIndexTxt, -2, -1, -2)).addGap(0, 0, 0).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxVariableModsLabel).addComponent(this.maxVariableModsTxt, -2, -1, -2)).addGap(0, 0, 0).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.generateDecoysLabel).addComponent(this.generateDecoysCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deisotopeCmb, -2, -1, -2).addComponent(this.deisotopeLabel)).addGap(0, 0, 0).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chimericSpectraCmb, -2, -1, -2).addComponent(this.chimericSpectraLabel)).addGap(0, 0, 0).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.wideWindowCmb, -2, -1, -2).addComponent(this.wideWindowLabel)).addGap(0, 0, 0).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.predictRtCmb, -2, -1, -2).addComponent(this.predictRtLabel)).addGap(0, 0, 0).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minNumberOfPeaksTxt, -2, -1, -2).addComponent(this.maxNumberOfPeaksTxt, -2, -1, -2).addComponent(this.numberOfPeaksDividerLabel).addComponent(this.numberOfPeaksLabel)).addGap(0, 0, 0).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minMatchedPeaksLabel).addComponent(this.minMatchedPeaksTxt, -2, -1, -2)).addGap(0, 0, 0).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxFragmentChargeLabel).addComponent(this.maxFragmentChargeTxt, -2, -1, -2)).addGap(0, 0, 0).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numberOfPsmsPerSpectrumLabel).addComponent(this.numberOfPsmsPerSpectrumTxt, -2, -1, -2)).addGap(0, 0, 0).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.batchSizeLabel).addComponent(this.batchSizeTxt, -2, -1, -2)).addContainerGap()));
        this.tabbedPane.addTab("Search", this.advancedSearchSettingsPanel);
        this.quantificationSettingsPanel.setOpaque(false);
        this.tmtTypeLabel.setText("TMT Type");
        this.tmtTypeCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "Tmt6", "Tmt10", "Tmt11", "Tmt16", "Tmt18"}));
        this.tmtTypeCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SageParametersDialog.this.tmtTypeCmbActionPerformed(evt);
            }
        });
        this.tmtLevelLabel.setText("Level");
        this.tmtLevelCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"2", "3"}));
        this.tmtLevelCmb.setSelectedIndex(1);
        this.tmtSnCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.tmtSnLabel.setText("Signal/Noise");
        this.lfqLabel.setText("LFQ");
        this.lfqCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.lfqCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SageParametersDialog.this.lfqCmbActionPerformed(evt);
            }
        });
        this.lfqPeakScoringLabel.setText("Peak Scoring");
        this.lfqPeakScoringCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Hybrid", "RetentionTime", "SpectralAngle"}));
        this.lfqIntegrationLabel.setText("Integration");
        this.lfqIntegrationCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Sum", "Max"}));
        this.lfqSpectraAngleLabel.setText("Spectral Angle");
        this.lfqPpmToleranceLabel.setText("PPM Tolerance");
        this.lfqSpectralAngleTxt.setHorizontalAlignment(0);
        this.lfqSpectralAngleTxt.setText("0.7");
        this.lfqPpmToleranceTxt.setHorizontalAlignment(0);
        this.lfqPpmToleranceTxt.setText("5.0");
        this.combineChargeStatesLabel.setText("Combine Charge States");
        this.combineChargeStatesCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        GroupLayout quantificationSettingsPanelLayout = new GroupLayout(this.quantificationSettingsPanel);
        this.quantificationSettingsPanel.setLayout(quantificationSettingsPanelLayout);
        quantificationSettingsPanelLayout.setHorizontalGroup(quantificationSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(quantificationSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(quantificationSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(quantificationSettingsPanelLayout.createSequentialGroup().addGroup(quantificationSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(quantificationSettingsPanelLayout.createSequentialGroup().addComponent(this.lfqLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lfqCmb, -2, 239, -2)).addComponent(this.tmtTypeLabel, -2, 206, -2)).addGap(0, 0, Short.MAX_VALUE)).addGroup(quantificationSettingsPanelLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(quantificationSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(quantificationSettingsPanelLayout.createSequentialGroup().addComponent(this.combineChargeStatesLabel, -2, 194, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.combineChargeStatesCmb, 0, -1, Short.MAX_VALUE)).addGroup(quantificationSettingsPanelLayout.createSequentialGroup().addGroup(quantificationSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lfqSpectraAngleLabel, -2, 194, -2).addComponent(this.lfqIntegrationLabel, -2, 194, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(quantificationSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lfqIntegrationCmb, 0, -1, Short.MAX_VALUE).addComponent(this.lfqSpectralAngleTxt))).addGroup(quantificationSettingsPanelLayout.createSequentialGroup().addGroup(quantificationSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(quantificationSettingsPanelLayout.createSequentialGroup().addComponent(this.lfqPeakScoringLabel, -2, 194, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lfqPeakScoringCmb, -2, 239, -2)).addGroup(quantificationSettingsPanelLayout.createSequentialGroup().addComponent(this.lfqPpmToleranceLabel, -2, 194, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lfqPpmToleranceTxt)).addGroup(quantificationSettingsPanelLayout.createSequentialGroup().addGroup(quantificationSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tmtSnLabel, -2, 194, -2).addComponent(this.tmtLevelLabel, GroupLayout.Alignment.TRAILING, -2, 194, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(quantificationSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.tmtSnCmb, 0, -1, Short.MAX_VALUE).addComponent(this.tmtLevelCmb, 0, -1, Short.MAX_VALUE).addComponent(this.tmtTypeCmb, 0, 239, Short.MAX_VALUE)))).addGap(0, 0, Short.MAX_VALUE))))).addContainerGap()));
        quantificationSettingsPanelLayout.setVerticalGroup(quantificationSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(quantificationSettingsPanelLayout.createSequentialGroup().addGap(8, 8, 8).addGroup(quantificationSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tmtTypeLabel).addComponent(this.tmtTypeCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(quantificationSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tmtLevelLabel).addComponent(this.tmtLevelCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(quantificationSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tmtSnLabel).addComponent(this.tmtSnCmb, -2, -1, -2)).addGap(18, 18, 18).addGroup(quantificationSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lfqCmb, -2, -1, -2).addComponent(this.lfqLabel)).addGap(0, 0, 0).addGroup(quantificationSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lfqPeakScoringLabel).addComponent(this.lfqPeakScoringCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(quantificationSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lfqIntegrationLabel).addComponent(this.lfqIntegrationCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(quantificationSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lfqSpectraAngleLabel).addComponent(this.lfqSpectralAngleTxt, -2, -1, -2)).addGap(0, 0, 0).addGroup(quantificationSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lfqPpmToleranceTxt, -2, -1, -2).addComponent(this.lfqPpmToleranceLabel)).addGap(0, 0, 0).addGroup(quantificationSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.combineChargeStatesLabel).addComponent(this.combineChargeStatesCmb, -2, -1, -2)).addContainerGap(208, Short.MAX_VALUE)));
        this.tabbedPane.addTab("Quantification", this.quantificationSettingsPanel);
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tabbedPane).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.openDialogHelpJButton).addGap(18, 18, 18).addComponent(this.advancedSettingsWarningLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane, -2, 502, -2).addGap(0, 0, 0).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.openDialogHelpJButton).addComponent(this.advancedSettingsWarningLabel).addComponent(this.okButton).addComponent(this.closeButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.cancelled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput(true)) {
            this.dispose();
        }
    }

    private void openDialogHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void openDialogHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void openDialogHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://github.com/lazear/sage");
        this.setCursor(new Cursor(0));
    }

    private void minPepLengthTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxPepLengthTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void minIonIndexTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void bucketSizeTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void minFragmentMzTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxFragmentMzTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void minPeptideMassTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxPeptideMassTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void minNumberOfPeaksTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxNumberOfPeaksTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxFragmentChargeTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void numberOfPsmsPerSpectrumTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxVariableModsTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void minMatchedPeaksTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void batchSizeTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void tmtTypeCmbActionPerformed(ActionEvent evt) {
        this.tmtLevelCmb.setEnabled(this.tmtTypeCmb.getSelectedIndex() > 0);
        this.tmtSnCmb.setEnabled(this.tmtTypeCmb.getSelectedIndex() > 0);
    }

    private void lfqCmbActionPerformed(ActionEvent evt) {
        this.lfqPeakScoringCmb.setEnabled(this.lfqCmb.getSelectedIndex() == 0);
        this.lfqIntegrationCmb.setEnabled(this.lfqCmb.getSelectedIndex() == 0);
        this.lfqSpectralAngleTxt.setEnabled(this.lfqCmb.getSelectedIndex() == 0);
        this.lfqPpmToleranceTxt.setEnabled(this.lfqCmb.getSelectedIndex() == 0);
    }

    public boolean validateInput(boolean showMessage) {
        boolean valid = true;
        valid = GuiUtilities.validateIntegerInput(this, this.bucketSizeLabel, this.bucketSizeTxt, "bucket size", "Bucket Size Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.peptideLengthLabel, this.minPepLengthTxt, "minimum peptide length", "Peptide Length Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.peptideLengthLabel, this.maxPepLengthTxt, "maximum peptide length", "Peptide Length Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.fragmentMzLabel, this.minFragmentMzTxt, "minimum fragment m/z", "Fragment M/Z Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.fragmentMzLabel, this.maxFragmentMzTxt, "maximum fragment m/z", "Fragment M/Z Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.peptideMassLabel, this.minPeptideMassTxt, "minimum peptide mass", "Peptide Mass Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.peptideMassLabel, this.maxFragmentMzTxt, "maximum peptide mass", "Peptide Mass Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.minIonIndexLabel, this.minIonIndexTxt, "minimum ion index", "Minimum Ion Index Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.maxVariableModsLabel, this.maxVariableModsTxt, "maximum variable modifications", "Maximum Variable Modifications Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.numberOfPeaksLabel, this.minNumberOfPeaksTxt, "minimum number of peaks", "Number of Peaks Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.numberOfPeaksLabel, this.maxNumberOfPeaksTxt, "maximum number of peaks", "Number of Peaks Error", true, showMessage, valid);
        if (!this.maxFragmentChargeTxt.getText().trim().isEmpty()) {
            valid = GuiUtilities.validateIntegerInput(this, this.maxFragmentChargeLabel, this.maxFragmentChargeTxt, "maximum fragment charge", "Fragment Charge Error", true, showMessage, valid);
        } else {
            this.maxFragmentChargeLabel.setForeground(Color.BLACK);
            this.maxFragmentChargeLabel.setToolTipText(null);
        }
        if (!this.minMatchedPeaksTxt.getText().trim().isEmpty()) {
            valid = GuiUtilities.validateIntegerInput(this, this.minMatchedPeaksLabel, this.minMatchedPeaksTxt, "minimum matched peaks", "Minimum Matched Peaks Error", true, showMessage, valid);
        } else {
            this.minMatchedPeaksLabel.setForeground(Color.BLACK);
            this.minMatchedPeaksLabel.setToolTipText(null);
        }
        valid = GuiUtilities.validateIntegerInput(this, this.numberOfPsmsPerSpectrumLabel, this.numberOfPsmsPerSpectrumTxt, "number of PSMs per spectrum", "PSMs per Spectrum Error", true, showMessage, valid);
        if (!this.batchSizeTxt.getText().trim().isEmpty()) {
            valid = GuiUtilities.validateIntegerInput(this, this.batchSizeLabel, this.batchSizeTxt, "batch size", "Batch Size Error", true, showMessage, valid);
        } else {
            this.batchSizeLabel.setForeground(Color.BLACK);
            this.batchSizeLabel.setToolTipText(null);
        }
        valid = GuiUtilities.validateDoubleInput(this, this.lfqSpectraAngleLabel, this.lfqSpectralAngleTxt, "spectral angle", "Spectral Angle Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.lfqPpmToleranceLabel, this.lfqPpmToleranceTxt, "ppm tolerance", "PPM Tolerance Error", true, showMessage, valid);
        this.okButton.setEnabled(valid);
        return valid;
    }
}

