/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification.search;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.biology.proteins.Protein;
import com.compomics.util.experiment.biology.taxonomy.SpeciesFactory;
import com.compomics.util.experiment.identification.utils.ProteinUtils;
import com.compomics.util.experiment.io.biology.protein.FastaParameters;
import com.compomics.util.experiment.io.biology.protein.FastaSummary;
import com.compomics.util.experiment.io.biology.protein.Header;
import com.compomics.util.experiment.io.biology.protein.ProteinDatabase;
import com.compomics.util.experiment.io.biology.protein.converters.DecoyConverter;
import com.compomics.util.experiment.io.biology.protein.iterators.FastaIterator;
import com.compomics.util.gui.JOptionEditorPane;
import com.compomics.util.gui.protein.FastaParametersDialog;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.file.LastSelectedFolder;
import com.compomics.util.parameters.UtilitiesUserParameters;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class SequenceDbDetailsDialog
extends JDialog {
    private static ProgressDialogX progressDialog;
    private LastSelectedFolder lastSelectedFolder = null;
    private boolean dbEditable = true;
    private Image waitingImage;
    private Image normalImange;
    private Frame parentFrame;
    private UtilitiesUserParameters utilitiesUserParameters;
    public static final String lastFolderKey = "fastaFile";
    private String selectedFastaFile = null;
    private FastaParameters fastaParameters = null;
    private FastaSummary fastaSummary = null;
    public static final int SAMPLE_BATCH_SIZE = 50;
    private ArrayList<String> accessionsSample = new ArrayList(50);
    private HashMap<String, Protein> proteinsSample = new HashMap(50);
    private HashMap<String, Header> headersSample = new HashMap(50);
    private FastaIterator proteinIterator;
    private boolean canceled = false;
    private JSpinner accessionsSpinner;
    private JPanel backgroundPanel;
    private JButton browseButton;
    private JButton cancelButton;
    private JLabel databaseHelpSettingsJLabel;
    private JPanel databaseInformationPanel;
    private JTextField dbNameTxt;
    private JButton decoyButton;
    private JLabel editFastaParametersJLabel;
    private JLabel fileLabel;
    private JTextField fileTxt;
    private JLabel lastModifiedLabel;
    private JTextField lastModifiedTxt;
    private JLabel nameLabel;
    private JButton okButton;
    private JPanel previewPanel;
    private JLabel proteinLabel;
    private JTextArea proteinTxt;
    private JScrollPane proteinYxtScrollPane;
    private JLabel sizeLabel;
    private JTextField sizeTxt;
    private JTextField speciesJTextField;
    private JLabel speciesLabel;
    private JLabel targetDecoyTxt;
    private JTextField typeJTextField;
    private JLabel typeLabel;
    private JLabel versionLabel;
    private JTextField versionTxt;

    public SequenceDbDetailsDialog(Dialog owner, Frame parent, String selectedFastaFile, FastaParameters fastaParameters, LastSelectedFolder lastSelectedFolder, boolean dbEditable, Image normalImange, Image waitingImage) {
        super(owner, true);
        this.initComponents();
        this.parentFrame = parent;
        this.lastSelectedFolder = lastSelectedFolder;
        this.dbEditable = dbEditable;
        this.waitingImage = waitingImage;
        this.normalImange = normalImange;
        this.selectedFastaFile = selectedFastaFile;
        this.fastaParameters = fastaParameters;
        this.utilitiesUserParameters = UtilitiesUserParameters.loadUserParameters();
        this.editFastaParametersJLabel.setEnabled(dbEditable);
        if (this.selectedFastaFile != null) {
            this.loadFastaFile(selectedFastaFile, fastaParameters == null, dbEditable, true);
        }
        this.setLocationRelativeTo(owner);
    }

    public SequenceDbDetailsDialog(Frame parent, String selectedFastaFile, FastaParameters fastaParameters, LastSelectedFolder lastSelectedFolder, boolean dbEditable, Image normalImange, Image waitingImage) {
        super(parent, true);
        this.initComponents();
        this.parentFrame = parent;
        this.lastSelectedFolder = lastSelectedFolder;
        this.dbEditable = dbEditable;
        this.waitingImage = waitingImage;
        this.normalImange = normalImange;
        this.selectedFastaFile = selectedFastaFile;
        this.fastaParameters = fastaParameters;
        this.utilitiesUserParameters = UtilitiesUserParameters.loadUserParameters();
        this.editFastaParametersJLabel.setEnabled(dbEditable);
        if (this.selectedFastaFile != null) {
            this.loadFastaFile(selectedFastaFile, fastaParameters == null, dbEditable, true);
        }
        this.setLocationRelativeTo(parent);
    }

    private void setUpGUI() {
        if (this.selectedFastaFile != null) {
            File fastaFile = new File(this.selectedFastaFile);
            this.fileTxt.setText(this.selectedFastaFile);
            this.lastModifiedTxt.setText(new Date(fastaFile.lastModified()).toString());
            if (this.fastaParameters == null) {
                this.dbNameTxt.setText("");
                this.versionTxt.setText("");
                this.decoyButton.setEnabled(true);
            }
            if (this.fastaSummary != null) {
                this.dbNameTxt.setText(this.fastaSummary.getName());
                this.versionTxt.setText(this.fastaSummary.getVersion());
                this.decoyButton.setEnabled(!this.fastaSummary.containsDecoys() && this.dbEditable);
                this.speciesJTextField.setText(SpeciesFactory.getSpeciesDescription(this.fastaSummary.speciesOccurrence));
                HashMap<ProteinDatabase, Integer> databaseType = this.fastaSummary.databaseType;
                if (databaseType.size() == 1) {
                    ProteinDatabase proteinDatabase = (ProteinDatabase)((Object)databaseType.keySet().stream().findFirst().get());
                    this.typeJTextField.setText(proteinDatabase.getFullName());
                } else {
                    TreeMap occurrenceToDBMap = databaseType.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(entry2 -> (ProteinDatabase)((Object)((Object)((Object)entry2.getKey())))).collect(Collectors.toCollection(TreeSet::new)), (a, b) -> {
                        a.addAll(b);
                        return a;
                    }, TreeMap::new));
                    String dbOccurrenceText = occurrenceToDBMap.descendingMap().values().stream().flatMap(dbs -> dbs.stream()).map(db -> db.getFullName() + " (" + databaseType.get(db) + ")").collect(Collectors.joining(", "));
                    this.typeJTextField.setText(dbOccurrenceText);
                }
                String nSequences = this.fastaSummary.nSequences + " sequences";
                if (this.fastaSummary.containsDecoys()) {
                    nSequences = nSequences + " (" + this.fastaSummary.nTarget + " target)";
                }
                this.sizeTxt.setText(nSequences);
            } else {
                this.speciesJTextField.setText("");
                this.typeJTextField.setText("");
                this.sizeTxt.setText("");
            }
            this.browseButton.setEnabled(this.dbEditable);
            if (fastaFile.exists()) {
                try {
                    this.proteinIterator = new FastaIterator(fastaFile);
                    this.bufferProteins();
                    this.accessionsSpinner.setEnabled(true);
                    this.updateSequence();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "An error occurred while reading the FASTA file.", "Import error", 2);
                    e.printStackTrace();
                }
            } else {
                this.accessionsSpinner.setEnabled(false);
            }
        }
    }

    private void updateSequence() {
        String accession = this.accessionsSpinner.getValue().toString();
        Header header = this.headersSample.get(accession);
        Protein protein = this.proteinsSample.get(accession);
        this.proteinTxt.setText(header.getRawHeader() + System.getProperty("line.separator") + protein.getSequence());
        this.proteinTxt.setCaretPosition(0);
        if (ProteinUtils.isDecoy(accession, this.fastaParameters)) {
            this.targetDecoyTxt.setText("(Decoy)");
        } else {
            this.targetDecoyTxt.setText("(Target)");
        }
    }

    public String getLastSelectedFolder() {
        if (this.lastSelectedFolder == null) {
            return null;
        }
        String folder = this.lastSelectedFolder.getLastSelectedFolder(lastFolderKey);
        if (folder == null) {
            folder = this.lastSelectedFolder.getLastSelectedFolder();
        }
        return folder;
    }

    public boolean selectDB(boolean userCanDispose) {
        File startLocation = null;
        if (this.utilitiesUserParameters.getDbFolder() != null && this.utilitiesUserParameters.getDbFolder().exists()) {
            startLocation = this.utilitiesUserParameters.getDbFolder();
        }
        if (startLocation == null) {
            startLocation = new File(this.getLastSelectedFolder());
        }
        JFileChooser fc = new JFileChooser(startLocation);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                return myFile.getName().toLowerCase().endsWith("fasta") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "FASTA (.fasta)";
            }
        };
        fc.setFileFilter(filter);
        int result = fc.showOpenDialog(this);
        if (result == 0) {
            File file = fc.getSelectedFile();
            File folder = file.getParentFile();
            this.utilitiesUserParameters.setDbFolder(folder);
            this.lastSelectedFolder.setLastSelectedFolder(lastFolderKey, folder.getAbsolutePath());
            if (file.getName().contains(" ") && (file = this.renameFastaFileName(file)) == null) {
                return false;
            }
            this.loadFastaFile(file.getAbsolutePath(), this.fastaParameters == null, true, true);
            return true;
        }
        if (userCanDispose) {
            this.dispose();
            return false;
        }
        return false;
    }

    private void loadFastaFile(String fastaFile, final boolean inferParameters, boolean iNewFastaSummary, final boolean setUpGUI) {
        this.selectedFastaFile = fastaFile;
        final boolean newFastaSummary = iNewFastaSummary;
        progressDialog = new ProgressDialogX(this, this.parentFrame, this.normalImange, this.waitingImage, true);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("importThread"){

            @Override
            public void run() {
                try {
                    if (inferParameters) {
                        progressDialog.setPrimaryProgressCounterIndeterminate(true);
                        progressDialog.setTitle("Inferring Database Format. Please Wait...");
                        SequenceDbDetailsDialog.this.fastaParameters = FastaParameters.inferParameters(SequenceDbDetailsDialog.this.selectedFastaFile, progressDialog);
                    }
                    if (!progressDialog.isRunCanceled()) {
                        progressDialog.setWaitingText("Importing Database. Please Wait...");
                        SequenceDbDetailsDialog.this.fastaSummary = FastaSummary.getSummary(SequenceDbDetailsDialog.this.selectedFastaFile, SequenceDbDetailsDialog.this.fastaParameters, newFastaSummary, progressDialog);
                        progressDialog.setSecondaryProgressCounterIndeterminate(true);
                        if (!SequenceDbDetailsDialog.this.fastaSummary.containsDecoys()) {
                            int outcome = JOptionPane.showConfirmDialog(SequenceDbDetailsDialog.this, "The database does not seem to contain decoy sequences.\nAdd decoys?", "Add decoys?", 0);
                            if (outcome == 0) {
                                SequenceDbDetailsDialog.this.generateTargetDecoyDatabase();
                            } else {
                                SequenceDbDetailsDialog.this.decoyButton.setEnabled(true);
                            }
                        }
                        if (setUpGUI && !progressDialog.isRunCanceled()) {
                            SequenceDbDetailsDialog.this.setUpGUI();
                        }
                        progressDialog.setRunFinished();
                    }
                }
                catch (Exception e) {
                    progressDialog.setRunFinished();
                    JOptionPane.showMessageDialog(SequenceDbDetailsDialog.this, JOptionEditorPane.getJOptionEditorPane("There was an error importing the FASTA file:<br>" + e.getMessage() + "<br>See <a href=\"https://compomics.github.io/projects/searchgui/wiki/DatabaseHelp.html\">DatabaseHelp</a> for help."), "FASTA Import Error", 2);
                    e.printStackTrace();
                    return;
                }
                progressDialog.setRunFinished();
            }
        }.start();
    }

    private void generateTargetDecoyDatabase() {
        String newFasta = this.selectedFastaFile;
        File originalFastaFile = new File(this.selectedFastaFile);
        if (this.selectedFastaFile.lastIndexOf(".") != -1) {
            newFasta = this.selectedFastaFile.substring(0, this.selectedFastaFile.lastIndexOf("."));
        }
        newFasta = newFasta + this.fastaParameters.getTargetDecoyFileNameSuffix() + ".fasta";
        try {
            File newFile = new File(newFasta);
            progressDialog.setTitle("Appending Decoy Sequences. Please Wait...");
            progressDialog.setPrimaryProgressCounterIndeterminate(false);
            progressDialog.setPrimaryProgressCounter(0);
            progressDialog.setMaxPrimaryProgressCounter(100);
            DecoyConverter.appendDecoySequences(originalFastaFile, newFile, this.fastaParameters, progressDialog);
            progressDialog.setTitle("Getting Database Details. Please Wait...");
            progressDialog.setPrimaryProgressCounterIndeterminate(true);
            this.selectedFastaFile = newFile.getAbsolutePath();
            this.fastaParameters = DecoyConverter.getDecoyParameters(this.fastaParameters);
            this.fastaSummary = DecoyConverter.getDecoySummary(originalFastaFile, this.fastaSummary);
        }
        catch (OutOfMemoryError error) {
            Runtime.getRuntime().gc();
            JOptionPane.showMessageDialog(this, "The tool used up all the available memory and had to be stopped.\nMemory boundaries are set in the Edit menu (Edit > Java Options).", "Out Of Memory Error", 0);
            System.out.println("Ran out of memory!");
            error.printStackTrace();
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(this, new String[]{"FASTA Import Error.", "File " + this.selectedFastaFile + " not found."}, "FASTA Import Error", 2);
            e.printStackTrace();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, new String[]{"FASTA Import Error.", "File " + this.selectedFastaFile + " could not be imported."}, "FASTA Import Error", 2);
            e.printStackTrace();
        }
    }

    public File renameFastaFileName(File file) {
        String tempName = file.getName();
        tempName = tempName.replaceAll(" ", "_");
        File renamedFile = new File(file.getParentFile().getAbsolutePath() + File.separator + tempName);
        boolean success = false;
        try {
            success = renamedFile.createNewFile();
            if (success) {
                IoUtil.copyFile(file, renamedFile);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "An error occurred while renaming the file.", "Please Rename File", 2);
            e.printStackTrace();
            success = false;
        }
        if (success) {
            JOptionPane.showMessageDialog(this, "Your FASTA file name contained white space and has been renamed to:\n" + file.getParentFile().getAbsolutePath() + File.separator + tempName, "Renamed File", 2);
            return renamedFile;
        }
        return null;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.databaseInformationPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.dbNameTxt = new JTextField();
        this.typeLabel = new JLabel();
        this.fileTxt = new JTextField();
        this.versionLabel = new JLabel();
        this.versionTxt = new JTextField();
        this.lastModifiedLabel = new JLabel();
        this.lastModifiedTxt = new JTextField();
        this.sizeLabel = new JLabel();
        this.sizeTxt = new JTextField();
        this.decoyButton = new JButton();
        this.browseButton = new JButton();
        this.fileLabel = new JLabel();
        this.typeJTextField = new JTextField();
        this.speciesJTextField = new JTextField();
        this.speciesLabel = new JLabel();
        this.previewPanel = new JPanel();
        this.proteinYxtScrollPane = new JScrollPane();
        this.proteinTxt = new JTextArea();
        this.proteinLabel = new JLabel();
        this.accessionsSpinner = new JSpinner();
        this.targetDecoyTxt = new JLabel();
        this.editFastaParametersJLabel = new JLabel();
        this.databaseHelpSettingsJLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Database Overview");
        this.setMinimumSize(new Dimension(500, 500));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SequenceDbDetailsDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceDbDetailsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceDbDetailsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.databaseInformationPanel.setBorder(BorderFactory.createTitledBorder("Database Details"));
        this.databaseInformationPanel.setOpaque(false);
        this.nameLabel.setText("Name");
        this.dbNameTxt.setEditable(false);
        this.dbNameTxt.setHorizontalAlignment(0);
        this.typeLabel.setText("Type(s)");
        this.fileTxt.setEditable(false);
        this.fileTxt.setHorizontalAlignment(2);
        this.versionLabel.setText("Version");
        this.versionTxt.setEditable(false);
        this.versionTxt.setHorizontalAlignment(0);
        this.lastModifiedLabel.setText("Modified");
        this.lastModifiedTxt.setEditable(false);
        this.lastModifiedTxt.setHorizontalAlignment(0);
        this.sizeLabel.setText("Size");
        this.sizeTxt.setEditable(false);
        this.sizeTxt.setHorizontalAlignment(0);
        this.decoyButton.setText("Decoys");
        this.decoyButton.setPreferredSize(new Dimension(75, 25));
        this.decoyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceDbDetailsDialog.this.decoyButtonActionPerformed(evt);
            }
        });
        this.browseButton.setText("Browse");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceDbDetailsDialog.this.browseButtonActionPerformed(evt);
            }
        });
        this.fileLabel.setText("File");
        this.typeJTextField.setEditable(false);
        this.typeJTextField.setHorizontalAlignment(0);
        this.speciesJTextField.setEditable(false);
        this.speciesJTextField.setHorizontalAlignment(0);
        this.speciesLabel.setText("Species");
        GroupLayout databaseInformationPanelLayout = new GroupLayout(this.databaseInformationPanel);
        this.databaseInformationPanel.setLayout(databaseInformationPanelLayout);
        databaseInformationPanelLayout.setHorizontalGroup(databaseInformationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(databaseInformationPanelLayout.createSequentialGroup().addContainerGap().addGroup(databaseInformationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, databaseInformationPanelLayout.createSequentialGroup().addComponent(this.fileLabel, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.decoyButton, -2, 75, -2)).addGroup(databaseInformationPanelLayout.createSequentialGroup().addComponent(this.sizeLabel, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sizeTxt)).addGroup(databaseInformationPanelLayout.createSequentialGroup().addComponent(this.typeLabel, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.typeJTextField)).addGroup(databaseInformationPanelLayout.createSequentialGroup().addComponent(this.versionLabel, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.versionTxt)).addGroup(databaseInformationPanelLayout.createSequentialGroup().addComponent(this.nameLabel, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dbNameTxt)).addGroup(databaseInformationPanelLayout.createSequentialGroup().addComponent(this.lastModifiedLabel, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lastModifiedTxt)).addGroup(databaseInformationPanelLayout.createSequentialGroup().addComponent(this.speciesLabel, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.speciesJTextField))).addContainerGap()));
        databaseInformationPanelLayout.linkSize(0, this.fileLabel, this.lastModifiedLabel, this.nameLabel, this.sizeLabel, this.typeLabel, this.versionLabel);
        databaseInformationPanelLayout.linkSize(0, this.browseButton, this.decoyButton);
        databaseInformationPanelLayout.setVerticalGroup(databaseInformationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(databaseInformationPanelLayout.createSequentialGroup().addContainerGap().addGroup(databaseInformationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileTxt, -2, -1, -2).addComponent(this.decoyButton, -2, -1, -2).addComponent(this.browseButton).addComponent(this.fileLabel)).addGap(0, 0, 0).addGroup(databaseInformationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.dbNameTxt, -2, -1, -2)).addGap(0, 0, 0).addGroup(databaseInformationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.speciesLabel).addComponent(this.speciesJTextField, -2, -1, -2)).addGap(0, 0, 0).addGroup(databaseInformationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.typeLabel).addComponent(this.typeJTextField, -2, -1, -2)).addGap(0, 0, 0).addGroup(databaseInformationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.versionTxt, -2, -1, -2).addComponent(this.versionLabel)).addGap(0, 0, 0).addGroup(databaseInformationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sizeLabel).addComponent(this.sizeTxt, -2, -1, -2)).addGap(0, 0, 0).addGroup(databaseInformationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lastModifiedLabel).addComponent(this.lastModifiedTxt, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        databaseInformationPanelLayout.linkSize(1, this.browseButton, this.decoyButton);
        this.previewPanel.setBorder(BorderFactory.createTitledBorder("Preview"));
        this.previewPanel.setOpaque(false);
        this.proteinTxt.setEditable(false);
        this.proteinTxt.setColumns(20);
        this.proteinTxt.setLineWrap(true);
        this.proteinTxt.setRows(5);
        this.proteinTxt.setWrapStyleWord(true);
        this.proteinYxtScrollPane.setViewportView(this.proteinTxt);
        this.proteinLabel.setText("Protein");
        this.accessionsSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SequenceDbDetailsDialog.this.accessionsSpinnerStateChanged(evt);
            }
        });
        this.targetDecoyTxt.setText("(target/decoy)");
        this.editFastaParametersJLabel.setForeground(new Color(0, 0, 255));
        this.editFastaParametersJLabel.setHorizontalAlignment(0);
        this.editFastaParametersJLabel.setText("<html><a style=\"text-decoration: none\">Edit FASTA parsing options</a></html>");
        this.editFastaParametersJLabel.setToolTipText("Edit the FASTA parsing options");
        this.editFastaParametersJLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SequenceDbDetailsDialog.this.editFastaParametersJLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SequenceDbDetailsDialog.this.editFastaParametersJLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SequenceDbDetailsDialog.this.editFastaParametersJLabelMouseExited(evt);
            }
        });
        GroupLayout previewPanelLayout = new GroupLayout(this.previewPanel);
        this.previewPanel.setLayout(previewPanelLayout);
        previewPanelLayout.setHorizontalGroup(previewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(previewPanelLayout.createSequentialGroup().addGroup(previewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(previewPanelLayout.createSequentialGroup().addGap(16, 16, 16).addComponent(this.proteinLabel).addGap(18, 18, 18).addComponent(this.accessionsSpinner, -2, 222, -2).addGap(18, 18, 18).addComponent(this.targetDecoyTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 169, Short.MAX_VALUE).addComponent(this.editFastaParametersJLabel, -2, 155, -2)).addComponent(this.proteinYxtScrollPane)).addContainerGap()));
        previewPanelLayout.setVerticalGroup(previewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(previewPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.proteinYxtScrollPane, -1, 160, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(previewPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.proteinLabel).addComponent(this.accessionsSpinner, -2, -1, -2).addComponent(this.targetDecoyTxt).addComponent(this.editFastaParametersJLabel, -2, -1, -2)).addContainerGap()));
        this.databaseHelpSettingsJLabel.setForeground(new Color(0, 0, 255));
        this.databaseHelpSettingsJLabel.setHorizontalAlignment(0);
        this.databaseHelpSettingsJLabel.setText("<html><a style=\"text-decoration: none\">Database help?</a></html>");
        this.databaseHelpSettingsJLabel.setToolTipText("Open Database Help");
        this.databaseHelpSettingsJLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SequenceDbDetailsDialog.this.databaseHelpSettingsJLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SequenceDbDetailsDialog.this.databaseHelpSettingsJLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SequenceDbDetailsDialog.this.databaseHelpSettingsJLabelMouseExited(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.databaseHelpSettingsJLabel, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, 75, -2)).addComponent(this.previewPanel, -1, -1, Short.MAX_VALUE).addComponent(this.databaseInformationPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.databaseInformationPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.previewPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton).addComponent(this.databaseHelpSettingsJLabel, -2, -1, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        UtilitiesUserParameters.saveUserParameters(this.utilitiesUserParameters);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        this.selectDB(false);
    }

    private void decoyButtonActionPerformed(ActionEvent evt) {
        progressDialog = new ProgressDialogX(this, this.parentFrame, this.normalImange, this.waitingImage, true);
        progressDialog.setPrimaryProgressCounterIndeterminate(true);
        progressDialog.setTitle("Creating Decoy. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("DecoyThread"){

            @Override
            public void run() {
                SequenceDbDetailsDialog.this.generateTargetDecoyDatabase();
                if (!progressDialog.isRunCanceled()) {
                    SequenceDbDetailsDialog.this.setUpGUI();
                }
                progressDialog.setRunFinished();
            }
        }.start();
    }

    private void accessionsSpinnerStateChanged(ChangeEvent evt) {
        this.updateSequence();
    }

    private void databaseHelpSettingsJLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://compomics.github.io/projects/searchgui/wiki/DatabaseHelp.html");
        this.setCursor(new Cursor(0));
    }

    private void databaseHelpSettingsJLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void databaseHelpSettingsJLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancelButtonActionPerformed(null);
    }

    private void editFastaParametersJLabelMouseClicked(MouseEvent evt) {
        FastaParameters newFastaParameters;
        FastaParametersDialog fastaParametersDialog = new FastaParametersDialog((Dialog)this, this.parentFrame, this.fastaParameters, this.dbEditable);
        if (!fastaParametersDialog.isCanceled() && !(newFastaParameters = fastaParametersDialog.getFastaSettings()).equals(this.fastaParameters)) {
            this.fastaParameters = newFastaParameters;
            this.loadFastaFile(this.selectedFastaFile, false, true, true);
        }
    }

    private void editFastaParametersJLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void editFastaParametersJLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void bufferProteins() throws IOException {
        Protein protein;
        this.accessionsSample.clear();
        this.proteinsSample.clear();
        this.headersSample.clear();
        this.proteinsSample.clear();
        int proteinCounter = 0;
        while (proteinCounter++ < 50 && (protein = this.proteinIterator.getNextProtein()) != null) {
            String accession = protein.getAccession();
            this.accessionsSample.add(accession);
            this.proteinsSample.put(accession, protein);
            this.headersSample.put(accession, this.proteinIterator.getLastHeader());
        }
        this.accessionsSpinner.setModel(new SpinnerListModel(this.accessionsSample));
        this.accessionsSpinner.setValue(this.accessionsSample.get(0));
    }

    public String getSelectedFastaFile() {
        return this.selectedFastaFile;
    }

    public FastaParameters getFastaParameters() {
        return this.fastaParameters;
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

