/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.proteowizard;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.mass_spectrometry.proteowizard.MsConvertParameters;
import com.compomics.util.experiment.mass_spectrometry.proteowizard.ProteoWizardFilter;
import com.compomics.util.experiment.mass_spectrometry.proteowizard.ProteoWizardMsFormat;
import com.compomics.util.gui.file_handling.FileChooserUtil;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.parameters.UtilitiesUserParameters;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class MsConvertParametersDialog
extends JDialog {
    private boolean canceled = false;
    private HashMap<Integer, String> filters;
    private ArrayList<Integer> filterIndexes;
    private String lastSelectedFolder = "";
    private UtilitiesUserParameters utilitiesUserParameters;
    private JMenu addFilterMenu;
    private JPanel backgourdPanel;
    private JButton browseButton;
    private JButton cancelButton;
    private JLabel filterHelpLabel;
    private JLabel filtersLbl;
    private JPopupMenu filtersPopupMenu;
    private JTable filtersTable;
    private JScrollPane filtersTableScrollPane;
    private JLabel folderHelpLabel;
    private JTextField installationJTextField;
    private JPanel installationPanel;
    private JPanel msconvertParameters;
    private JButton okButton;
    private JComboBox outputFormatCmb;
    private JLabel outputFormatLbl;
    private JMenuItem removeFilterMenuItem;

    public MsConvertParametersDialog(Frame parent, MsConvertParameters msConvertParameters) {
        super(parent, true);
        this.initComponents();
        this.setUpGUI(msConvertParameters);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void setUpGUI(MsConvertParameters msConvertParameters) {
        int option;
        this.filtersTableScrollPane.getViewport().setOpaque(false);
        this.filtersTable.getTableHeader().setReorderingAllowed(false);
        if (msConvertParameters != null) {
            this.outputFormatCmb.setSelectedItem((Object)msConvertParameters.getMsFormat());
            this.filters = (HashMap)msConvertParameters.getFiltersMap().clone();
        } else {
            this.outputFormatCmb.setSelectedItem((Object)ProteoWizardMsFormat.mzML);
            this.filters = new HashMap(2);
        }
        this.filterIndexes = new ArrayList<Integer>(this.filters.keySet());
        Collections.sort(this.filterIndexes);
        FiltersTableModel tableModel = new FiltersTableModel();
        this.filtersTable.setModel(tableModel);
        TableColumnModel tableColumnModel = this.filtersTable.getColumnModel();
        tableColumnModel.getColumn(0).setMinWidth(50);
        tableColumnModel.getColumn(0).setMaxWidth(50);
        TableColumn filterColumn = tableColumnModel.getColumn(1);
        filterColumn.setMinWidth(200);
        filterColumn.setMaxWidth(200);
        JComboBox<ProteoWizardFilter> comboBox = new JComboBox<ProteoWizardFilter>(ProteoWizardFilter.values());
        filterColumn.setCellEditor(new DefaultCellEditor(comboBox));
        for (final ProteoWizardFilter tempFilter : ProteoWizardFilter.values()) {
            JMenuItem tempFilterMenuItem = new JMenuItem(tempFilter.name);
            tempFilterMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (!MsConvertParametersDialog.this.filters.containsKey(tempFilter.number)) {
                        MsConvertParametersDialog.this.filters.put(tempFilter.number, "");
                        MsConvertParametersDialog.this.updateTable();
                    }
                }
            });
            this.addFilterMenu.add(tempFilterMenuItem);
        }
        this.outputFormatCmb.setRenderer(new AlignedListCellRenderer(0));
        this.utilitiesUserParameters = UtilitiesUserParameters.loadUserParameters();
        if (this.utilitiesUserParameters.getProteoWizardPath() == null && (option = JOptionPane.showConfirmDialog(this, "Cannot find ProteoWizard. Do you want to download it now?", "Download ProteoWizard?", 0)) == 0) {
            this.openWebPage();
        }
        if (this.utilitiesUserParameters != null) {
            this.installationJTextField.setText(this.utilitiesUserParameters.getProteoWizardPath());
            this.lastSelectedFolder = this.utilitiesUserParameters.getProteoWizardPath();
        }
    }

    private void updateTable() {
        this.filterIndexes = new ArrayList<Integer>(this.filters.keySet());
        Collections.sort(this.filterIndexes);
        ((DefaultTableModel)this.filtersTable.getModel()).fireTableDataChanged();
    }

    private void initComponents() {
        this.filtersPopupMenu = new JPopupMenu();
        this.removeFilterMenuItem = new JMenuItem();
        this.addFilterMenu = new JMenu();
        this.backgourdPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.msconvertParameters = new JPanel();
        this.outputFormatLbl = new JLabel();
        this.outputFormatCmb = new JComboBox();
        this.filtersLbl = new JLabel();
        this.filtersTableScrollPane = new JScrollPane();
        this.filtersTable = new JTable();
        this.filterHelpLabel = new JLabel();
        this.installationPanel = new JPanel();
        this.installationJTextField = new JTextField();
        this.browseButton = new JButton();
        this.folderHelpLabel = new JLabel();
        this.removeFilterMenuItem.setText("Remove Filter");
        this.removeFilterMenuItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                MsConvertParametersDialog.this.removeFilterMenuItemMouseReleased(evt);
            }
        });
        this.filtersPopupMenu.add(this.removeFilterMenuItem);
        this.addFilterMenu.setText("Add Filter");
        this.filtersPopupMenu.add(this.addFilterMenu);
        this.setDefaultCloseOperation(2);
        this.setTitle("MSConvert Settings");
        this.setMinimumSize(new Dimension(400, 400));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MsConvertParametersDialog.this.formWindowClosing(evt);
            }
        });
        this.backgourdPanel.setBackground(new Color(230, 230, 230));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MsConvertParametersDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MsConvertParametersDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.msconvertParameters.setBorder(BorderFactory.createTitledBorder("Settings"));
        this.msconvertParameters.setOpaque(false);
        this.outputFormatLbl.setText("Output Format");
        this.outputFormatCmb.setMaximumRowCount(10);
        this.outputFormatCmb.setModel(new DefaultComboBoxModel<ProteoWizardMsFormat>(ProteoWizardMsFormat.getDataFormats(null, true)));
        this.filtersLbl.setText("Filters (right click in the table to edit)");
        this.filtersTableScrollPane.setOpaque(false);
        this.filtersTableScrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                MsConvertParametersDialog.this.filtersTableScrollPaneMouseReleased(evt);
            }
        });
        this.filtersTable.setModel(new FiltersTableModel());
        this.filtersTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                MsConvertParametersDialog.this.filtersTableMouseReleased(evt);
            }
        });
        this.filtersTableScrollPane.setViewportView(this.filtersTable);
        GroupLayout msconvertParametersLayout = new GroupLayout(this.msconvertParameters);
        this.msconvertParameters.setLayout(msconvertParametersLayout);
        msconvertParametersLayout.setHorizontalGroup(msconvertParametersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(msconvertParametersLayout.createSequentialGroup().addContainerGap().addGroup(msconvertParametersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.filtersTableScrollPane, GroupLayout.Alignment.TRAILING, -1, 682, Short.MAX_VALUE).addGroup(msconvertParametersLayout.createSequentialGroup().addComponent(this.filtersLbl).addGap(0, 507, Short.MAX_VALUE)).addGroup(msconvertParametersLayout.createSequentialGroup().addComponent(this.outputFormatLbl).addGap(18, 18, 18).addComponent(this.outputFormatCmb, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        msconvertParametersLayout.setVerticalGroup(msconvertParametersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, msconvertParametersLayout.createSequentialGroup().addContainerGap().addGroup(msconvertParametersLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputFormatLbl).addComponent(this.outputFormatCmb, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.filtersLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filtersTableScrollPane, -1, 194, Short.MAX_VALUE).addContainerGap()));
        this.filterHelpLabel.setText("<html><a href>Help with the msconvert filters</a></html>");
        this.filterHelpLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                MsConvertParametersDialog.this.filterHelpLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                MsConvertParametersDialog.this.filterHelpLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                MsConvertParametersDialog.this.filterHelpLabelMouseReleased(evt);
            }
        });
        this.installationPanel.setBorder(BorderFactory.createTitledBorder("ProteoWizard Folder"));
        this.installationPanel.setOpaque(false);
        this.installationJTextField.setEditable(false);
        this.installationJTextField.setToolTipText("The folder containing the PeptideShaker jar file.");
        this.browseButton.setText("Browse");
        this.browseButton.setToolTipText("The folder containing the PeptideShaker jar file.");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MsConvertParametersDialog.this.browseButtonActionPerformed(evt);
            }
        });
        this.folderHelpLabel.setFont(this.folderHelpLabel.getFont().deriveFont(this.folderHelpLabel.getFont().getStyle() | 2));
        this.folderHelpLabel.setText("Please locate the ProteoWizard installation folder");
        GroupLayout installationPanelLayout = new GroupLayout(this.installationPanel);
        this.installationPanel.setLayout(installationPanelLayout);
        installationPanelLayout.setHorizontalGroup(installationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, installationPanelLayout.createSequentialGroup().addContainerGap().addGroup(installationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.installationJTextField, -1, 609, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, installationPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.folderHelpLabel).addGap(11, 11, 11))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton).addContainerGap()));
        installationPanelLayout.setVerticalGroup(installationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(installationPanelLayout.createSequentialGroup().addContainerGap().addGroup(installationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.installationJTextField, -2, -1, -2).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.folderHelpLabel).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout backgourdPanelLayout = new GroupLayout(this.backgourdPanel);
        this.backgourdPanel.setLayout(backgourdPanelLayout);
        backgourdPanelLayout.setHorizontalGroup(backgourdPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgourdPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgourdPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgourdPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.filterHelpLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.msconvertParameters, -1, -1, Short.MAX_VALUE).addComponent(this.installationPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgourdPanelLayout.setVerticalGroup(backgourdPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgourdPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.installationPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.msconvertParameters, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgourdPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton).addComponent(this.filterHelpLabel, -2, -1, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgourdPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgourdPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        int value;
        boolean formatCheck = true;
        ProteoWizardMsFormat selectedFormat = (ProteoWizardMsFormat)((Object)this.outputFormatCmb.getSelectedItem());
        if (selectedFormat != ProteoWizardMsFormat.mgf && selectedFormat != ProteoWizardMsFormat.mzML && (value = JOptionPane.showConfirmDialog(this, "mzML and mgf are the only formats compatible with SearchGUI. Proceed anyway?", "Output Format Warning", 0, 2)) == 1) {
            formatCheck = false;
        }
        if (formatCheck) {
            this.utilitiesUserParameters.setProteoWizardPath(this.installationJTextField.getText());
            try {
                UtilitiesUserParameters.saveUserParameters(this.utilitiesUserParameters);
                this.dispose();
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "An error occurred while saving the preferences.", "Error", 2);
            }
        }
    }

    private void removeFilterMenuItemMouseReleased(MouseEvent evt) {
        String itemName;
        ProteoWizardFilter proteoWizardFilter;
        int row = this.filtersTable.getSelectedRow();
        if (row >= 0 && (proteoWizardFilter = ProteoWizardFilter.getFilter(itemName = this.filtersTable.getValueAt(row, 1).toString())) != null) {
            this.filters.remove(proteoWizardFilter.number);
            this.updateTable();
        }
    }

    private void filtersTableMouseReleased(MouseEvent evt) {
        if (evt != null && this.filtersTable.rowAtPoint(evt.getPoint()) != -1) {
            int row = this.filtersTable.rowAtPoint(evt.getPoint());
            this.filtersTable.setRowSelectionInterval(row, row);
        }
        if (evt != null && evt.getButton() == 3) {
            this.removeFilterMenuItem.setVisible(this.filtersTable.getSelectedRow() != -1);
            this.filtersPopupMenu.show(this.filtersTable, evt.getX(), evt.getY());
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancelButtonActionPerformed(null);
    }

    private void filterHelpLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void filterHelpLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void filterHelpLabelMouseReleased(MouseEvent evt) {
        BareBonesBrowserLaunch.openURL("http://proteowizard.sourceforge.net/tools/filters.html");
    }

    private void filtersTableScrollPaneMouseReleased(MouseEvent evt) {
        this.filtersTableMouseReleased(evt);
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File selectedFile = FileChooserUtil.getUserSelectedFolder(this, "ProteoWizard Installation Folder", this.lastSelectedFolder, "ProteoWizard installation folder", "OK", true);
        if (selectedFile != null) {
            if (!new File(selectedFile, "msconvert.exe").exists() && !new File(selectedFile, "msconvert").exists()) {
                JOptionPane.showMessageDialog(this, "The selected folder is not a valid ProteoWizard folder.", "Wrong Folder Selected", 2);
                this.okButton.setEnabled(false);
            } else {
                this.lastSelectedFolder = selectedFile.getPath();
                this.installationJTextField.setText(this.lastSelectedFolder);
                this.okButton.setEnabled(true);
            }
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public MsConvertParameters getMsConvertParameters() {
        MsConvertParameters msConvertParameters = new MsConvertParameters();
        msConvertParameters.setMsFormat((ProteoWizardMsFormat)((Object)this.outputFormatCmb.getSelectedItem()));
        for (Integer filterIndex : this.filters.keySet()) {
            msConvertParameters.addFilter(filterIndex, this.filters.get(filterIndex));
        }
        return msConvertParameters;
    }

    private void openWebPage() {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://proteowizard.sourceforge.net");
        this.setCursor(new Cursor(0));
    }

    private class FiltersTableModel
    extends DefaultTableModel {
        @Override
        public int getRowCount() {
            if (MsConvertParametersDialog.this.filters == null) {
                return 0;
            }
            return MsConvertParametersDialog.this.filters.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Value";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    Integer index = (Integer)MsConvertParametersDialog.this.filterIndexes.get(row);
                    ProteoWizardFilter proteoWizardFilter = ProteoWizardFilter.getFilter(index);
                    String itemName = proteoWizardFilter.name;
                    return itemName;
                }
                case 2: {
                    Integer index = (Integer)MsConvertParametersDialog.this.filterIndexes.get(row);
                    String value = (String)MsConvertParametersDialog.this.filters.get(index);
                    if (value == null) {
                        value = null;
                    }
                    return value;
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            switch (column) {
                case 1: {
                    Integer index = (Integer)MsConvertParametersDialog.this.filterIndexes.get(row);
                    MsConvertParametersDialog.this.filters.remove(index);
                    ProteoWizardFilter proteoWizardFilter = (ProteoWizardFilter)((Object)value);
                    MsConvertParametersDialog.this.filters.put(proteoWizardFilter.number, "");
                    break;
                }
                case 2: {
                    Integer index = (Integer)MsConvertParametersDialog.this.filterIndexes.get(row);
                    MsConvertParametersDialog.this.filters.put(index, (String)value);
                }
            }
            MsConvertParametersDialog.this.updateTable();
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column > 0;
        }
    }
}

