/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.protein;

import com.compomics.util.experiment.io.biology.protein.FastaParameters;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class FastaParametersDialog
extends JDialog {
    private Frame parentFrame;
    private boolean canceled = false;
    private boolean editable;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JTextField decoyFlagTxt;
    private JLabel decoySuffixLabel;
    private JLabel decoyTagLabel;
    private JComboBox<String> decoyTypeComboBox;
    private JLabel decoyTypeLabel;
    private JTextField fastaSuffixTxt;
    private JPanel fileProcessingPanel;
    private JButton helpJButton;
    private JButton okButton;
    private JComboBox<String> targetDecoyComboBox;
    private JLabel targetDecoyLabel;

    public FastaParametersDialog(Frame parentFrame, FastaParameters fastaSettings, boolean editable) {
        super(parentFrame, true);
        this.parentFrame = parentFrame;
        this.editable = editable;
        this.initComponents();
        this.setUpGui(fastaSettings);
        this.setLocationRelativeTo(parentFrame);
        this.setVisible(true);
    }

    public FastaParametersDialog(Dialog owner, Frame parentFrame, FastaParameters fastaSettings, boolean editable) {
        super(owner, true);
        this.parentFrame = parentFrame;
        this.editable = editable;
        this.initComponents();
        this.setUpGui(fastaSettings);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGui(FastaParameters fastaSettings) {
        this.decoyTypeComboBox.setRenderer(new AlignedListCellRenderer(0));
        this.targetDecoyComboBox.setRenderer(new AlignedListCellRenderer(0));
        if (fastaSettings.isTargetDecoy()) {
            this.targetDecoyComboBox.setSelectedIndex(0);
        } else {
            this.targetDecoyComboBox.setSelectedIndex(1);
        }
        this.decoyFlagTxt.setText(fastaSettings.getDecoyFlag());
        if (fastaSettings.isDecoySuffix()) {
            this.decoyTypeComboBox.setSelectedIndex(1);
        } else {
            this.decoyTypeComboBox.setSelectedIndex(0);
        }
        this.fastaSuffixTxt.setText(fastaSettings.getTargetDecoyFileNameSuffix());
        this.targetDecoyComboBox.setEnabled(this.editable);
        this.decoyFlagTxt.setEnabled(this.editable);
        this.decoyTypeComboBox.setEnabled(this.editable);
        this.fastaSuffixTxt.setEnabled(this.editable);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public FastaParameters getFastaSettings() {
        FastaParameters fastaSettings = new FastaParameters();
        fastaSettings.setTargetDecoy(this.targetDecoyComboBox.getSelectedIndex() == 0);
        fastaSettings.setDecoyFlag(this.decoyFlagTxt.getText());
        fastaSettings.setDecoySuffix(this.decoyTypeComboBox.getSelectedIndex() == 1);
        fastaSettings.setTargetDecoyFileNameSuffix(this.fastaSuffixTxt.getText());
        return fastaSettings;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.fileProcessingPanel = new JPanel();
        this.fastaSuffixTxt = new JTextField();
        this.decoyTagLabel = new JLabel();
        this.decoyFlagTxt = new JTextField();
        this.decoySuffixLabel = new JLabel();
        this.decoyTypeLabel = new JLabel();
        this.decoyTypeComboBox = new JComboBox();
        this.targetDecoyLabel = new JLabel();
        this.targetDecoyComboBox = new JComboBox();
        this.helpJButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Database Processing");
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.okButton.setText("OK");
        this.okButton.setPreferredSize(new Dimension(75, 25));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FastaParametersDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.setPreferredSize(new Dimension(75, 25));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FastaParametersDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.fileProcessingPanel.setBorder(BorderFactory.createTitledBorder("Settings"));
        this.fileProcessingPanel.setOpaque(false);
        this.fastaSuffixTxt.setHorizontalAlignment(0);
        this.decoyTagLabel.setText("Decoy Tag");
        this.decoyFlagTxt.setHorizontalAlignment(0);
        this.decoySuffixLabel.setText("Decoy File Tag");
        this.decoyTypeLabel.setText("Decoy Type");
        this.decoyTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Prefix", "Suffix"}));
        this.decoyTypeComboBox.setSelectedIndex(1);
        this.targetDecoyLabel.setText("Target-Decoy");
        this.targetDecoyComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.targetDecoyComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FastaParametersDialog.this.targetDecoyComboBoxActionPerformed(evt);
            }
        });
        GroupLayout fileProcessingPanelLayout = new GroupLayout(this.fileProcessingPanel);
        this.fileProcessingPanel.setLayout(fileProcessingPanelLayout);
        fileProcessingPanelLayout.setHorizontalGroup(fileProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fileProcessingPanelLayout.createSequentialGroup().addContainerGap().addGroup(fileProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.decoyTagLabel, -2, 75, -2).addComponent(this.decoyTypeLabel).addComponent(this.decoySuffixLabel).addComponent(this.targetDecoyLabel)).addGap(18, 18, 18).addGroup(fileProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.targetDecoyComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.fastaSuffixTxt).addComponent(this.decoyFlagTxt).addComponent(this.decoyTypeComboBox, 0, -1, Short.MAX_VALUE)).addContainerGap()));
        fileProcessingPanelLayout.setVerticalGroup(fileProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fileProcessingPanelLayout.createSequentialGroup().addContainerGap().addGroup(fileProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.targetDecoyLabel).addComponent(this.targetDecoyComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(fileProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.decoyTagLabel).addComponent(this.decoyFlagTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(fileProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.decoyTypeLabel).addComponent(this.decoyTypeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(fileProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fastaSuffixTxt, -2, -1, -2).addComponent(this.decoySuffixLabel)).addContainerGap()));
        this.helpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.helpJButton.setToolTipText("Help");
        this.helpJButton.setBorder(null);
        this.helpJButton.setBorderPainted(false);
        this.helpJButton.setContentAreaFilled(false);
        this.helpJButton.setFocusable(false);
        this.helpJButton.setHorizontalTextPosition(0);
        this.helpJButton.setVerticalTextPosition(3);
        this.helpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                FastaParametersDialog.this.helpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                FastaParametersDialog.this.helpJButtonMouseExited(evt);
            }
        });
        this.helpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FastaParametersDialog.this.helpJButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.fileProcessingPanel, -1, -1, Short.MAX_VALUE)).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.helpJButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 297, Short.MAX_VALUE).addComponent(this.okButton, -2, 47, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, -1, -2))).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.fileProcessingPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.helpJButton).addComponent(this.okButton, -2, -1, -2).addComponent(this.cancelButton, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        boolean valid = true;
        if (this.decoyFlagTxt.getText().isEmpty()) {
            JOptionPane.showMessageDialog(this, "The decoy tag cannot be empty.", "Warning", 2);
            valid = false;
        }
        if (this.fastaSuffixTxt.getText().isEmpty()) {
            JOptionPane.showMessageDialog(this, "The decoy file tag cannot be empty.", "Warning", 2);
            valid = false;
        }
        if (valid) {
            this.dispose();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void helpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void helpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void helpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this.parentFrame, this.getClass().getResource("/helpFiles/FastaPreferences.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "FASTA Processing - Help");
        this.setCursor(new Cursor(0));
    }

    private void targetDecoyComboBoxActionPerformed(ActionEvent evt) {
        boolean targetDecoy = this.targetDecoyComboBox.getSelectedIndex() == 0;
        this.decoyFlagTxt.setEnabled(targetDecoy);
        this.decoyTypeComboBox.setEnabled(targetDecoy);
    }
}

