/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.protein;

import com.compomics.util.Util;
import java.awt.Color;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ProteinSequencePane {
    private static TreeMap<String, String> peffKeyValuePairs;

    public static double formatProteinSequence(JEditorPane editorPane, String cleanSequence, int[] coverage, TreeMap<String, String> keyValuePairs, HashMap<String, Color> tagColors, boolean showModifications, boolean showVariants, boolean showCoverage) {
        return ProteinSequencePane.formatProteinSequence(editorPane, cleanSequence, -1, -1, coverage, keyValuePairs, tagColors);
    }

    public static double formatProteinSequence(JEditorPane editorPane, String cleanSequence, int[] coverage) {
        return ProteinSequencePane.formatProteinSequence(editorPane, cleanSequence, -1, -1, coverage, new TreeMap<String, String>(), new HashMap<String, Color>());
    }

    public static double formatProteinSequence(JEditorPane editorPane, String cleanSequence, int selectedPeptideStart, int selectedPeptideEnd, int[] coverage) {
        return ProteinSequencePane.formatProteinSequence(editorPane, cleanSequence, selectedPeptideStart, selectedPeptideEnd, coverage, new TreeMap<String, String>(), new HashMap<String, Color>());
    }

    public static double formatProteinSequence(JEditorPane editorPane, String cleanSequence, ArrayList<Integer> selectedPeptideStart, ArrayList<Integer> selectedPeptideEnd, int[] coverage) {
        if (cleanSequence.length() != coverage.length - 1) {
            throw new IllegalArgumentException("The lenght of the coverage map has to be equal to the lenght of the sequence + 1!");
        }
        String sequenceTable = "";
        String currentCellSequence = "";
        boolean selectedPeptide = false;
        boolean coveredPeptide = false;
        double sequenceCoverage = 0.0;
        FontMetrics fm = editorPane.getGraphics().getFontMetrics();
        int fontWidth = fm.stringWidth("X");
        if (!UIManager.getLookAndFeel().getName().equalsIgnoreCase("Nimbus")) {
            fontWidth = 8;
        }
        int indexWidth = 200;
        if (cleanSequence.length() > 999) {
            indexWidth += 50;
        }
        double temp = (editorPane.getParent().getWidth() - indexWidth) / fontWidth;
        int numberOfAminoAcidsPerRow = (int)temp / 10;
        numberOfAminoAcidsPerRow *= 10;
        ArrayList<Integer> referenceMarkers = new ArrayList<Integer>();
        boolean previousAminoAcidWasCovered = false;
        boolean previousAminoAcidWasSelected = false;
        for (int i = 1; i < coverage.length; ++i) {
            if (i % numberOfAminoAcidsPerRow == 1 || i == 1) {
                sequenceTable = sequenceTable + "</tr><tr><td><font color=black><a name=\"" + i + "\">" + i + "</a></font></td>";
                referenceMarkers.add(i);
            }
            if (coverage[i] > 0) {
                sequenceCoverage += 1.0;
                coveredPeptide = true;
            } else {
                coveredPeptide = false;
            }
            for (int possibleStart : selectedPeptideStart) {
                if (i != possibleStart) continue;
                selectedPeptide = true;
            }
            for (int possibleEnd : selectedPeptideEnd) {
                if (i != possibleEnd) continue;
                selectedPeptide = false;
            }
            if (previousAminoAcidWasSelected && !selectedPeptide) {
                currentCellSequence = currentCellSequence + "</span>";
            }
            if (selectedPeptide) {
                currentCellSequence = i % 10 == 1 ? currentCellSequence + "<span style=\"background:#CEE3F6\">" + cleanSequence.charAt(i - 1) : (previousAminoAcidWasSelected ? currentCellSequence + cleanSequence.charAt(i - 1) : currentCellSequence + "</span><span style=\"background:#CEE3F6\">" + cleanSequence.charAt(i - 1));
                previousAminoAcidWasSelected = true;
            } else {
                previousAminoAcidWasSelected = false;
                currentCellSequence = coveredPeptide ? (i % 10 == 1 ? currentCellSequence + cleanSequence.charAt(i - 1) : (previousAminoAcidWasCovered ? currentCellSequence + cleanSequence.charAt(i - 1) : currentCellSequence + "</span>" + cleanSequence.charAt(i - 1))) : (i % 10 == 1 ? currentCellSequence + "<span style=\"color:#BDBDBD\">" + cleanSequence.charAt(i - 1) : (previousAminoAcidWasCovered ? currentCellSequence + "<span style=\"color:#BDBDBD\">" + cleanSequence.charAt(i - 1) : currentCellSequence + cleanSequence.charAt(i - 1)));
            }
            if (i % 10 == 0) {
                sequenceTable = previousAminoAcidWasCovered && !previousAminoAcidWasSelected ? sequenceTable + "<td><tt>" + currentCellSequence + "</tt></td>" : sequenceTable + "<td><tt>" + currentCellSequence + "</span></tt></td>";
                currentCellSequence = "";
            }
            previousAminoAcidWasCovered = coveredPeptide;
        }
        sequenceTable = sequenceTable + "<td><tt>" + currentCellSequence + "</tt></td></table>";
        String formattedSequence = "<html><body><table cellspacing='2'>" + sequenceTable + "</html></body>";
        editorPane.setText(formattedSequence);
        if (selectedPeptideStart.size() > 0 && selectedPeptideStart.get(0) != -1) {
            boolean referenceMarkerFound = false;
            for (int i = 0; i < referenceMarkers.size() - 1 && !referenceMarkerFound; ++i) {
                if (selectedPeptideStart.get(0) < (Integer)referenceMarkers.get(i) || selectedPeptideStart.get(0) >= (Integer)referenceMarkers.get(i + 1)) continue;
                final JEditorPane tempEditorPane = editorPane;
                final String referenceMarker = ((Integer)referenceMarkers.get(i)).toString();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        tempEditorPane.scrollToReference(referenceMarker);
                    }
                });
                referenceMarkerFound = true;
            }
            if (!referenceMarkerFound) {
                final JEditorPane tempEditorPane = editorPane;
                final String referenceMarker = ((Integer)referenceMarkers.get(referenceMarkers.size() - 1)).toString();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        tempEditorPane.scrollToReference(referenceMarker);
                    }
                });
            }
        } else {
            editorPane.setCaretPosition(0);
        }
        return sequenceCoverage / (double)cleanSequence.length() * 100.0;
    }

    public static double formatProteinSequence(JEditorPane editorPane, String cleanSequence, int selectedPeptideStart, int selectedPeptideEnd, int[] coverage, TreeMap<String, String> aKeyValuePairs, HashMap<String, Color> selectedAnnotationType) {
        if (cleanSequence.length() != coverage.length - 1) {
            throw new IllegalArgumentException("The lenght of the coverage map has to be equal to the lenght of the sequence + 1!");
        }
        peffKeyValuePairs = aKeyValuePairs;
        String sequenceTable = "";
        String currentCellSequence = "";
        boolean selectedPeptide = false;
        boolean coveredPeptide = false;
        double sequenceCoverage = 0.0;
        FontMetrics fm = editorPane.getGraphics().getFontMetrics();
        int fontWidth = fm.stringWidth("X");
        if (!UIManager.getLookAndFeel().getName().equalsIgnoreCase("Nimbus")) {
            fontWidth = 8;
        }
        int indexWidth = 200;
        if (cleanSequence.length() > 999) {
            indexWidth += 50;
        }
        double temp = (editorPane.getParent().getWidth() - indexWidth) / fontWidth;
        int numberOfAminoAcidsPerRow = (int)temp / 10;
        numberOfAminoAcidsPerRow *= 10;
        ArrayList<Integer> referenceMarkers = new ArrayList<Integer>();
        String[] modificationMap = new String[coverage.length];
        String[] variantMap = new String[coverage.length];
        String[] signalMap = new String[coverage.length];
        String[] siteMap = new String[coverage.length];
        if (peffKeyValuePairs.containsKey("ModRes") && selectedAnnotationType.containsKey("ModRes_Foreground")) {
            String modifications = peffKeyValuePairs.get("ModRes");
            modifications = modifications.substring(1, modifications.length() - 1);
            String[] mods = modifications.split("\\)\\(");
            for (int j = 0; j < mods.length; ++j) {
                String[] tempMod = mods[j].split("\\|");
                int index = Integer.valueOf(tempMod[0]);
                String psiMod = tempMod[1];
                if (modificationMap[index] == null) {
                    modificationMap[index] = "Modification(s):<br>" + index + ": " + psiMod;
                    continue;
                }
                int n = index;
                modificationMap[n] = modificationMap[n] + "<br>" + index + ": " + psiMod;
            }
            for (int i = 0; i < modificationMap.length; ++i) {
                if (modificationMap[i] == null) continue;
                modificationMap[i] = "<html>" + modificationMap[i] + "<html>";
            }
        }
        if (peffKeyValuePairs.containsKey("Variant") && selectedAnnotationType.containsKey("Variant_Foreground")) {
            ProteinSequencePane.fillTwoValueMap("Variant(s)", peffKeyValuePairs.get("Variant"), variantMap);
        }
        if (peffKeyValuePairs.containsKey("Signal") && selectedAnnotationType.containsKey("Signal_Foreground")) {
            ProteinSequencePane.fillTwoValueMap("Signal(s)", peffKeyValuePairs.get("Signal"), signalMap);
        }
        if (peffKeyValuePairs.containsKey("Site") && selectedAnnotationType.containsKey("Site_Foreground")) {
            ProteinSequencePane.fillTwoValueMap("Site(s)", peffKeyValuePairs.get("Site"), siteMap);
        }
        String uncoveredForegroundColor = Util.color2Hex(Color.lightGray);
        String uncoveredBackgroundColor = Util.color2Hex(Color.WHITE);
        String modsForegroundColor = null;
        String modsBackgroundColor = null;
        String variantsForegroundColor = null;
        String variantsBackgroundColor = null;
        String signalForegroundColor = null;
        String signalBackgroundColor = null;
        String siteForegroundColor = null;
        String siteBackgroundColor = null;
        String multipleForegroundColor = null;
        String multipleBackgroundColor = null;
        if (selectedAnnotationType.get("ModRes_Foreground") != null) {
            modsForegroundColor = Util.color2Hex(selectedAnnotationType.get("ModRes_Foreground"));
            modsBackgroundColor = Util.color2Hex(selectedAnnotationType.get("ModRes_Background"));
        }
        if (selectedAnnotationType.get("Variant_Foreground") != null) {
            variantsForegroundColor = Util.color2Hex(selectedAnnotationType.get("Variant_Foreground"));
            variantsBackgroundColor = Util.color2Hex(selectedAnnotationType.get("Variant_Background"));
        }
        if (selectedAnnotationType.get("Signal_Foreground") != null) {
            signalForegroundColor = Util.color2Hex(selectedAnnotationType.get("Signal_Foreground"));
            signalBackgroundColor = Util.color2Hex(selectedAnnotationType.get("Signal_Background"));
        }
        if (selectedAnnotationType.get("Site_Foreground") != null) {
            siteForegroundColor = Util.color2Hex(selectedAnnotationType.get("Site_Foreground"));
            siteBackgroundColor = Util.color2Hex(selectedAnnotationType.get("Site_Background"));
        }
        if (selectedAnnotationType.get("Multiple_Foreground") != null) {
            multipleForegroundColor = Util.color2Hex(selectedAnnotationType.get("Multiple_Foreground"));
            multipleBackgroundColor = Util.color2Hex(selectedAnnotationType.get("Multiple_Background"));
        }
        for (int i = 1; i < coverage.length; ++i) {
            if (i % numberOfAminoAcidsPerRow == 1 || i == 1) {
                sequenceTable = sequenceTable + "</tr><tr><td><font color=black><a name=\"" + i + "\">" + i + "</a></font></td>";
                referenceMarkers.add(i);
            }
            if (coverage[i] > 0) {
                sequenceCoverage += 1.0;
                coveredPeptide = true;
            } else {
                coveredPeptide = false;
            }
            if (i == selectedPeptideStart) {
                selectedPeptide = true;
            } else if (i == selectedPeptideEnd + 1) {
                selectedPeptide = false;
            }
            int index = 0;
            if (modificationMap[i] != null) {
                ++index;
            }
            if (variantMap[i] != null) {
                ++index;
            }
            if (signalMap[i] != null) {
                ++index;
            }
            if (siteMap[i] != null) {
                ++index;
            }
            if (index == 0) {
                currentCellSequence = coveredPeptide ? (selectedPeptide ? currentCellSequence + "<font color=black><u>" + cleanSequence.charAt(i - 1) + "</u></font>" : currentCellSequence + "<font color=black>" + cleanSequence.charAt(i - 1) + "</font>") : currentCellSequence + "<span style=\"color:#" + uncoveredForegroundColor + "; background:#" + uncoveredBackgroundColor + "\">" + cleanSequence.charAt(i - 1) + "</span>";
            } else if (index == 1) {
                String currentForegroundColor = "";
                String currentBackgroundColor = "";
                String currentValue = null;
                if (modificationMap[i] != null) {
                    currentForegroundColor = modsForegroundColor;
                    currentBackgroundColor = modsBackgroundColor;
                    currentValue = modificationMap[i];
                } else if (variantMap[i] != null) {
                    currentForegroundColor = variantsForegroundColor;
                    currentBackgroundColor = variantsBackgroundColor;
                    currentValue = variantMap[i];
                } else if (signalMap[i] != null) {
                    currentForegroundColor = signalForegroundColor;
                    currentBackgroundColor = signalBackgroundColor;
                    currentValue = signalMap[i];
                } else if (siteMap[i] != null) {
                    currentForegroundColor = siteForegroundColor;
                    currentBackgroundColor = siteBackgroundColor;
                    currentValue = siteMap[i];
                }
                currentCellSequence = selectedPeptide ? currentCellSequence + "<span style=\"color:#" + currentForegroundColor + ";background:#" + currentBackgroundColor + "\"><A HREF=\"" + currentValue + "\" TITLE=\"" + currentValue + "\">" + cleanSequence.charAt(i - 1) + "</A></span>" : (coveredPeptide ? currentCellSequence + "<span style=\"color:#" + currentForegroundColor + ";background:#" + currentBackgroundColor + ";text-decoration:none\"><A HREF=\"" + currentValue + "\" TITLE=\"" + currentValue + "\">" + cleanSequence.charAt(i - 1) + "</A></span>" : currentCellSequence + "<span style=\"color:#" + uncoveredForegroundColor + ";background:#" + currentBackgroundColor + ";text-decoration:none\"><A HREF=\"" + currentValue + "\" TITLE=\"" + currentValue + "\">" + cleanSequence.charAt(i - 1) + "</A></span>");
            } else {
                String tempAnnotation = "";
                if (modificationMap[i] != null) {
                    tempAnnotation = tempAnnotation + modificationMap[i];
                }
                if (variantMap[i] != null) {
                    tempAnnotation = tempAnnotation.length() > 0 ? tempAnnotation + "<br><br>" + variantMap[i] : tempAnnotation + variantMap[i];
                }
                if (signalMap[i] != null) {
                    tempAnnotation = tempAnnotation.length() > 0 ? tempAnnotation + "<br><br>" + signalMap[i] : tempAnnotation + signalMap[i];
                }
                if (siteMap[i] != null) {
                    tempAnnotation = tempAnnotation.length() > 0 ? tempAnnotation + "<br><br>" + siteMap[i] : tempAnnotation + siteMap[i];
                }
                currentCellSequence = selectedPeptide ? currentCellSequence + "<span style=\"color:#" + multipleForegroundColor + ";background:#" + multipleBackgroundColor + "\"><b><A HREF=\"" + tempAnnotation + "\" TITLE=\"" + tempAnnotation + "\">" + cleanSequence.charAt(i - 1) + "</A></b></span>" : (coveredPeptide ? currentCellSequence + "<span style=\"color:#" + multipleForegroundColor + ";background:#" + multipleBackgroundColor + ";text-decoration:none\"><b><A HREF=\"" + tempAnnotation + "\" TITLE=\"" + tempAnnotation + "\">" + cleanSequence.charAt(i - 1) + "</A></b></span>" : currentCellSequence + "<span style=\"color:#" + uncoveredForegroundColor + ";background:#" + multipleBackgroundColor + ";text-decoration:none\"><b><A HREF=\"" + tempAnnotation + "\" TITLE=\"" + tempAnnotation + "\">" + cleanSequence.charAt(i - 1) + "</A></b></span>");
            }
            if (i % 10 != 0) continue;
            sequenceTable = sequenceTable + "<td><tt>" + currentCellSequence + "</tt></td>";
            currentCellSequence = "";
        }
        sequenceTable = sequenceTable + "<td><tt>" + currentCellSequence + "</tt></td></table><font color=black>";
        String formattedSequence = "<html><body><table cellspacing='2'>" + sequenceTable + "</html></body>";
        editorPane.setText(formattedSequence);
        if (selectedPeptideStart != -1) {
            boolean referenceMarkerFound = false;
            for (int i = 0; i < referenceMarkers.size() - 1 && !referenceMarkerFound; ++i) {
                if (selectedPeptideStart < (Integer)referenceMarkers.get(i) || selectedPeptideStart >= (Integer)referenceMarkers.get(i + 1)) continue;
                final JEditorPane tempEditorPane = editorPane;
                final String referenceMarker = ((Integer)referenceMarkers.get(i)).toString();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        tempEditorPane.scrollToReference(referenceMarker);
                    }
                });
                referenceMarkerFound = true;
            }
            if (!referenceMarkerFound) {
                final JEditorPane tempEditorPane = editorPane;
                final String referenceMarker = ((Integer)referenceMarkers.get(referenceMarkers.size() - 1)).toString();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        tempEditorPane.scrollToReference(referenceMarker);
                    }
                });
            }
        } else {
            editorPane.setCaretPosition(0);
        }
        return sequenceCoverage / (double)cleanSequence.length() * 100.0;
    }

    private static void fillTwoValueMap(String type, String values, String[] map) {
        values = values.substring(1, values.length() - 1);
        String[] value = values.split("\\)\\(");
        for (int j = 0; j < value.length; ++j) {
            String[] tempValue = value[j].split("\\|");
            int start = Integer.valueOf(tempValue[0]);
            int end = Integer.valueOf(tempValue[1]);
            String sequence = "";
            if (tempValue.length > 2) {
                sequence = tempValue[2];
            }
            if (start != end) {
                for (int k = start; k <= end; ++k) {
                    if (map[k] == null) {
                        map[k] = type + ":<br>" + start + "-" + end + ": " + sequence;
                        continue;
                    }
                    int n = k;
                    map[n] = map[n] + "<br>" + start + "-" + end + ": " + sequence;
                }
                continue;
            }
            if (map[start] == null) {
                map[start] = type + ":<br>" + start + ": " + sequence;
                continue;
            }
            int n = start;
            map[n] = map[n] + "<br>" + start + ": " + sequence;
        }
        for (int i = 0; i < map.length; ++i) {
            if (map[i] == null) continue;
            map[i] = "<html>" + map[i] + "<html>";
        }
    }
}

