/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.waiting.waitinghandlers;

import com.compomics.util.threading.SimpleSemaphore;
import com.compomics.util.waiting.WaitingActionListener;
import com.compomics.util.waiting.WaitingHandler;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;

public class ProgressDialogX
extends JDialog
implements WaitingHandler {
    private boolean doNothingOnClose = false;
    private boolean unstoppable = false;
    private boolean canceled = false;
    private boolean finished = false;
    private boolean displayProgress = true;
    private Image waitingIcon;
    private Image normalIcon;
    private Frame waitingHandlerParentFrame;
    private JDialog waitingHandlerParentDialog;
    private WaitingActionListener waitingActionListener = null;
    private final SimpleSemaphore mutex = new SimpleSemaphore(1);
    private JProgressBar progressBar;

    public ProgressDialogX(Frame waitingHandlerParent, Image normalIcon, Image waitingIcon, boolean modal) {
        super(waitingHandlerParent, modal);
        this.initComponents();
        this.setLocationRelativeTo(waitingHandlerParent);
        this.waitingHandlerParentFrame = waitingHandlerParent;
        this.waitingIcon = waitingIcon;
        this.normalIcon = normalIcon;
        if (waitingIcon != null) {
            this.waitingHandlerParentFrame.setIconImage(waitingIcon);
        }
    }

    public ProgressDialogX(JDialog waitingHandlerParent, Frame waitingHandlerParentFrame, Image normalIcon, Image waitingIcon, boolean modal) {
        super((Dialog)waitingHandlerParent, modal);
        this.initComponents();
        this.setLocationRelativeTo(waitingHandlerParent);
        this.waitingIcon = waitingIcon;
        this.normalIcon = normalIcon;
        this.waitingHandlerParentDialog = waitingHandlerParent;
        this.waitingHandlerParentFrame = waitingHandlerParentFrame;
        if (waitingIcon != null) {
            this.waitingHandlerParentDialog.setIconImage(waitingIcon);
            waitingHandlerParentFrame.setIconImage(waitingIcon);
        }
    }

    public ProgressDialogX(boolean modal) {
        this.setModal(true);
        this.initComponents();
        this.setLocationRelativeTo(null);
    }

    public void setValue(int value) {
        if (this.displayProgress) {
            this.progressBar.setValue(value);
        }
    }

    @Override
    public void setPrimaryProgressCounterIndeterminate(final boolean indeterminate) {
        if (this.displayProgress) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressDialogX.this.progressBar.setStringPainted(!indeterminate);
                    ProgressDialogX.this.progressBar.setIndeterminate(indeterminate);
                }
            });
        }
    }

    public void setString(final String displayString) {
        if (this.displayProgress) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressDialogX.this.progressBar.setStringPainted(displayString != null);
                    ProgressDialogX.this.progressBar.setString(displayString);
                }
            });
        }
    }

    public void setUnstoppable(boolean unstoppable) {
        this.unstoppable = unstoppable;
    }

    private void initComponents() {
        this.progressBar = new JProgressBar();
        this.setDefaultCloseOperation(0);
        this.setTitle("Please Wait...");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ProgressDialogX.this.formWindowClosing(evt);
            }
        });
        this.progressBar.setFont(this.progressBar.getFont().deriveFont((float)this.progressBar.getFont().getSize() - 1.0f));
        this.progressBar.setStringPainted(true);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.progressBar, -1, 518, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.progressBar, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.setRunCanceled();
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    @Override
    public void setMaxPrimaryProgressCounter(final int maxProgressValue) {
        if (this.displayProgress) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressDialogX.this.progressBar.setMaximum(maxProgressValue);
                }
            });
        }
    }

    @Override
    public void increasePrimaryProgressCounter() {
        this.increasePrimaryProgressCounter(1);
    }

    @Override
    public void increasePrimaryProgressCounter(int increment) {
        this.mutex.acquire();
        int newValue = this.progressBar.getValue() + increment;
        if (this.displayProgress) {
            this.progressBar.setValue(newValue);
        }
        this.mutex.release();
    }

    @Override
    public void setMaxSecondaryProgressCounter(int maxProgressValue) {
        if (this.displayProgress) {
            this.setMaxPrimaryProgressCounter(maxProgressValue);
        }
    }

    @Override
    public void resetSecondaryProgressCounter() {
        if (this.displayProgress) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressDialogX.this.finished = false;
                    ProgressDialogX.this.canceled = false;
                    ProgressDialogX.this.progressBar.setIndeterminate(false);
                    ProgressDialogX.this.progressBar.setStringPainted(true);
                    ProgressDialogX.this.progressBar.setValue(0);
                    if (ProgressDialogX.this.waitingIcon != null) {
                        ProgressDialogX.this.waitingHandlerParentFrame.setIconImage(ProgressDialogX.this.waitingIcon);
                    }
                }
            });
        }
    }

    @Override
    public void setPrimaryProgressCounter(int value) {
        if (this.displayProgress) {
            this.setValue(value);
        }
    }

    @Override
    public void increaseSecondaryProgressCounter() {
        if (this.displayProgress) {
            this.increasePrimaryProgressCounter();
        }
    }

    @Override
    public void setSecondaryProgressCounter(int value) {
        if (this.displayProgress) {
            this.setValue(value);
        }
    }

    @Override
    public void increaseSecondaryProgressCounter(int number) {
        if (this.displayProgress) {
            this.increasePrimaryProgressCounter(number);
        }
    }

    @Override
    public void setSecondaryProgressCounterIndeterminate(boolean indeterminate) {
        if (this.displayProgress) {
            this.setPrimaryProgressCounterIndeterminate(indeterminate);
        }
    }

    @Override
    public void setRunFinished() {
        if (this.normalIcon != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ProgressDialogX.this.waitingHandlerParentDialog != null) {
                        ProgressDialogX.this.waitingHandlerParentDialog.setIconImage(ProgressDialogX.this.normalIcon);
                    }
                    ProgressDialogX.this.waitingHandlerParentFrame.setIconImage(ProgressDialogX.this.normalIcon);
                }
            });
        }
        this.finished = true;
        this.dispose();
    }

    @Override
    public void setRunCanceled() {
        if (!this.finished) {
            int selection;
            if (!(this.canceled || this.doNothingOnClose || this.unstoppable)) {
                this.canceled = true;
                if (this.waitingActionListener != null) {
                    this.waitingActionListener.cancelPressed();
                }
            }
            if (!this.canceled && this.unstoppable && (selection = JOptionPane.showConfirmDialog(this, "Cancelling this process is not directly supported.\nDoing so may result in instability or errors.\n\nDo you still want to cancel the process?", "Cancel Process?", 1, 2)) == 0) {
                this.canceled = true;
                if (this.waitingActionListener != null) {
                    this.waitingActionListener.cancelPressed();
                }
            }
        }
    }

    @Override
    public void appendReport(String report, boolean includeDate, boolean addNewLine) {
        throw new UnsupportedOperationException("This waiting handler has no report.");
    }

    @Override
    public void appendReportNewLineNoDate() {
        throw new UnsupportedOperationException("This waiting handler has no report.");
    }

    @Override
    public void appendReportEndLine() {
        throw new UnsupportedOperationException("This waiting handler has no report.");
    }

    @Override
    public boolean isRunCanceled() {
        return this.canceled;
    }

    @Override
    public boolean isRunFinished() {
        return this.finished;
    }

    @Override
    public void setWaitingText(String text) {
        if (this.displayProgress) {
            this.setTitle(text);
        }
    }

    @Override
    public boolean isReport() {
        return false;
    }

    public void addWaitingActionListener(WaitingActionListener waitingActionListener) {
        this.waitingActionListener = waitingActionListener;
    }

    @Override
    public void setSecondaryProgressText(String text) {
        if (this.displayProgress) {
            this.setString(text);
        }
    }

    @Override
    public void resetPrimaryProgressCounter() {
        if (this.displayProgress) {
            this.resetSecondaryProgressCounter();
        }
    }

    @Override
    public int getPrimaryProgressCounter() {
        return this.progressBar.getValue();
    }

    @Override
    public int getMaxPrimaryProgressCounter() {
        return this.progressBar.getMaximum();
    }

    @Override
    public int getSecondaryProgressCounter() {
        return this.progressBar.getValue();
    }

    @Override
    public int getMaxSecondaryProgressCounter() {
        return this.progressBar.getMaximum();
    }

    @Override
    public void setDisplayProgress(boolean displayProgress) {
        this.displayProgress = displayProgress;
    }

    @Override
    public boolean getDisplayProgress() {
        return this.displayProgress;
    }
}

