/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io.export.features.peptideshaker;

import com.compomics.util.io.export.ExportFeature;
import java.util.ArrayList;
import java.util.Arrays;

public enum PsAnnotationFeature implements ExportFeature
{
    intensity_limit("Intensity Limit", "The intensity threshold for considering a peak (in percentile of the intensities in the spectrum).", false),
    automatic_annotation("Automatic Annotation", "Indicates whether the PeptideShaker automated peak annotation was used (1: yes, 0: no).", false),
    selected_ions("Selected Ions", "Indicates the ion types selected for peak annotation.", false),
    neutral_losses("Neutral Losses", "Indicates the neutral losses selected for peak annotation.", false),
    neutral_losses_sequence_dependence("Neutral Losses Sequence Dependence", "Indicates whether neutral losses consideration is sequence dependent (1: yes, 0: no).", false),
    fragment_ion_accuracy("Fragment Ion m/z Tolerance", "The m/z tolerance used for fragment ion annotation.", false);

    private final String title;
    private final String description;
    private final boolean advanced;
    public static final String type = "Annotation Settings";

    private PsAnnotationFeature(String title, String description, boolean advanced) {
        this.title = title;
        this.description = description;
        this.advanced = advanced;
    }

    @Override
    public ArrayList<ExportFeature> getExportFeatures(boolean includeSubFeatures) {
        ArrayList<ExportFeature> result = new ArrayList<ExportFeature>();
        result.addAll(Arrays.asList(PsAnnotationFeature.values()));
        return result;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getFeatureFamily() {
        return type;
    }

    @Override
    public boolean isAdvanced() {
        return this.advanced;
    }
}

