/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io.export.features.peptideshaker;

import com.compomics.util.io.export.ExportFeature;
import java.util.ArrayList;
import java.util.Arrays;

public enum PsSearchFeature implements ExportFeature
{
    precursor_tolerance_unit("Precursor Tolerance Unit", "Unit of the precursor tolearance: ppm or Da.", false),
    precursor_tolerance("Precursor Ion m/z Tolerance", "Precursor ion m/z tolerance used for the search.", false),
    fragment_tolerance_unit("Fragment Ion Tolerance Unit", "Unit of the precursor tolearance: ppm or Da.", false),
    fragment_tolerance("Fragment Ion m/z Tolerance", "Fragment ion m/z tolerance used for the search.", false),
    cleavage("Cleavage", "The type of cleavage used for the search.", false),
    enzyme("Enzyme", "The enzymes used for the search.", false),
    mc("Missed Cleavages", "The number of missed cleavages allowed for the enzyme digestion.", false),
    specificity("Specificity", "The specificity used for the enzyme digestion.", false),
    database("Database", "The protein sequence database.", false),
    forward_ion("Forward Ion", "The forward ion type searched for.", false),
    rewind_ion("Rewind Ion", "The rewind ion type searched for.", false),
    fixed_modifications("Fixed Modifications", "The fixed posttranslational modifications used for the search.", false),
    variable_modifications("Variable Modifications", "The variable posttranslational modifications used for the search.", false),
    refinement_variable_modifications("Refinement Variable Modifications", "The refinement variable posttranslational modifications used for the search, typically a second pass search.", false),
    refinement_fixed_modifications("Refinement Fixed Modifications", "The refinement fixed posttranslational modifications used for the search, typically a second pass search.", false);

    public String title;
    public String description;
    public static final String type = "Database Search Parameters";
    private final boolean advanced;

    private PsSearchFeature(String title, String description, boolean advanced) {
        this.title = title;
        this.description = description;
        this.advanced = advanced;
    }

    @Override
    public ArrayList<ExportFeature> getExportFeatures(boolean includeSubFeatures) {
        ArrayList<ExportFeature> result = new ArrayList<ExportFeature>();
        result.addAll(Arrays.asList(PsSearchFeature.values()));
        return result;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getFeatureFamily() {
        return type;
    }

    @Override
    public boolean isAdvanced() {
        return this.advanced;
    }
}

