/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io.flat;

import com.compomics.util.threading.SimpleSemaphore;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPOutputStream;

public class SimpleFileWriter
implements AutoCloseable {
    private final BufferedWriter bw;
    private final SimpleSemaphore mutex = new SimpleSemaphore(1);

    public SimpleFileWriter(File file, boolean gz) {
        try {
            if (gz) {
                FileOutputStream fileStream = new FileOutputStream(file);
                GZIPOutputStream gzipStream = new GZIPOutputStream(fileStream);
                OutputStreamWriter encoder = new OutputStreamWriter((OutputStream)gzipStream, "UTF-8");
                this.bw = new BufferedWriter(encoder);
            } else {
                this.bw = new BufferedWriter(new FileWriter(file));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeLine(String ... elements) {
        String line = String.join((CharSequence)"\t", elements);
        this.writeLine(line);
    }

    public void writeLine(String line) {
        this.write(line, true);
    }

    public void write(char[] buffer, int offset, int length) {
        try {
            this.bw.write(buffer, offset, length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void newLine() {
        try {
            this.bw.newLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void write(String text) {
        this.write(text, false);
    }

    public void write(String text, boolean newLine) {
        try {
            this.mutex.acquire();
            this.bw.write(text);
            if (newLine) {
                this.bw.newLine();
            }
            this.mutex.release();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.bw.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public BufferedWriter getWriter() {
        return this.bw;
    }
}

