/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io.json;

import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.io.json.adapter.ColorAdapter;
import com.compomics.util.io.json.adapter.FileAdapter;
import com.compomics.util.io.json.adapter.InterfaceAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;

public class JsonMarshaller
extends ExperimentObject {
    protected Gson gson = new Gson();
    protected final GsonBuilder builder = new GsonBuilder();

    public JsonMarshaller() {
        this.init();
        this.gson = this.builder.setPrettyPrinting().create();
    }

    protected void init() {
        this.builder.registerTypeAdapter(File.class, (Object)new FileAdapter());
        this.builder.registerTypeAdapter(Color.class, (Object)new ColorAdapter());
    }

    public JsonMarshaller(Class ... interfaces) {
        this.builder.registerTypeAdapter(File.class, (Object)new FileAdapter());
        for (Class aClass : interfaces) {
            this.builder.registerTypeAdapter((Type)aClass, new InterfaceAdapter());
        }
        this.gson = this.builder.setPrettyPrinting().create();
    }

    public String toJson(Object anObject) {
        return this.gson.toJson(anObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveObjectToJson(Object anObject, File jsonFile) throws IOException {
        try (BufferedWriter out = new BufferedWriter(new FileWriter(jsonFile));){
            out.append(this.toJson(anObject)).flush();
        }
    }

    public Object fromJson(Class objectType, String jsonString) {
        return this.gson.fromJson(jsonString, objectType);
    }

    public Object fromJson(Class objectType, File jsonFile) throws IOException {
        String jsonString = this.getJsonStringFromFile(jsonFile);
        return this.gson.fromJson(jsonString, objectType);
    }

    public Object fromJson(Class objectType, URL jsonURL) throws IOException {
        return this.gson.fromJson((Reader)new InputStreamReader(jsonURL.openStream()), objectType);
    }

    public Object fromJson(Type objectType, String jsonString) {
        return this.gson.fromJson(jsonString, objectType);
    }

    public Object fromJson(Type objectType, File jsonFile) throws IOException {
        String jsonString = this.getJsonStringFromFile(jsonFile);
        return this.gson.fromJson(jsonString, objectType);
    }

    public Object fromJson(Type objectType, URL jsonURL) throws IOException {
        return this.gson.fromJson((Reader)new InputStreamReader(jsonURL.openStream()), objectType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getJsonStringFromFile(File jsonFile) throws FileNotFoundException, IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(jsonFile)));){
            String line;
            while ((line = in.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        return stringBuilder.toString();
    }
}

