/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.math;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class HistogramUtils {
    public static double getMedianValue(HashMap<Double, Integer> histogram) {
        int nValues = histogram.values().stream().mapToInt(a -> a).sum();
        return HistogramUtils.getMedianValue(histogram, nValues);
    }

    public static double getMedianValue(HashMap<Double, Integer> histogram, int nValues) {
        ArrayList<Double> values = new ArrayList<Double>(histogram.keySet());
        Collections.sort(values);
        long currentSum = 0L;
        long previousSum = 0L;
        Double previousValue = 0.0;
        for (Double value : values) {
            int currentOccurence = histogram.get(value);
            if (2L * (currentSum += (long)currentOccurence) >= (long)nValues) {
                if (2L * (previousSum + 1L) > (long)nValues && previousSum > 0L) {
                    return (previousValue + value) / 2.0;
                }
                return value;
            }
            previousValue = value;
        }
        throw new IllegalArgumentException("Reached the end of the histogram before reaching the median.");
    }

    public static HashMap<Double, Integer> mergeHistograms(Collection<HashMap<Double, Integer>> histograms) {
        HashMap<Double, Integer> result = new HashMap<Double, Integer>();
        for (HashMap<Double, Integer> histogram : histograms) {
            for (Double value : histogram.keySet()) {
                Integer histogramValue = histogram.get(value);
                Integer resultValue = result.get(value);
                if (resultValue == null) {
                    result.put(value, histogramValue);
                    continue;
                }
                if (Integer.MAX_VALUE - histogramValue < resultValue) {
                    throw new IllegalArgumentException("Reached the maximal capacity of an integer in a histogram bin.");
                }
                result.put(value, resultValue + histogramValue);
            }
        }
        return result;
    }
}

