/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.math.statistics.distributions;

import com.compomics.util.math.statistics.Distribution;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.math.distribution.BinomialDistributionImpl;
import org.apache.commons.math.special.Beta;

public class BinomialDistribution
implements Distribution {
    private final BinomialDistributionImpl binomialDistributionImpl;
    private final int n;
    private final double p;
    private final int cacheSize = 1000;
    private final HashMap<Integer, Double> pCache = new HashMap();
    private final HashMap<Integer, Double> descendingCumulativePCache = new HashMap();

    public BinomialDistribution() {
        this.binomialDistributionImpl = null;
        this.n = 0;
        this.p = 0.0;
    }

    public BinomialDistribution(int n, double p) {
        this.n = n;
        this.p = p;
        this.binomialDistributionImpl = new BinomialDistributionImpl(n, p);
    }

    @Override
    public double getProbabilityAt(double x) {
        if (x < 0.0 || x > (double)this.n) {
            return 0.0;
        }
        int k = (int)x;
        Double result = this.pCache.get(k);
        if (result == null) {
            result = this.binomialDistributionImpl.probability(k);
            this.addPToCache(k, result);
        }
        return result;
    }

    private synchronized void addPToCache(int k, Double p) {
        if (this.pCache.size() >= 1000) {
            HashSet<Integer> keys = new HashSet<Integer>(this.pCache.keySet());
            for (Integer key : keys) {
                this.pCache.remove(key);
                if (this.pCache.size() >= 1000) continue;
                break;
            }
        }
        this.pCache.put(k, p);
    }

    @Override
    public double getCumulativeProbabilityAt(double x) {
        return 1.0 - this.getDescendingCumulativeProbabilityAt(x);
    }

    @Override
    public double getDescendingCumulativeProbabilityAt(double x) {
        int k = (int)x;
        if (k > this.n) {
            return 0.0;
        }
        if (k < 0) {
            return 1.0;
        }
        Double result = this.pCache.get(k);
        if (result == null) {
            try {
                result = Beta.regularizedBeta((double)this.p, (double)(x + 1.0), (double)((double)this.n - x));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            this.addDescendingCumulativePToCache(k, result);
        }
        return result;
    }

    private synchronized void addDescendingCumulativePToCache(int k, Double p) {
        if (this.descendingCumulativePCache.size() >= 1000) {
            HashSet<Integer> keys = new HashSet<Integer>(this.descendingCumulativePCache.keySet());
            for (Integer key : keys) {
                this.descendingCumulativePCache.remove(key);
                if (this.descendingCumulativePCache.size() >= 1000) continue;
                break;
            }
        }
        this.descendingCumulativePCache.put(k, p);
    }

    public boolean isCacheEmpty() {
        return this.pCache.isEmpty() && this.descendingCumulativePCache.isEmpty();
    }

    @Override
    public double getSmallestCumulativeProbabilityAt(double x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getMaxValueForProbability(double p) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public double getMinValueForProbability(double p) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public double getValueAtCumulativeProbability(double p) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public double getValueAtDescendingCumulativeProbability(double p) {
        throw new UnsupportedOperationException("Not supported.");
    }
}

