/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.nucleotide;

import com.compomics.util.experiment.io.biology.protein.Header;
import com.compomics.util.nucleotide.NucleotideSequenceImpl;
import com.compomics.util.protein.AASequenceImpl;
import com.compomics.util.protein.Protein;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NucleotideSequence {
    Logger logger = LogManager.getLogger(NucleotideSequence.class);
    private NucleotideSequenceImpl iSequence = null;
    private Header iHeader = null;

    public NucleotideSequence() {
    }

    public NucleotideSequence(NucleotideSequenceImpl aSequence) {
        this(null, aSequence);
    }

    public NucleotideSequence(Header aHeader, NucleotideSequenceImpl aSequence) {
        this.iHeader = aHeader;
        this.iSequence = aSequence;
    }

    public NucleotideSequence(String aFASTAString) {
        try {
            BufferedReader br = new BufferedReader(new StringReader(aFASTAString));
            this.iHeader = Header.parseFromFASTA(br.readLine());
            StringBuffer lSB = new StringBuffer();
            String line = null;
            while ((line = br.readLine()) != null) {
                lSB.append(line);
            }
            this.iSequence = new NucleotideSequenceImpl(lSB.toString());
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Unable to process your FASTA String ('" + aFASTAString + "'). IOException: " + ioe.getMessage() + ".");
        }
    }

    public NucleotideSequence(String aHeader, String aSequence) {
        this.iHeader = Header.parseFromFASTA(aHeader);
        this.iSequence = new NucleotideSequenceImpl(aSequence);
    }

    public NucleotideSequenceImpl getSequence() {
        return this.iSequence;
    }

    public void setSequence(NucleotideSequenceImpl aSequence) {
        this.iSequence = aSequence;
    }

    public Header getHeader() {
        return this.iHeader;
    }

    public void setHeader(Header aHeader) {
        this.iHeader = aHeader;
    }

    public long getLength() {
        return this.getSequence().getLength();
    }

    public double getMass() {
        return this.getSequence().getMass();
    }

    public void writeToFASTAFile(PrintWriter aOut) throws IOException {
        aOut.println(this.getHeader().getAbbreviatedFASTAHeaderWithAddenda());
        StringBuffer sequence = new StringBuffer(this.getSequence().getSequence());
        if (sequence.length() > 59) {
            int offset = 58;
            int i = 0;
            while (true) {
                sequence.insert(offset, "\n");
                if ((offset += 59) > sequence.length()) break;
                ++i;
            }
        }
        aOut.println(sequence.toString());
    }

    public Protein[] translate() {
        AASequenceImpl[] translated = this.iSequence.translate();
        Protein[] result = new Protein[translated.length];
        for (int i = 0; i < translated.length; ++i) {
            Header protHeader = (Header)this.getHeader().clone();
            if (protHeader.getAccession() != null) {
                protHeader.setAccession(protHeader.getAccession() + "_(RF " + (i + 1) + ")");
            } else {
                protHeader.setRest(protHeader.getRest() + "_(RF " + (i + 1) + ")");
            }
            result[i] = new Protein(protHeader, translated[i]);
        }
        return result;
    }
}

