/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.nucleotide;

import com.compomics.util.experiment.io.biology.protein.Header;
import com.compomics.util.general.MassCalc;
import com.compomics.util.general.UnknownElementMassException;
import com.compomics.util.interfaces.Sequence;
import com.compomics.util.protein.AASequenceImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NucleotideSequenceImpl
implements Sequence {
    Logger logger = LogManager.getLogger(NucleotideSequenceImpl.class);
    private String iSequence = null;
    private double iMass = -1.0;
    private static Properties iTranslate = null;
    private static Properties iComplement = null;

    public NucleotideSequenceImpl() {
    }

    public NucleotideSequenceImpl(String aSequence) {
        this.setSequence(aSequence);
    }

    public NucleotideSequenceImpl(String aSequence, Properties aCodonUsageTable) {
        iTranslate = aCodonUsageTable;
        this.setSequence(aSequence);
    }

    public NucleotideSequenceImpl(String aSequence, String aCodonUsageTable) {
        if (aCodonUsageTable != null && (iTranslate = this.loadProps(aCodonUsageTable)).size() == 0) {
            throw new IllegalArgumentException("Unable to read or parse your codon usage table!");
        }
        this.setSequence(aSequence);
    }

    @Override
    public void setSequence(String aSequence) {
        this.iSequence = aSequence.trim().toUpperCase();
        this.iMass = -1.0;
    }

    @Override
    public int getLength() {
        return this.iSequence.length();
    }

    @Override
    public double getMass() {
        if (this.iMass < 0.0) {
            try {
                this.iMass = new MassCalc(2).calculateMass(this.iSequence);
            }
            catch (UnknownElementMassException ueme) {
                this.logger.error(ueme.getMessage(), (Throwable)ueme);
            }
        }
        return this.iMass;
    }

    @Override
    public String getSequence() {
        return this.iSequence;
    }

    public AASequenceImpl[] translate() {
        Vector<AASequenceImpl> seqs = new Vector<AASequenceImpl>(6);
        if (iTranslate == null) {
            iTranslate = this.loadProps("DNA_Protein_Translation.properties");
        }
        for (int i = 0; i < 3; ++i) {
            String tempSeq = this.translate(this.iSequence, i);
            if (tempSeq == null || tempSeq.trim().equals("")) continue;
            seqs.add(new AASequenceImpl(tempSeq));
        }
        String inverse = this.getReverseComplementary();
        for (int i = 0; i < 3; ++i) {
            String tempSeq = this.translate(inverse, i);
            if (tempSeq == null || tempSeq.trim().equals("")) continue;
            seqs.add(new AASequenceImpl(tempSeq));
        }
        AASequenceImpl[] result = new AASequenceImpl[seqs.size()];
        seqs.toArray(result);
        return result;
    }

    public Vector translateToStopCodonSeparatedEntries(String aDatabaseIdentifier, String aShortOrganism) {
        Vector<HashMap> allSeqs = new Vector<HashMap>(6);
        if (iTranslate == null) {
            iTranslate = this.loadProps("DNA_Protein_Translation.properties");
        }
        for (int i = 0; i < 3; ++i) {
            String lEntryIdentifier = aDatabaseIdentifier + "-sense-" + (i + 1);
            HashMap lHashSeq = this.translateEntriesSeparatedByStopCodon(this.iSequence, i, lEntryIdentifier, aShortOrganism);
            if (lHashSeq.isEmpty()) continue;
            allSeqs.add(lHashSeq);
        }
        String inverse = this.getReverseComplementary();
        for (int i = 0; i < 3; ++i) {
            String lEntryIdentifier = aDatabaseIdentifier + "-antisense-" + (i + 1);
            HashMap lHashSeq = this.translateEntriesSeparatedByStopCodon(inverse, i, lEntryIdentifier, aShortOrganism);
            if (lHashSeq.isEmpty()) continue;
            allSeqs.add(lHashSeq);
        }
        return allSeqs;
    }

    public String getReverseComplementary() {
        if (iComplement == null) {
            iComplement = this.loadProps("complementaryNucleotides.properties");
        }
        StringBuffer complement = new StringBuffer();
        for (int i = this.iSequence.length(); i > 0; --i) {
            String key = this.iSequence.substring(i - 1, i);
            complement.append(iComplement.get(key));
        }
        return complement.toString();
    }

    private String translate(String aSequence, int aStartFrame) {
        StringBuffer aminoacidsequence = new StringBuffer();
        for (int i = aStartFrame %= 3; i < aSequence.length() - 2; i += 3) {
            String key = aSequence.substring(i, i + 3);
            if (key.indexOf(78) >= 0) {
                aminoacidsequence.append("X");
                continue;
            }
            aminoacidsequence.append((String)iTranslate.get(key));
        }
        return aminoacidsequence.toString();
    }

    private HashMap translateEntriesSeparatedByStopCodon(String aSequence, int aStartFrame, String aEntryIdentifier, String aShortOrganism) {
        HashMap<Header, String> seqs = new HashMap<Header, String>();
        int counter = 0;
        StringBuffer aminoacidSequence = new StringBuffer();
        aStartFrame %= 3;
        String key = null;
        try {
            for (int i = aStartFrame; i < aSequence.length() - 2; i += 3) {
                key = aSequence.substring(i, i + 3);
                if (key.indexOf(78) >= 0) {
                    aminoacidSequence.append("X");
                    continue;
                }
                if (iTranslate.get(key).equals("_") || i + 3 >= aSequence.length() - 2) {
                    String sequence;
                    if (key.length() == 3 && !iTranslate.get(key).equals("_")) {
                        aminoacidSequence.append((String)iTranslate.get(key));
                    }
                    if ((sequence = aminoacidSequence.toString()).equals("")) continue;
                    ++counter;
                    int start = i - sequence.length() * 3;
                    int stop = i - 1;
                    if (!iTranslate.get(key).equals("_")) {
                        stop += 3;
                        start += 3;
                    }
                    String nucleicSequence = aSequence.substring(start, stop + 1);
                    String lEntryIdentifier = aShortOrganism + counter + "_" + aEntryIdentifier;
                    Header lEntryHeader = Header.parseFromFASTA(lEntryIdentifier + " [" + (start + 1) + "-" + (stop + 1) + "]");
                    lEntryHeader.setAccession(lEntryHeader.getAccession());
                    lEntryHeader.setRest(nucleicSequence);
                    seqs.put(lEntryHeader, aminoacidSequence.toString());
                    aminoacidSequence = new StringBuffer();
                    continue;
                }
                aminoacidSequence.append((String)iTranslate.get(key));
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return seqs;
    }

    private Properties loadProps(String aPropFileName) {
        Properties p = new Properties();
        try {
            p.load(this.getClass().getClassLoader().getResourceAsStream(aPropFileName));
        }
        catch (IOException ioe) {
            this.logger.error("\nProperties file (" + aPropFileName + ") not found in classpath!");
            this.logger.error("All resultant values will be computed to 0.0!!\n");
        }
        return p;
    }
}

