/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.parameters.identification.advanced;

import com.compomics.util.experiment.io.biology.protein.FastaSummary;
import com.compomics.util.experiment.personalization.ExperimentObject;
import java.util.Map;
import java.util.TreeMap;

public class GeneParameters
extends ExperimentObject {
    static final long serialVersionUID = -5077297373352021745L;
    private Boolean autoUpdate;
    private Boolean useGeneMapping;
    private String backgroundSpecies;

    public GeneParameters() {
    }

    public GeneParameters(GeneParameters genePreferences) {
    }

    public Boolean getUseGeneMapping() {
        if (this.useGeneMapping == null) {
            this.useGeneMapping = true;
        }
        return this.useGeneMapping;
    }

    public void setUseGeneMapping(Boolean useGeneMapping) {
        this.useGeneMapping = useGeneMapping;
    }

    public Boolean getAutoUpdate() {
        if (this.autoUpdate == null) {
            this.autoUpdate = true;
        }
        return this.autoUpdate;
    }

    public void setAutoUpdate(Boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public boolean equals(GeneParameters genePreferences) {
        return this.getAutoUpdate().equals(genePreferences.getAutoUpdate());
    }

    public String getBackgroundSpecies() {
        return this.backgroundSpecies;
    }

    public void setBackgroundSpecies(String selectedBackgroundSpecies) {
        this.backgroundSpecies = selectedBackgroundSpecies;
    }

    public void setBackgroundSpeciesFromFastaSummary(FastaSummary fastaSummary) {
        try {
            TreeMap<String, Integer> speciesOccurrence = fastaSummary.speciesOccurrence;
            Integer occurrenceMax = null;
            for (Map.Entry<String, Integer> entry : speciesOccurrence.entrySet()) {
                String latinName = entry.getKey();
                if (latinName.equals("Unknown") || !this.getUseGeneMapping().booleanValue()) continue;
                Integer occurrence = entry.getValue();
                if (occurrenceMax != null && occurrence <= occurrenceMax) continue;
                occurrenceMax = occurrence;
                try {
                    String organismNameLowerCase = latinName.toLowerCase().replaceAll(" ", "_");
                    this.setBackgroundSpecies(organismNameLowerCase);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getShortDescription() {
        String newLine = System.getProperty("line.separator");
        StringBuilder output = new StringBuilder();
        output.append("Use Gene Mappings: ").append(this.getUseGeneMapping()).append(".").append(newLine);
        output.append("Update Gene Mappings: ").append(this.getAutoUpdate()).append(".").append(newLine);
        if (this.backgroundSpecies != null) {
            output.append("Species: ").append(this.backgroundSpecies).append(".").append(newLine);
        } else {
            output.append("Species: ").append("(not selected)").append(newLine);
        }
        return output.toString();
    }
}

