/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.parameters.identification.advanced;

import com.compomics.util.experiment.identification.modification.ModificationLocalizationScore;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;

public class ModificationLocalizationParameters
extends ExperimentObject {
    private boolean probabilisticScoreCalculation = true;
    private ModificationLocalizationScore selectedProbabilisticScore = ModificationLocalizationScore.PhosphoRS;
    private double dScoreThreshold = 95.0;
    private double probabilisticScoreThreshold = 95.0;
    private boolean probabilisticScoreNeutralLosses = false;
    private SequenceMatchingParameters sequenceMatchingParameters = new SequenceMatchingParameters();
    private boolean alignNonConfidentModifications = true;

    public ModificationLocalizationParameters() {
        this.sequenceMatchingParameters.setSequenceMatchingType(SequenceMatchingParameters.MatchingType.aminoAcid);
    }

    public boolean isProbabilisticScoreCalculation() {
        return this.probabilisticScoreCalculation;
    }

    public void setProbabilisticScoreCalculation(boolean probabilisticScoreCalculation) {
        this.probabilisticScoreCalculation = probabilisticScoreCalculation;
    }

    public ModificationLocalizationScore getSelectedProbabilisticScore() {
        return this.selectedProbabilisticScore;
    }

    public void setSelectedProbabilisticScore(ModificationLocalizationScore selectedProbabilisticScore) {
        this.selectedProbabilisticScore = selectedProbabilisticScore;
    }

    public double getProbabilisticScoreThreshold() {
        return this.probabilisticScoreThreshold;
    }

    public void setProbabilisticScoreThreshold(double probabilisticScoreThreshold) {
        this.probabilisticScoreThreshold = probabilisticScoreThreshold;
    }

    public double getDScoreThreshold() {
        return this.dScoreThreshold;
    }

    public void setDScoreThreshold(double dScoreThreshold) {
        this.dScoreThreshold = dScoreThreshold;
    }

    public boolean isProbabilisticScoreNeutralLosses() {
        return this.probabilisticScoreNeutralLosses;
    }

    public void setProbabilisticScoreNeutralLosses(boolean probabilisticScoreNeutralLosses) {
        this.probabilisticScoreNeutralLosses = probabilisticScoreNeutralLosses;
    }

    public SequenceMatchingParameters getSequenceMatchingParameters() {
        return this.sequenceMatchingParameters;
    }

    public void setSequenceMatchingParameters(SequenceMatchingParameters sequenceMatchingParameters) {
        this.sequenceMatchingParameters = sequenceMatchingParameters;
    }

    public boolean getAlignNonConfidentModifications() {
        return this.alignNonConfidentModifications;
    }

    public void setAlignNonConfidentModifications(boolean alignNonConfidentModifications) {
        this.alignNonConfidentModifications = alignNonConfidentModifications;
    }

    public String getShortDescription() {
        String newLine = System.getProperty("line.separator");
        StringBuilder output = new StringBuilder();
        output.append("Score: ").append((Object)this.selectedProbabilisticScore).append(".").append(newLine);
        output.append("Include Neutral Losses: ").append(this.probabilisticScoreNeutralLosses).append(".").append(newLine);
        output.append("Threshold: ").append(this.probabilisticScoreThreshold).append(".").append(newLine);
        output.append("Align modifications: ").append(this.getAlignNonConfidentModifications()).append(".").append(newLine);
        return output.toString();
    }

    public boolean equals(ModificationLocalizationParameters otherParameters) {
        if (otherParameters == null) {
            return false;
        }
        if (this.probabilisticScoreCalculation != otherParameters.isProbabilisticScoreCalculation()) {
            return false;
        }
        if (this.selectedProbabilisticScore != otherParameters.getSelectedProbabilisticScore()) {
            return false;
        }
        if (this.probabilisticScoreNeutralLosses != otherParameters.isProbabilisticScoreNeutralLosses()) {
            return false;
        }
        if (!this.getAlignNonConfidentModifications() == otherParameters.getAlignNonConfidentModifications()) {
            return false;
        }
        return this.sequenceMatchingParameters.isSameAs(otherParameters.getSequenceMatchingParameters());
    }
}

