/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.parameters.identification.tool_specific;

import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.mass_spectrometry.FragmentationMethod;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.gui.parameters.identification.IdentificationAlgorithmParameter;
import java.util.HashMap;

public class AndromedaParameters
extends ExperimentObject
implements IdentificationAlgorithmParameter {
    static final long serialVersionUID = 9056661756332085205L;
    private Double maxPeptideMass = 4600.0;
    private Integer maxCombinations = 250;
    private Integer topPeaks = 8;
    private Integer topPeaksWindow = 100;
    private Boolean includeWater = true;
    private Boolean includeAmmonia = true;
    private Boolean dependentLosses = true;
    private Boolean fragmentAll = false;
    private Boolean empiricalCorrection = true;
    private Boolean higherCharge = true;
    private FragmentationMethod fragmentationMethod = FragmentationMethod.CID;
    private Integer maxNumberOfModifications = 5;
    private Integer minPeptideLengthNoEnzyme = 8;
    private Integer maxPeptideLengthNoEnzyme = 30;
    private Boolean equalIL = false;
    private Integer numberOfCandidates = 10;
    private final HashMap<Integer, String> ptmIndexes = new HashMap(128);
    private AndromedaDecoyMode decoyMode = AndromedaDecoyMode.none;

    public double getMaxPeptideMass() {
        return this.maxPeptideMass;
    }

    public void setMaxPeptideMass(Double maxPeptideMass) {
        this.maxPeptideMass = maxPeptideMass;
    }

    public int getMaxCombinations() {
        return this.maxCombinations;
    }

    public void setMaxCombinations(int maxCombinations) {
        this.maxCombinations = maxCombinations;
    }

    public int getTopPeaks() {
        return this.topPeaks;
    }

    public void setTopPeaks(int topPeaks) {
        this.topPeaks = topPeaks;
    }

    public int getTopPeaksWindow() {
        return this.topPeaksWindow;
    }

    public void setTopPeaksWindow(int topPeaksWindow) {
        this.topPeaksWindow = topPeaksWindow;
    }

    public boolean isIncludeWater() {
        return this.includeWater;
    }

    public void setIncludeWater(boolean includeWater) {
        this.includeWater = includeWater;
    }

    public boolean isIncludeAmmonia() {
        return this.includeAmmonia;
    }

    public void setIncludeAmmonia(boolean includeAmmonia) {
        this.includeAmmonia = includeAmmonia;
    }

    public boolean isDependentLosses() {
        return this.dependentLosses;
    }

    public void setDependentLosses(boolean dependentLosses) {
        this.dependentLosses = dependentLosses;
    }

    public boolean isFragmentAll() {
        return this.fragmentAll;
    }

    public void setFragmentAll(boolean fragmentAll) {
        this.fragmentAll = fragmentAll;
    }

    public boolean isEmpiricalCorrection() {
        return this.empiricalCorrection;
    }

    public void setEmpiricalCorrection(boolean empiricalCorrection) {
        this.empiricalCorrection = empiricalCorrection;
    }

    public boolean isHigherCharge() {
        return this.higherCharge;
    }

    public void setHigherCharge(boolean higherCharge) {
        this.higherCharge = higherCharge;
    }

    public FragmentationMethod getFragmentationMethod() {
        return this.fragmentationMethod;
    }

    public void setFragmentationMethod(FragmentationMethod fragmentationMethod) {
        this.fragmentationMethod = fragmentationMethod;
    }

    public int getMaxNumberOfModifications() {
        return this.maxNumberOfModifications;
    }

    public void setMaxNumberOfModifications(int maxNumberOfModifications) {
        this.maxNumberOfModifications = maxNumberOfModifications;
    }

    public int getMinPeptideLengthNoEnzyme() {
        return this.minPeptideLengthNoEnzyme;
    }

    public void setMinPeptideLengthNoEnzyme(int minPeptideLengthNoEnzyme) {
        this.minPeptideLengthNoEnzyme = minPeptideLengthNoEnzyme;
    }

    public int getMaxPeptideLengthNoEnzyme() {
        return this.maxPeptideLengthNoEnzyme;
    }

    public void setMaxPeptideLengthNoEnzyme(int maxPeptideLengthNoEnzyme) {
        this.maxPeptideLengthNoEnzyme = maxPeptideLengthNoEnzyme;
    }

    public boolean isEqualIL() {
        return this.equalIL;
    }

    public void setEqualIL(boolean equalIL) {
        this.equalIL = equalIL;
    }

    public AndromedaDecoyMode getDecoyMode() {
        if (this.decoyMode == null) {
            this.decoyMode = AndromedaDecoyMode.none;
        }
        return this.decoyMode;
    }

    public void setDecoyMode(AndromedaDecoyMode decoyMode) {
        this.decoyMode = decoyMode;
    }

    public int getNumberOfCandidates() {
        return this.numberOfCandidates;
    }

    public void setPtmIndex(String modificationName, int ptmIndex) {
        this.ptmIndexes.put(ptmIndex, modificationName);
    }

    public String getModificationName(int ptmIndex) {
        return this.ptmIndexes.get(ptmIndex);
    }

    public boolean hasModificationIndexes() {
        return this.ptmIndexes != null && !this.ptmIndexes.isEmpty();
    }

    public Integer getPtmIndex(String modificationName) {
        for (int index : this.ptmIndexes.keySet()) {
            if (!modificationName.equalsIgnoreCase(this.ptmIndexes.get(index))) continue;
            return index;
        }
        return null;
    }

    public HashMap<Integer, String> getPtmIndexes() {
        return this.ptmIndexes;
    }

    public void setNumberOfCandidates(int numberOfCandidates) {
        this.numberOfCandidates = numberOfCandidates;
    }

    @Override
    public Advocate getAlgorithm() {
        return Advocate.andromeda;
    }

    @Override
    public boolean equals(IdentificationAlgorithmParameter identificationAlgorithmParameter) {
        if (identificationAlgorithmParameter instanceof AndromedaParameters) {
            AndromedaParameters andromedaParameters = (AndromedaParameters)identificationAlgorithmParameter;
            if (this.minPeptideLengthNoEnzyme.intValue() != andromedaParameters.getMinPeptideLengthNoEnzyme()) {
                return false;
            }
            if (this.maxPeptideLengthNoEnzyme.intValue() != andromedaParameters.getMaxPeptideLengthNoEnzyme()) {
                return false;
            }
            if (this.maxPeptideMass.doubleValue() != andromedaParameters.getMaxPeptideMass()) {
                return false;
            }
            if (this.numberOfCandidates.intValue() != andromedaParameters.getNumberOfCandidates()) {
                return false;
            }
            if (this.maxNumberOfModifications.intValue() != andromedaParameters.getMaxNumberOfModifications()) {
                return false;
            }
            if (this.fragmentationMethod != andromedaParameters.getFragmentationMethod()) {
                return false;
            }
            if (!this.includeWater.equals(andromedaParameters.isIncludeWater())) {
                return false;
            }
            if (!this.includeAmmonia.equals(andromedaParameters.isIncludeAmmonia())) {
                return false;
            }
            if (!this.dependentLosses.equals(andromedaParameters.isDependentLosses())) {
                return false;
            }
            if (!this.equalIL.equals(andromedaParameters.isEqualIL())) {
                return false;
            }
            if (!this.fragmentAll.equals(andromedaParameters.isFragmentAll())) {
                return false;
            }
            if (!this.empiricalCorrection.equals(andromedaParameters.isEmpiricalCorrection())) {
                return false;
            }
            if (!this.higherCharge.equals(andromedaParameters.isHigherCharge())) {
                return false;
            }
            if (this.maxCombinations.intValue() != andromedaParameters.getMaxCombinations()) {
                return false;
            }
            if (this.topPeaks.intValue() != andromedaParameters.getTopPeaks()) {
                return false;
            }
            if (this.topPeaksWindow.intValue() != andromedaParameters.getTopPeaksWindow()) {
                return false;
            }
            return this.getDecoyMode() == andromedaParameters.getDecoyMode();
        }
        return false;
    }

    @Override
    public String toString(boolean html) {
        String newLine = System.getProperty("line.separator");
        if (html) {
            newLine = "<br>";
        }
        StringBuilder output = new StringBuilder();
        Advocate advocate = this.getAlgorithm();
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append("# ").append(advocate.getName()).append(" Specific Parameters");
        output.append(newLine);
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append(newLine);
        output.append("MIN_PEPTIDE_LENGHT_NO_ENZYME=");
        output.append(this.minPeptideLengthNoEnzyme);
        output.append(newLine);
        output.append("MAX_PEPTIDE_LENGHT_NO_ENZYME=");
        output.append(this.maxPeptideLengthNoEnzyme);
        output.append(newLine);
        output.append("MAX_PEPTIDE_MASS=");
        output.append(this.maxPeptideMass);
        output.append(newLine);
        output.append("NUMBER_SPECTRUM_MATCHES=");
        output.append(this.numberOfCandidates);
        output.append(newLine);
        output.append("MAX_PTMS=");
        output.append(this.maxNumberOfModifications);
        output.append(newLine);
        output.append("FRAGMENTATION_METHOD=");
        output.append((Object)this.fragmentationMethod);
        output.append(newLine);
        output.append("WATER_LOSS=");
        output.append(this.includeWater);
        output.append(newLine);
        output.append("AMMONIA_LOSS=");
        output.append(this.includeAmmonia);
        output.append(newLine);
        output.append("SEQUENCE_DEPENDENT_NEUTRAL_LOSS=");
        output.append(this.dependentLosses);
        output.append(newLine);
        output.append("EQUAL_IL=");
        output.append(this.equalIL);
        output.append(newLine);
        output.append("FRAGMENT_ALL=");
        output.append(this.fragmentAll);
        output.append(newLine);
        output.append("EMPERICAL_CORRECTION=");
        output.append(this.empiricalCorrection);
        output.append(newLine);
        output.append("HIGHER_CHARGE=");
        output.append(this.higherCharge);
        output.append(newLine);
        output.append("MAX_COMBINATIONS=");
        output.append(this.maxCombinations);
        output.append(newLine);
        output.append("TOP_PEAKS=");
        output.append(this.topPeaks);
        output.append(newLine);
        output.append("TOP_PEAKS_WINDOW=");
        output.append(this.topPeaksWindow);
        output.append(newLine);
        output.append("DECOY_MODE=");
        output.append((Object)this.decoyMode);
        output.append(newLine);
        return output.toString();
    }

    public static enum AndromedaDecoyMode {
        none,
        reverse;

    }
}

