/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.parameters.identification.tool_specific;

import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.gui.parameters.identification.IdentificationAlgorithmParameter;

public class MsgfParameters
extends ExperimentObject
implements IdentificationAlgorithmParameter {
    static final long serialVersionUID = -2656523093031942973L;
    private boolean searchDecoyDatabase = false;
    private int instrumentID = 3;
    private int fragmentationType = 3;
    private int protocol = 0;
    private Integer minPeptideLength = 8;
    private Integer maxPeptideLength = 30;
    private Integer numberOfSpectrumMarches = 10;
    private boolean additionalOutput = false;
    private Integer numberTolerableTermini = 2;
    private Integer numberOfModificationsPerPeptide = 2;
    private Integer numberOfTasks = null;

    @Override
    public Advocate getAlgorithm() {
        return Advocate.msgf;
    }

    @Override
    public boolean equals(IdentificationAlgorithmParameter identificationAlgorithmParameter) {
        if (identificationAlgorithmParameter instanceof MsgfParameters) {
            MsgfParameters msgfParameters = (MsgfParameters)identificationAlgorithmParameter;
            if (this.searchDecoyDatabase != msgfParameters.searchDecoyDatabase()) {
                return false;
            }
            if (this.instrumentID != msgfParameters.getInstrumentID()) {
                return false;
            }
            if (this.fragmentationType != msgfParameters.getFragmentationType()) {
                return false;
            }
            if (this.protocol != msgfParameters.getProtocol()) {
                return false;
            }
            if (!this.minPeptideLength.equals(msgfParameters.getMinPeptideLength())) {
                return false;
            }
            if (!this.maxPeptideLength.equals(msgfParameters.getMaxPeptideLength())) {
                return false;
            }
            if (!this.numberOfSpectrumMarches.equals(msgfParameters.getNumberOfSpectrumMatches())) {
                return false;
            }
            if (this.additionalOutput != msgfParameters.isAdditionalOutput()) {
                return false;
            }
            if (!this.numberTolerableTermini.equals(msgfParameters.getNumberTolerableTermini())) {
                return false;
            }
            if (!this.numberOfModificationsPerPeptide.equals(msgfParameters.getNumberOfModificationsPerPeptide())) {
                return false;
            }
            return !(this.numberOfTasks != null && msgfParameters.getNumberOfTasks() == null || this.numberOfTasks == null && msgfParameters.getNumberOfTasks() != null) && (this.numberOfTasks == null || msgfParameters.getNumberOfTasks() == null || this.numberOfTasks.equals(msgfParameters.getNumberOfTasks()));
        }
        return false;
    }

    @Override
    public String toString(boolean html) {
        String newLine = System.getProperty("line.separator");
        if (html) {
            newLine = "<br>";
        }
        StringBuilder output = new StringBuilder();
        Advocate advocate = this.getAlgorithm();
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append("# ").append(advocate.getName()).append(" Specific Parameters");
        output.append(newLine);
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append(newLine);
        output.append("SEARCH_DECOY=");
        output.append(this.searchDecoyDatabase);
        output.append(newLine);
        output.append("INSTRUMENT_ID=");
        output.append(this.instrumentID);
        output.append(newLine);
        output.append("FRAGMENTATION_ID=");
        output.append(this.fragmentationType);
        output.append(newLine);
        output.append("PROTOCOL_ID=");
        output.append(this.protocol);
        output.append(newLine);
        output.append("MIN_PEP_LENGTH=");
        output.append(this.minPeptideLength);
        output.append(newLine);
        output.append("MAX_PEP_LENGTH=");
        output.append(this.maxPeptideLength);
        output.append(newLine);
        output.append("NUMBER_SPECTRUM_MATCHES=");
        output.append(this.numberOfSpectrumMarches);
        output.append(newLine);
        output.append("ADDITIONAL_OUTPUT=");
        output.append(this.additionalOutput);
        output.append(newLine);
        output.append("NUMBER_OF_TOLERABLE_TERMINI=");
        output.append(this.numberTolerableTermini);
        output.append(newLine);
        output.append("MAX_NUMBER_MODIFICATIONS=");
        output.append(this.numberOfModificationsPerPeptide);
        output.append(newLine);
        output.append("NUMBER_TASKS=");
        output.append(this.numberOfTasks);
        output.append(newLine);
        return output.toString();
    }

    public boolean searchDecoyDatabase() {
        return this.searchDecoyDatabase;
    }

    public void setSearchDecoyDatabase(boolean searchDecoyDatabase) {
        this.searchDecoyDatabase = searchDecoyDatabase;
    }

    public Integer getMaxPeptideLength() {
        return this.maxPeptideLength;
    }

    public void setMaxPeptideLength(Integer maxPeptideLength) {
        this.maxPeptideLength = maxPeptideLength;
    }

    public Integer getMinPeptideLength() {
        return this.minPeptideLength;
    }

    public void setMinPeptideLength(Integer minPeptideLength) {
        this.minPeptideLength = minPeptideLength;
    }

    public int getInstrumentID() {
        return this.instrumentID;
    }

    public void setInstrumentID(int instrumentID) {
        this.instrumentID = instrumentID;
    }

    public int getFragmentationType() {
        return this.fragmentationType;
    }

    public void setFragmentationType(int fragmentationType) {
        this.fragmentationType = fragmentationType;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public void setProtocol(int protocol) {
        this.protocol = protocol;
    }

    public Integer getNumberOfSpectrumMatches() {
        return this.numberOfSpectrumMarches;
    }

    public void setNumberOfSpectrumMarches(Integer numberOfSpectrumMarches) {
        this.numberOfSpectrumMarches = numberOfSpectrumMarches;
    }

    public boolean isAdditionalOutput() {
        return this.additionalOutput;
    }

    public void setAdditionalOutput(boolean additionalOutput) {
        this.additionalOutput = additionalOutput;
    }

    public Integer getNumberTolerableTermini() {
        return this.numberTolerableTermini;
    }

    public void setNumberTolerableTermini(Integer numberTolerableTermini) {
        this.numberTolerableTermini = numberTolerableTermini;
    }

    public Integer getNumberOfModificationsPerPeptide() {
        return this.numberOfModificationsPerPeptide;
    }

    public void setNumberOfModificationsPerPeptide(Integer numberOfModificationsPerPeptide) {
        this.numberOfModificationsPerPeptide = numberOfModificationsPerPeptide;
    }

    public Integer getNumberOfTasks() {
        return this.numberOfTasks;
    }

    public void setNumberOfTasks(Integer numberOfTasks) {
        this.numberOfTasks = numberOfTasks;
    }
}

