/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.parameters.identification.tool_specific;

import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.gui.parameters.identification.IdentificationAlgorithmParameter;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class OmssaParameters
extends ExperimentObject
implements IdentificationAlgorithmParameter {
    static final long serialVersionUID = -6704164074092668637L;
    private double maxEValue = 100.0;
    private int hitListLength = 10;
    private int minimalChargeForMultipleChargedFragments = 3;
    private int minPeptideLength = 8;
    private int maxPeptideLength = 30;
    private boolean removePrecursor = false;
    private boolean scalePrecursor = true;
    private boolean estimateCharge = true;
    private String selectedOutput = "OMX";
    private static final String[] omssaOutputTypes = new String[]{"OMX", "CSV", "pepXML"};
    private boolean memoryMappedSequenceLibraries = false;
    private double neutronThreshold = 1446.94;
    private double lowIntensityCutOff = 0.0;
    private double highIntensityCutOff = 0.2;
    private double intensityCutOffIncrement = 5.0E-4;
    private int singleChargeWindow = 27;
    private int doubleChargeWindow = 14;
    private int nPeaksInSingleChargeWindow = 2;
    private int nPeaksIndoubleChargeWindow = 2;
    private int maxHitsPerSpectrumPerCharge = 30;
    private int nAnnotatedMostIntensePeaks = 6;
    private int minAnnotatedPeaks = 2;
    private int minPeaks = 4;
    private boolean cleaveNtermMethionine = true;
    private int maxMzLadders = 128;
    private int maxFragmentCharge = 2;
    private double fractionOfPeaksForChargeEstimation = 0.95;
    private boolean determineChargePlusOneAlgorithmically = true;
    private boolean searchPositiveIons = true;
    private int minPrecPerSpectrum = 1;
    private boolean searchForwardFragmentFirst = false;
    private boolean searchRewindFragments = true;
    private int maxFragmentPerSeries = 100;
    private boolean useCorrelationCorrectionScore = true;
    private double consecutiveIonProbability = 0.5;
    private double iterativeSequenceEvalue = 0.0;
    private double iterativeReplaceEvalue = 0.0;
    private double iterativeSpectrumEvalue = 0.01;
    private ArrayList<Integer> noProlineRuleSeries = new ArrayList();
    private final HashMap<Integer, String> ptmIndexes = new HashMap();

    public double getMaxEValue() {
        return this.maxEValue;
    }

    public void setMaxEValue(double maxEValue) {
        this.maxEValue = maxEValue;
    }

    public int getHitListLength() {
        return this.hitListLength;
    }

    public void setHitListLength(int hitListLength) {
        this.hitListLength = hitListLength;
    }

    public int getMinimalChargeForMultipleChargedFragments() {
        return this.minimalChargeForMultipleChargedFragments;
    }

    public void setMinimalChargeForMultipleChargedFragments(int minimalChargeForMultipleChargedFragments) {
        this.minimalChargeForMultipleChargedFragments = minimalChargeForMultipleChargedFragments;
    }

    public int getMaxPeptideLength() {
        return this.maxPeptideLength;
    }

    public void setMaxPeptideLength(int maxPeptideLength) {
        this.maxPeptideLength = maxPeptideLength;
    }

    public int getMinPeptideLength() {
        return this.minPeptideLength;
    }

    public void setMinPeptideLength(int minPeptideLength) {
        this.minPeptideLength = minPeptideLength;
    }

    public boolean isEstimateCharge() {
        return this.estimateCharge;
    }

    public void setEstimateCharge(boolean estimateCharge) {
        this.estimateCharge = estimateCharge;
    }

    public boolean isRemovePrecursor() {
        return this.removePrecursor;
    }

    public void setRemovePrecursor(boolean removePrecursor) {
        this.removePrecursor = removePrecursor;
    }

    public boolean isScalePrecursor() {
        return this.scalePrecursor;
    }

    public void setScalePrecursor(boolean scalePrecursor) {
        this.scalePrecursor = scalePrecursor;
    }

    public String getSelectedOutput() {
        return this.selectedOutput;
    }

    public void setSelectedOutput(String selectedOutput) {
        this.selectedOutput = selectedOutput;
    }

    public static String[] getOmssaOutputTypes() {
        return omssaOutputTypes;
    }

    public boolean isMemoryMappedSequenceLibraries() {
        return this.memoryMappedSequenceLibraries;
    }

    public void setMemoryMappedSequenceLibraries(boolean memoryMappedSequenceLibraries) {
        this.memoryMappedSequenceLibraries = memoryMappedSequenceLibraries;
    }

    public double getNeutronThreshold() {
        return this.neutronThreshold;
    }

    public void setNeutronThreshold(double neutronThreshold) {
        this.neutronThreshold = neutronThreshold;
    }

    public double getLowIntensityCutOff() {
        return this.lowIntensityCutOff;
    }

    public void setLowIntensityCutOff(double lowIntensityCutOff) {
        this.lowIntensityCutOff = lowIntensityCutOff;
    }

    public double getHighIntensityCutOff() {
        return this.highIntensityCutOff;
    }

    public void setHighIntensityCutOff(double highIntensityCutOff) {
        this.highIntensityCutOff = highIntensityCutOff;
    }

    public double getIntensityCutOffIncrement() {
        return this.intensityCutOffIncrement;
    }

    public void setIntensityCutOffIncrement(double intensityCutOffIncrement) {
        this.intensityCutOffIncrement = intensityCutOffIncrement;
    }

    public int getSingleChargeWindow() {
        return this.singleChargeWindow;
    }

    public void setSingleChargeWindow(int singleChargeWindow) {
        this.singleChargeWindow = singleChargeWindow;
    }

    public int getDoubleChargeWindow() {
        return this.doubleChargeWindow;
    }

    public void setDoubleChargeWindow(int doubleChargeWindow) {
        this.doubleChargeWindow = doubleChargeWindow;
    }

    public int getnPeaksInSingleChargeWindow() {
        return this.nPeaksInSingleChargeWindow;
    }

    public void setnPeaksInSingleChargeWindow(int nPeaksInSingleChargeWindow) {
        this.nPeaksInSingleChargeWindow = nPeaksInSingleChargeWindow;
    }

    public int getnPeaksInDoubleChargeWindow() {
        return this.nPeaksIndoubleChargeWindow;
    }

    public void setnPeaksInDoubleChargeWindow(int nPeaksIndoubleChargeWindow) {
        this.nPeaksIndoubleChargeWindow = nPeaksIndoubleChargeWindow;
    }

    public int getMaxHitsPerSpectrumPerCharge() {
        return this.maxHitsPerSpectrumPerCharge;
    }

    public void setMaxHitsPerSpectrumPerCharge(int maxHitsPerSpectrumPerCharge) {
        this.maxHitsPerSpectrumPerCharge = maxHitsPerSpectrumPerCharge;
    }

    public int getnAnnotatedMostIntensePeaks() {
        return this.nAnnotatedMostIntensePeaks;
    }

    public void setnAnnotatedMostIntensePeaks(int nAnnotatedMostIntensePeaks) {
        this.nAnnotatedMostIntensePeaks = nAnnotatedMostIntensePeaks;
    }

    public int getMinAnnotatedPeaks() {
        return this.minAnnotatedPeaks;
    }

    public void setMinAnnotatedPeaks(int minAnnotatedPeaks) {
        this.minAnnotatedPeaks = minAnnotatedPeaks;
    }

    public int getMinPeaks() {
        return this.minPeaks;
    }

    public void setMinPeaks(int minPeaks) {
        this.minPeaks = minPeaks;
    }

    public boolean isCleaveNterMethionine() {
        return this.cleaveNtermMethionine;
    }

    public void setCleaveNterMethionine(boolean cleaveNterMethionine) {
        this.cleaveNtermMethionine = cleaveNterMethionine;
    }

    public int getMaxMzLadders() {
        return this.maxMzLadders;
    }

    public void setMaxMzLadders(int maxMzLadders) {
        this.maxMzLadders = maxMzLadders;
    }

    public int getMaxFragmentCharge() {
        return this.maxFragmentCharge;
    }

    public void setMaxFragmentCharge(int maxFragmentCharge) {
        this.maxFragmentCharge = maxFragmentCharge;
    }

    public double getFractionOfPeaksForChargeEstimation() {
        return this.fractionOfPeaksForChargeEstimation;
    }

    public void setFractionOfPeaksForChargeEstimation(double fractionOfPeaksForChargeEstimation) {
        this.fractionOfPeaksForChargeEstimation = fractionOfPeaksForChargeEstimation;
    }

    public boolean isDetermineChargePlusOneAlgorithmically() {
        return this.determineChargePlusOneAlgorithmically;
    }

    public void setDetermineChargePlusOneAlgorithmically(boolean determineChargePlusOneAlgorithmically) {
        this.determineChargePlusOneAlgorithmically = determineChargePlusOneAlgorithmically;
    }

    public boolean isSearchPositiveIons() {
        return this.searchPositiveIons;
    }

    public void setSearchPositiveIons(boolean searchPositiveIons) {
        this.searchPositiveIons = searchPositiveIons;
    }

    public int getMinPrecPerSpectrum() {
        return this.minPrecPerSpectrum;
    }

    public void setMinPrecPerSpectrum(int minPrecPerSpectrum) {
        this.minPrecPerSpectrum = minPrecPerSpectrum;
    }

    public boolean isSearchForwardFragmentFirst() {
        return this.searchForwardFragmentFirst;
    }

    public void setSearchForwardFragmentFirst(boolean searchForwardFragmentFirst) {
        this.searchForwardFragmentFirst = searchForwardFragmentFirst;
    }

    public boolean isSearchRewindFragments() {
        return this.searchRewindFragments;
    }

    public void setSearchRewindFragments(boolean searchRewindFragments) {
        this.searchRewindFragments = searchRewindFragments;
    }

    public int getMaxFragmentPerSeries() {
        return this.maxFragmentPerSeries;
    }

    public void setMaxFragmentPerSeries(int maxFragmentPerSeries) {
        this.maxFragmentPerSeries = maxFragmentPerSeries;
    }

    public boolean isUseCorrelationCorrectionScore() {
        return this.useCorrelationCorrectionScore;
    }

    public void setUseCorrelationCorrectionScore(boolean useCorrelationCorrectionScore) {
        this.useCorrelationCorrectionScore = useCorrelationCorrectionScore;
    }

    public double getConsecutiveIonProbability() {
        return this.consecutiveIonProbability;
    }

    public void setConsecutiveIonProbability(double consecutiveIonProbability) {
        this.consecutiveIonProbability = consecutiveIonProbability;
    }

    public double getIterativeSequenceEvalue() {
        return this.iterativeSequenceEvalue;
    }

    public void setIterativeSequenceEvalue(double iterativeSequenceEvalue) {
        this.iterativeSequenceEvalue = iterativeSequenceEvalue;
    }

    public double getIterativeReplaceEvalue() {
        return this.iterativeReplaceEvalue;
    }

    public void setIterativeReplaceEvalue(double iterativeReplaceEvalue) {
        this.iterativeReplaceEvalue = iterativeReplaceEvalue;
    }

    public double getIterativeSpectrumEvalue() {
        return this.iterativeSpectrumEvalue;
    }

    public void setIterativeSpectrumEvalue(double iterativeSpectrumEvalue) {
        this.iterativeSpectrumEvalue = iterativeSpectrumEvalue;
    }

    public ArrayList<Integer> getNoProlineRuleSeries() {
        return this.noProlineRuleSeries;
    }

    public void setNoProlineRuleSeries(ArrayList<Integer> noProlineRuleSeries) {
        this.noProlineRuleSeries = noProlineRuleSeries;
    }

    public void setPtmIndex(String modificationName, int ptmIndex) {
        this.ptmIndexes.put(ptmIndex, modificationName);
    }

    public String getModificationName(int ptmIndex) {
        return this.ptmIndexes.get(ptmIndex);
    }

    public boolean hasModificationIndexes() {
        return this.ptmIndexes != null && !this.ptmIndexes.isEmpty();
    }

    public int getPtmIndex(String modificationName) {
        for (int index : this.ptmIndexes.keySet()) {
            if (!modificationName.equalsIgnoreCase(this.ptmIndexes.get(index))) continue;
            return index;
        }
        throw new IllegalArgumentException("No OMSSA index set for " + modificationName + ".");
    }

    public HashMap<Integer, String> getPtmIndexes() {
        return this.ptmIndexes;
    }

    public void setPtmIndexes(ModificationParameters modificationProfile) {
        this.ptmIndexes.clear();
        int rank = 1;
        for (String ptm : modificationProfile.getAllModifications()) {
            int omssaIndex = rank + 118;
            if (omssaIndex > 128) {
                omssaIndex += 13;
            }
            this.setPtmIndex(ptm, omssaIndex);
            ++rank;
        }
    }

    public static HashMap<String, Integer> getOMSSAIndexes(File modificationsFile) throws XmlPullParserException, FileNotFoundException, IOException {
        HashMap<String, Integer> indexes = new HashMap<String, Integer>();
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setNamespaceAware(true);
        XmlPullParser parser = factory.newPullParser();
        BufferedReader br = new BufferedReader(new FileReader(modificationsFile));
        parser.setInput((Reader)br);
        int type = parser.next();
        int number = -1;
        while (type != 1) {
            if (type == 2 && parser.getName().equals("MSMod")) {
                parser.next();
                String numberString = parser.getText();
                try {
                    number = Integer.valueOf(numberString);
                }
                catch (NumberFormatException nfe) {
                    throw new XmlPullParserException("Found non-parseable text '" + numberString + "' for the value of the 'MSMod' tag on line " + parser.getLineNumber() + ".");
                }
            }
            if (type == 2 && parser.getName().equals("MSModSpec_name")) {
                parser.next();
                String name = parser.getText();
                if (number != -1) {
                    indexes.put(name, number);
                }
            }
            type = parser.next();
        }
        br.close();
        return indexes;
    }

    @Override
    public Advocate getAlgorithm() {
        return Advocate.omssa;
    }

    @Override
    public boolean equals(IdentificationAlgorithmParameter identificationAlgorithmParameter) {
        if (identificationAlgorithmParameter instanceof OmssaParameters) {
            OmssaParameters omssaParameters = (OmssaParameters)identificationAlgorithmParameter;
            if (this.getMaxEValue() != omssaParameters.getMaxEValue()) {
                return false;
            }
            if (this.getHitListLength() != omssaParameters.getHitListLength()) {
                return false;
            }
            if (this.getMaxPeptideLength() != omssaParameters.getMaxPeptideLength()) {
                return false;
            }
            if (this.getMinPeptideLength() != omssaParameters.getMinPeptideLength()) {
                return false;
            }
            if (this.getMinimalChargeForMultipleChargedFragments() != omssaParameters.getMinimalChargeForMultipleChargedFragments()) {
                return false;
            }
            if (this.isEstimateCharge() != omssaParameters.isEstimateCharge()) {
                return false;
            }
            if (this.isRemovePrecursor() != omssaParameters.isRemovePrecursor()) {
                return false;
            }
            if (this.isScalePrecursor() != omssaParameters.isScalePrecursor()) {
                return false;
            }
            if (!this.getSelectedOutput().equals(omssaParameters.getSelectedOutput())) {
                return false;
            }
            if (this.isMemoryMappedSequenceLibraries() != omssaParameters.isMemoryMappedSequenceLibraries()) {
                return false;
            }
            double diff = Math.abs(this.neutronThreshold - omssaParameters.getNeutronThreshold());
            if (diff > Double.MIN_VALUE) {
                return false;
            }
            if (this.getLowIntensityCutOff() != omssaParameters.getLowIntensityCutOff()) {
                return false;
            }
            if (this.getHighIntensityCutOff() != omssaParameters.getHighIntensityCutOff()) {
                return false;
            }
            if (this.getIntensityCutOffIncrement() != omssaParameters.getIntensityCutOffIncrement()) {
                return false;
            }
            if (this.getSingleChargeWindow() != omssaParameters.getSingleChargeWindow()) {
                return false;
            }
            if (this.getDoubleChargeWindow() != omssaParameters.getDoubleChargeWindow()) {
                return false;
            }
            if (this.getnPeaksInSingleChargeWindow() != omssaParameters.getnPeaksInSingleChargeWindow()) {
                return false;
            }
            if (this.getnPeaksInDoubleChargeWindow() != omssaParameters.getnPeaksInDoubleChargeWindow()) {
                return false;
            }
            if (this.getMaxHitsPerSpectrumPerCharge() != omssaParameters.getMaxHitsPerSpectrumPerCharge()) {
                return false;
            }
            if (this.getnAnnotatedMostIntensePeaks() != omssaParameters.getnAnnotatedMostIntensePeaks()) {
                return false;
            }
            if (this.getMinAnnotatedPeaks() != omssaParameters.getMinAnnotatedPeaks()) {
                return false;
            }
            if (this.getMinPeaks() != omssaParameters.getMinPeaks()) {
                return false;
            }
            if (this.isCleaveNterMethionine() != omssaParameters.isCleaveNterMethionine()) {
                return false;
            }
            if (this.getMaxMzLadders() != omssaParameters.getMaxMzLadders()) {
                return false;
            }
            if (this.getMaxFragmentCharge() != omssaParameters.getMaxFragmentCharge()) {
                return false;
            }
            diff = Math.abs(this.fractionOfPeaksForChargeEstimation - omssaParameters.getFractionOfPeaksForChargeEstimation());
            if (diff > Double.MIN_VALUE) {
                return false;
            }
            if (this.isDetermineChargePlusOneAlgorithmically() != omssaParameters.isDetermineChargePlusOneAlgorithmically()) {
                return false;
            }
            if (this.isSearchPositiveIons() != omssaParameters.isSearchPositiveIons()) {
                return false;
            }
            if (this.isSearchRewindFragments() != omssaParameters.isSearchRewindFragments()) {
                return false;
            }
            if (this.getMaxFragmentPerSeries() != omssaParameters.getMaxFragmentPerSeries()) {
                return false;
            }
            if (this.isUseCorrelationCorrectionScore() != omssaParameters.isUseCorrelationCorrectionScore()) {
                return false;
            }
            diff = Math.abs(this.consecutiveIonProbability - omssaParameters.getConsecutiveIonProbability());
            if (diff > Double.MIN_VALUE) {
                return false;
            }
            diff = Math.abs(this.iterativeSequenceEvalue - omssaParameters.getIterativeSequenceEvalue());
            if (diff > Double.MIN_VALUE) {
                return false;
            }
            diff = Math.abs(this.iterativeSpectrumEvalue - omssaParameters.getIterativeSpectrumEvalue());
            if (diff > Double.MIN_VALUE) {
                return false;
            }
            diff = Math.abs(this.iterativeReplaceEvalue - omssaParameters.getIterativeReplaceEvalue());
            return !(diff > Double.MIN_VALUE);
        }
        return false;
    }

    @Override
    public String toString(boolean html) {
        String newLine = System.getProperty("line.separator");
        if (html) {
            newLine = "<br>";
        }
        StringBuilder output = new StringBuilder();
        Advocate advocate = this.getAlgorithm();
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append("# ").append(advocate.getName()).append(" Specific Parameters");
        output.append(newLine);
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append(newLine);
        output.append("EVALUE_CUTOFF=");
        output.append(this.maxEValue);
        output.append(newLine);
        output.append("MAXIMUM_HITLIST_LENGTH=");
        output.append(this.hitListLength);
        output.append(newLine);
        output.append("PRECURSOR_ELIMINATION=");
        output.append(this.removePrecursor);
        output.append(newLine);
        output.append("PRECURSOR_SCALING=");
        output.append(this.scalePrecursor);
        output.append(newLine);
        output.append("MINIMAL_PEPTIDE_SIZE=");
        output.append(this.minPeptideLength);
        output.append(newLine);
        output.append("MAXIMAL_PEPTIDE_SIZE=");
        output.append(this.maxPeptideLength);
        output.append(newLine);
        output.append("PRECURSOR_CHARGE_TO_CONSIDER_MULTIPLY_CHARGED_FRAGMENTS=");
        output.append(this.minimalChargeForMultipleChargedFragments);
        output.append(newLine);
        output.append("CHARGE_ESTIMATION=");
        output.append(this.estimateCharge);
        output.append(newLine);
        output.append("OUTPUT_TYPE=");
        output.append(this.selectedOutput);
        output.append(newLine);
        output.append("MEMORY_MAPPED_SEQUENCES=");
        output.append(this.memoryMappedSequenceLibraries);
        output.append(newLine);
        output.append("MASS_TO_CONSIDER_EXACT_NEUTRON_MASS=");
        output.append(this.neutronThreshold);
        output.append(newLine);
        output.append("LOW_INTENSITY_CUTOFF=");
        output.append(this.lowIntensityCutOff);
        output.append(newLine);
        output.append("HIGH_INTENSITY_CUTOFF=");
        output.append(this.highIntensityCutOff);
        output.append(newLine);
        output.append("INTENSITY_INCREMENT=");
        output.append(this.intensityCutOffIncrement);
        output.append(newLine);
        output.append("SINGLE_CHARGE_WINDOW_WIDTH=");
        output.append(this.singleChargeWindow);
        output.append(newLine);
        output.append("DOUBLE_CHARGE_WINDOW_WIDTH=");
        output.append(this.doubleChargeWindow);
        output.append(newLine);
        output.append("SINGLE_CHARGE_WINDOW_NPEAKS=");
        output.append(this.nPeaksInSingleChargeWindow);
        output.append(newLine);
        output.append("DOUBLE_CHARGE_WINDOW_NPEAKS=");
        output.append(this.nPeaksIndoubleChargeWindow);
        output.append(newLine);
        output.append("MAX_HITS_PER_SPECTRUM_PER_CHARGE=");
        output.append(this.maxHitsPerSpectrumPerCharge);
        output.append(newLine);
        output.append("MIN_ANNOTATED_INTENSE_PEAKS=");
        output.append(this.nAnnotatedMostIntensePeaks);
        output.append(newLine);
        output.append("MIN_ANNOTATED_PEAKS=");
        output.append(this.minAnnotatedPeaks);
        output.append(newLine);
        output.append("MIN_PEAKS=");
        output.append(this.minPeaks);
        output.append(newLine);
        output.append("CLEAVE_TERMINAL_METHIONINE=");
        output.append(this.cleaveNtermMethionine);
        output.append(newLine);
        output.append("MAX_MZ_LADDERS=");
        output.append(this.maxMzLadders);
        output.append(newLine);
        output.append("MAX_FRAGMENT_CHARGE=");
        output.append(this.maxFragmentCharge);
        output.append(newLine);
        output.append("FRACTION_PEAKS_FOR_CHARGE_1_ESTIMATION=");
        output.append(this.fractionOfPeaksForChargeEstimation);
        output.append(newLine);
        output.append("AUTO_DETERMINE_CHARGE_ONE=");
        output.append(this.determineChargePlusOneAlgorithmically);
        output.append(newLine);
        output.append("SEARCH_POSITIVE_IONS=");
        output.append(this.searchPositiveIons);
        output.append(newLine);
        output.append("MIN_PERCURSORS_PER_SPECTRUM=");
        output.append(this.minPrecPerSpectrum);
        output.append(newLine);
        output.append("FORWARD_FRAGMENTS_FIRST=");
        output.append(this.searchForwardFragmentFirst);
        output.append(newLine);
        output.append("REWIND_FRAGMENTS=");
        output.append(this.searchRewindFragments);
        output.append(newLine);
        output.append("FRAGMENTS_PER_SERIES=");
        output.append(this.maxFragmentPerSeries);
        output.append(newLine);
        output.append("CORRELATION_CORRECTION_SCORE=");
        output.append(this.useCorrelationCorrectionScore);
        output.append(newLine);
        output.append("CONSECUTIVE_ION_PROBABILITY=");
        output.append(this.consecutiveIonProbability);
        output.append(newLine);
        output.append("ITERATIVE_SEARCH_SEQUENCE_EVALUE=");
        output.append(this.iterativeSequenceEvalue);
        output.append(newLine);
        output.append("ITERATIVE_SEARCH_SPECTRUM_EVALUE=");
        output.append(this.iterativeSpectrumEvalue);
        output.append(newLine);
        output.append("ITERATIVE_SEARCH_REPLACEMENT_EVALUE=");
        output.append(this.iterativeReplaceEvalue);
        output.append(newLine);
        return output.toString();
    }
}

