/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.parameters.identification.tool_specific;

import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.gui.parameters.identification.IdentificationAlgorithmParameter;

public class SageParameters
extends ExperimentObject
implements IdentificationAlgorithmParameter {
    static final long serialVersionUID = 7440784691598087741L;
    private Integer bucketSize = 32768;
    private Double minFragmentMz = 200.0;
    private Double maxFragmentMz = 2000.0;
    private Double minPeptideMass = 600.0;
    private Double maxPeptideMass = 5000.0;
    private Integer minIonIndex = 2;
    private Integer maxVariableMods = 2;
    private String decoyTag = "_REVERSED";
    private Boolean generateDecoys = false;
    private String tmtType = null;
    private Integer tmtLevel = 3;
    private Boolean tmtSn = false;
    private Boolean performLfq = false;
    private String lfqPeakScoring = "Hybrid";
    private String lfqIntergration = "Sum";
    private Double lfqSpectralAngle = 0.7;
    private Double lfqPpmTolerance = 5.0;
    private Boolean combineChargeStates = true;
    private Boolean deisotope = false;
    private Boolean chimera = false;
    private Boolean wideWindow = false;
    private Boolean predictRt = true;
    private Integer minPeaks = 15;
    private Integer maxPeaks = 150;
    private Integer minMatchedPeaks = 4;
    private Integer maxFragmentCharge = null;
    private Integer numPsmsPerSpectrum = 1;
    private Integer batchSize = null;
    private Integer minPeptideLength = 8;
    private Integer maxPeptideLength = 30;

    @Override
    public Advocate getAlgorithm() {
        return Advocate.sage;
    }

    @Override
    public boolean equals(IdentificationAlgorithmParameter identificationAlgorithmParameter) {
        if (identificationAlgorithmParameter instanceof SageParameters) {
            SageParameters sageParameters = (SageParameters)identificationAlgorithmParameter;
            if (!this.bucketSize.equals(sageParameters.getBucketSize())) {
                return false;
            }
            if (!this.minPeptideLength.equals(sageParameters.getMinPeptideLength())) {
                return false;
            }
            if (!this.maxPeptideLength.equals(sageParameters.getMaxPeptideLength())) {
                return false;
            }
            double diff = Math.abs(this.minFragmentMz - sageParameters.getMinFragmentMz());
            if (diff > 1.0E-13) {
                return false;
            }
            diff = Math.abs(this.maxFragmentMz - sageParameters.getMaxFragmentMz());
            if (diff > 1.0E-13) {
                return false;
            }
            diff = Math.abs(this.minPeptideMass - sageParameters.getMinPeptideMass());
            if (diff > 1.0E-13) {
                return false;
            }
            diff = Math.abs(this.maxPeptideMass - sageParameters.getMaxPeptideMass());
            if (diff > 1.0E-13) {
                return false;
            }
            if (!this.minIonIndex.equals(sageParameters.getMinIonIndex())) {
                return false;
            }
            if (!this.getMaxVariableMods().equals(sageParameters.getMaxVariableMods())) {
                return false;
            }
            if (!this.generateDecoys.equals(sageParameters.getGenerateDecoys())) {
                return false;
            }
            if (this.tmtType == null && sageParameters.getTmtType() != null || this.tmtType != null && sageParameters.getTmtType() == null) {
                return false;
            }
            if (this.tmtType != null && sageParameters.getTmtType() != null && !this.tmtType.equalsIgnoreCase(sageParameters.getTmtType())) {
                return false;
            }
            if (this.tmtLevel == null && sageParameters.getTmtLevel() != null || this.tmtLevel != null && sageParameters.getTmtLevel() == null) {
                return false;
            }
            if (this.tmtLevel != null && sageParameters.getTmtLevel() != null && !this.tmtLevel.equals(sageParameters.getTmtLevel())) {
                return false;
            }
            if (!this.getTmtSn().equals(sageParameters.getTmtSn())) {
                return false;
            }
            if (!this.performLfq.equals(sageParameters.getPerformLfq())) {
                return false;
            }
            if (this.lfqPeakScoring == null && sageParameters.getLfqPeakScoring() != null || this.lfqPeakScoring != null && sageParameters.getLfqPeakScoring() == null) {
                return false;
            }
            if (this.lfqPeakScoring != null && sageParameters.getLfqPeakScoring() != null && !this.lfqPeakScoring.equalsIgnoreCase(sageParameters.getLfqPeakScoring())) {
                return false;
            }
            if (this.lfqIntergration == null && sageParameters.getLfqIntergration() != null || this.lfqIntergration != null && sageParameters.getLfqIntergration() == null) {
                return false;
            }
            if (this.lfqIntergration != null && sageParameters.getLfqIntergration() != null && !this.lfqIntergration.equalsIgnoreCase(sageParameters.getLfqIntergration())) {
                return false;
            }
            diff = Math.abs(this.getLfqSpectralAngle() - sageParameters.getLfqSpectralAngle());
            if (diff > 1.0E-13) {
                return false;
            }
            diff = Math.abs(this.getLfqPpmTolerance() - sageParameters.getLfqPpmTolerance());
            if (diff > 1.0E-13) {
                return false;
            }
            if (!this.getCombineChargeStates().equals(sageParameters.getCombineChargeStates())) {
                return false;
            }
            if (!this.deisotope.equals(sageParameters.getDeisotope())) {
                return false;
            }
            if (!this.chimera.equals(sageParameters.getChimera())) {
                return false;
            }
            if (!this.getWideWindow().equals(sageParameters.getWideWindow())) {
                return false;
            }
            if (!this.predictRt.equals(sageParameters.getPredictRt())) {
                return false;
            }
            if (!this.minPeaks.equals(sageParameters.getMinPeaks())) {
                return false;
            }
            if (!this.maxPeaks.equals(sageParameters.getMaxPeaks())) {
                return false;
            }
            if (this.minMatchedPeaks == null && sageParameters.getMinMatchedPeaks() != null || this.minMatchedPeaks != null && sageParameters.getMinMatchedPeaks() == null) {
                return false;
            }
            if (this.minMatchedPeaks != null && sageParameters.getMinMatchedPeaks() != null && !this.minMatchedPeaks.equals(sageParameters.getMinMatchedPeaks())) {
                return false;
            }
            if (this.maxFragmentCharge == null && sageParameters.getMaxFragmentCharge() != null || this.maxFragmentCharge != null && sageParameters.getMaxFragmentCharge() == null) {
                return false;
            }
            if (this.maxFragmentCharge != null && sageParameters.getMaxFragmentCharge() != null && !this.maxFragmentCharge.equals(sageParameters.getMaxFragmentCharge())) {
                return false;
            }
            if (!this.numPsmsPerSpectrum.equals(sageParameters.getNumPsmsPerSpectrum())) {
                return false;
            }
            if (this.getBatchSize() == null && sageParameters.getBatchSize() != null || this.getBatchSize() != null && sageParameters.getBatchSize() == null) {
                return false;
            }
            return this.getBatchSize() == null || sageParameters.getBatchSize() == null || this.getBatchSize().equals(sageParameters.getBatchSize());
        }
        return false;
    }

    @Override
    public String toString(boolean html) {
        String newLine = System.getProperty("line.separator");
        if (html) {
            newLine = "<br>";
        }
        StringBuilder output = new StringBuilder();
        Advocate advocate = this.getAlgorithm();
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append("# ").append(advocate.getName()).append(" Specific Parameters");
        output.append(newLine);
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append(newLine);
        output.append("BUCKET_SIZE=");
        output.append(this.bucketSize);
        output.append(newLine);
        output.append("MIN_PEP_LENGTH=");
        output.append(this.minPeptideLength);
        output.append(newLine);
        output.append("MAX_PEP_LENGTH=");
        output.append(this.maxPeptideLength);
        output.append(newLine);
        output.append("MIN_FRAGMENT_MZ=");
        output.append(this.minFragmentMz);
        output.append(newLine);
        output.append("MAX_FRAGMENT_MZ=");
        output.append(this.maxFragmentMz);
        output.append(newLine);
        output.append("MIN_PEPTIDE_MASS=");
        output.append(this.minPeptideMass);
        output.append(newLine);
        output.append("MAX_PEPTIDE_MASS=");
        output.append(this.maxPeptideMass);
        output.append(newLine);
        output.append("MIN_ION_INDEX=");
        output.append(this.minIonIndex);
        output.append(newLine);
        output.append("MAX_VARIABLE_MODS=");
        output.append(this.maxVariableMods);
        output.append(newLine);
        output.append("GENERATE_DECOYS=");
        output.append(this.generateDecoys);
        output.append(newLine);
        output.append("TMT_TYPE=");
        output.append(this.tmtType);
        output.append(newLine);
        output.append("TMT_LEVEL=");
        output.append(this.tmtLevel);
        output.append(newLine);
        output.append("TMT_SN=");
        output.append(this.tmtSn);
        output.append(newLine);
        output.append("LFQ=");
        output.append(this.performLfq);
        output.append(newLine);
        output.append("LFQ_PEAK_SCORING=");
        output.append(this.lfqPeakScoring);
        output.append(newLine);
        output.append("LFQ_INTEGRATION=");
        output.append(this.lfqIntergration);
        output.append(newLine);
        output.append("LFQ_SPECTRAL_ANGLE=");
        output.append(this.lfqSpectralAngle);
        output.append(newLine);
        output.append("LFQ_PPM_TOLERANCE=");
        output.append(this.lfqPpmTolerance);
        output.append(newLine);
        output.append("LFQ_COMBINE_CHARGE_STATES=");
        output.append(this.getCombineChargeStates());
        output.append(newLine);
        output.append("DEISOTOPE=");
        output.append(this.deisotope);
        output.append(newLine);
        output.append("CHIMERA=");
        output.append(this.chimera);
        output.append(newLine);
        output.append("WIDE_WINDOW=");
        output.append(this.wideWindow);
        output.append(newLine);
        output.append("PREDICT_RT=");
        output.append(this.predictRt);
        output.append(newLine);
        output.append("MIN_PEAKS=");
        output.append(this.minPeaks);
        output.append(newLine);
        output.append("MAX_PEAKS=");
        output.append(this.maxPeaks);
        output.append(newLine);
        output.append("MIN_MATCHED_PEAKS=");
        output.append(this.minMatchedPeaks);
        output.append(newLine);
        output.append("MAX_FRAGMENT_CHARGE=");
        output.append(this.maxFragmentCharge);
        output.append(newLine);
        output.append("NUM_PSMS_PER_SPECTRUM=");
        output.append(this.numPsmsPerSpectrum);
        output.append(newLine);
        output.append("BATCH_SIZE=");
        output.append(this.batchSize);
        output.append(newLine);
        return output.toString();
    }

    public Integer getMaxPeptideLength() {
        return this.maxPeptideLength;
    }

    public void setMaxPeptideLength(int maxPeptideLength) {
        this.maxPeptideLength = maxPeptideLength;
    }

    public Integer getMinPeptideLength() {
        return this.minPeptideLength;
    }

    public void setMinPeptideLength(int minPeptideLength) {
        this.minPeptideLength = minPeptideLength;
    }

    public Integer getBucketSize() {
        return this.bucketSize;
    }

    public void setBucketSize(Integer bucketSize) {
        this.bucketSize = bucketSize;
    }

    public Double getMinFragmentMz() {
        return this.minFragmentMz;
    }

    public void setMinFragmentMz(Double minFragmentMz) {
        this.minFragmentMz = minFragmentMz;
    }

    public Double getMaxFragmentMz() {
        return this.maxFragmentMz;
    }

    public void setMaxFragmentMz(Double maxFragmentMz) {
        this.maxFragmentMz = maxFragmentMz;
    }

    public Double getMinPeptideMass() {
        return this.minPeptideMass;
    }

    public void setMinPeptideMass(Double minPeptideMass) {
        this.minPeptideMass = minPeptideMass;
    }

    public Double getMaxPeptideMass() {
        return this.maxPeptideMass;
    }

    public void setMaxPeptideMass(Double maxPeptideMass) {
        this.maxPeptideMass = maxPeptideMass;
    }

    public Integer getMinIonIndex() {
        return this.minIonIndex;
    }

    public void setMinIonIndex(Integer minIonIndex) {
        this.minIonIndex = minIonIndex;
    }

    public String getDecoyTag() {
        return this.decoyTag;
    }

    public void setDecoyTag(String decoyTag) {
        this.decoyTag = decoyTag;
    }

    public Boolean getGenerateDecoys() {
        return this.generateDecoys;
    }

    public void setGenerateDecoys(Boolean generateDecoys) {
        this.generateDecoys = generateDecoys;
    }

    public String getTmtType() {
        return this.tmtType;
    }

    public void setTmtType(String tmtType) {
        this.tmtType = tmtType;
    }

    public Integer getTmtLevel() {
        if (this.tmtLevel == null) {
            this.tmtLevel = 3;
        }
        return this.tmtLevel;
    }

    public void setTmtLevel(Integer tmtLevel) {
        this.tmtLevel = tmtLevel;
    }

    public Boolean getTmtSn() {
        if (this.tmtSn == null) {
            this.tmtSn = false;
        }
        return this.tmtSn;
    }

    public void setTmtSn(Boolean tmtSn) {
        this.tmtSn = tmtSn;
    }

    public Boolean getPerformLfq() {
        return this.performLfq;
    }

    public void setPerformLfq(Boolean performLfq) {
        this.performLfq = performLfq;
    }

    public Boolean getDeisotope() {
        return this.deisotope;
    }

    public void setDeisotope(Boolean deisotope) {
        this.deisotope = deisotope;
    }

    public Boolean getChimera() {
        return this.chimera;
    }

    public void setChimera(Boolean chimera) {
        this.chimera = chimera;
    }

    public Boolean getWideWindow() {
        if (this.wideWindow == null) {
            this.wideWindow = false;
        }
        return this.wideWindow;
    }

    public void setWideWindow(Boolean wideWindow) {
        this.wideWindow = wideWindow;
    }

    public Boolean getPredictRt() {
        return this.predictRt;
    }

    public void setPredictRt(Boolean predictRt) {
        this.predictRt = predictRt;
    }

    public Integer getMinPeaks() {
        return this.minPeaks;
    }

    public void setMinPeaks(Integer minPeaks) {
        this.minPeaks = minPeaks;
    }

    public Integer getMaxPeaks() {
        return this.maxPeaks;
    }

    public void setMaxPeaks(Integer maxPeaks) {
        this.maxPeaks = maxPeaks;
    }

    public Integer getMinMatchedPeaks() {
        return this.minMatchedPeaks;
    }

    public void setMinMatchedPeaks(Integer minMatchedPeaks) {
        this.minMatchedPeaks = minMatchedPeaks;
    }

    public Integer getMaxFragmentCharge() {
        return this.maxFragmentCharge;
    }

    public void setMaxFragmentCharge(Integer maxFragmentCharge) {
        this.maxFragmentCharge = maxFragmentCharge;
    }

    public Integer getNumPsmsPerSpectrum() {
        return this.numPsmsPerSpectrum;
    }

    public void setNumPsmsPerSpectrum(Integer numPsmsPerSpectrum) {
        this.numPsmsPerSpectrum = numPsmsPerSpectrum;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public Integer getMaxVariableMods() {
        if (this.maxVariableMods == null) {
            this.maxVariableMods = 2;
        }
        return this.maxVariableMods;
    }

    public void setMaxVariableMods(Integer maxVariableMods) {
        this.maxVariableMods = maxVariableMods;
    }

    public String getLfqPeakScoring() {
        if (this.lfqPeakScoring == null) {
            this.lfqPeakScoring = "Hybrid";
        }
        return this.lfqPeakScoring;
    }

    public void setLfqPeakScoring(String lfqPeakScoring) {
        this.lfqPeakScoring = lfqPeakScoring;
    }

    public String getLfqIntergration() {
        if (this.lfqIntergration == null) {
            this.lfqIntergration = "Sum";
        }
        return this.lfqIntergration;
    }

    public void setLfqIntergration(String lfqIntergration) {
        this.lfqIntergration = lfqIntergration;
    }

    public Double getLfqSpectralAngle() {
        if (this.lfqSpectralAngle == null) {
            this.lfqSpectralAngle = 0.7;
        }
        return this.lfqSpectralAngle;
    }

    public void setLfqSpectralAngle(Double lfqSpectralAngle) {
        this.lfqSpectralAngle = lfqSpectralAngle;
    }

    public Double getLfqPpmTolerance() {
        if (this.lfqPpmTolerance == null) {
            this.lfqPpmTolerance = 0.5;
        }
        return this.lfqPpmTolerance;
    }

    public void setLfqPpmTolerance(Double lfqPpmTolerance) {
        this.lfqPpmTolerance = lfqPpmTolerance;
    }

    public Boolean getCombineChargeStates() {
        if (this.combineChargeStates == null) {
            this.combineChargeStates = true;
        }
        return this.combineChargeStates;
    }

    public void setCombineChargeStates(Boolean combineChargeStates) {
        this.combineChargeStates = combineChargeStates;
    }
}

