/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.pdbfinder;

import com.compomics.util.pdbfinder.das.readers.AlignmentBlock;
import com.compomics.util.pdbfinder.das.readers.DasAlignment;
import com.compomics.util.pdbfinder.das.readers.DasAnnotationServerAlingmentReader;
import com.compomics.util.pdbfinder.pdb.PdbBlock;
import com.compomics.util.pdbfinder.pdb.PdbParameter;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class FindPdbForUniprotAccessions {
    private String iProteinAccession;
    private DasAlignment[] iAlignments;
    private Vector<PdbParameter> iPdbs = new Vector();
    private DasAnnotationServerAlingmentReader iDasReader;
    private String iUrl;
    private boolean isFirstTry = true;
    private boolean urlRead = false;
    private WaitingHandler waitingHandler;

    public FindPdbForUniprotAccessions() {
    }

    public FindPdbForUniprotAccessions(String aProteinAccession, WaitingHandler aWaitingHandler) {
        this.iProteinAccession = aProteinAccession;
        this.waitingHandler = aWaitingHandler;
        Thread pdbThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String urlMake = "https://www.ebi.ac.uk/pdbe/api/mappings/best_structures/" + FindPdbForUniprotAccessions.this.iProteinAccession;
                    FindPdbForUniprotAccessions.this.readUrl(urlMake);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "PdbDownloader");
        pdbThread.start();
        while (pdbThread.getState() == Thread.State.NEW) {
        }
        while (!this.urlRead) {
            new String("waiting...");
            if (this.waitingHandler == null || !this.waitingHandler.isRunCanceled()) continue;
        }
        if (this.waitingHandler != null && this.waitingHandler.isRunCanceled()) {
            return;
        }
        this.iAlignments = this.iDasReader.getAllAlignments();
        try {
            for (DasAlignment align : this.iAlignments) {
                PdbBlock block;
                String pdb = align.getPdbAccession().substring(0, 4);
                pdb = pdb.toUpperCase();
                boolean newPdb = true;
                PdbParameter pdbParamToAddBlock = null;
                for (int v = 0; v < this.iPdbs.size(); ++v) {
                    PdbParameter pdbParam = this.iPdbs.get(v);
                    if (!pdb.equalsIgnoreCase(pdbParam.getPdbaccession())) continue;
                    newPdb = false;
                    v = this.iPdbs.size();
                    pdbParamToAddBlock = pdbParam;
                }
                if (newPdb) {
                    pdbParamToAddBlock = new PdbParameter(pdb, align.getTitle(), align.getExperimentType(), align.getResolution());
                    for (AlignmentBlock alignBlock : align.getAlignmentBlocks()) {
                        block = new PdbBlock(alignBlock.getSpAccession(), alignBlock.getSpStart(), alignBlock.getSpEnd(), alignBlock.getPdbStart(), alignBlock.getPdbEnd());
                        pdbParamToAddBlock.addBlock(block);
                    }
                    this.iPdbs.add(pdbParamToAddBlock);
                    continue;
                }
                for (AlignmentBlock alignBlock : align.getAlignmentBlocks()) {
                    block = new PdbBlock(alignBlock.getSpAccession(), alignBlock.getSpStart(), alignBlock.getSpEnd(), alignBlock.getPdbStart(), alignBlock.getPdbEnd());
                    pdbParamToAddBlock.addBlock(block);
                }
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            System.out.println("Error in reading das pdb alignment");
            e.printStackTrace();
        }
    }

    public boolean urlWasRead() {
        return this.urlRead;
    }

    public Vector<PdbParameter> getPdbs() {
        return this.iPdbs;
    }

    private void readUrl(String aUrl) {
        this.urlRead = false;
        this.iUrl = aUrl;
        try {
            int i;
            URL myURL = new URL(this.iUrl);
            StringBuilder input = new StringBuilder();
            HttpURLConnection connection = (HttpURLConnection)myURL.openConnection();
            BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
            InputStreamReader r = new InputStreamReader(in);
            while ((i = ((Reader)r).read()) != -1) {
                input.append((char)i);
            }
            ((Reader)r).close();
            in.close();
            this.iDasReader = new DasAnnotationServerAlingmentReader(input.toString());
            this.urlRead = true;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ConnectException e) {
            System.out.println("Connect exception for url " + this.iUrl);
            if (this.isFirstTry) {
                this.readUrl(this.iUrl);
            }
            this.isFirstTry = false;
        }
        catch (IOException e) {
            System.out.println("I/O exception for url " + this.iUrl);
        }
    }

    public static void main(String[] args) {
        String lAccession = "O75369";
        FindPdbForUniprotAccessions lF = new FindPdbForUniprotAccessions(lAccession, null);
        System.out.println("Found " + lF.getPdbs().size() + " pdf file(s) for " + lAccession);
        for (int i = 0; i < lF.getPdbs().size(); ++i) {
            PdbBlock[] lBlocks;
            PdbParameter lParam = lF.getPdbs().get(i);
            System.out.println(i + 1 + ". " + lParam.getPdbaccession() + " : " + lParam.getTitle() + " (" + lParam.getExperiment_type() + ") " + lParam.getResolution());
            System.out.println("\t\tDownload from : https://www.rcsb.org/pdb/files/" + lParam.getPdbaccession() + ".pdb");
            System.out.println(lParam.getBlocks().length + " block(s) found in this pdf file");
            for (PdbBlock lBlock : lBlocks = lParam.getBlocks()) {
                System.out.println("\tBlock : " + lBlock.getBlock());
                System.out.println("\tAlignment between uniprot protein sequence and sequences in this block");
                System.out.println("\t\tStart block " + lBlock.getStartBlock() + " <=> Start protein " + lBlock.getStartProtein());
                System.out.println("\t\tEnd block " + lBlock.getEndBlock() + " <=> End protein " + lBlock.getEndProtein());
            }
            System.out.println("\n");
        }
    }
}

