/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.pride.prideobjects.webservice;

public enum PrideQuery {
    GET_PROJECT_BY_ACCESSION("project/{projectAccession}"),
    GET_PROJECTS_BY_CRITERIA("project/list"),
    GET_ASSAY_BY_ACCESSION("assay/{assayAccession}"),
    GET_ASSAYS_BY_PROJECT("assay/list/project/{projectAccession}"),
    GET_FILES_BY_PROJECT("file/list/project/{projectAccession}"),
    GET_FILES_BY_ASAY("file/list/assay/{assayAccession}"),
    GET_ALL_PROTEIN_IDENTIFICATIONS_BY_PROJECT("protein/list/project/{projectAccession}"),
    GET_PROTEIN_IDENTIFICATION_BY_PROJECT("protein/list/project/{projectAccession}/protein/{accession}"),
    GET_ALL_PROTEIN_IDENTIFICATIONS_BY_ASSAY("protein/list/assay/{assayAccession}"),
    GET_ALL_PEPTIDE_IDENTIFICATIONS_BY_PROJECT("peptide/list/project/{projectAccession}"),
    GET_ALL_PEPTIDE_IDENTIFICATIONS_BY_PROJECT_AND_SEQUENCE("peptide/list/project/{projectAccession}/sequence/{peptideSequence}"),
    GET_ALL_PEPTIDE_IDENTIFICATIONS_BY_ASSAY("peptide/list/assay/{assayAccession}"),
    GET_ALL_PEPTIDE_IDENTIFICATIONS_BY_ASSAY_AND_SEQUENCE("peptide/list/assay/{assayAccession}/sequence/{peptideSequence}");

    private static final String ROOT_URL = "https://www.ebi.ac.uk:443/pride/ws/archive/";
    private final String queryTemplate;

    private PrideQuery(String queryTemplate) {
        this.queryTemplate = queryTemplate;
    }

    public String getQueryTemplate(boolean count) {
        String temp = ROOT_URL;
        temp = count ? temp + this.queryTemplate.replace("list", "count") : temp + this.queryTemplate;
        return temp;
    }

    private PrideQuery() {
        this.queryTemplate = "";
    }
}

