/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.threading;

import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.threading.SimpleSemaphore;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectMutex {
    private final SimpleSemaphore masterMutex = new SimpleSemaphore(1);
    private final ConcurrentHashMap<Long, SimpleSemaphore> mutexMap = new ConcurrentHashMap();

    public void acquire(long key) {
        SimpleSemaphore objectMutex = this.mutexMap.get(key);
        if (objectMutex == null) {
            this.masterMutex.acquire();
            objectMutex = this.mutexMap.get(key);
            if (objectMutex == null) {
                objectMutex = new SimpleSemaphore(1);
                this.mutexMap.put(key, objectMutex);
            }
            this.masterMutex.release();
        }
        objectMutex.acquire();
    }

    public void acquire(String key) {
        long longKey = ExperimentObject.asLong(key);
        this.acquire(longKey);
    }

    public void release(long key) {
        SimpleSemaphore objectMutex = this.mutexMap.get(key);
        objectMutex.release();
    }

    public void release(String key) {
        long longKey = ExperimentObject.asLong(key);
        this.release(longKey);
    }
}

