/*
 * Decompiled with CFR 0.152.
 */
package no.uib.jsparklines.data;

import java.awt.BasicStroke;
import java.awt.Color;
import java.util.ArrayList;
import no.uib.jsparklines.renderers.util.Util;

public class JSparklinesDataSeries {
    private ArrayList<Double> data;
    private Color seriesColor;
    private String seriesLabel;
    private BasicStroke lineType;
    private float lineWidth = 5.0f;

    public JSparklinesDataSeries(ArrayList<Double> data, Color seriesColor, String seriesLabel) {
        this.data = data;
        this.seriesColor = seriesColor;
        this.seriesLabel = seriesLabel;
        this.lineType = new BasicStroke(this.lineWidth, 1, 1);
    }

    public JSparklinesDataSeries(ArrayList<Double> data, Color seriesColor, String seriesLabel, BasicStroke lineType) {
        this.data = data;
        this.seriesColor = seriesColor;
        this.seriesLabel = seriesLabel;
        this.lineType = lineType;
    }

    public ArrayList<Double> getData() {
        return this.data;
    }

    public void setData(ArrayList<Double> data) {
        this.data = data;
    }

    public Color getSeriesColor() {
        return this.seriesColor;
    }

    public void setSeriesColor(Color seriesColor) {
        this.seriesColor = seriesColor;
    }

    public String getSeriesLabel() {
        return this.seriesLabel;
    }

    public void setSeriesLabel(String seriesLabel) {
        this.seriesLabel = seriesLabel;
    }

    public BasicStroke getLineType() {
        return this.lineType;
    }

    public void setLineType(BasicStroke lineType) {
        this.lineType = lineType;
    }

    public String toString() {
        if (this.data.isEmpty()) {
            return "";
        }
        StringBuilder temp = new StringBuilder();
        temp.append(Util.roundDouble(this.data.get(0), 2));
        for (int i = 1; i < this.data.size(); ++i) {
            temp.append(",").append(Util.roundDouble(this.data.get(i), 2));
        }
        return temp.toString();
    }
}

