/*
 * Decompiled with CFR 0.152.
 */
package no.uib.jsparklines.extra;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class HtmlLinksRenderer
implements TableCellRenderer {
    private String selectedRowFontColor;
    private String notSelectedRowFontColor;

    public HtmlLinksRenderer(String selectedRowFontColor, String notSelectedRowFontColor) {
        this.selectedRowFontColor = selectedRowFontColor;
        this.notSelectedRowFontColor = notSelectedRowFontColor;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)new DefaultTableCellRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Color bg = label.getBackground();
        label.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
        if (value != null && value instanceof String) {
            String link = (String)value;
            link = isSelected ? link.replace(this.notSelectedRowFontColor, this.selectedRowFontColor) : link.replace(this.selectedRowFontColor, this.notSelectedRowFontColor);
            label.setText(link);
        }
        return label;
    }
}

