/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.tools.braf;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class BufferedRandomAccessFile
extends RandomAccessFile {
    private byte[] buffer;
    private int buf_end = 0;
    private int buf_pos = 0;
    private long real_pos = 0L;
    private final int BUF_SIZE;

    public BufferedRandomAccessFile(String filename, String mode, int bufsize) throws IOException {
        super(filename, mode);
        this.invalidate();
        this.BUF_SIZE = bufsize;
        this.buffer = new byte[this.BUF_SIZE];
    }

    public BufferedRandomAccessFile(File file, String mode, int bufsize) throws IOException {
        this(file.getAbsolutePath(), mode, bufsize);
    }

    @Override
    public final int read() throws IOException {
        if (this.buf_pos >= this.buf_end && this.fillBuffer() < 0) {
            return -1;
        }
        if (this.buf_end == 0) {
            return -1;
        }
        return this.buffer[this.buf_pos++];
    }

    private int fillBuffer() throws IOException {
        int n = super.read(this.buffer, 0, this.BUF_SIZE);
        if (n >= 0) {
            this.real_pos += (long)n;
            this.buf_end = n;
            this.buf_pos = 0;
        }
        return n;
    }

    private void invalidate() throws IOException {
        this.buf_end = 0;
        this.buf_pos = 0;
        this.real_pos = super.getFilePointer();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int leftover = this.buf_end - this.buf_pos;
        if (len <= leftover) {
            System.arraycopy(this.buffer, this.buf_pos, b, off, len);
            this.buf_pos += len;
            return len;
        }
        for (int i = 0; i < len; ++i) {
            int c = this.read();
            if (c == -1) {
                return i;
            }
            b[off + i] = (byte)c;
        }
        return len;
    }

    @Override
    public long getFilePointer() throws IOException {
        long l = this.real_pos;
        return l - (long)this.buf_end + (long)this.buf_pos;
    }

    @Override
    public void seek(long pos) throws IOException {
        int n = (int)(this.real_pos - pos);
        if (n >= 0 && n <= this.buf_end) {
            this.buf_pos = this.buf_end - n;
        } else {
            super.seek(pos);
            this.invalidate();
        }
    }

    public final String getNextLine() throws IOException {
        String str = null;
        if (this.buf_end - this.buf_pos <= 0 && this.fillBuffer() < 0) {
            return null;
        }
        int lineend = -1;
        for (int i = this.buf_pos; i < this.buf_end; ++i) {
            if (this.buffer[i] == 10) {
                lineend = i;
                break;
            }
            if (i - this.buf_pos <= 0 || this.buffer[i - 1] != 13) continue;
            lineend = i - 1;
            break;
        }
        if (lineend < 0) {
            int c;
            StringBuffer input = new StringBuffer(256);
            int lastC = 0;
            while ((c = this.read()) != -1 && c != 10 && lastC != 13) {
                input.append((char)c);
                lastC = c;
            }
            if (c == -1 && input.length() == 0) {
                return null;
            }
            return input.toString();
        }
        str = lineend > 0 && this.buffer[lineend] == 10 && this.buffer[lineend - 1] == 13 ? new String(this.buffer, this.buf_pos, lineend - this.buf_pos - 1) : new String(this.buffer, this.buf_pos, lineend - this.buf_pos);
        this.buf_pos = lineend + 1;
        return str;
    }
}

