/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.cmd;

import com.compomics.cli.fasta.FastaParametersCLIParams;
import com.compomics.cli.fasta.FastaParametersInputBean;
import com.compomics.software.CompomicsWrapper;
import com.compomics.util.experiment.io.biology.protein.FastaParameters;
import com.compomics.util.experiment.io.biology.protein.FastaSummary;
import com.compomics.util.experiment.io.biology.protein.converters.DecoyConverter;
import com.compomics.util.gui.waiting.waitinghandlers.WaitingHandlerCLIImpl;
import com.compomics.util.io.IoUtil;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.cmd.FastaCLIInputBean;
import eu.isas.searchgui.cmd.FastaCLIParams;
import eu.isas.searchgui.cmd.PathSettingsCLI;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;

public class FastaCLI {
    private FastaCLIInputBean fastaCLIInputBean;
    private FastaParametersInputBean fastaParametersInputBean;
    private WaitingHandler waitingHandler;

    public FastaCLI(String[] args) {
        try {
            this.waitingHandler = new WaitingHandlerCLIImpl();
            String[] nonPathSettingArgsAsList = PathSettingsCLI.extractAndUpdatePathOptions(args);
            Options nonPathOptions = new Options();
            FastaCLIParams.createOptionsCLI(nonPathOptions);
            FastaParametersCLIParams.createOptionsCLI((Options)nonPathOptions);
            DefaultParser parser = new DefaultParser();
            CommandLine line = parser.parse(nonPathOptions, nonPathSettingArgsAsList);
            if (!FastaCLIInputBean.isValidStartup(line)) {
                PrintWriter lPrintWriter = new PrintWriter(System.out);
                lPrintWriter.print(System.getProperty("line.separator") + "======================" + System.getProperty("line.separator"));
                lPrintWriter.print("FastaCLI" + System.getProperty("line.separator"));
                lPrintWriter.print("======================" + System.getProperty("line.separator"));
                lPrintWriter.print(FastaCLI.getHeader());
                lPrintWriter.print(FastaCLIParams.getOptionsAsString());
                lPrintWriter.print(FastaParametersCLIParams.getOptionsAsString());
                lPrintWriter.flush();
                lPrintWriter.close();
                System.exit(0);
            } else if (!FastaParametersInputBean.isValidStartup((CommandLine)line)) {
                PrintWriter lPrintWriter = new PrintWriter(System.out);
                lPrintWriter.print(System.getProperty("line.separator") + "======================" + System.getProperty("line.separator"));
                lPrintWriter.print("FastaCLI" + System.getProperty("line.separator"));
                lPrintWriter.print("======================" + System.getProperty("line.separator"));
                lPrintWriter.print(FastaCLI.getHeader());
                lPrintWriter.print(FastaCLIParams.getOptionsAsString());
                lPrintWriter.print(FastaParametersCLIParams.getOptionsAsString());
                lPrintWriter.flush();
                lPrintWriter.close();
                System.exit(0);
            } else {
                this.fastaCLIInputBean = new FastaCLIInputBean(line);
                this.fastaParametersInputBean = new FastaParametersInputBean(line, this.fastaCLIInputBean.getInputFile(), this.waitingHandler);
                this.call();
            }
        }
        catch (Exception e) {
            this.waitingHandler.appendReport("An error occurred while running the command line. " + FastaCLI.getLogFileMessage(), true, true);
            e.printStackTrace();
        }
    }

    public void call() {
        try {
            FastaParameters fastaParameters = this.fastaParametersInputBean.getFastaParameters();
            String fastaFilePath = this.fastaCLIInputBean.getInputFile().getAbsolutePath();
            System.out.println(System.getProperty("line.separator") + "Input: " + fastaFilePath + System.getProperty("line.separator"));
            System.out.println("Extracting FASTA summary. Please wait...");
            FastaSummary fastaSummary = FastaSummary.getSummary((String)fastaFilePath, (FastaParameters)fastaParameters, (boolean)true, (WaitingHandler)this.waitingHandler);
            System.out.println(System.getProperty("line.separator"));
            this.writeDbProperties(fastaSummary, fastaParameters);
            if (this.fastaCLIInputBean.isDecoy()) {
                String decoySuffix = this.fastaCLIInputBean.getDecoySuffix();
                if (decoySuffix != null) {
                    fastaParameters.setTargetDecoyFileNameSuffix(decoySuffix);
                }
                File newFile = this.generateTargetDecoyDatabase(fastaParameters, this.waitingHandler);
                System.out.println(System.getProperty("line.separator"));
                System.out.println("Decoy file successfully created." + System.getProperty("line.separator"));
                System.out.println("Output: " + newFile.getAbsolutePath());
                FastaParameters decoyParameters = DecoyConverter.getDecoyParameters((FastaParameters)fastaParameters);
                FastaSummary decoySummary = DecoyConverter.getDecoySummary((File)newFile, (FastaSummary)fastaSummary);
                this.writeDbProperties(decoySummary, decoyParameters);
            }
        }
        catch (Exception e) {
            this.waitingHandler.appendReport("An error occurred while running the command line. " + FastaCLI.getLogFileMessage(), true, true);
            e.printStackTrace();
        }
    }

    public void writeDbProperties(FastaSummary fastaSummary, FastaParameters fastaParameters) {
        System.out.println("Name: " + fastaSummary.getName());
        System.out.println("Description: " + fastaSummary.getDescription());
        System.out.println("Version: " + fastaSummary.getVersion());
        if (fastaParameters.isTargetDecoy()) {
            if (fastaParameters.isDecoySuffix()) {
                System.out.println("Decoy Flag: " + fastaParameters.getDecoyFlag() + " (Suffix)");
            } else {
                System.out.println("Decoy Flag: " + fastaParameters.getDecoyFlag() + " (Prefix)");
            }
        } else {
            System.out.println("No decoy");
        }
        System.out.println("Type: " + fastaSummary.getTypeAsString());
        System.out.println("Last modified: " + new Date(fastaSummary.lastModified).toString());
        String nSequences = fastaSummary.nSequences + " sequences";
        if (fastaParameters.isTargetDecoy()) {
            nSequences = nSequences + " (" + fastaSummary.nTarget + " target)";
        }
        System.out.println("Size: " + nSequences);
    }

    public File generateTargetDecoyDatabase(FastaParameters fastaParameters, WaitingHandler waitingHandler) throws IOException {
        File fileIn = this.fastaCLIInputBean.getInputFile();
        File fileOut = new File(fileIn.getParent(), IoUtil.removeExtension((String)fileIn.getName()) + fastaParameters.getTargetDecoyFileNameSuffix() + ".fasta");
        waitingHandler.setWaitingText("Appending Decoy Sequences. Please Wait...");
        DecoyConverter.appendDecoySequences((File)fileIn, (File)fileOut, (FastaParameters)fastaParameters, (WaitingHandler)waitingHandler);
        return fileOut;
    }

    private static String getHeader() {
        return System.getProperty("line.separator") + "FastaCLI takes a FASTA file as input, generates general information about the database and allows operations on the FASTA file." + System.getProperty("line.separator") + System.getProperty("line.separator") + "For further help see https://compomics.github.io/projects/searchgui.html and https://compomics.github.io/projects/searchgui/wiki/SearchCLI.html." + System.getProperty("line.separator") + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + "OPTIONS" + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + "\n";
    }

    public static void main(String[] args) {
        try {
            new FastaCLI(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getLogFileMessage() {
        return "Please see the SearchGUI log file.";
    }

    public String getJarFilePath() {
        return CompomicsWrapper.getJarFilePath((String)this.getClass().getResource("FastaCLI.class").getPath(), (String)"SearchGUI");
    }
}

