/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.cmd;

import com.compomics.cli.identification_parameters.IdentificationParametersInputBean;
import com.compomics.software.cli.CommandLineUtils;
import com.compomics.software.cli.CommandParameter;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.searchgui.OutputParameters;
import eu.isas.searchgui.cmd.PathSettingsCLIInputBean;
import eu.isas.searchgui.cmd.SearchCLIParams;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;

public class SearchCLIInputBean {
    private ArrayList<File> spectrumFiles;
    private File fastaFile;
    private File outputFolder;
    private File configFolder;
    private IdentificationParametersInputBean identificationParametersInputBean;
    private PathSettingsCLIInputBean pathSettingsCLIInputBean;
    private boolean omssaEnabled = false;
    private boolean xtandemEnabled = false;
    private boolean msgfEnabled = false;
    private boolean msAmandaEnabled = false;
    private boolean myriMatchEnabled = false;
    private boolean cometEnabled = false;
    private boolean tideEnabled = false;
    private boolean andromedaEnabled = false;
    private boolean metaMorpheusEnabled = false;
    private boolean sageEnabled = false;
    private boolean novorEnabled = false;
    private boolean direcTagEnabled = false;
    private File omssaLocation = null;
    private File xtandemLocation = null;
    private File msgfLocation = null;
    private File msAmandaLocation = null;
    private File myriMatchLocation = null;
    private File cometLocation = null;
    private File tideLocation = null;
    private File tideIndexLocation = null;
    private File andromedaLocation = null;
    private File metaMorpheusLocation = null;
    private File sageLocation = null;
    private File novorLocation = null;
    private File direcTagLocation = null;
    private File makeblastdbLocation = null;
    private int mgfMaxSize = 1000;
    private Boolean checkMgfSize = false;
    private int mgfNSpectra = 25000;
    private Double refMass = 2000.0;
    private int duplicateSpectrumTitleHandling = 1;
    private int missingSpectrumTitleHandling = 0;
    private int nThreads = Runtime.getRuntime().availableProcessors();
    private boolean gzip = true;
    private OutputParameters outputParameters = OutputParameters.grouped;
    private Boolean outputData = false;
    private Boolean outputDate = false;
    private Boolean renameXTandemFile = true;
    private String targetDecoyFileNameTag = "_concatenated_target_decoy";
    private String defaultOutputFileName = "searchgui_out";

    public SearchCLIInputBean(CommandLine aLine) throws IOException, ClassNotFoundException {
        String omssaFolder;
        String mgfSizeCheckOption;
        String spectrumFilesTxt = aLine.getOptionValue(SearchCLIParams.SPECTRUM_FILES.id);
        this.spectrumFiles = SearchCLIInputBean.getSpectrumFiles(spectrumFilesTxt);
        String arg = aLine.getOptionValue(SearchCLIParams.FASTA_FILE.id);
        this.fastaFile = new File(arg);
        arg = aLine.getOptionValue(SearchCLIParams.OUTPUT_FOLDER.id);
        this.outputFolder = new File(arg);
        if (aLine.hasOption(SearchCLIParams.CONFIG_FOLDER.id)) {
            arg = aLine.getOptionValue(SearchCLIParams.CONFIG_FOLDER.id);
            this.configFolder = new File(arg);
        }
        if (aLine.hasOption(SearchCLIParams.MGF_CHECK_SIZE.id) && (mgfSizeCheckOption = aLine.getOptionValue(SearchCLIParams.MGF_CHECK_SIZE.id)).trim().equals("1")) {
            this.checkMgfSize = true;
        }
        if (aLine.hasOption(SearchCLIParams.MGF_SPLITTING_LIMIT.id)) {
            int option;
            arg = aLine.getOptionValue(SearchCLIParams.MGF_SPLITTING_LIMIT.id);
            this.mgfMaxSize = option = Integer.parseInt(arg);
        }
        if (aLine.hasOption(SearchCLIParams.MGF_MAX_SPECTRA.id)) {
            int option;
            arg = aLine.getOptionValue(SearchCLIParams.MGF_MAX_SPECTRA.id);
            this.mgfNSpectra = option = Integer.parseInt(arg);
        }
        if (aLine.hasOption(SearchCLIParams.OMSSA.id)) {
            String omssaOption = aLine.getOptionValue(SearchCLIParams.OMSSA.id);
            this.omssaEnabled = omssaOption.trim().equals("1");
        }
        if (aLine.hasOption(SearchCLIParams.XTANDEM.id)) {
            String xtandemOption = aLine.getOptionValue(SearchCLIParams.XTANDEM.id);
            this.xtandemEnabled = xtandemOption.trim().equals("1");
        }
        if (aLine.hasOption(SearchCLIParams.MSGF.id)) {
            String msgfOption = aLine.getOptionValue(SearchCLIParams.MSGF.id);
            this.msgfEnabled = msgfOption.trim().equals("1");
        }
        if (aLine.hasOption(SearchCLIParams.MS_AMANDA.id)) {
            String msAmandaOption = aLine.getOptionValue(SearchCLIParams.MS_AMANDA.id);
            this.msAmandaEnabled = msAmandaOption.trim().equals("1");
        }
        if (aLine.hasOption(SearchCLIParams.MYRIMATCH.id)) {
            String myriMatchOption = aLine.getOptionValue(SearchCLIParams.MYRIMATCH.id);
            this.myriMatchEnabled = myriMatchOption.trim().equals("1");
        }
        if (aLine.hasOption(SearchCLIParams.COMET.id)) {
            String cometOption = aLine.getOptionValue(SearchCLIParams.COMET.id);
            this.cometEnabled = cometOption.trim().equals("1");
        }
        if (aLine.hasOption(SearchCLIParams.TIDE.id)) {
            String tideOption = aLine.getOptionValue(SearchCLIParams.TIDE.id);
            this.tideEnabled = tideOption.trim().equals("1");
        }
        if (aLine.hasOption(SearchCLIParams.ANDROMEDA.id)) {
            String andromedaOption = aLine.getOptionValue(SearchCLIParams.ANDROMEDA.id);
            this.andromedaEnabled = andromedaOption.trim().equals("1");
        }
        if (aLine.hasOption(SearchCLIParams.META_MORPHEUS.id)) {
            String metaMorpheusOption = aLine.getOptionValue(SearchCLIParams.META_MORPHEUS.id);
            this.metaMorpheusEnabled = metaMorpheusOption.trim().equals("1");
        }
        if (aLine.hasOption(SearchCLIParams.SAGE.id)) {
            String sageOption = aLine.getOptionValue(SearchCLIParams.SAGE.id);
            this.sageEnabled = sageOption.trim().equals("1");
        }
        if (aLine.hasOption(SearchCLIParams.NOVOR.id)) {
            String novorOption = aLine.getOptionValue(SearchCLIParams.NOVOR.id);
            this.novorEnabled = novorOption.trim().equals("1");
        }
        if (aLine.hasOption(SearchCLIParams.DIRECTAG.id)) {
            String direcTagOption = aLine.getOptionValue(SearchCLIParams.DIRECTAG.id);
            this.direcTagEnabled = direcTagOption.trim().equals("1");
        }
        if (aLine.hasOption(SearchCLIParams.OMSSA_LOCATION.id)) {
            omssaFolder = aLine.getOptionValue(SearchCLIParams.OMSSA_LOCATION.id);
            this.omssaLocation = new File(omssaFolder);
        }
        if (aLine.hasOption(SearchCLIParams.XTANDEM_LOCATION.id)) {
            omssaFolder = aLine.getOptionValue(SearchCLIParams.XTANDEM_LOCATION.id);
            this.xtandemLocation = new File(omssaFolder);
        }
        if (aLine.hasOption(SearchCLIParams.MSGF_LOCATION.id)) {
            String msgfFolder = aLine.getOptionValue(SearchCLIParams.MSGF_LOCATION.id);
            this.msgfLocation = new File(msgfFolder);
        }
        if (aLine.hasOption(SearchCLIParams.MS_AMANDA_LOCATION.id)) {
            String msAmandaFolder = aLine.getOptionValue(SearchCLIParams.MS_AMANDA_LOCATION.id);
            this.msAmandaLocation = new File(msAmandaFolder);
        }
        if (aLine.hasOption(SearchCLIParams.MYRIMATCH_LOCATION.id)) {
            String myriMatchFolder = aLine.getOptionValue(SearchCLIParams.MYRIMATCH_LOCATION.id);
            this.myriMatchLocation = new File(myriMatchFolder);
        }
        if (aLine.hasOption(SearchCLIParams.COMET_LOCATION.id)) {
            String cometFolder = aLine.getOptionValue(SearchCLIParams.COMET_LOCATION.id);
            this.cometLocation = new File(cometFolder);
        }
        if (aLine.hasOption(SearchCLIParams.TIDE_LOCATION.id)) {
            String tideFolder = aLine.getOptionValue(SearchCLIParams.TIDE_LOCATION.id);
            this.tideLocation = new File(tideFolder);
        }
        if (aLine.hasOption(SearchCLIParams.TIDE_INDEX_LOCATION.id)) {
            String tideIndexFile = aLine.getOptionValue(SearchCLIParams.TIDE_INDEX_LOCATION.id);
            this.tideIndexLocation = new File(tideIndexFile);
        }
        if (aLine.hasOption(SearchCLIParams.ANDROMEDA_LOCATION.id)) {
            String andromedaFolder = aLine.getOptionValue(SearchCLIParams.ANDROMEDA_LOCATION.id);
            this.andromedaLocation = new File(andromedaFolder);
        }
        if (aLine.hasOption(SearchCLIParams.META_MORPHEUS_LOCATION.id)) {
            String metaMorpheusFolder = aLine.getOptionValue(SearchCLIParams.META_MORPHEUS_LOCATION.id);
            this.metaMorpheusLocation = new File(metaMorpheusFolder);
        }
        if (aLine.hasOption(SearchCLIParams.SAGE_LOCATION.id)) {
            String sageFolder = aLine.getOptionValue(SearchCLIParams.SAGE_LOCATION.id);
            this.sageLocation = new File(sageFolder);
        }
        if (aLine.hasOption(SearchCLIParams.NOVOR_LOCATION.id)) {
            String novorFolder = aLine.getOptionValue(SearchCLIParams.NOVOR_LOCATION.id);
            this.novorLocation = new File(novorFolder);
        }
        if (aLine.hasOption(SearchCLIParams.DIRECTAG_LOCATION.id)) {
            String direcTagFolder = aLine.getOptionValue(SearchCLIParams.DIRECTAG_LOCATION.id);
            this.direcTagLocation = new File(direcTagFolder);
        }
        if (aLine.hasOption(SearchCLIParams.MAKEBLASTDB_LOCATION.id)) {
            String makeblastdbFolder = aLine.getOptionValue(SearchCLIParams.MAKEBLASTDB_LOCATION.id);
            this.makeblastdbLocation = new File(makeblastdbFolder);
        }
        if (aLine.hasOption(SearchCLIParams.DUPLICATE_TITLE_HANDLING.id)) {
            arg = aLine.getOptionValue(SearchCLIParams.DUPLICATE_TITLE_HANDLING.id);
            int option = Integer.parseInt(arg);
            if (option == 0 || option == 1 || option == 2) {
                this.duplicateSpectrumTitleHandling = option;
            } else {
                throw new IllegalArgumentException("Unknown value '" + option + "' for " + SearchCLIParams.DUPLICATE_TITLE_HANDLING.id + ".");
            }
        }
        if (aLine.hasOption(SearchCLIParams.MISSING_TITLE_HANDLING.id)) {
            arg = aLine.getOptionValue(SearchCLIParams.MISSING_TITLE_HANDLING.id);
            int option = Integer.parseInt(arg);
            if (option == 0 || option == 1) {
                this.missingSpectrumTitleHandling = option;
            } else {
                throw new IllegalArgumentException("Unknown value '" + option + "' for " + SearchCLIParams.MISSING_TITLE_HANDLING.id + ".");
            }
        }
        if (aLine.hasOption(SearchCLIParams.THREADS.id)) {
            arg = aLine.getOptionValue(SearchCLIParams.THREADS.id);
            this.nThreads = Integer.parseInt(arg);
        }
        if (aLine.hasOption(SearchCLIParams.TARGET_DECOY_TAG.id)) {
            this.targetDecoyFileNameTag = arg = aLine.getOptionValue(SearchCLIParams.TARGET_DECOY_TAG.id);
        }
        if (aLine.hasOption(SearchCLIParams.REFERENCE_MASS.id)) {
            Double option;
            arg = aLine.getOptionValue(SearchCLIParams.REFERENCE_MASS.id);
            this.refMass = option = Double.valueOf(arg);
        }
        if (aLine.hasOption(SearchCLIParams.OUTPUT_DEFAULT_NAME.id)) {
            this.defaultOutputFileName = arg = aLine.getOptionValue(SearchCLIParams.OUTPUT_DEFAULT_NAME.id);
        }
        if (aLine.hasOption(SearchCLIParams.OUTPUT_GZIP.id)) {
            int option = Integer.parseInt(aLine.getOptionValue(SearchCLIParams.OUTPUT_GZIP.id));
            boolean bl = this.gzip = option == 1;
        }
        if (aLine.hasOption(SearchCLIParams.OUTPUT_OPTION.id)) {
            int option = Integer.parseInt(aLine.getOptionValue(SearchCLIParams.OUTPUT_OPTION.id));
            this.outputParameters = OutputParameters.getOutputParameters((int)option);
        }
        if (aLine.hasOption(SearchCLIParams.OUTPUT_DATA.id)) {
            int input = Integer.parseInt(aLine.getOptionValue(SearchCLIParams.OUTPUT_DATA.id));
            this.outputData = input == 1;
        }
        if (aLine.hasOption(SearchCLIParams.OUTPUT_DATE.id)) {
            int input = Integer.parseInt(aLine.getOptionValue(SearchCLIParams.OUTPUT_DATE.id));
            this.outputDate = input == 1;
        }
        if (aLine.hasOption(SearchCLIParams.RENAME_XTANDEM_OUTPUT.id)) {
            int input = Integer.parseInt(aLine.getOptionValue(SearchCLIParams.RENAME_XTANDEM_OUTPUT.id));
            this.renameXTandemFile = input == 1;
        }
        this.identificationParametersInputBean = new IdentificationParametersInputBean(aLine);
        this.pathSettingsCLIInputBean = new PathSettingsCLIInputBean(aLine);
    }

    public ArrayList<File> getSpectrumFiles() {
        return this.spectrumFiles;
    }

    public File getFastaFile() {
        return this.fastaFile;
    }

    public File getOutputFolder() {
        return this.outputFolder;
    }

    public File getConfigFolder() {
        return this.configFolder;
    }

    public IdentificationParameters getIdentificationParameters() {
        return this.identificationParametersInputBean.getIdentificationParameters();
    }

    public File getIdentificationParametersFile() {
        if (this.identificationParametersInputBean.getDestinationFile() != null) {
            return this.identificationParametersInputBean.getDestinationFile();
        }
        return this.identificationParametersInputBean.getInputFile();
    }

    public static ArrayList<File> getSpectrumFiles(String optionInput) throws FileNotFoundException {
        ArrayList<String> extentions = new ArrayList<String>();
        extentions.add(".mgf");
        extentions.add(".mzml");
        return CommandLineUtils.getFiles((String)optionInput, extentions);
    }

    public boolean isOmssaEnabled() {
        return this.omssaEnabled;
    }

    public boolean isXTandemEnabled() {
        return this.xtandemEnabled;
    }

    public boolean isMsgfEnabled() {
        return this.msgfEnabled;
    }

    public boolean isMsAmandaEnabled() {
        return this.msAmandaEnabled;
    }

    public boolean isMyriMatchEnabled() {
        return this.myriMatchEnabled;
    }

    public boolean isCometEnabled() {
        return this.cometEnabled;
    }

    public boolean isTideEnabled() {
        return this.tideEnabled;
    }

    public boolean isAndromedaEnabled() {
        return this.andromedaEnabled;
    }

    public boolean isMetaMorpheusEnabled() {
        return this.metaMorpheusEnabled;
    }

    public boolean isSageEnabled() {
        return this.sageEnabled;
    }

    public boolean isNovorEnabled() {
        return this.novorEnabled;
    }

    public boolean isDirecTagEnabled() {
        return this.direcTagEnabled;
    }

    public File getOmssaLocation() {
        return this.omssaLocation;
    }

    public File getXtandemLocation() {
        return this.xtandemLocation;
    }

    public File getMsgfLocation() {
        return this.msgfLocation;
    }

    public File getMsAmandaLocation() {
        return this.msAmandaLocation;
    }

    public File getMyriMatchLocation() {
        return this.myriMatchLocation;
    }

    public File getCometLocation() {
        return this.cometLocation;
    }

    public File getTideLocation() {
        return this.tideLocation;
    }

    public File getTideIndexLocation() {
        return this.tideIndexLocation;
    }

    public File getAndromedaLocation() {
        return this.andromedaLocation;
    }

    public File getMetaMorpheusLocation() {
        return this.metaMorpheusLocation;
    }

    public File getSageLocation() {
        return this.sageLocation;
    }

    public File getNovorLocation() {
        return this.novorLocation;
    }

    public File getDirecTagLocation() {
        return this.direcTagLocation;
    }

    public File getMakeblastdbLocation() {
        return this.makeblastdbLocation;
    }

    public int getMgfMaxSize() {
        return this.mgfMaxSize;
    }

    public int getMgfNSpectra() {
        return this.mgfNSpectra;
    }

    public int getDuplicateSpectrumTitleHandling() {
        return this.duplicateSpectrumTitleHandling;
    }

    public void setDuplicateSpectrumTitleHandling(int duplicateSpectrumTitleHandling) {
        this.duplicateSpectrumTitleHandling = duplicateSpectrumTitleHandling;
    }

    public int getMissingSpectrumTitleHandling() {
        return this.missingSpectrumTitleHandling;
    }

    public void setMissingSpectrumTitleHandling(int missingSpectrumTitleHandling) {
        this.missingSpectrumTitleHandling = missingSpectrumTitleHandling;
    }

    public int getNThreads() {
        return this.nThreads;
    }

    public static boolean isValidStartup(CommandLine aLine) throws IOException {
        File file;
        String arg;
        String input;
        if (aLine.getOptions().length == 0) {
            return false;
        }
        if (!aLine.hasOption(SearchCLIParams.SPECTRUM_FILES.id) || aLine.getOptionValue(SearchCLIParams.SPECTRUM_FILES.id).equals("")) {
            System.out.println(System.getProperty("line.separator") + "Spectrum files not specified." + System.getProperty("line.separator"));
            return false;
        }
        ArrayList<File> tempSpectrumFiles = SearchCLIInputBean.getSpectrumFiles(aLine.getOptionValue(SearchCLIParams.SPECTRUM_FILES.id));
        for (File file2 : tempSpectrumFiles) {
            if (file2.exists()) continue;
            System.out.println(System.getProperty("line.separator") + "Spectrum file '" + file2.getName() + "' not found." + System.getProperty("line.separator"));
            return false;
        }
        if (!aLine.hasOption(SearchCLIParams.FASTA_FILE.id) || aLine.getOptionValue(SearchCLIParams.FASTA_FILE.id).equals("")) {
            System.out.println(System.getProperty("line.separator") + "FASTA file not specified." + System.getProperty("line.separator"));
            return false;
        }
        File file3 = new File(aLine.getOptionValue(SearchCLIParams.FASTA_FILE.id));
        if (!file3.exists()) {
            System.out.println(System.getProperty("line.separator") + "FASTA file '" + file3.getName() + "' not found." + System.getProperty("line.separator"));
            return false;
        }
        if (!aLine.hasOption(SearchCLIParams.OUTPUT_FOLDER.id) || aLine.getOptionValue(SearchCLIParams.OUTPUT_FOLDER.id).equals("")) {
            System.out.println(System.getProperty("line.separator") + "Output folder not specified." + System.getProperty("line.separator"));
            return false;
        }
        file3 = new File(aLine.getOptionValue(SearchCLIParams.OUTPUT_FOLDER.id));
        if (!file3.exists()) {
            System.out.println(System.getProperty("line.separator") + "Output folder '" + file3.getName() + "' not found." + System.getProperty("line.separator"));
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.CONFIG_FOLDER.id)) {
            if (aLine.getOptionValue(SearchCLIParams.CONFIG_FOLDER.id).equals("")) {
                System.out.println(System.getProperty("line.separator") + "Config folder not specified." + System.getProperty("line.separator"));
                return false;
            }
            file3 = new File(aLine.getOptionValue(SearchCLIParams.CONFIG_FOLDER.id));
            if (!file3.exists()) {
                System.out.println(System.getProperty("line.separator") + "Config folder '" + file3.getName() + "' not found." + System.getProperty("line.separator"));
                return false;
            }
        }
        if (aLine.hasOption(SearchCLIParams.OUTPUT_DEFAULT_NAME.id) && aLine.getOptionValue(SearchCLIParams.OUTPUT_DEFAULT_NAME.id).equals("")) {
            System.out.println("\nDefault output name cannot be empty.\n");
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.OUTPUT_OPTION.id)) {
            input = aLine.getOptionValue(SearchCLIParams.OUTPUT_OPTION.id);
            try {
                int option = Integer.parseInt(input);
                if (OutputParameters.getOutputParameters((int)option) == null) {
                    System.out.println(System.getProperty("line.separator") + "Output option '" + option + "' not recognized." + System.getProperty("line.separator"));
                    return false;
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "Output option '" + input + "' not recognized." + System.getProperty("line.separator"));
                return false;
            }
        }
        if (aLine.hasOption(SearchCLIParams.OUTPUT_DATA.id) && !CommandParameter.isBooleanInput((String)SearchCLIParams.OUTPUT_DATA.id, (String)(input = aLine.getOptionValue(SearchCLIParams.OUTPUT_DATA.id)))) {
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.OUTPUT_DATE.id) && !CommandParameter.isBooleanInput((String)SearchCLIParams.OUTPUT_DATE.id, (String)(input = aLine.getOptionValue(SearchCLIParams.OUTPUT_DATE.id)))) {
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.RENAME_XTANDEM_OUTPUT.id) && !CommandParameter.isBooleanInput((String)SearchCLIParams.RENAME_XTANDEM_OUTPUT.id, (String)(input = aLine.getOptionValue(SearchCLIParams.RENAME_XTANDEM_OUTPUT.id)))) {
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.TARGET_DECOY_TAG.id) && (arg = aLine.getOptionValue(SearchCLIParams.TARGET_DECOY_TAG.id)).isEmpty()) {
            System.out.println(System.getProperty("line.separator") + "The target-decoy tag cannot be empty!" + System.getProperty("line.separator"));
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.THREADS.id) && !CommandParameter.isPositiveInteger((String)SearchCLIParams.THREADS.id, (String)(arg = aLine.getOptionValue(SearchCLIParams.THREADS.id)), (boolean)false)) {
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.OMSSA.id) && !CommandParameter.isBooleanInput((String)SearchCLIParams.OMSSA.id, (String)(input = aLine.getOptionValue(SearchCLIParams.OMSSA.id)))) {
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.XTANDEM.id) && !CommandParameter.isBooleanInput((String)SearchCLIParams.XTANDEM.id, (String)(input = aLine.getOptionValue(SearchCLIParams.XTANDEM.id)))) {
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.MSGF.id) && !CommandParameter.isBooleanInput((String)SearchCLIParams.MSGF.id, (String)(input = aLine.getOptionValue(SearchCLIParams.MSGF.id)))) {
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.MS_AMANDA.id) && !CommandParameter.isBooleanInput((String)SearchCLIParams.MS_AMANDA.id, (String)(input = aLine.getOptionValue(SearchCLIParams.MS_AMANDA.id)))) {
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.MYRIMATCH.id) && !CommandParameter.isBooleanInput((String)SearchCLIParams.MYRIMATCH.id, (String)(input = aLine.getOptionValue(SearchCLIParams.MYRIMATCH.id)))) {
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.COMET.id) && !CommandParameter.isBooleanInput((String)SearchCLIParams.COMET.id, (String)(input = aLine.getOptionValue(SearchCLIParams.COMET.id)))) {
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.TIDE.id) && !CommandParameter.isBooleanInput((String)SearchCLIParams.TIDE.id, (String)(input = aLine.getOptionValue(SearchCLIParams.TIDE.id)))) {
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.ANDROMEDA.id) && !CommandParameter.isBooleanInput((String)SearchCLIParams.ANDROMEDA.id, (String)(input = aLine.getOptionValue(SearchCLIParams.ANDROMEDA.id)))) {
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.META_MORPHEUS.id) && !CommandParameter.isBooleanInput((String)SearchCLIParams.META_MORPHEUS.id, (String)(input = aLine.getOptionValue(SearchCLIParams.META_MORPHEUS.id)))) {
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.NOVOR.id) && !CommandParameter.isBooleanInput((String)SearchCLIParams.NOVOR.id, (String)(input = aLine.getOptionValue(SearchCLIParams.NOVOR.id)))) {
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.DIRECTAG.id) && !CommandParameter.isBooleanInput((String)SearchCLIParams.DIRECTAG.id, (String)(input = aLine.getOptionValue(SearchCLIParams.DIRECTAG.id)))) {
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.OMSSA_LOCATION.id) && !(file = new File(input = aLine.getOptionValue(SearchCLIParams.OMSSA_LOCATION.id))).exists()) {
            System.out.println(System.getProperty("line.separator") + "The " + SearchCLIParams.OMSSA_LOCATION.id + " '" + input + "' does not exist." + System.getProperty("line.separator"));
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.MAKEBLASTDB_LOCATION.id) && !(file = new File(input = aLine.getOptionValue(SearchCLIParams.MAKEBLASTDB_LOCATION.id))).exists()) {
            System.out.println(System.getProperty("line.separator") + "The " + SearchCLIParams.MAKEBLASTDB_LOCATION.id + " '" + input + "' does not exist." + System.getProperty("line.separator"));
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.XTANDEM_LOCATION.id) && !(file = new File(input = aLine.getOptionValue(SearchCLIParams.XTANDEM_LOCATION.id))).exists()) {
            System.out.println(System.getProperty("line.separator") + "The " + SearchCLIParams.XTANDEM_LOCATION.id + " '" + input + "' does not exist." + System.getProperty("line.separator"));
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.MSGF_LOCATION.id) && !(file = new File(input = aLine.getOptionValue(SearchCLIParams.MSGF_LOCATION.id))).exists()) {
            System.out.println(System.getProperty("line.separator") + "The " + SearchCLIParams.MSGF_LOCATION.id + " '" + input + "' does not exist." + System.getProperty("line.separator"));
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.MS_AMANDA_LOCATION.id) && !(file = new File(input = aLine.getOptionValue(SearchCLIParams.MS_AMANDA_LOCATION.id))).exists()) {
            System.out.println(System.getProperty("line.separator") + "The " + SearchCLIParams.MS_AMANDA_LOCATION.id + " '" + input + "' does not exist." + System.getProperty("line.separator"));
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.MYRIMATCH_LOCATION.id) && !(file = new File(input = aLine.getOptionValue(SearchCLIParams.MYRIMATCH_LOCATION.id))).exists()) {
            System.out.println(System.getProperty("line.separator") + "The " + SearchCLIParams.MYRIMATCH_LOCATION.id + " '" + input + "' does not exist." + System.getProperty("line.separator"));
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.COMET_LOCATION.id) && !(file = new File(input = aLine.getOptionValue(SearchCLIParams.COMET_LOCATION.id))).exists()) {
            System.out.println(System.getProperty("line.separator") + "The " + SearchCLIParams.COMET_LOCATION.id + " '" + input + "' does not exist." + System.getProperty("line.separator"));
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.TIDE_LOCATION.id) && !(file = new File(input = aLine.getOptionValue(SearchCLIParams.TIDE_LOCATION.id))).exists()) {
            System.out.println(System.getProperty("line.separator") + "The " + SearchCLIParams.TIDE_LOCATION.id + " '" + input + "' does not exist." + System.getProperty("line.separator"));
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.TIDE_INDEX_LOCATION.id)) {
            // empty if block
        }
        if (aLine.hasOption(SearchCLIParams.ANDROMEDA_LOCATION.id) && !(file = new File(input = aLine.getOptionValue(SearchCLIParams.ANDROMEDA_LOCATION.id))).exists()) {
            System.out.println(System.getProperty("line.separator") + "The " + SearchCLIParams.ANDROMEDA_LOCATION.id + " '" + input + "' does not exist." + System.getProperty("line.separator"));
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.META_MORPHEUS_LOCATION.id) && !(file = new File(input = aLine.getOptionValue(SearchCLIParams.META_MORPHEUS_LOCATION.id))).exists()) {
            System.out.println(System.getProperty("line.separator") + "The " + SearchCLIParams.META_MORPHEUS_LOCATION.id + " '" + input + "' does not exist." + System.getProperty("line.separator"));
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.NOVOR_LOCATION.id) && !(file = new File(input = aLine.getOptionValue(SearchCLIParams.NOVOR_LOCATION.id))).exists()) {
            System.out.println(System.getProperty("line.separator") + "The " + SearchCLIParams.NOVOR_LOCATION.id + " '" + input + "' does not exist." + System.getProperty("line.separator"));
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.DIRECTAG_LOCATION.id) && !(file = new File(input = aLine.getOptionValue(SearchCLIParams.DIRECTAG_LOCATION.id))).exists()) {
            System.out.println(System.getProperty("line.separator") + "The " + SearchCLIParams.DIRECTAG_LOCATION.id + " '" + input + "' does not exist." + System.getProperty("line.separator"));
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.MGF_CHECK_SIZE.id) && !CommandParameter.isBooleanInput((String)SearchCLIParams.MGF_CHECK_SIZE.id, (String)(input = aLine.getOptionValue(SearchCLIParams.MGF_CHECK_SIZE.id)))) {
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.MGF_SPLITTING_LIMIT.id) && !CommandParameter.isPositiveDouble((String)SearchCLIParams.MGF_CHECK_SIZE.id, (String)(input = aLine.getOptionValue(SearchCLIParams.MGF_SPLITTING_LIMIT.id)), (boolean)false)) {
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.MGF_MAX_SPECTRA.id) && !CommandParameter.isPositiveInteger((String)SearchCLIParams.MGF_MAX_SPECTRA.id, (String)(input = aLine.getOptionValue(SearchCLIParams.MGF_MAX_SPECTRA.id)), (boolean)false)) {
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.DUPLICATE_TITLE_HANDLING.id) && !CommandParameter.isBooleanInput((String)SearchCLIParams.DUPLICATE_TITLE_HANDLING.id, (String)(input = aLine.getOptionValue(SearchCLIParams.DUPLICATE_TITLE_HANDLING.id)))) {
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.MISSING_TITLE_HANDLING.id) && !CommandParameter.isBooleanInput((String)SearchCLIParams.MISSING_TITLE_HANDLING.id, (String)(input = aLine.getOptionValue(SearchCLIParams.MISSING_TITLE_HANDLING.id)))) {
            return false;
        }
        if (aLine.hasOption(SearchCLIParams.REFERENCE_MASS.id) && !CommandParameter.isPositiveDouble((String)SearchCLIParams.REFERENCE_MASS.id, (String)(input = aLine.getOptionValue(SearchCLIParams.REFERENCE_MASS.id)), (boolean)false)) {
            return false;
        }
        return IdentificationParametersInputBean.isValidStartup((CommandLine)aLine, (boolean)false);
    }

    public PathSettingsCLIInputBean getPathSettingsCLIInputBean() {
        return this.pathSettingsCLIInputBean;
    }

    public String getDefaultOutputFileName() {
        return this.defaultOutputFileName;
    }

    public void setDefaultOutputFileName(String defaultOutputFileName) {
        this.defaultOutputFileName = defaultOutputFileName;
    }

    public boolean isGzip() {
        return this.gzip;
    }

    public OutputParameters getOutputOption() {
        return this.outputParameters;
    }

    public Boolean isOutputData() {
        return this.outputData;
    }

    public Boolean isOutputDate() {
        return this.outputDate;
    }

    public Boolean renameXTandemFile() {
        if (this.renameXTandemFile == null) {
            this.renameXTandemFile = true;
        }
        return this.renameXTandemFile;
    }

    public void setRenameXTandemFile(Boolean renameXTandemFile) {
        this.renameXTandemFile = renameXTandemFile;
    }

    public String getTargetDecoyFileNameTag() {
        if (this.targetDecoyFileNameTag == null) {
            this.targetDecoyFileNameTag = "_concatenated_target_decoy";
        }
        return this.targetDecoyFileNameTag;
    }

    public void setTargetDecoyFileNameTag(String targetDecoyFileNameTag) {
        this.targetDecoyFileNameTag = targetDecoyFileNameTag;
    }

    public boolean checkMgfSize() {
        return this.checkMgfSize;
    }

    public void setCheckMgfSize(boolean checkMgfSize) {
        this.checkMgfSize = checkMgfSize;
    }

    public Double getRefMass() {
        if (this.refMass == null) {
            this.refMass = 2000.0;
        }
        return this.refMass;
    }

    public void setRefMass(Double refMass) {
        this.refMass = refMass;
    }
}

