/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.gui;

import com.compomics.software.CompomicsWrapper;
import com.compomics.software.autoupdater.DownloadLatestZipFromRepo;
import com.compomics.software.autoupdater.FileDAO;
import com.compomics.software.autoupdater.GUIFileDAO;
import com.compomics.software.autoupdater.MavenJarFile;
import com.compomics.software.autoupdater.WebDAO;
import com.compomics.software.dialogs.JavaHomeOrMemoryDialogParent;
import com.compomics.software.dialogs.JavaParametersDialog;
import com.compomics.software.dialogs.PeptideShakerSetupDialog;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.file_handling.FileChooserUtil;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.parameters.UtilitiesUserParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.gui.SearchGUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import javax.xml.stream.XMLStreamException;

public class PeptideShakerParametersDialog
extends JDialog {
    private SearchGUI searchGUI;
    private ArrayList<File> mascotDatFiles = new ArrayList();
    private boolean canceled = false;
    private ProgressDialogX progressDialog;
    private JPanel advancedPanel;
    private JPanel backgroundPanel;
    private JButton browseMascotFilesButton;
    private JButton cancelButton;
    private JButton clearMascotFilesButton;
    private JButton editOutputButton;
    private JButton editPeptideShakerLocationButton;
    private JButton editProjectSettingsButton;
    private JPanel fileNamePanel;
    private JLabel lowMemoryWarningLabel;
    private JLabel mascotFilesLabel;
    private JTextField mascotFilesTextField;
    private JButton okButton;
    private JButton openDialogHelpJButton;
    private JLabel outputFileLabel;
    private JTextField outputFileTextField;
    private JTextField peptideShakerInstallationJTextField;
    private JPanel peptideShakerInstallationPanel;
    private JLabel peptideShakerLocationLabel;
    private JPanel projectDetailsPanel;
    private JTextField projectNameIdTxt;
    private JLabel projectReferenceLabel;
    private JLabel projectSettingsLbl;
    private JTextField projectSettingsTxt;

    public PeptideShakerParametersDialog(SearchGUI searchGUI, boolean modal, ArrayList<File> mascotFiles) {
        super((Frame)searchGUI, modal);
        boolean javaVersionWarning;
        this.searchGUI = searchGUI;
        this.initComponents();
        UtilitiesUserParameters utilitiesUserParameters = UtilitiesUserParameters.loadUserParameters();
        boolean java64bit = CompomicsWrapper.is64BitJava();
        boolean memoryOk = utilitiesUserParameters.getMemoryParameter() >= 4000;
        String javaVersion = System.getProperty("java.version");
        boolean bl = javaVersionWarning = javaVersion.startsWith("1.5") || javaVersion.startsWith("1.6") || javaVersion.startsWith("1.7");
        if (java64bit && memoryOk && !javaVersionWarning) {
            this.lowMemoryWarningLabel.setVisible(false);
        }
        if (javaVersionWarning) {
            this.lowMemoryWarningLabel.setText("<html><u>Java Version Warning!</u>");
        }
        this.projectNameIdTxt.setText(searchGUI.getSearchHandler().getExperimentLabel());
        this.peptideShakerInstallationJTextField.setColumns(1);
        this.outputFileTextField.setColumns(1);
        this.projectNameIdTxt.setColumns(1);
        this.mascotDatFiles.addAll(mascotFiles);
        if (this.mascotDatFiles.isEmpty()) {
            this.mascotFilesTextField.setText(null);
        } else if (this.mascotDatFiles.size() == 1) {
            this.mascotFilesTextField.setText(this.mascotDatFiles.get(0).getAbsolutePath());
        } else {
            this.mascotFilesTextField.setText(this.mascotDatFiles.size() + " file(s) selected");
        }
        if (searchGUI.getSearchHandler().getPeptideShakerFile() != null) {
            this.outputFileTextField.setText(searchGUI.getSearchHandler().getPeptideShakerFile().getAbsolutePath());
        }
        if (utilitiesUserParameters != null) {
            boolean newVersion;
            this.peptideShakerInstallationJTextField.setText(utilitiesUserParameters.getPeptideShakerPath());
            String peptideShakerJarPath = utilitiesUserParameters.getPeptideShakerPath();
            if (peptideShakerJarPath != null && peptideShakerJarPath.lastIndexOf("-beta") == -1 && new File(peptideShakerJarPath).exists() && (newVersion = this.checkForNewVersion(peptideShakerJarPath))) {
                int option = JOptionPane.showConfirmDialog(null, "A newer version of PeptideShaker is available.\nDo you want to update?", "Update Available", 1);
                if (option == 0) {
                    boolean success = this.downloadPeptideShaker();
                    if (success) {
                        utilitiesUserParameters = UtilitiesUserParameters.loadUserParameters();
                        this.peptideShakerInstallationJTextField.setText(utilitiesUserParameters.getPeptideShakerPath());
                    }
                } else if (option == 2 || option == -1) {
                    this.dispose();
                    return;
                }
            }
        }
        this.validateInput();
        this.setLocationRelativeTo(searchGUI);
        this.setVisible(true);
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.projectDetailsPanel = new JPanel();
        this.projectNameIdTxt = new JTextField();
        this.projectReferenceLabel = new JLabel();
        this.okButton = new JButton();
        this.fileNamePanel = new JPanel();
        this.outputFileLabel = new JLabel();
        this.outputFileTextField = new JTextField();
        this.editOutputButton = new JButton();
        this.peptideShakerInstallationPanel = new JPanel();
        this.peptideShakerInstallationJTextField = new JTextField();
        this.editPeptideShakerLocationButton = new JButton();
        this.peptideShakerLocationLabel = new JLabel();
        this.cancelButton = new JButton();
        this.advancedPanel = new JPanel();
        this.mascotFilesLabel = new JLabel();
        this.mascotFilesTextField = new JTextField();
        this.browseMascotFilesButton = new JButton();
        this.clearMascotFilesButton = new JButton();
        this.projectSettingsLbl = new JLabel();
        this.projectSettingsTxt = new JTextField();
        this.editProjectSettingsButton = new JButton();
        this.openDialogHelpJButton = new JButton();
        this.lowMemoryWarningLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("PeptideShaker Settings");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PeptideShakerParametersDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.projectDetailsPanel.setBorder(BorderFactory.createTitledBorder("Project Details"));
        this.projectDetailsPanel.setOpaque(false);
        this.projectNameIdTxt.setHorizontalAlignment(0);
        this.projectNameIdTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PeptideShakerParametersDialog.this.projectNameIdTxtKeyReleased(evt);
            }
        });
        this.projectReferenceLabel.setText("Project Reference");
        GroupLayout projectDetailsPanelLayout = new GroupLayout(this.projectDetailsPanel);
        this.projectDetailsPanel.setLayout(projectDetailsPanelLayout);
        projectDetailsPanelLayout.setHorizontalGroup(projectDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(projectDetailsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.projectReferenceLabel, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.projectNameIdTxt, -1, 628, Short.MAX_VALUE).addContainerGap()));
        projectDetailsPanelLayout.setVerticalGroup(projectDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(projectDetailsPanelLayout.createSequentialGroup().addContainerGap().addGroup(projectDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectNameIdTxt, -2, -1, -2).addComponent(this.projectReferenceLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.okButton.setText("OK");
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerParametersDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.fileNamePanel.setBorder(BorderFactory.createTitledBorder("Output"));
        this.fileNamePanel.setOpaque(false);
        this.outputFileLabel.setText("Output File");
        this.outputFileTextField.setEditable(false);
        this.editOutputButton.setText("Browse");
        this.editOutputButton.setToolTipText("The file where the output will be stored.");
        this.editOutputButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerParametersDialog.this.editOutputButtonActionPerformed(evt);
            }
        });
        GroupLayout fileNamePanelLayout = new GroupLayout(this.fileNamePanel);
        this.fileNamePanel.setLayout(fileNamePanelLayout);
        fileNamePanelLayout.setHorizontalGroup(fileNamePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, fileNamePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.outputFileLabel, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputFileTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editOutputButton, -2, 145, -2).addContainerGap()));
        fileNamePanelLayout.setVerticalGroup(fileNamePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fileNamePanelLayout.createSequentialGroup().addContainerGap().addGroup(fileNamePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputFileLabel).addComponent(this.outputFileTextField, -2, -1, -2).addComponent(this.editOutputButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.peptideShakerInstallationPanel.setBorder(BorderFactory.createTitledBorder("PeptideShaker"));
        this.peptideShakerInstallationPanel.setOpaque(false);
        this.peptideShakerInstallationJTextField.setEditable(false);
        this.peptideShakerInstallationJTextField.setToolTipText("The folder containing the PeptideShaker jar file.");
        this.editPeptideShakerLocationButton.setText("Edit");
        this.editPeptideShakerLocationButton.setToolTipText("The folder containing the PeptideShaker jar file.");
        this.editPeptideShakerLocationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerParametersDialog.this.editPeptideShakerLocationButtonActionPerformed(evt);
            }
        });
        this.peptideShakerLocationLabel.setText("Location");
        GroupLayout peptideShakerInstallationPanelLayout = new GroupLayout(this.peptideShakerInstallationPanel);
        this.peptideShakerInstallationPanel.setLayout(peptideShakerInstallationPanelLayout);
        peptideShakerInstallationPanelLayout.setHorizontalGroup(peptideShakerInstallationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, peptideShakerInstallationPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.peptideShakerLocationLabel, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.peptideShakerInstallationJTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editPeptideShakerLocationButton, -2, 145, -2).addContainerGap()));
        peptideShakerInstallationPanelLayout.setVerticalGroup(peptideShakerInstallationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peptideShakerInstallationPanelLayout.createSequentialGroup().addContainerGap().addGroup(peptideShakerInstallationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.peptideShakerInstallationJTextField, -2, -1, -2).addComponent(this.editPeptideShakerLocationButton).addComponent(this.peptideShakerLocationLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerParametersDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.advancedPanel.setBorder(BorderFactory.createTitledBorder("Advanced Settings (see help for details)"));
        this.advancedPanel.setOpaque(false);
        this.mascotFilesLabel.setText("Mascot Files");
        this.mascotFilesTextField.setEditable(false);
        this.browseMascotFilesButton.setText("Browse");
        this.browseMascotFilesButton.setToolTipText("The file where the output will be stored.");
        this.browseMascotFilesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerParametersDialog.this.browseMascotFilesButtonActionPerformed(evt);
            }
        });
        this.clearMascotFilesButton.setText("Clear");
        this.clearMascotFilesButton.setToolTipText("The file where the output will be stored.");
        this.clearMascotFilesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerParametersDialog.this.clearMascotFilesButtonActionPerformed(evt);
            }
        });
        this.projectSettingsLbl.setText("Project");
        this.projectSettingsTxt.setEditable(false);
        this.projectSettingsTxt.setHorizontalAlignment(0);
        this.projectSettingsTxt.setText("Default");
        this.editProjectSettingsButton.setText("Edit");
        this.editProjectSettingsButton.setEnabled(false);
        this.editProjectSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerParametersDialog.this.editProjectSettingsButtonActionPerformed(evt);
            }
        });
        GroupLayout advancedPanelLayout = new GroupLayout(this.advancedPanel);
        this.advancedPanel.setLayout(advancedPanelLayout);
        advancedPanelLayout.setHorizontalGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedPanelLayout.createSequentialGroup().addContainerGap().addGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.projectSettingsLbl, -1, -1, Short.MAX_VALUE).addComponent(this.mascotFilesLabel, -2, 100, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.mascotFilesTextField).addComponent(this.projectSettingsTxt, GroupLayout.Alignment.LEADING, -1, 476, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(advancedPanelLayout.createSequentialGroup().addComponent(this.browseMascotFilesButton, -1, 70, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearMascotFilesButton, -2, 70, -2)).addComponent(this.editProjectSettingsButton, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        advancedPanelLayout.setVerticalGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedPanelLayout.createSequentialGroup().addContainerGap().addGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectSettingsLbl).addComponent(this.projectSettingsTxt, -2, -1, -2).addComponent(this.editProjectSettingsButton)).addGap(0, 0, 0).addGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mascotFilesLabel).addComponent(this.mascotFilesTextField, -2, -1, -2).addComponent(this.browseMascotFilesButton).addComponent(this.clearMascotFilesButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.openDialogHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.openDialogHelpJButton.setToolTipText("Help");
        this.openDialogHelpJButton.setBorder(null);
        this.openDialogHelpJButton.setBorderPainted(false);
        this.openDialogHelpJButton.setContentAreaFilled(false);
        this.openDialogHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PeptideShakerParametersDialog.this.openDialogHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PeptideShakerParametersDialog.this.openDialogHelpJButtonMouseExited(evt);
            }
        });
        this.openDialogHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerParametersDialog.this.openDialogHelpJButtonActionPerformed(evt);
            }
        });
        this.lowMemoryWarningLabel.setFont(this.lowMemoryWarningLabel.getFont().deriveFont(this.lowMemoryWarningLabel.getFont().getStyle() | 1));
        this.lowMemoryWarningLabel.setForeground(new Color(255, 0, 0));
        this.lowMemoryWarningLabel.setText("<html><u>Low Memory Warning!</u>");
        this.lowMemoryWarningLabel.setToolTipText("Click to see details");
        this.lowMemoryWarningLabel.setHorizontalTextPosition(10);
        this.lowMemoryWarningLabel.setIconTextGap(-4);
        this.lowMemoryWarningLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PeptideShakerParametersDialog.this.lowMemoryWarningLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PeptideShakerParametersDialog.this.lowMemoryWarningLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                PeptideShakerParametersDialog.this.lowMemoryWarningLabelMouseReleased(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.openDialogHelpJButton, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.lowMemoryWarningLabel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.okButton, -2, 70, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, 70, -2)).addComponent(this.projectDetailsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.peptideShakerInstallationPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.fileNamePanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.advancedPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.peptideShakerInstallationPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.projectDetailsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileNamePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.advancedPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.okButton).addComponent(this.cancelButton).addComponent(this.openDialogHelpJButton).addComponent(this.lowMemoryWarningLabel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        this.pack();
    }

    private void editPeptideShakerLocationButtonActionPerformed(ActionEvent evt) {
        try {
            new PeptideShakerSetupDialog((JFrame)this.searchGUI, true);
            UtilitiesUserParameters utilitiesUserParameters = UtilitiesUserParameters.loadUserParameters();
            if (utilitiesUserParameters != null) {
                this.peptideShakerInstallationJTextField.setText(utilitiesUserParameters.getPeptideShakerPath());
            }
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this, "File not found.", "File Error", 0);
            ex.printStackTrace();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "File error.", "File Error", 0);
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            JOptionPane.showMessageDialog(this, "File not found.", "File Error", 0);
            ex.printStackTrace();
        }
        this.validateInput();
    }

    private void editOutputButtonActionPerformed(ActionEvent evt) {
        File selectedFile;
        String tempProjectReference;
        File startLocation = this.searchGUI.getUtilitiesUserParameters().getOutputFolder();
        if (startLocation == null) {
            startLocation = new File(this.searchGUI.getLastSelectedFolder().getLastSelectedFolder());
        }
        if (!this.outputFileTextField.getText().isEmpty() && new File(this.outputFileTextField.getText()).getParentFile() != null) {
            startLocation = new File(this.outputFileTextField.getText()).getParentFile();
        }
        if (!(tempProjectReference = this.projectNameIdTxt.getText().trim()).isEmpty()) {
            tempProjectReference = "-" + tempProjectReference;
        }
        if ((selectedFile = FileChooserUtil.getUserSelectedFile((Component)this, (String)".psdb", (String)"PeptideShaker Database Format (*.psdb)", (String)"Select PeptideShaker Output", (String)startLocation.getAbsolutePath(), (String)("PeptideShaker-output" + tempProjectReference + ".psdb"), (boolean)false)) != null) {
            if (!selectedFile.getName().endsWith(".psdb")) {
                selectedFile = new File(selectedFile.getAbsolutePath() + ".psdb");
            }
            this.searchGUI.getUtilitiesUserParameters().setOutputFolder(selectedFile.getParentFile());
            this.searchGUI.getLastSelectedFolder().setLastSelectedFolder(selectedFile.getParentFile().getAbsolutePath());
            this.outputFileTextField.setText(selectedFile.getAbsolutePath());
        }
        this.validateInput();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void browseMascotFilesButtonActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser(this.searchGUI.getLastSelectedFolder().getLastSelectedFolder());
        fileChooser.setDialogTitle("Select Mascot Result File(s)");
        fileChooser.setFileSelectionMode(2);
        fileChooser.setMultiSelectionEnabled(true);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                return myFile.getName().toLowerCase().endsWith("dat") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Supported formats: Mascot (.dat)";
            }
        };
        fileChooser.setFileFilter(filter);
        int returnVal = fileChooser.showDialog(this.getParent(), "Select");
        if (returnVal == 0) {
            for (File newFile : fileChooser.getSelectedFiles()) {
                if (newFile.isDirectory()) {
                    File[] tempFiles;
                    for (File file : tempFiles = newFile.listFiles()) {
                        if (!file.getName().toLowerCase().endsWith("dat")) continue;
                        this.mascotDatFiles.add(file);
                    }
                } else {
                    this.mascotDatFiles.add(newFile);
                }
                this.searchGUI.getLastSelectedFolder().setLastSelectedFolder(newFile.getAbsolutePath());
            }
        }
        if (this.mascotDatFiles.isEmpty()) {
            this.mascotFilesTextField.setText(null);
        } else if (this.mascotDatFiles.size() == 1) {
            this.mascotFilesTextField.setText(this.mascotDatFiles.get(0).getAbsolutePath());
        } else {
            this.mascotFilesTextField.setText(this.mascotDatFiles.size() + " file(s) selected");
        }
    }

    private void openDialogHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void openDialogHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void openDialogHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog((Frame)this.searchGUI, this.getClass().getResource("/helpFiles/PeptideShakerSettingsDialog.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "PeptideShaker - Help", 500, 50);
        this.setCursor(new Cursor(0));
    }

    private void clearMascotFilesButtonActionPerformed(ActionEvent evt) {
        this.mascotDatFiles = new ArrayList();
        this.mascotFilesTextField.setText(null);
    }

    private void editProjectSettingsButtonActionPerformed(ActionEvent evt) {
    }

    private void projectNameIdTxtKeyReleased(KeyEvent evt) {
        this.validateInput();
    }

    private void lowMemoryWarningLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void lowMemoryWarningLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void lowMemoryWarningLabelMouseReleased(MouseEvent evt) {
        new JavaParametersDialog((JFrame)this.searchGUI, (JavaHomeOrMemoryDialogParent)this.searchGUI, null, "SearchGUI", true);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.canceled = true;
    }

    private boolean validateInput() {
        this.peptideShakerLocationLabel.setForeground(Color.black);
        this.projectReferenceLabel.setForeground(Color.black);
        this.outputFileLabel.setForeground(Color.black);
        this.peptideShakerLocationLabel.setToolTipText(null);
        this.projectReferenceLabel.setToolTipText(null);
        this.outputFileLabel.setToolTipText(null);
        boolean valid = true;
        if (this.peptideShakerInstallationJTextField.getText().trim().length() == 0) {
            valid = false;
            this.peptideShakerLocationLabel.setForeground(Color.red);
            this.peptideShakerLocationLabel.setToolTipText("Please locate the PeptideShaker jar file.");
        }
        if (!new File(this.peptideShakerInstallationJTextField.getText().trim()).exists()) {
            valid = false;
            this.peptideShakerLocationLabel.setForeground(Color.red);
            this.peptideShakerLocationLabel.setToolTipText("PeptideShaker jar file not found.");
        }
        if (this.projectNameIdTxt.getText().trim().length() == 0) {
            valid = false;
            this.projectReferenceLabel.setForeground(Color.red);
            this.projectReferenceLabel.setToolTipText("Please provide a project name.");
            this.projectNameIdTxt.requestFocus();
        }
        if (this.outputFileTextField.getText().trim().length() == 0) {
            valid = false;
            this.outputFileLabel.setForeground(Color.red);
            this.outputFileLabel.setToolTipText("Please provide an output file.");
        }
        this.okButton.setEnabled(valid);
        return valid;
    }

    public ArrayList<File> getMascotFiles() {
        return this.mascotDatFiles;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public String getProjectName() {
        return this.projectNameIdTxt.getText();
    }

    public File getPeptideShakerOutputFile() {
        return new File(this.outputFileTextField.getText());
    }

    public boolean checkForNewVersion(String peptideShakerJarPath) {
        try {
            File jarFile = new File(peptideShakerJarPath);
            MavenJarFile oldMavenJarFile = new MavenJarFile(jarFile.toURI());
            URL jarRepository = new URL("https", "genesis.ugent.be", "/archiva/repository/maven2/");
            return WebDAO.newVersionReleased((MavenJarFile)oldMavenJarFile, (URL)jarRepository);
        }
        catch (UnknownHostException ex) {
            System.out.println("Checking for new version failed. No internet connection.");
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean downloadPeptideShaker() {
        File downloadFolder;
        boolean firstTimeInstall = true;
        String installPath = null;
        final UtilitiesUserParameters utilitiesUserParameters = UtilitiesUserParameters.loadUserParameters();
        String peptideShakerPath = utilitiesUserParameters.getPeptideShakerPath();
        if (peptideShakerPath != null && new File(peptideShakerPath).getParentFile() != null && new File(peptideShakerPath).getParentFile().getParentFile() != null) {
            installPath = new File(peptideShakerPath).getParentFile().getParent();
        }
        if (installPath == null) {
            installPath = "user.home";
            downloadFolder = FileChooserUtil.getUserSelectedFolder((Component)this, (String)"Select PeptideShaker Folder", (String)installPath, (String)"PeptideShaker Folder", (String)"Select", (boolean)false);
        } else {
            firstTimeInstall = false;
            downloadFolder = new File(installPath);
        }
        final boolean finalFirstTimeInstall = firstTimeInstall;
        if (downloadFolder != null) {
            this.progressDialog = new ProgressDialogX((Frame)this.searchGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui-orange.gif")), true);
            this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
            this.progressDialog.setTitle("Downloading PeptideShaker. Please Wait...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        PeptideShakerParametersDialog.this.progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            Thread thread = new Thread("DownloadThread"){

                @Override
                public void run() {
                    try {
                        URL jarRepository = new URL("http", "genesis.ugent.be", "/maven2/");
                        if (finalFirstTimeInstall) {
                            DownloadLatestZipFromRepo.downloadLatestZipFromRepo((File)downloadFolder, (String)"PeptideShaker", (String)"eu.isas.peptideshaker", (String)"PeptideShaker", (String)"peptide-shaker.ico", null, (URL)jarRepository, (boolean)false, (boolean)true, (FileDAO)new GUIFileDAO(), (WaitingHandler)PeptideShakerParametersDialog.this.progressDialog);
                        } else {
                            DownloadLatestZipFromRepo.downloadLatestZipFromRepo((URL)new File(utilitiesUserParameters.getPeptideShakerPath()).toURI().toURL(), (String)"PeptideShaker", (boolean)false, (String)"peptide-shaker.ico", null, (URL)jarRepository, (boolean)false, (boolean)true, (FileDAO)new GUIFileDAO(), (WaitingHandler)PeptideShakerParametersDialog.this.progressDialog);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                    catch (XMLStreamException e) {
                        e.printStackTrace();
                    }
                }
            };
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.progressDialog.isRunCanceled()) {
                this.progressDialog.setRunFinished();
                return false;
            }
            if (!this.progressDialog.isRunFinished()) {
                this.progressDialog.setRunFinished();
            }
            return true;
        }
        return false;
    }
}

