/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.gui;

import com.compomics.util.experiment.identification.Advocate;
import eu.isas.searchgui.gui.SearchGUI;
import eu.isas.searchgui.processbuilders.MakeblastdbProcessBuilder;
import eu.isas.searchgui.processbuilders.MetaMorpheusProcessBuilder;
import eu.isas.searchgui.processbuilders.SageProcessBuilder;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class SoftwareLocationDialog
extends JDialog {
    private static final String[] ENABLED_DISABLED = new String[]{"Enabled", "Disabled"};
    private SearchGUI searchGUIMainFrame;
    private boolean guiLoaded = false;
    private boolean omssaValid = true;
    private boolean tandemValid = true;
    private boolean msgfValid = true;
    private boolean msAmandaValid = true;
    private boolean myriMatchValid = true;
    private boolean cometValid = true;
    private boolean tideValid = true;
    private boolean andromedaValid = true;
    private boolean metaMorpheusValid = true;
    private boolean sageValid = true;
    private boolean novorValid = true;
    private boolean direcTagValid = true;
    private JButton andromedaBrowse;
    private JLabel andromedaLocationLabel;
    private JTextField andromedaLocationTxt;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JButton cometBrowse;
    private JLabel cometLocationLabel;
    private JTextField cometLocationTxt;
    private JButton direcTagBrowse;
    private JLabel direcTagLocationLabel;
    private JTextField direcTagLocationTxt;
    private JComboBox enableAndromedaCombo;
    private JComboBox enableCometCombo;
    private JComboBox enableDirecTagCombo;
    private JComboBox enableMetaMorpheusCombo;
    private JComboBox enableMsAmandaCombo;
    private JComboBox enableMsgfCombo;
    private JComboBox enableMyriMatchCombo;
    private JComboBox enableNovorCombo;
    private JComboBox enableOmssaCombo;
    private JComboBox enableSageCombo;
    private JComboBox enableTideCombo;
    private JComboBox enableXTandemCombo;
    private JButton makeblastdbBrowse;
    private JLabel makeblastdbLocationLabel;
    private JTextField makeblastdbLocationTxt;
    private JButton metaMorpheusBrowse;
    private JLabel metaMorpheusLocationLabel;
    private JTextField metaMorpheusLocationTxt;
    private JButton msAmandaBrowse;
    private JLabel msAmandaLocationLabel;
    private JTextField msAmandaLocationTxt;
    private JButton msgfBrowse;
    private JLabel msgfLocationLabel;
    private JTextField msgfLocationTxt;
    private JButton myriMatchBrowse;
    private JLabel myriMatchLocationLabel;
    private JTextField myriMatchLocationTxt;
    private JButton novorBrowse;
    private JLabel novorLocationLabel;
    private JTextField novorLocationTxt;
    private JButton okButton;
    private JButton omssaBrowse;
    private JLabel omssaLocationLabel;
    private JTextField omssaLocationTxt;
    private JButton sageBrowse;
    private JLabel sageLocationLabel;
    private JTextField sageLocationTxt;
    private JPanel searchEnginesLocationPanel;
    private JButton tideBrowse;
    private JLabel tideLocationLabel;
    private JTextField tideLocationTxt;
    private JButton xTandemBrowse;
    private JLabel xTandemLocationLabel;
    private JTextField xTandemLocationTxt;

    public SoftwareLocationDialog(SearchGUI searchGUIMainFrame, boolean modal) {
        super((Frame)searchGUIMainFrame, modal);
        this.searchGUIMainFrame = searchGUIMainFrame;
        this.initComponents();
        this.loadSearchEngines();
        this.validateInput(false);
        this.guiLoaded = true;
        this.setLocationRelativeTo(searchGUIMainFrame);
        this.setVisible(true);
    }

    private void loadSearchEngines() {
        if (this.searchGUIMainFrame.getSearchHandler().getOmssaLocation() != null) {
            this.omssaLocationTxt.setText(this.searchGUIMainFrame.getSearchHandler().getOmssaLocation().getAbsolutePath());
            if (this.searchGUIMainFrame.getSearchHandler().isOmssaEnabled()) {
                this.enableOmssaCombo.setSelectedItem("Enabled");
            } else {
                this.enableOmssaCombo.setSelectedItem("Disabled");
            }
        } else {
            this.omssaLocationTxt.setText("");
            this.enableOmssaCombo.setSelectedItem("Disabled");
        }
        if (this.searchGUIMainFrame.getSearchHandler().getXtandemLocation() != null) {
            this.xTandemLocationTxt.setText(this.searchGUIMainFrame.getSearchHandler().getXtandemLocation().getAbsolutePath());
            if (this.searchGUIMainFrame.getSearchHandler().isXtandemEnabled()) {
                this.enableXTandemCombo.setSelectedItem("Enabled");
            } else {
                this.enableXTandemCombo.setSelectedItem("Disabled");
            }
        } else {
            this.xTandemLocationTxt.setText("");
            this.enableXTandemCombo.setSelectedItem("Disabled");
        }
        if (this.searchGUIMainFrame.getSearchHandler().getMsgfLocation() != null) {
            this.msgfLocationTxt.setText(this.searchGUIMainFrame.getSearchHandler().getMsgfLocation().getAbsolutePath());
            if (this.searchGUIMainFrame.getSearchHandler().isMsgfEnabled()) {
                this.enableMsgfCombo.setSelectedItem("Enabled");
            } else {
                this.enableMsgfCombo.setSelectedItem("Disabled");
            }
        } else {
            this.msgfLocationTxt.setText("");
            this.enableMsgfCombo.setSelectedItem("Disabled");
        }
        if (this.searchGUIMainFrame.getSearchHandler().getMsAmandaLocation() != null) {
            this.msAmandaLocationTxt.setText(this.searchGUIMainFrame.getSearchHandler().getMsAmandaLocation().getAbsolutePath());
            if (this.searchGUIMainFrame.getSearchHandler().isMsAmandaEnabled()) {
                this.enableMsAmandaCombo.setSelectedItem("Enabled");
            } else {
                this.enableMsAmandaCombo.setSelectedItem("Disabled");
            }
        } else {
            this.msAmandaLocationTxt.setText("");
            this.enableMsAmandaCombo.setSelectedItem("Disabled");
        }
        if (this.searchGUIMainFrame.getSearchHandler().getMyriMatchLocation() != null) {
            this.myriMatchLocationTxt.setText(this.searchGUIMainFrame.getSearchHandler().getMyriMatchLocation().getAbsolutePath());
            if (this.searchGUIMainFrame.getSearchHandler().isMyriMatchEnabled()) {
                this.enableMyriMatchCombo.setSelectedItem("Enabled");
            } else {
                this.enableMyriMatchCombo.setSelectedItem("Disabled");
            }
        } else {
            this.myriMatchLocationTxt.setText("");
            this.enableMyriMatchCombo.setSelectedItem("Disabled");
        }
        if (this.searchGUIMainFrame.getSearchHandler().getCometLocation() != null) {
            this.cometLocationTxt.setText(this.searchGUIMainFrame.getSearchHandler().getCometLocation().getAbsolutePath());
            if (this.searchGUIMainFrame.getSearchHandler().isCometEnabled()) {
                this.enableCometCombo.setSelectedItem("Enabled");
            } else {
                this.enableCometCombo.setSelectedItem("Disabled");
            }
        } else {
            this.cometLocationTxt.setText("");
            this.enableCometCombo.setSelectedItem("Disabled");
        }
        if (this.searchGUIMainFrame.getSearchHandler().getTideLocation() != null) {
            this.tideLocationTxt.setText(this.searchGUIMainFrame.getSearchHandler().getTideLocation().getAbsolutePath());
            if (this.searchGUIMainFrame.getSearchHandler().isTideEnabled()) {
                this.enableTideCombo.setSelectedItem("Enabled");
            } else {
                this.enableTideCombo.setSelectedItem("Disabled");
            }
        } else {
            this.tideLocationTxt.setText("");
            this.enableTideCombo.setSelectedItem("Disabled");
        }
        if (this.searchGUIMainFrame.getSearchHandler().getAndromedaLocation() != null) {
            this.andromedaLocationTxt.setText(this.searchGUIMainFrame.getSearchHandler().getAndromedaLocation().getAbsolutePath());
            if (this.searchGUIMainFrame.getSearchHandler().isAndromedaEnabled()) {
                this.enableAndromedaCombo.setSelectedItem("Enabled");
            } else {
                this.enableAndromedaCombo.setSelectedItem("Disabled");
            }
        } else {
            this.andromedaLocationTxt.setText("");
            this.enableAndromedaCombo.setSelectedItem("Disabled");
        }
        if (this.searchGUIMainFrame.getSearchHandler().getMetaMorpheusLocation() != null) {
            this.metaMorpheusLocationTxt.setText(this.searchGUIMainFrame.getSearchHandler().getMetaMorpheusLocation().getAbsolutePath());
            if (this.searchGUIMainFrame.getSearchHandler().isMetaMorpheusEnabled()) {
                this.enableMetaMorpheusCombo.setSelectedItem("Enabled");
            } else {
                this.enableMetaMorpheusCombo.setSelectedItem("Disabled");
            }
        } else {
            this.metaMorpheusLocationTxt.setText("");
            this.enableMetaMorpheusCombo.setSelectedItem("Disabled");
        }
        if (this.searchGUIMainFrame.getSearchHandler().getSageLocation() != null) {
            this.sageLocationTxt.setText(this.searchGUIMainFrame.getSearchHandler().getSageLocation().getAbsolutePath());
            if (this.searchGUIMainFrame.getSearchHandler().isSageEnabled()) {
                this.enableSageCombo.setSelectedItem("Enabled");
            } else {
                this.enableSageCombo.setSelectedItem("Disabled");
            }
        } else {
            this.sageLocationTxt.setText("");
            this.enableSageCombo.setSelectedItem("Disabled");
        }
        if (this.searchGUIMainFrame.getSearchHandler().getNovorLocation() != null) {
            this.novorLocationTxt.setText(this.searchGUIMainFrame.getSearchHandler().getNovorLocation().getAbsolutePath());
            if (this.searchGUIMainFrame.getSearchHandler().isNovorEnabled()) {
                this.enableNovorCombo.setSelectedItem("Enabled");
            } else {
                this.enableNovorCombo.setSelectedItem("Disabled");
            }
        } else {
            this.novorLocationTxt.setText("");
            this.enableNovorCombo.setSelectedItem("Disabled");
        }
        if (this.searchGUIMainFrame.getSearchHandler().getDirecTagLocation() != null) {
            this.direcTagLocationTxt.setText(this.searchGUIMainFrame.getSearchHandler().getDirecTagLocation().getAbsolutePath());
            if (this.searchGUIMainFrame.getSearchHandler().isDirecTagEnabled()) {
                this.enableDirecTagCombo.setSelectedItem("Enabled");
            } else {
                this.enableDirecTagCombo.setSelectedItem("Disabled");
            }
        } else {
            this.direcTagLocationTxt.setText("");
            this.enableDirecTagCombo.setSelectedItem("Disabled");
        }
        String operatingSystem = System.getProperty("os.name").toLowerCase();
        if (operatingSystem.contains("mac os")) {
            this.myriMatchLocationTxt.setText("");
            this.myriMatchBrowse.setEnabled(false);
            this.enableMyriMatchCombo.setEnabled(false);
            this.direcTagLocationTxt.setText("");
            this.direcTagBrowse.setEnabled(false);
            this.enableDirecTagCombo.setEnabled(false);
        }
        if (this.searchGUIMainFrame.getSearchHandler().getMakeblastdbLocation() != null) {
            this.makeblastdbLocationTxt.setText(this.searchGUIMainFrame.getSearchHandler().getMakeblastdbLocation().getAbsolutePath());
        } else {
            File makeBlastDbFolder = new File(this.searchGUIMainFrame.getJarFilePath(), MakeblastdbProcessBuilder.getMakeblastdbFolder());
            this.makeblastdbLocationTxt.setText(makeBlastDbFolder.getAbsolutePath());
        }
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.okButton = new JButton();
        this.searchEnginesLocationPanel = new JPanel();
        this.xTandemLocationLabel = new JLabel();
        this.xTandemLocationTxt = new JTextField();
        this.xTandemBrowse = new JButton();
        this.enableXTandemCombo = new JComboBox();
        this.omssaLocationLabel = new JLabel();
        this.omssaLocationTxt = new JTextField();
        this.omssaBrowse = new JButton();
        this.enableOmssaCombo = new JComboBox();
        this.msgfLocationLabel = new JLabel();
        this.msgfLocationTxt = new JTextField();
        this.msgfBrowse = new JButton();
        this.enableMsgfCombo = new JComboBox();
        this.msAmandaLocationLabel = new JLabel();
        this.msAmandaLocationTxt = new JTextField();
        this.msAmandaBrowse = new JButton();
        this.enableMsAmandaCombo = new JComboBox();
        this.makeblastdbLocationLabel = new JLabel();
        this.makeblastdbLocationTxt = new JTextField();
        this.makeblastdbBrowse = new JButton();
        this.myriMatchLocationLabel = new JLabel();
        this.myriMatchLocationTxt = new JTextField();
        this.myriMatchBrowse = new JButton();
        this.enableMyriMatchCombo = new JComboBox();
        this.cometLocationLabel = new JLabel();
        this.cometLocationTxt = new JTextField();
        this.cometBrowse = new JButton();
        this.enableCometCombo = new JComboBox();
        this.tideLocationLabel = new JLabel();
        this.tideLocationTxt = new JTextField();
        this.tideBrowse = new JButton();
        this.enableTideCombo = new JComboBox();
        this.andromedaLocationLabel = new JLabel();
        this.andromedaLocationTxt = new JTextField();
        this.andromedaBrowse = new JButton();
        this.enableAndromedaCombo = new JComboBox();
        this.novorLocationLabel = new JLabel();
        this.novorLocationTxt = new JTextField();
        this.novorBrowse = new JButton();
        this.enableNovorCombo = new JComboBox();
        this.direcTagLocationLabel = new JLabel();
        this.direcTagLocationTxt = new JTextField();
        this.direcTagBrowse = new JButton();
        this.enableDirecTagCombo = new JComboBox();
        this.metaMorpheusLocationLabel = new JLabel();
        this.metaMorpheusLocationTxt = new JTextField();
        this.metaMorpheusBrowse = new JButton();
        this.enableMetaMorpheusCombo = new JComboBox();
        this.sageLocationLabel = new JLabel();
        this.sageLocationTxt = new JTextField();
        this.sageBrowse = new JButton();
        this.enableSageCombo = new JComboBox();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Software Folders");
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoftwareLocationDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.searchEnginesLocationPanel.setBorder(BorderFactory.createTitledBorder("Folders"));
        this.searchEnginesLocationPanel.setOpaque(false);
        this.xTandemLocationLabel.setText("X! Tandem");
        this.xTandemLocationTxt.setEditable(false);
        this.xTandemBrowse.setText("Browse");
        this.xTandemBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoftwareLocationDialog.this.xTandemBrowseActionPerformed(evt);
            }
        });
        this.enableXTandemCombo.setModel(new DefaultComboBoxModel<String>(ENABLED_DISABLED));
        this.enableXTandemCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoftwareLocationDialog.this.enableXTandemComboActionPerformed(evt);
            }
        });
        this.omssaLocationLabel.setText("OMSSA");
        this.omssaLocationTxt.setEditable(false);
        this.omssaBrowse.setText("Browse");
        this.omssaBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoftwareLocationDialog.this.omssaBrowseActionPerformed(evt);
            }
        });
        this.enableOmssaCombo.setModel(new DefaultComboBoxModel<String>(ENABLED_DISABLED));
        this.enableOmssaCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoftwareLocationDialog.this.enableOmssaComboActionPerformed(evt);
            }
        });
        this.msgfLocationLabel.setText("MS-GF+");
        this.msgfLocationTxt.setEditable(false);
        this.msgfBrowse.setText("Browse");
        this.msgfBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoftwareLocationDialog.this.msgfBrowseActionPerformed(evt);
            }
        });
        this.enableMsgfCombo.setModel(new DefaultComboBoxModel<String>(ENABLED_DISABLED));
        this.enableMsgfCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoftwareLocationDialog.this.enableMsgfComboActionPerformed(evt);
            }
        });
        this.msAmandaLocationLabel.setText("MS Amanda");
        this.msAmandaLocationTxt.setEditable(false);
        this.msAmandaBrowse.setText("Browse");
        this.msAmandaBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoftwareLocationDialog.this.msAmandaBrowseActionPerformed(evt);
            }
        });
        this.enableMsAmandaCombo.setModel(new DefaultComboBoxModel<String>(ENABLED_DISABLED));
        this.enableMsAmandaCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoftwareLocationDialog.this.enableMsAmandaComboActionPerformed(evt);
            }
        });
        this.makeblastdbLocationLabel.setText("makeblastdb");
        this.makeblastdbLocationLabel.setToolTipText("makeblastdb is required to use OMSSA");
        this.makeblastdbLocationTxt.setEditable(false);
        this.makeblastdbLocationTxt.setToolTipText("makeblastdb is required to use OMSSA");
        this.makeblastdbBrowse.setText("Browse");
        this.makeblastdbBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoftwareLocationDialog.this.makeblastdbBrowseActionPerformed(evt);
            }
        });
        this.myriMatchLocationLabel.setText("MyriMatch");
        this.myriMatchLocationTxt.setEditable(false);
        this.myriMatchBrowse.setText("Browse");
        this.myriMatchBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoftwareLocationDialog.this.myriMatchBrowseActionPerformed(evt);
            }
        });
        this.enableMyriMatchCombo.setModel(new DefaultComboBoxModel<String>(ENABLED_DISABLED));
        this.enableMyriMatchCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoftwareLocationDialog.this.enableMyriMatchComboActionPerformed(evt);
            }
        });
        this.cometLocationLabel.setText("Comet");
        this.cometLocationTxt.setEditable(false);
        this.cometBrowse.setText("Browse");
        this.cometBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoftwareLocationDialog.this.cometBrowseActionPerformed(evt);
            }
        });
        this.enableCometCombo.setModel(new DefaultComboBoxModel<String>(ENABLED_DISABLED));
        this.enableCometCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoftwareLocationDialog.this.enableCometComboActionPerformed(evt);
            }
        });
        this.tideLocationLabel.setText("Tide");
        this.tideLocationTxt.setEditable(false);
        this.tideBrowse.setText("Browse");
        this.tideBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoftwareLocationDialog.this.tideBrowseActionPerformed(evt);
            }
        });
        this.enableTideCombo.setModel(new DefaultComboBoxModel<String>(ENABLED_DISABLED));
        this.enableTideCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoftwareLocationDialog.this.enableTideComboActionPerformed(evt);
            }
        });
        this.andromedaLocationLabel.setText("Andromeda");
        this.andromedaLocationTxt.setEditable(false);
        this.andromedaBrowse.setText("Browse");
        this.andromedaBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoftwareLocationDialog.this.andromedaBrowseActionPerformed(evt);
            }
        });
        this.enableAndromedaCombo.setModel(new DefaultComboBoxModel<String>(ENABLED_DISABLED));
        this.enableAndromedaCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoftwareLocationDialog.this.enableAndromedaComboActionPerformed(evt);
            }
        });
        this.novorLocationLabel.setText("Novor");
        this.novorLocationTxt.setEditable(false);
        this.novorBrowse.setText("Browse");
        this.novorBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoftwareLocationDialog.this.novorBrowseActionPerformed(evt);
            }
        });
        this.enableNovorCombo.setModel(new DefaultComboBoxModel<String>(ENABLED_DISABLED));
        this.enableNovorCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoftwareLocationDialog.this.enableNovorComboActionPerformed(evt);
            }
        });
        this.direcTagLocationLabel.setText("DirecTag");
        this.direcTagLocationTxt.setEditable(false);
        this.direcTagBrowse.setText("Browse");
        this.direcTagBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoftwareLocationDialog.this.direcTagBrowseActionPerformed(evt);
            }
        });
        this.enableDirecTagCombo.setModel(new DefaultComboBoxModel<String>(ENABLED_DISABLED));
        this.enableDirecTagCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoftwareLocationDialog.this.enableDirecTagComboActionPerformed(evt);
            }
        });
        this.metaMorpheusLocationLabel.setText("MetaMorpheus");
        this.metaMorpheusLocationTxt.setEditable(false);
        this.metaMorpheusBrowse.setText("Browse");
        this.metaMorpheusBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoftwareLocationDialog.this.metaMorpheusBrowseActionPerformed(evt);
            }
        });
        this.enableMetaMorpheusCombo.setModel(new DefaultComboBoxModel<String>(ENABLED_DISABLED));
        this.enableMetaMorpheusCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoftwareLocationDialog.this.enableMetaMorpheusComboActionPerformed(evt);
            }
        });
        this.sageLocationLabel.setText("Sage");
        this.sageLocationTxt.setEditable(false);
        this.sageBrowse.setText("Browse");
        this.sageBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoftwareLocationDialog.this.sageBrowseActionPerformed(evt);
            }
        });
        this.enableSageCombo.setModel(new DefaultComboBoxModel<String>(ENABLED_DISABLED));
        this.enableSageCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoftwareLocationDialog.this.enableSageComboActionPerformed(evt);
            }
        });
        GroupLayout searchEnginesLocationPanelLayout = new GroupLayout(this.searchEnginesLocationPanel);
        this.searchEnginesLocationPanel.setLayout(searchEnginesLocationPanelLayout);
        searchEnginesLocationPanelLayout.setHorizontalGroup(searchEnginesLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchEnginesLocationPanelLayout.createSequentialGroup().addContainerGap().addGroup(searchEnginesLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchEnginesLocationPanelLayout.createSequentialGroup().addGroup(searchEnginesLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchEnginesLocationPanelLayout.createSequentialGroup().addComponent(this.msgfLocationLabel, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.msgfLocationTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.msgfBrowse, -2, 80, -2)).addGroup(searchEnginesLocationPanelLayout.createSequentialGroup().addComponent(this.msAmandaLocationLabel, -2, 91, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.msAmandaLocationTxt, -1, 503, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.msAmandaBrowse, -2, 80, -2)).addGroup(searchEnginesLocationPanelLayout.createSequentialGroup().addComponent(this.xTandemLocationLabel, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xTandemLocationTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xTandemBrowse, -2, 80, -2)).addGroup(searchEnginesLocationPanelLayout.createSequentialGroup().addComponent(this.myriMatchLocationLabel, -2, 91, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.myriMatchLocationTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.myriMatchBrowse, -2, 80, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(GroupLayout.Alignment.TRAILING, searchEnginesLocationPanelLayout.createSequentialGroup().addGroup(searchEnginesLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(searchEnginesLocationPanelLayout.createSequentialGroup().addComponent(this.sageLocationLabel, -2, 91, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sageLocationTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sageBrowse, -2, 80, -2)).addGroup(searchEnginesLocationPanelLayout.createSequentialGroup().addComponent(this.metaMorpheusLocationLabel, -2, 91, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.metaMorpheusLocationTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.metaMorpheusBrowse, -2, 80, -2)).addGroup(searchEnginesLocationPanelLayout.createSequentialGroup().addComponent(this.direcTagLocationLabel, -2, 91, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.direcTagLocationTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.direcTagBrowse, -2, 80, -2)).addGroup(searchEnginesLocationPanelLayout.createSequentialGroup().addComponent(this.novorLocationLabel, -2, 91, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.novorLocationTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.novorBrowse, -2, 80, -2)).addGroup(searchEnginesLocationPanelLayout.createSequentialGroup().addComponent(this.andromedaLocationLabel, -2, 91, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.andromedaLocationTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.andromedaBrowse, -2, 80, -2)).addGroup(searchEnginesLocationPanelLayout.createSequentialGroup().addComponent(this.tideLocationLabel, -2, 91, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tideLocationTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tideBrowse, -2, 80, -2)).addGroup(searchEnginesLocationPanelLayout.createSequentialGroup().addComponent(this.cometLocationLabel, -2, 91, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cometLocationTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cometBrowse, -2, 80, -2)).addGroup(searchEnginesLocationPanelLayout.createSequentialGroup().addGroup(searchEnginesLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.omssaLocationLabel, -2, 91, -2).addComponent(this.makeblastdbLocationLabel, -2, 91, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchEnginesLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.makeblastdbLocationTxt).addComponent(this.omssaLocationTxt)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchEnginesLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.omssaBrowse, -2, 80, -2).addComponent(this.makeblastdbBrowse, -2, 80, -2)))).addGap(6, 6, 6))).addGroup(searchEnginesLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.enableSageCombo, 0, -1, Short.MAX_VALUE).addComponent(this.enableMetaMorpheusCombo, 0, -1, Short.MAX_VALUE).addComponent(this.enableDirecTagCombo, 0, -1, Short.MAX_VALUE).addComponent(this.enableAndromedaCombo, 0, -1, Short.MAX_VALUE).addComponent(this.enableTideCombo, 0, -1, Short.MAX_VALUE).addComponent(this.enableCometCombo, 0, -1, Short.MAX_VALUE).addComponent(this.enableOmssaCombo, 0, -1, Short.MAX_VALUE).addComponent(this.enableMsgfCombo, 0, -1, Short.MAX_VALUE).addComponent(this.enableMsAmandaCombo, 0, -1, Short.MAX_VALUE).addComponent(this.enableMyriMatchCombo, 0, -1, Short.MAX_VALUE).addComponent(this.enableXTandemCombo, GroupLayout.Alignment.TRAILING, 0, 80, Short.MAX_VALUE).addComponent(this.enableNovorCombo, 0, -1, Short.MAX_VALUE)).addContainerGap()));
        searchEnginesLocationPanelLayout.setVerticalGroup(searchEnginesLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchEnginesLocationPanelLayout.createSequentialGroup().addContainerGap().addGroup(searchEnginesLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.xTandemLocationLabel).addComponent(this.xTandemLocationTxt, -2, -1, -2).addComponent(this.xTandemBrowse).addComponent(this.enableXTandemCombo, -2, -1, -2)).addGap(0, 0, 0).addGroup(searchEnginesLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.enableMyriMatchCombo, -2, -1, -2).addComponent(this.myriMatchBrowse).addComponent(this.myriMatchLocationTxt, -2, -1, -2).addComponent(this.myriMatchLocationLabel)).addGap(0, 0, 0).addGroup(searchEnginesLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.enableMsAmandaCombo, -2, -1, -2).addComponent(this.msAmandaBrowse).addComponent(this.msAmandaLocationTxt, -2, -1, -2).addComponent(this.msAmandaLocationLabel)).addGap(0, 0, 0).addGroup(searchEnginesLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.msgfLocationLabel).addComponent(this.msgfLocationTxt, -2, -1, -2).addComponent(this.enableMsgfCombo, -2, -1, -2).addComponent(this.msgfBrowse)).addGap(0, 0, 0).addGroup(searchEnginesLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.enableOmssaCombo, -2, -1, -2).addComponent(this.omssaBrowse).addComponent(this.omssaLocationTxt, -2, -1, -2).addComponent(this.omssaLocationLabel)).addGap(0, 0, 0).addGroup(searchEnginesLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.enableCometCombo, -2, -1, -2).addComponent(this.cometBrowse).addComponent(this.cometLocationTxt, -2, -1, -2).addComponent(this.cometLocationLabel)).addGap(0, 0, 0).addGroup(searchEnginesLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.enableTideCombo, -2, -1, -2).addComponent(this.tideBrowse).addComponent(this.tideLocationTxt, -2, -1, -2).addComponent(this.tideLocationLabel)).addGap(0, 0, 0).addGroup(searchEnginesLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.enableAndromedaCombo, -2, -1, -2).addComponent(this.andromedaBrowse).addComponent(this.andromedaLocationTxt, -2, -1, -2).addComponent(this.andromedaLocationLabel)).addGap(0, 0, 0).addGroup(searchEnginesLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.enableMetaMorpheusCombo, -2, -1, -2).addComponent(this.metaMorpheusBrowse).addComponent(this.metaMorpheusLocationTxt, -2, -1, -2).addComponent(this.metaMorpheusLocationLabel)).addGap(0, 0, 0).addGroup(searchEnginesLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.enableSageCombo, -2, -1, -2).addComponent(this.sageBrowse).addComponent(this.sageLocationTxt, -2, -1, -2).addComponent(this.sageLocationLabel)).addGap(0, 0, 0).addGroup(searchEnginesLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.novorLocationLabel).addComponent(this.novorLocationTxt, -2, -1, -2).addComponent(this.novorBrowse).addComponent(this.enableNovorCombo, -2, -1, -2)).addGap(0, 0, 0).addGroup(searchEnginesLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.direcTagLocationLabel).addComponent(this.direcTagLocationTxt, -2, -1, -2).addComponent(this.direcTagBrowse).addComponent(this.enableDirecTagCombo, -2, -1, -2)).addGap(0, 0, 0).addGroup(searchEnginesLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.makeblastdbBrowse).addComponent(this.makeblastdbLocationTxt, -2, -1, -2).addComponent(this.makeblastdbLocationLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        searchEnginesLocationPanelLayout.linkSize(1, this.enableMsAmandaCombo, this.enableMsgfCombo, this.enableOmssaCombo, this.enableXTandemCombo, this.makeblastdbBrowse, this.msAmandaBrowse, this.msgfBrowse, this.omssaBrowse, this.xTandemBrowse);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoftwareLocationDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.searchEnginesLocationPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.searchEnginesLocationPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void omssaBrowseActionPerformed(ActionEvent evt) {
        this.browseOMSSALocationPressed();
    }

    private void xTandemBrowseActionPerformed(ActionEvent evt) {
        this.browseXTandemLocationPressed();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        boolean valid = this.validateInput(true);
        if (valid) {
            this.searchGUIMainFrame.getSearchHandler().setOmssaLocation(this.getOmssaLocation());
            this.searchGUIMainFrame.getSearchHandler().setXtandemLocation(this.getXtandemLocation());
            this.searchGUIMainFrame.getSearchHandler().setMsgfLocation(this.getMsgfLocation());
            this.searchGUIMainFrame.getSearchHandler().setMsAmandaLocation(this.getMsAmandaLocation());
            this.searchGUIMainFrame.getSearchHandler().setMyriMatchLocation(this.getMyriMatchLocation());
            this.searchGUIMainFrame.getSearchHandler().setCometLocation(this.getCometLocation());
            this.searchGUIMainFrame.getSearchHandler().setTideLocation(this.getTideLocation());
            this.searchGUIMainFrame.getSearchHandler().setAndromedaLocation(this.getAndromedaLocation());
            this.searchGUIMainFrame.getSearchHandler().setMetaMorpheusLocation(this.getMetaMorpheusLocation());
            this.searchGUIMainFrame.getSearchHandler().setSageLocation(this.getSageLocation());
            this.searchGUIMainFrame.getSearchHandler().setNovorLocation(this.getNovorLocation());
            this.searchGUIMainFrame.getSearchHandler().setDirecTagLocation(this.getDirecTagLocation());
            this.searchGUIMainFrame.getSearchHandler().setMakeblastdbLocation(this.getMakeblastdbLocation());
            this.searchGUIMainFrame.enableSearchEngines(this.enableOmssaCombo.getSelectedIndex() == 0, this.enableXTandemCombo.getSelectedIndex() == 0, this.enableMsgfCombo.getSelectedIndex() == 0, this.enableMsAmandaCombo.getSelectedIndex() == 0, this.enableMyriMatchCombo.getSelectedIndex() == 0, this.enableCometCombo.getSelectedIndex() == 0, this.enableTideCombo.getSelectedIndex() == 0, this.enableAndromedaCombo.getSelectedIndex() == 0, this.enableMetaMorpheusCombo.getSelectedIndex() == 0, this.enableSageCombo.getSelectedIndex() == 0, this.enableNovorCombo.getSelectedIndex() == 0, this.enableDirecTagCombo.getSelectedIndex() == 0);
            this.dispose();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.searchGUIMainFrame.enableSearchEngines(this.enableOmssaCombo.getSelectedIndex() == 0 && this.omssaValid, this.enableXTandemCombo.getSelectedIndex() == 0 && this.tandemValid, this.enableMsgfCombo.getSelectedIndex() == 0 && this.msgfValid, this.enableMsAmandaCombo.getSelectedIndex() == 0 && this.msAmandaValid, this.enableMyriMatchCombo.getSelectedIndex() == 0 && this.myriMatchValid, this.enableCometCombo.getSelectedIndex() == 0 && this.cometValid, this.enableTideCombo.getSelectedIndex() == 0 && this.tideValid, this.enableAndromedaCombo.getSelectedIndex() == 0 && this.andromedaValid, this.enableMetaMorpheusCombo.getSelectedIndex() == 0 && this.metaMorpheusValid, this.enableSageCombo.getSelectedIndex() == 0 && this.sageValid, this.enableNovorCombo.getSelectedIndex() == 0 && this.novorValid, this.enableDirecTagCombo.getSelectedIndex() == 0 && this.direcTagValid);
        this.dispose();
    }

    private void enableOmssaComboActionPerformed(ActionEvent evt) {
        if (this.guiLoaded) {
            this.validateInput(true);
        }
    }

    private void enableXTandemComboActionPerformed(ActionEvent evt) {
        if (this.guiLoaded) {
            this.validateInput(true);
        }
    }

    private void msgfBrowseActionPerformed(ActionEvent evt) {
        this.browseMsgfLocationPressed();
    }

    private void enableMsgfComboActionPerformed(ActionEvent evt) {
        if (this.guiLoaded) {
            this.validateInput(true);
        }
    }

    private void msAmandaBrowseActionPerformed(ActionEvent evt) {
        this.browseMsAmandaLocationPressed();
    }

    private void enableMsAmandaComboActionPerformed(ActionEvent evt) {
        if (this.guiLoaded) {
            this.validateInput(true);
        }
    }

    private void makeblastdbBrowseActionPerformed(ActionEvent evt) {
        File temp;
        File startLocation = new File(this.searchGUIMainFrame.getLastSelectedFolder().getLastSelectedFolder());
        if (this.makeblastdbLocationTxt != null && this.makeblastdbLocationTxt.getText() != null && !this.makeblastdbLocationTxt.getText().trim().equals("") && (temp = new File(this.makeblastdbLocationTxt.getText())).exists() && temp.isDirectory()) {
            startLocation = temp;
        }
        JFileChooser fc = new JFileChooser(startLocation);
        fc.setFileSelectionMode(1);
        int result = fc.showOpenDialog(this);
        if (result == 0) {
            File file = fc.getSelectedFile();
            this.searchGUIMainFrame.getLastSelectedFolder().setLastSelectedFolder(file.getAbsolutePath());
            if (this.validateSearchEngineFolder(file, "makeblastdb")) {
                this.makeblastdbLocationTxt.setText(file.getAbsolutePath());
            } else {
                JOptionPane.showMessageDialog(this, new String[]{"Incorrect makeblastdb folder specified.", "Please try again, or press cancel to exit."}, "Incorrect makeblastdb Folder", 2);
                this.makeblastdbBrowseActionPerformed(null);
            }
            this.validateInput(true);
        }
    }

    private void myriMatchBrowseActionPerformed(ActionEvent evt) {
        this.browseMyriMatchLocationPressed();
    }

    private void enableMyriMatchComboActionPerformed(ActionEvent evt) {
        if (this.guiLoaded) {
            this.validateInput(true);
        }
    }

    private void cometBrowseActionPerformed(ActionEvent evt) {
        this.browseCometLocationPressed();
    }

    private void enableCometComboActionPerformed(ActionEvent evt) {
        if (this.guiLoaded) {
            this.validateInput(true);
        }
    }

    private void tideBrowseActionPerformed(ActionEvent evt) {
        this.browseTideLocationPressed();
    }

    private void enableTideComboActionPerformed(ActionEvent evt) {
        if (this.guiLoaded) {
            this.validateInput(true);
        }
    }

    private void andromedaBrowseActionPerformed(ActionEvent evt) {
        this.browseAndromedaLocationPressed();
    }

    private void enableAndromedaComboActionPerformed(ActionEvent evt) {
        if (this.guiLoaded) {
            this.validateInput(true);
        }
    }

    private void novorBrowseActionPerformed(ActionEvent evt) {
        this.browseNovorLocationPressed();
    }

    private void enableNovorComboActionPerformed(ActionEvent evt) {
        if (this.guiLoaded) {
            this.validateInput(true);
        }
    }

    private void direcTagBrowseActionPerformed(ActionEvent evt) {
        this.browseDirecTagLocationPressed();
    }

    private void enableDirecTagComboActionPerformed(ActionEvent evt) {
        if (this.guiLoaded) {
            this.validateInput(true);
        }
    }

    private void metaMorpheusBrowseActionPerformed(ActionEvent evt) {
        this.browseMetaMorpheusLocationPressed();
    }

    private void enableMetaMorpheusComboActionPerformed(ActionEvent evt) {
        if (this.guiLoaded) {
            this.validateInput(true);
        }
    }

    private void sageBrowseActionPerformed(ActionEvent evt) {
        this.browseSageLocationPressed();
    }

    private void enableSageComboActionPerformed(ActionEvent evt) {
        if (this.guiLoaded) {
            this.validateInput(true);
        }
    }

    public void browseOMSSALocationPressed() {
        this.browseSearchEngineLocationPressed(Advocate.omssa, "omssacl", this.omssaLocationTxt);
    }

    public void browseXTandemLocationPressed() {
        this.browseSearchEngineLocationPressed(Advocate.xtandem, "tandem", this.xTandemLocationTxt);
    }

    public void browseMsgfLocationPressed() {
        this.browseSearchEngineLocationPressed(Advocate.msgf, "MSGFPlus.jar", this.msgfLocationTxt);
    }

    public void browseMsAmandaLocationPressed() {
        this.browseSearchEngineLocationPressed(Advocate.msAmanda, "MSAmanda", this.msAmandaLocationTxt);
    }

    public void browseMyriMatchLocationPressed() {
        this.browseSearchEngineLocationPressed(Advocate.myriMatch, "myrimatch", this.myriMatchLocationTxt);
    }

    public void browseCometLocationPressed() {
        this.browseSearchEngineLocationPressed(Advocate.comet, "comet.exe", this.cometLocationTxt);
    }

    public void browseTideLocationPressed() {
        this.browseSearchEngineLocationPressed(Advocate.tide, "crux", this.tideLocationTxt);
    }

    public void browseAndromedaLocationPressed() {
        this.browseSearchEngineLocationPressed(Advocate.andromeda, "AndromedaCmd.exe", this.andromedaLocationTxt);
    }

    public void browseMetaMorpheusLocationPressed() {
        this.browseSearchEngineLocationPressed(Advocate.metaMorpheus, MetaMorpheusProcessBuilder.getExecutableFileName(false), this.metaMorpheusLocationTxt);
    }

    public void browseSageLocationPressed() {
        this.browseSearchEngineLocationPressed(Advocate.sage, SageProcessBuilder.getExecutableFileName(), this.sageLocationTxt);
    }

    public void browseNovorLocationPressed() {
        this.browseSearchEngineLocationPressed(Advocate.novor, "novor.jar", this.novorLocationTxt);
    }

    public void browseDirecTagLocationPressed() {
        this.browseSearchEngineLocationPressed(Advocate.direcTag, "directag", this.direcTagLocationTxt);
    }

    public void browseSearchEngineLocationPressed(Advocate advocate, String firstTargetName, JTextField searchEngineLocationTxt) {
        this.browseSearchEngineLocationPressed(advocate, firstTargetName, null, searchEngineLocationTxt);
    }

    public void browseSearchEngineLocationPressed(Advocate advocate, String firstTargetName, String secondTargetName, JTextField searchEngineLocationTxt) {
        File temp;
        File startLocation = new File(this.searchGUIMainFrame.getLastSelectedFolder().getLastSelectedFolder());
        if (searchEngineLocationTxt != null && searchEngineLocationTxt.getText() != null && !searchEngineLocationTxt.getText().trim().equals("") && (temp = new File(searchEngineLocationTxt.getText())).exists() && temp.isDirectory()) {
            startLocation = temp;
        }
        JFileChooser fc = new JFileChooser(startLocation);
        fc.setFileSelectionMode(1);
        int result = fc.showOpenDialog(this);
        if (result == 0) {
            File file = fc.getSelectedFile();
            this.searchGUIMainFrame.getLastSelectedFolder().setLastSelectedFolder(file.getAbsolutePath());
            if (this.validateSearchEngineFolder(file, firstTargetName, secondTargetName)) {
                searchEngineLocationTxt.setText(file.getAbsolutePath());
            } else {
                JOptionPane.showMessageDialog(this, new String[]{"Incorrect " + advocate + " home folder specified.", "Please try again, or press cancel to exit."}, "Incorrect " + advocate + " Folder", 2);
                this.browseSearchEngineLocationPressed(advocate, firstTargetName, secondTargetName, searchEngineLocationTxt);
            }
            this.validateInput(true);
        }
    }

    public boolean validateSearchEngineFolder(File aFile, String targetFile) {
        return this.validateSearchEngineFolder(aFile, targetFile, null);
    }

    public boolean validateSearchEngineFolder(File aFile, String targetFile, String secondTargetFile) {
        boolean result = false;
        if (aFile.exists() && aFile.isDirectory()) {
            String[] fileNames = aFile.list();
            int count = 0;
            for (String lFileName : fileNames) {
                if (lFileName.startsWith(targetFile)) {
                    ++count;
                    continue;
                }
                if (secondTargetFile == null || !lFileName.startsWith(secondTargetFile)) continue;
                ++count;
            }
            if (count > 0) {
                result = true;
            }
        }
        return result;
    }

    private boolean validateInput(boolean showMessage) {
        boolean valid = true;
        this.makeblastdbLocationLabel.setEnabled(this.enableOmssaCombo.getSelectedIndex() == 0);
        this.makeblastdbLocationTxt.setEnabled(this.enableOmssaCombo.getSelectedIndex() == 0);
        this.makeblastdbBrowse.setEnabled(this.enableOmssaCombo.getSelectedIndex() == 0);
        this.omssaLocationLabel.setForeground(Color.BLACK);
        this.xTandemLocationLabel.setForeground(Color.BLACK);
        this.msgfLocationLabel.setForeground(Color.BLACK);
        this.msAmandaLocationLabel.setForeground(Color.BLACK);
        this.myriMatchLocationLabel.setForeground(Color.BLACK);
        this.cometLocationTxt.setForeground(Color.BLACK);
        this.tideLocationTxt.setForeground(Color.BLACK);
        this.andromedaLocationTxt.setForeground(Color.BLACK);
        this.metaMorpheusLocationTxt.setForeground(Color.BLACK);
        this.sageLocationTxt.setForeground(Color.BLACK);
        this.novorLocationTxt.setForeground(Color.BLACK);
        this.direcTagLocationTxt.setForeground(Color.BLACK);
        this.omssaLocationLabel.setToolTipText(null);
        this.xTandemLocationLabel.setToolTipText(null);
        this.msgfLocationLabel.setToolTipText(null);
        this.msAmandaLocationLabel.setToolTipText(null);
        this.myriMatchLocationLabel.setToolTipText(null);
        this.cometLocationLabel.setToolTipText(null);
        this.tideLocationLabel.setToolTipText(null);
        this.andromedaLocationLabel.setToolTipText(null);
        this.metaMorpheusLocationLabel.setToolTipText(null);
        this.sageLocationLabel.setToolTipText(null);
        this.novorLocationLabel.setToolTipText(null);
        this.direcTagLocationLabel.setToolTipText(null);
        this.omssaValid = true;
        this.tandemValid = true;
        this.msgfValid = true;
        this.msAmandaValid = true;
        this.myriMatchValid = true;
        this.cometValid = true;
        this.tideValid = true;
        this.andromedaValid = true;
        this.metaMorpheusValid = true;
        this.sageValid = true;
        this.novorValid = true;
        this.direcTagValid = true;
        if (this.isOmssaEnabled()) {
            this.omssaValid = this.validateSearchEngineInstallation(Advocate.omssa, this.getOmssaLocation(), valid, this.omssaLocationLabel, showMessage);
            boolean bl = valid = this.omssaValid && valid;
        }
        if (this.isXtandemEnabled()) {
            this.tandemValid = this.validateSearchEngineInstallation(Advocate.xtandem, this.getXtandemLocation(), valid, this.xTandemLocationLabel, showMessage);
            boolean bl = valid = this.tandemValid && valid;
        }
        if (this.isMsgfEnabled()) {
            this.msgfValid = this.validateSearchEngineInstallation(Advocate.msgf, this.getMsgfLocation(), valid, this.msgfLocationLabel, showMessage);
            boolean bl = valid = this.msgfValid && valid;
        }
        if (this.isMsAmandaEnabled()) {
            this.msAmandaValid = this.validateSearchEngineInstallation(Advocate.msAmanda, this.getMsAmandaLocation(), valid, this.msAmandaLocationLabel, showMessage);
            boolean bl = valid = this.msAmandaValid && valid;
        }
        if (this.isMyriMatchEnabled()) {
            this.myriMatchValid = this.validateSearchEngineInstallation(Advocate.myriMatch, this.getMyriMatchLocation(), valid, this.myriMatchLocationLabel, showMessage);
            boolean bl = valid = this.myriMatchValid && valid;
        }
        if (this.isCometEnabled()) {
            this.cometValid = this.validateSearchEngineInstallation(Advocate.comet, this.getCometLocation(), valid, this.cometLocationLabel, showMessage);
            boolean bl = valid = this.cometValid && valid;
        }
        if (this.isTideEnabled()) {
            this.tideValid = this.validateSearchEngineInstallation(Advocate.tide, this.getTideLocation(), valid, this.tideLocationLabel, showMessage);
            boolean bl = valid = this.tideValid && valid;
        }
        if (this.isAndromedaEnabled()) {
            this.andromedaValid = this.validateSearchEngineInstallation(Advocate.andromeda, this.getAndromedaLocation(), valid, this.andromedaLocationLabel, showMessage);
            boolean bl = valid = this.andromedaValid && valid;
        }
        if (this.isMetaMorpheusEnabled()) {
            this.metaMorpheusValid = this.validateSearchEngineInstallation(Advocate.metaMorpheus, this.getMetaMorpheusLocation(), valid, this.metaMorpheusLocationLabel, showMessage);
            boolean bl = valid = this.metaMorpheusValid && valid;
        }
        if (this.isSageEnabled()) {
            this.sageValid = this.validateSearchEngineInstallation(Advocate.sage, this.getSageLocation(), valid, this.sageLocationLabel, showMessage);
            boolean bl = valid = this.sageValid && valid;
        }
        if (this.isNovorEnabled()) {
            this.novorValid = this.validateSearchEngineInstallation(Advocate.novor, this.getNovorLocation(), valid, this.novorLocationLabel, showMessage);
            boolean bl = valid = this.novorValid && valid;
        }
        if (this.isDirecTagEnabled()) {
            this.direcTagValid = this.validateSearchEngineInstallation(Advocate.direcTag, this.getDirecTagLocation(), valid, this.direcTagLocationLabel, showMessage);
            valid = this.direcTagValid && valid;
        }
        this.okButton.setEnabled(valid);
        return valid;
    }

    private boolean validateSearchEngineInstallation(Advocate advocate, File searchEngineLocation, boolean allValid, JLabel searchEngineLabel, boolean showMessage) {
        boolean searchEngineValid = true;
        boolean installationOk = false;
        if (searchEngineLocation == null) {
            if (showMessage && allValid) {
                JOptionPane.showMessageDialog(this, "You need to specify the location of " + advocate + ".", advocate + " Not Found", 2);
            }
            allValid = false;
            searchEngineValid = false;
            searchEngineLabel.setToolTipText("Please specify the location of " + advocate);
            searchEngineLabel.setForeground(Color.RED);
        } else if (!searchEngineLocation.exists()) {
            if (showMessage && allValid) {
                JOptionPane.showMessageDialog(this, "The " + advocate + " folder does not exist. Please specify the location of " + advocate + ".", advocate + " Not Found", 2);
            }
            allValid = false;
            searchEngineValid = false;
            searchEngineLabel.setToolTipText("Please specify the location of " + advocate);
            searchEngineLabel.setForeground(Color.RED);
        } else if (allValid) {
            if (advocate == Advocate.tide) {
                installationOk = SearchGUI.validateSearchEngineInstallation(Advocate.tide, this.getTideLocation(), showMessage);
            } else if (advocate == Advocate.comet) {
                installationOk = SearchGUI.validateSearchEngineInstallation(Advocate.comet, this.getCometLocation(), showMessage);
            } else if (advocate == Advocate.myriMatch) {
                installationOk = SearchGUI.validateSearchEngineInstallation(Advocate.myriMatch, this.getMyriMatchLocation(), showMessage);
            } else if (advocate == Advocate.msAmanda) {
                installationOk = SearchGUI.validateSearchEngineInstallation(Advocate.msAmanda, this.getMsAmandaLocation(), showMessage);
            } else if (advocate == Advocate.msgf) {
                installationOk = SearchGUI.validateSearchEngineInstallation(Advocate.msgf, this.getMsgfLocation(), showMessage);
            } else if (advocate == Advocate.xtandem) {
                installationOk = SearchGUI.validateSearchEngineInstallation(Advocate.xtandem, this.getXtandemLocation(), showMessage);
            } else if (advocate == Advocate.omssa) {
                installationOk = SearchGUI.validateSearchEngineInstallation(Advocate.omssa, this.getOmssaLocation(), showMessage);
            } else if (advocate == Advocate.andromeda) {
                installationOk = SearchGUI.validateSearchEngineInstallation(Advocate.andromeda, this.getAndromedaLocation(), showMessage);
            } else if (advocate == Advocate.metaMorpheus) {
                installationOk = SearchGUI.validateSearchEngineInstallation(Advocate.metaMorpheus, this.getMetaMorpheusLocation(), showMessage);
            } else if (advocate == Advocate.sage) {
                installationOk = SearchGUI.validateSearchEngineInstallation(Advocate.sage, this.getSageLocation(), showMessage);
            } else if (advocate == Advocate.novor) {
                installationOk = SearchGUI.validateSearchEngineInstallation(Advocate.novor, this.getNovorLocation(), showMessage);
            } else if (advocate == Advocate.direcTag) {
                installationOk = SearchGUI.validateSearchEngineInstallation(Advocate.direcTag, this.getDirecTagLocation(), showMessage);
            }
            if (!installationOk) {
                allValid = false;
                searchEngineValid = false;
                searchEngineLabel.setToolTipText("Failed to run " + advocate);
                searchEngineLabel.setForeground(Color.RED);
            }
        }
        this.okButton.setEnabled(installationOk);
        return searchEngineValid;
    }

    public boolean isOmssaEnabled() {
        return ((String)this.enableOmssaCombo.getSelectedItem()).equals(ENABLED_DISABLED[0]);
    }

    public boolean isXtandemEnabled() {
        return ((String)this.enableXTandemCombo.getSelectedItem()).equals(ENABLED_DISABLED[0]);
    }

    public boolean isMsgfEnabled() {
        return ((String)this.enableMsgfCombo.getSelectedItem()).equals(ENABLED_DISABLED[0]);
    }

    public boolean isMsAmandaEnabled() {
        return ((String)this.enableMsAmandaCombo.getSelectedItem()).equals(ENABLED_DISABLED[0]);
    }

    public boolean isMyriMatchEnabled() {
        return ((String)this.enableMyriMatchCombo.getSelectedItem()).equals(ENABLED_DISABLED[0]);
    }

    public boolean isCometEnabled() {
        return ((String)this.enableCometCombo.getSelectedItem()).equals(ENABLED_DISABLED[0]);
    }

    public boolean isTideEnabled() {
        return ((String)this.enableTideCombo.getSelectedItem()).equals(ENABLED_DISABLED[0]);
    }

    public boolean isAndromedaEnabled() {
        return ((String)this.enableAndromedaCombo.getSelectedItem()).equals(ENABLED_DISABLED[0]);
    }

    public boolean isMetaMorpheusEnabled() {
        return ((String)this.enableMetaMorpheusCombo.getSelectedItem()).equals(ENABLED_DISABLED[0]);
    }

    public boolean isSageEnabled() {
        return ((String)this.enableSageCombo.getSelectedItem()).equals(ENABLED_DISABLED[0]);
    }

    public boolean isNovorEnabled() {
        return ((String)this.enableNovorCombo.getSelectedItem()).equals(ENABLED_DISABLED[0]);
    }

    public boolean isDirecTagEnabled() {
        return ((String)this.enableDirecTagCombo.getSelectedItem()).equals(ENABLED_DISABLED[0]);
    }

    public File getOmssaLocation() {
        if (this.omssaLocationTxt.getText() != null) {
            return new File(this.omssaLocationTxt.getText());
        }
        return null;
    }

    public File getXtandemLocation() {
        if (this.xTandemLocationTxt.getText() != null) {
            return new File(this.xTandemLocationTxt.getText());
        }
        return null;
    }

    public File getMsgfLocation() {
        if (this.msgfLocationTxt.getText() != null) {
            return new File(this.msgfLocationTxt.getText());
        }
        return null;
    }

    public File getMsAmandaLocation() {
        if (this.msAmandaLocationTxt.getText() != null) {
            return new File(this.msAmandaLocationTxt.getText());
        }
        return null;
    }

    public File getMyriMatchLocation() {
        if (this.myriMatchLocationTxt.getText() != null) {
            return new File(this.myriMatchLocationTxt.getText());
        }
        return null;
    }

    public File getCometLocation() {
        if (this.cometLocationTxt.getText() != null) {
            return new File(this.cometLocationTxt.getText());
        }
        return null;
    }

    public File getTideLocation() {
        if (this.tideLocationTxt.getText() != null) {
            return new File(this.tideLocationTxt.getText());
        }
        return null;
    }

    public File getAndromedaLocation() {
        if (this.andromedaLocationTxt.getText() != null) {
            return new File(this.andromedaLocationTxt.getText());
        }
        return null;
    }

    public File getMetaMorpheusLocation() {
        if (this.metaMorpheusLocationTxt.getText() != null) {
            return new File(this.metaMorpheusLocationTxt.getText());
        }
        return null;
    }

    public File getSageLocation() {
        if (this.sageLocationTxt.getText() != null) {
            return new File(this.sageLocationTxt.getText());
        }
        return null;
    }

    public File getNovorLocation() {
        if (this.novorLocationTxt.getText() != null) {
            return new File(this.novorLocationTxt.getText());
        }
        return null;
    }

    public File getDirecTagLocation() {
        if (this.direcTagLocationTxt.getText() != null) {
            return new File(this.direcTagLocationTxt.getText());
        }
        return null;
    }

    public File getMakeblastdbLocation() {
        if (this.makeblastdbLocationTxt.getText() != null) {
            return new File(this.makeblastdbLocationTxt.getText());
        }
        return null;
    }
}

