/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.parameters;

import com.compomics.software.CompomicsWrapper;
import com.compomics.software.settings.PathKey;
import com.compomics.software.settings.UtilitiesPathParameters;
import com.compomics.util.experiment.io.mass_spectrometry.cms.CmsFolder;
import com.compomics.util.io.flat.SimpleFileReader;
import com.compomics.util.io.flat.SimpleFileWriter;
import eu.isas.searchgui.SearchHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

public class SearchGUIPathParameters {
    public static void loadPathParametersFromFile(File inputFile) throws FileNotFoundException, IOException {
        try (SimpleFileReader reader = SimpleFileReader.getFileReader((File)inputFile);){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).equals("") || line.startsWith("#")) continue;
                SearchGUIPathParameters.loadPathParameterFromLine(line);
            }
        }
    }

    public static void loadPathParameterFromLine(String line) throws FileNotFoundException {
        String id = UtilitiesPathParameters.getPathID((String)line);
        if (id.equals("")) {
            throw new IllegalArgumentException("Impossible to parse path in " + line + ".");
        }
        SearchGUIPathKey searchGUIPathKey = SearchGUIPathKey.getKeyFromId(id);
        if (searchGUIPathKey == null) {
            UtilitiesPathParameters.loadPathParameterFromLine((String)line);
        } else {
            String path = UtilitiesPathParameters.getPath((String)line);
            if (!path.equals("default")) {
                File file = new File(path);
                if (!file.exists()) {
                    throw new FileNotFoundException("File " + path + " not found.");
                }
                if (searchGUIPathKey.isDirectory && !file.isDirectory()) {
                    throw new FileNotFoundException("Found a file when expecting a directory for " + searchGUIPathKey.id + ".");
                }
                SearchGUIPathParameters.setPathParameter(searchGUIPathKey, path);
            }
        }
    }

    public static void setPathParameter(SearchGUIPathKey searchGUIPathKey, String path) {
        switch (searchGUIPathKey.ordinal()) {
            case 0: {
                SearchHandler.setTempFolderPath(path);
                break;
            }
            case 1: {
                SearchHandler.setTempSearchEngineFolderPath(path);
                break;
            }
            case 2: {
                CmsFolder.setParentFolder((String)path);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Path " + searchGUIPathKey.id + " not implemented.");
            }
        }
    }

    public static void setPathParameter(PathKey pathKey, String path) {
        if (pathKey instanceof SearchGUIPathKey) {
            SearchGUIPathParameters.setPathParameter((SearchGUIPathKey)pathKey, path);
        } else if (pathKey instanceof UtilitiesPathParameters.UtilitiesPathKey) {
            UtilitiesPathParameters.UtilitiesPathKey utilitiesPathKey = (UtilitiesPathParameters.UtilitiesPathKey)pathKey;
            UtilitiesPathParameters.setPathParameter((UtilitiesPathParameters.UtilitiesPathKey)utilitiesPathKey, (String)path);
        } else {
            throw new UnsupportedOperationException("Path " + pathKey.getId() + " not implemented.");
        }
    }

    public static String getPathParameter(SearchGUIPathKey searchGUIPathKey, File configFolder) {
        switch (searchGUIPathKey.ordinal()) {
            case 0: {
                return SearchHandler.getTempFolderPath(configFolder);
            }
            case 1: {
                return SearchHandler.getTempSearchEngineFolderPath(configFolder);
            }
            case 2: {
                return CmsFolder.getParentFolder();
            }
        }
        throw new UnsupportedOperationException("Path " + searchGUIPathKey.id + " not implemented.");
    }

    public static void setAllPathsIn(String path) throws FileNotFoundException {
        for (SearchGUIPathKey searchGUIPathKey : SearchGUIPathKey.values()) {
            String subDirectory = searchGUIPathKey.defaultSubDirectory;
            File newFile = new File(path, subDirectory);
            if (!newFile.exists()) {
                newFile.mkdirs();
            }
            if (!newFile.exists()) {
                throw new FileNotFoundException(newFile.getAbsolutePath() + " could not be created.");
            }
            SearchGUIPathParameters.setPathParameter(searchGUIPathKey, newFile.getAbsolutePath());
        }
        UtilitiesPathParameters.setAllPathsIn((String)path);
    }

    public static void writeConfigurationToFile(File file, File configFolder) throws IOException {
        try (SimpleFileWriter writer = new SimpleFileWriter(file, false);){
            SearchGUIPathParameters.writeConfigurationToFile(writer, configFolder);
        }
    }

    public static void writeConfigurationToFile(SimpleFileWriter writer, File configFolder) throws IOException {
        for (SearchGUIPathKey pathKey : SearchGUIPathKey.values()) {
            SearchGUIPathParameters.writePathToFile(writer, pathKey, configFolder);
        }
        UtilitiesPathParameters.writeConfigurationToFile((BufferedWriter)writer.getWriter());
    }

    public static void writePathToFile(SimpleFileWriter writer, SearchGUIPathKey pathKey, File configFolder) throws IOException {
        writer.write(pathKey.id + "=");
        switch (pathKey.ordinal()) {
            case 0: {
                String toWrite = SearchHandler.getTempFolderPath(configFolder);
                if (toWrite == null) {
                    toWrite = "default";
                }
                writer.write(toWrite);
                break;
            }
            case 1: {
                String toWrite = SearchHandler.getTempSearchEngineFolderPath(configFolder);
                if (toWrite == null) {
                    toWrite = "default";
                }
                writer.write(toWrite);
                break;
            }
            case 2: {
                String toWrite = CmsFolder.getParentFolder();
                if (toWrite == null) {
                    toWrite = "default";
                }
                writer.write(toWrite);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Path " + pathKey.id + " not implemented.");
            }
        }
        writer.newLine();
    }

    public static ArrayList<PathKey> getErrorKeys(File configFolder) throws IOException {
        ArrayList<PathKey> result = new ArrayList<PathKey>();
        for (SearchGUIPathKey pathKey : SearchGUIPathKey.values()) {
            String folder = SearchGUIPathParameters.getPathParameter(pathKey, configFolder);
            if (folder == null || UtilitiesPathParameters.testPath((String)folder)) continue;
            result.add(pathKey);
        }
        result.addAll(UtilitiesPathParameters.getErrorKeys());
        return result;
    }

    public String getJarFilePath() {
        return CompomicsWrapper.getJarFilePath((String)this.getClass().getResource("SearchGUIPathPreferences.class").getPath(), (String)"SearchGUI");
    }

    public static enum SearchGUIPathKey implements PathKey
    {
        tempDirectory("searchgui_temp", "Folder where SearchGUI temporary files are stored.", "", true),
        tempSearchEngineDirectory("search_engine_temp", "Folder where search engine temporary files are stored.", "", true),
        cmsFolder("cms", "Folder to use for cms files", "", true);

        private final String id;
        private final String description;
        private final String defaultSubDirectory;
        private final boolean isDirectory;

        private SearchGUIPathKey(String id, String description, String defaultSubDirectory, boolean isDirectory) {
            this.id = id;
            this.description = description;
            this.defaultSubDirectory = defaultSubDirectory;
            this.isDirectory = isDirectory;
        }

        public static SearchGUIPathKey getKeyFromId(String id) {
            for (SearchGUIPathKey pathKey : SearchGUIPathKey.values()) {
                if (!pathKey.id.equals(id)) continue;
                return pathKey;
            }
            return null;
        }

        public String getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

