/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.processbuilders;

import com.compomics.software.cli.CommandLineUtils;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.biology.enzymes.EnzymeFactory;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.modifications.ModificationType;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.identification.tool_specific.MsAmandaParameters;
import com.compomics.util.pride.CvTerm;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.processbuilders.SearchGUIProcessBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class MsAmandaProcessBuilder
extends SearchGUIProcessBuilder {
    private final String SETTINGS_FILE = "settings_SearchGUI.xml";
    private final String ENZYMES_FILE = "enzymes_SearchGUI.xml";
    private final String INSTRUMENTS_FILE = "instruments_SearchGUI.xml";
    private final String UNIMOD_FILE = "unimod.xml";
    private final String UNIMOD_OBO_FILE = "unimod.obo";
    private final String PSI_MS_OBO_FILE = "psi-ms.obo";
    private File msAmandaFolder;
    public static final String EXECUTABLE_FILE_NAME = "MSAmanda";
    private File database;
    private File spectrumFile;
    private Double fragmentMassError;
    private Double precursorMassError;
    private String precursorUnit;
    private String fragmentUnit;
    private int minCharge;
    private int maxCharge;
    private int missedCleavages;
    private String instrument;
    private ModificationFactory modificationFactory = ModificationFactory.getInstance();
    private String modificationsAsString;
    private String enzymeName;
    private String enzymeSpecificity;
    private int maxRank;
    private boolean monoisotopic = true;
    private boolean generateDecoys;
    private boolean reportBothBestHitsForTD;
    private Boolean lowMemoryMode = true;
    private Boolean performDeisotoping = true;
    private Integer maxModifications = 3;
    private Integer maxVariableModifications = 4;
    private Integer maxModificationSites = 6;
    private Integer maxNeutralLosses = 1;
    private Integer maxNeutralLossesPerModification = 2;
    private Integer minPeptideLength = 6;
    private Integer maxPeptideLength = 30;
    private Integer maxLoadedProteins = 100000;
    private Integer maxLoadedSpectra = 2000;
    private String maxAllowedChargeState = "+2";
    private Integer minPeakDepth = 1;
    private Integer maxPeakDepth = 10;
    private Boolean performSecondSearch = false;
    private Boolean keepY1Ion = true;
    private Boolean removeWaterLosses = true;
    private Boolean removeAmmoniaLosses = true;
    private Boolean excludeFirstPrecursor = true;
    private Integer maxMultiplePrecursors = 5;
    private String consideredChargesForPrecursors = "+2,+3";
    private Boolean combineConsideredCharges = true;
    private Boolean runPercolator = false;
    private Boolean generatePInFile = false;
    private File msAmandaTempFolder;
    private MsAmandaParameters msAmandaParameters;

    public MsAmandaProcessBuilder(File msAmandaDirectory, File msAmandaTempFolder, File mgfFile, File fastaFile, String outputPath, SearchParameters searchParameters, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler, int nThreads) throws IOException {
        this.waitingHandler = waitingHandler;
        this.exceptionHandler = exceptionHandler;
        this.msAmandaParameters = (MsAmandaParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.msAmanda.getIndex());
        this.msAmandaFolder = msAmandaDirectory;
        this.msAmandaTempFolder = msAmandaTempFolder;
        this.spectrumFile = mgfFile;
        this.database = fastaFile.getAbsoluteFile();
        if (!msAmandaTempFolder.exists()) {
            msAmandaTempFolder.mkdirs();
        }
        this.maxRank = this.msAmandaParameters.getMaxRank();
        this.generateDecoys = this.msAmandaParameters.generateDecoy();
        this.reportBothBestHitsForTD = this.msAmandaParameters.reportBothBestHitsForTD();
        this.monoisotopic = this.msAmandaParameters.isMonoIsotopic();
        this.performDeisotoping = this.msAmandaParameters.isPerformDeisotoping();
        this.maxModifications = this.msAmandaParameters.getMaxModifications();
        this.maxVariableModifications = this.msAmandaParameters.getMaxVariableModifications();
        this.maxModificationSites = this.msAmandaParameters.getMaxModificationSites();
        this.maxNeutralLosses = this.msAmandaParameters.getMaxNeutralLosses();
        this.maxNeutralLossesPerModification = this.msAmandaParameters.getMaxNeutralLossesPerModification();
        this.minPeptideLength = this.msAmandaParameters.getMinPeptideLength();
        this.maxPeptideLength = this.msAmandaParameters.getMaxPeptideLength();
        this.maxLoadedProteins = this.msAmandaParameters.getMaxLoadedProteins();
        this.maxLoadedSpectra = this.msAmandaParameters.getMaxLoadedSpectra();
        this.maxAllowedChargeState = this.msAmandaParameters.getMaxAllowedChargeState();
        this.minPeakDepth = this.msAmandaParameters.getMinPeakDepth();
        this.maxPeakDepth = this.msAmandaParameters.getMaxPeakDepth();
        this.performSecondSearch = this.msAmandaParameters.getPerformSecondSearch();
        this.keepY1Ion = this.msAmandaParameters.getKeepY1Ion();
        this.removeWaterLosses = this.msAmandaParameters.getRemoveWaterLosses();
        this.removeAmmoniaLosses = this.msAmandaParameters.getRemoveAmmoniaLosses();
        this.excludeFirstPrecursor = this.msAmandaParameters.getExcludeFirstPrecursor();
        this.maxMultiplePrecursors = this.msAmandaParameters.getMaxMultiplePrecursors();
        this.consideredChargesForPrecursors = this.msAmandaParameters.getConsideredChargesForPrecursors();
        this.combineConsideredCharges = this.msAmandaParameters.getCombineConsideredCharges();
        this.runPercolator = this.msAmandaParameters.getRunPercolator();
        this.generatePInFile = this.msAmandaParameters.getGeneratePInFile();
        this.fragmentMassError = searchParameters.getFragmentIonAccuracy();
        this.precursorMassError = searchParameters.getPrecursorAccuracy();
        if (searchParameters.getPrecursorAccuracyType() == SearchParameters.MassAccuracyType.PPM) {
            this.precursorUnit = "ppm";
        } else if (searchParameters.getPrecursorAccuracyType() == SearchParameters.MassAccuracyType.DA) {
            this.precursorUnit = "Da";
        }
        if (searchParameters.getFragmentAccuracyType() == SearchParameters.MassAccuracyType.PPM) {
            this.fragmentUnit = "ppm";
        } else if (searchParameters.getFragmentAccuracyType() == SearchParameters.MassAccuracyType.DA) {
            this.fragmentUnit = "Da";
        }
        this.minCharge = searchParameters.getMinChargeSearched();
        this.maxCharge = searchParameters.getMaxChargeSearched();
        DigestionParameters digestionPreferences = searchParameters.getDigestionParameters();
        if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme) {
            if (digestionPreferences.getEnzymes().size() > 1) {
                throw new IOException("Multiple enzymes not supported by MS Amanda!");
            }
            Enzyme enzyme = (Enzyme)digestionPreferences.getEnzymes().get(0);
            this.enzymeName = enzyme.getName();
            DigestionParameters.Specificity specificity = digestionPreferences.getSpecificity(this.enzymeName);
            switch (specificity) {
                case specific: {
                    this.enzymeSpecificity = "FULL";
                    break;
                }
                case semiSpecific: {
                    this.enzymeSpecificity = "SEMI";
                    break;
                }
                case specificCTermOnly: {
                    this.enzymeSpecificity = "SEMI(C)";
                    break;
                }
                case specificNTermOnly: {
                    this.enzymeSpecificity = "SEMI(N)";
                    break;
                }
            }
            this.missedCleavages = digestionPreferences.getnMissedCleavages(this.enzymeName);
        } else if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.unSpecific) {
            this.enzymeName = digestionPreferences.getCleavageParameter().toString();
            this.enzymeSpecificity = "FULL";
            this.missedCleavages = 2;
        } else {
            this.enzymeName = digestionPreferences.getCleavageParameter().toString();
            this.enzymeSpecificity = "FULL";
            this.missedCleavages = 0;
        }
        this.modificationsAsString = this.getModificationsAsString(searchParameters.getModificationParameters());
        this.instrument = this.msAmandaParameters.getInstrumentID();
        this.createEnzymeFile();
        this.createSettingsFile();
        File msAmanda = new File(this.msAmandaFolder.getAbsolutePath() + File.separator + EXECUTABLE_FILE_NAME);
        msAmanda.setExecutable(true);
        this.process_name_array.add(msAmanda.getAbsolutePath());
        this.process_name_array.add("-s");
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument((File)this.spectrumFile));
        this.process_name_array.add("-d");
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument((File)this.database));
        this.process_name_array.add("-e");
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument((File)new File(msAmandaTempFolder, "settings_SearchGUI.xml")));
        this.process_name_array.add("-f");
        if (this.msAmandaParameters.getOutputFormat().equalsIgnoreCase("csv")) {
            this.process_name_array.add("1");
        } else {
            this.process_name_array.add("2");
        }
        this.process_name_array.add("-o");
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument((File)new File(outputPath)));
        this.process_name_array.trimToSize();
        System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "ms amanda command: ");
        for (Object processElement : this.process_name_array) {
            System.out.print(processElement + " ");
        }
        System.out.println(System.getProperty("line.separator"));
        this.pb = new ProcessBuilder(this.process_name_array);
        this.pb.directory(msAmandaDirectory);
        this.pb.redirectErrorStream(true);
    }

    private void createEnzymeFile() {
        File enzymeFile = new File(this.msAmandaTempFolder, "enzymes_SearchGUI.xml");
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(enzymeFile));
            bw.write("<?xml version=\"1.0\" encoding=\"utf-8\" ?>" + System.getProperty("line.separator"));
            bw.write("<enzymes>" + System.getProperty("line.separator"));
            EnzymeFactory enzymeFactory = EnzymeFactory.getInstance();
            for (Enzyme enzyme : enzymeFactory.getEnzymes()) {
                String cleavageType;
                bw.write("  <enzyme>" + System.getProperty("line.separator"));
                bw.write("    <name>" + enzyme.getName() + "</name>" + System.getProperty("line.separator"));
                String cleavageSite = "";
                String restriction = "";
                if (enzyme.getAminoAcidBefore().isEmpty()) {
                    cleavageType = "before";
                    for (Character character : enzyme.getAminoAcidAfter()) {
                        cleavageSite = cleavageSite + character;
                    }
                    if (!enzyme.getRestrictionBefore().isEmpty()) {
                        restriction = "";
                        for (Character character : enzyme.getRestrictionBefore()) {
                            restriction = restriction + character;
                        }
                    }
                } else {
                    cleavageType = "after";
                    for (Character character : enzyme.getAminoAcidBefore()) {
                        cleavageSite = cleavageSite + character;
                    }
                    if (!enzyme.getRestrictionAfter().isEmpty()) {
                        restriction = "";
                        for (Character character : enzyme.getRestrictionAfter()) {
                            restriction = restriction + character;
                        }
                    }
                }
                bw.write("    <cleavage_sites>" + cleavageSite + "</cleavage_sites>" + System.getProperty("line.separator"));
                if (!restriction.isEmpty()) {
                    bw.write("    <inhibitors>" + restriction + "</inhibitors>" + System.getProperty("line.separator"));
                }
                bw.write("    <position>" + cleavageType + "</position>" + System.getProperty("line.separator"));
                bw.write("  </enzyme>" + System.getProperty("line.separator"));
            }
            bw.write("  <enzyme>" + System.getProperty("line.separator"));
            bw.write("    <name>" + DigestionParameters.CleavageParameter.wholeProtein + "</name>" + System.getProperty("line.separator"));
            bw.write("    <cleavage_sites></cleavage_sites>" + System.getProperty("line.separator"));
            bw.write("  </enzyme>" + System.getProperty("line.separator"));
            bw.write("  <enzyme>" + System.getProperty("line.separator"));
            bw.write("    <name>" + DigestionParameters.CleavageParameter.unSpecific + "</name>" + System.getProperty("line.separator"));
            bw.write("    <cleavage_sites>X</cleavage_sites>" + System.getProperty("line.separator"));
            bw.write("  </enzyme>" + System.getProperty("line.separator"));
            bw.write("</enzymes>" + System.getProperty("line.separator"));
            bw.flush();
            bw.close();
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Could not create MS Amanda enzyme file. Unable to write file: '" + ioe.getMessage() + "'!");
        }
    }

    private void createSettingsFile() throws IllegalArgumentException {
        File settingsFile = new File(this.msAmandaTempFolder, "settings_SearchGUI.xml");
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(settingsFile));
            bw.write("<?xml version=\"1.0\" encoding=\"utf-8\" ?>" + System.getProperty("line.separator") + "<settings>" + System.getProperty("line.separator") + "\t<search_settings>" + System.getProperty("line.separator") + "\t\t<enzyme specificity=\"" + this.enzymeSpecificity + "\">" + this.enzymeName + "</enzyme>" + System.getProperty("line.separator") + "\t\t<missed_cleavages>" + this.missedCleavages + "</missed_cleavages>" + System.getProperty("line.separator") + this.modificationsAsString + "\t\t<instrument>" + this.instrument + "</instrument>" + System.getProperty("line.separator") + "\t\t<ms1_tol unit=\"" + this.precursorUnit + "\">" + this.precursorMassError + "</ms1_tol> " + System.getProperty("line.separator") + "\t\t<ms2_tol unit=\"" + this.fragmentUnit + "\">" + this.fragmentMassError + "</ms2_tol> " + System.getProperty("line.separator") + "\t\t<max_rank>" + this.maxRank + "</max_rank> " + System.getProperty("line.separator") + "\t\t<generate_decoy>" + this.generateDecoys + "</generate_decoy> " + System.getProperty("line.separator") + "\t\t<PerformDeisotoping>" + this.performDeisotoping + "</PerformDeisotoping> " + System.getProperty("line.separator") + "\t\t<MaxNoModifs>" + this.maxModifications + "</MaxNoModifs> " + System.getProperty("line.separator") + "\t\t<MaxNoDynModifs>" + this.maxVariableModifications + "</MaxNoDynModifs> " + System.getProperty("line.separator") + "\t\t<MaxNumberModSites>" + this.maxModificationSites + "</MaxNumberModSites> " + System.getProperty("line.separator") + "\t\t<MaxNumberNeutralLoss>" + this.maxNeutralLosses + "</MaxNumberNeutralLoss> " + System.getProperty("line.separator") + "\t\t<MaxNumberNeutralLossModifications>" + this.maxNeutralLossesPerModification + "</MaxNumberNeutralLossModifications> " + System.getProperty("line.separator") + "\t\t<MinimumPepLength>" + this.minPeptideLength + "</MinimumPepLength> " + System.getProperty("line.separator") + "\t\t<MaximumPepLength>" + this.maxPeptideLength + "</MaximumPepLength> " + System.getProperty("line.separator") + "\t\t<ReportBothBestHitsForTD>" + this.reportBothBestHitsForTD + "</ReportBothBestHitsForTD> " + System.getProperty("line.separator") + "\t\t<MaxAllowedChargeState>" + this.maxAllowedChargeState + "</MaxAllowedChargeState> " + System.getProperty("line.separator") + "\t\t<MinimumPeakDepth>" + this.minPeakDepth + "</MinimumPeakDepth> " + System.getProperty("line.separator") + "\t\t<MaximumPeakDepth>" + this.maxPeakDepth + "</MaximumPeakDepth> " + System.getProperty("line.separator") + "\t</search_settings> " + System.getProperty("line.separator") + System.getProperty("line.separator") + "\t<second_search_settings> " + System.getProperty("line.separator") + "\t\t<PerformSecondSearch>" + this.performSecondSearch + "</PerformSecondSearch> " + System.getProperty("line.separator") + "\t\t<KeepY1Ion>" + this.keepY1Ion + "</KeepY1Ion> " + System.getProperty("line.separator") + "\t\t<RemoveWaterLosses>" + this.removeWaterLosses + "</RemoveWaterLosses> " + System.getProperty("line.separator") + "\t\t<RemoveAmmoniaLosses>" + this.removeAmmoniaLosses + "</RemoveAmmoniaLosses> " + System.getProperty("line.separator") + "\t\t<ExcludeFirstPrecursor>" + this.excludeFirstPrecursor + "</ExcludeFirstPrecursor> " + System.getProperty("line.separator") + "\t\t<MaxMultiplePrecursors>" + this.maxMultiplePrecursors + "</MaxMultiplePrecursors> " + System.getProperty("line.separator") + "\t\t<ConsideredChargesForPrecursors>" + this.consideredChargesForPrecursors + "</ConsideredChargesForPrecursors> " + System.getProperty("line.separator") + "\t</second_search_settings> " + System.getProperty("line.separator") + System.getProperty("line.separator") + "\t<basic_settings> " + System.getProperty("line.separator") + "\t\t<instruments_file>" + new File(this.msAmandaFolder, "instruments_SearchGUI.xml").getAbsolutePath() + "</instruments_file> " + System.getProperty("line.separator") + "\t\t<unimod_file>" + new File(this.msAmandaFolder, "unimod.xml").getAbsolutePath() + "</unimod_file> " + System.getProperty("line.separator") + "\t\t<enzyme_file>" + new File(this.msAmandaTempFolder, "enzymes_SearchGUI.xml").getAbsolutePath() + "</enzyme_file> " + System.getProperty("line.separator") + "\t\t<unimod_obo_file>" + new File(this.msAmandaFolder, "unimod.obo").getAbsolutePath() + "</unimod_obo_file> " + System.getProperty("line.separator") + "\t\t<psims_obo_file>" + new File(this.msAmandaFolder, "psi-ms.obo").getAbsolutePath() + "</psims_obo_file> " + System.getProperty("line.separator") + "\t\t<monoisotopic>" + this.monoisotopic + "</monoisotopic> " + System.getProperty("line.separator") + "\t\t<considered_charges>" + this.getChargeRangeAsString() + "</considered_charges> " + System.getProperty("line.separator") + "\t\t<combine_considered_charges>" + this.combineConsideredCharges + "</combine_considered_charges> " + System.getProperty("line.separator") + "\t\t<LoadedProteinsAtOnce>" + this.maxLoadedProteins + "</LoadedProteinsAtOnce> " + System.getProperty("line.separator") + "\t\t<LoadedSpectraAtOnce>" + this.maxLoadedSpectra + "</LoadedSpectraAtOnce> " + System.getProperty("line.separator") + "\t\t<data_folder>" + this.msAmandaTempFolder + "</data_folder> " + System.getProperty("line.separator") + "\t</basic_settings> " + System.getProperty("line.separator") + "\t<percolator_settings> " + System.getProperty("line.separator") + "\t\t<generatePInFile>" + this.generatePInFile + "</generatePInFile> " + System.getProperty("line.separator") + "\t\t<runPercolator>" + this.runPercolator + "</runPercolator> " + System.getProperty("line.separator") + "\t</percolator_settings> " + System.getProperty("line.separator") + "</settings>" + System.getProperty("line.separator"));
            bw.flush();
            bw.close();
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Could not create MS Amanda settings file. Unable to write file: '" + ioe.getMessage() + "'!");
        }
    }

    @Override
    public String getType() {
        return "MS Amanda";
    }

    @Override
    public String getCurrentlyProcessedFileName() {
        return this.spectrumFile.getName();
    }

    private String getModificationsAsString(ModificationParameters modificationProfile) {
        Modification modification;
        String temp = "\t\t<modifications>" + System.getProperty("line.separator");
        for (String modificationName : modificationProfile.getFixedModifications()) {
            modification = this.modificationFactory.getModification(modificationName);
            temp = temp + this.getModificationAsString(modification, true) + System.getProperty("line.separator");
        }
        for (String modificationName : modificationProfile.getVariableModifications()) {
            modification = this.modificationFactory.getModification(modificationName);
            temp = temp + this.getModificationAsString(modification, false) + System.getProperty("line.separator");
        }
        temp = temp + "\t\t</modifications>" + System.getProperty("line.separator");
        return temp;
    }

    private String getModificationAsString(Modification modification, boolean fixed) {
        CvTerm cvTerm;
        String nTermTag = "";
        String cTermTag = "";
        String proteinTag = "";
        String fixedTag = "";
        if (fixed) {
            fixedTag = " fix=\"true\"";
        }
        switch (modification.getModificationType()) {
            case modaa: {
                break;
            }
            case modc_protein: 
            case modcaa_protein: {
                cTermTag = " cterm=\"true\"";
                break;
            }
            case modc_peptide: 
            case modcaa_peptide: {
                cTermTag = " cterm=\"true\"";
                break;
            }
            case modn_protein: 
            case modnaa_protein: {
                proteinTag = " protein=\"true\"";
                nTermTag = " nterm=\"true\"";
                break;
            }
            case modn_peptide: 
            case modnaa_peptide: {
                nTermTag = " nterm=\"true\"";
            }
        }
        String aminoAcidsAtTarget = "";
        if (modification.getModificationType() == ModificationType.modaa || modification.getModificationType() == ModificationType.modcaa_peptide || modification.getModificationType() == ModificationType.modcaa_protein || modification.getModificationType() == ModificationType.modnaa_peptide || modification.getModificationType() == ModificationType.modnaa_protein) {
            for (Character aa : modification.getPattern().getAminoAcidsAtTarget()) {
                if (!aminoAcidsAtTarget.isEmpty()) {
                    aminoAcidsAtTarget = aminoAcidsAtTarget + ",";
                }
                aminoAcidsAtTarget = aminoAcidsAtTarget + aa;
            }
        }
        if (!aminoAcidsAtTarget.isEmpty()) {
            aminoAcidsAtTarget = "(" + aminoAcidsAtTarget + ")";
        }
        if ((cvTerm = modification.getUnimodCvTerm()) != null) {
            return "\t\t\t<modification" + fixedTag + nTermTag + cTermTag + proteinTag + ">" + cvTerm.getName() + aminoAcidsAtTarget + "</modification>";
        }
        return "\t\t\t<modification delta_mass=\"" + modification.getRoundedMass() + "\"" + fixedTag + nTermTag + cTermTag + proteinTag + ">" + modification.getName() + aminoAcidsAtTarget + "</modification>";
    }

    private String getChargeRangeAsString() {
        String charges = "";
        for (int i = this.minCharge; i <= this.maxCharge; ++i) {
            if (!charges.isEmpty()) {
                charges = charges + ",";
            }
            charges = charges + i + "+";
        }
        return charges;
    }

    public boolean reportBothBestHitsForTD() {
        return this.reportBothBestHitsForTD;
    }

    public void setReportBothBestHitsForTD(boolean reportBothBestHitsForTD) {
        this.reportBothBestHitsForTD = reportBothBestHitsForTD;
    }
}

