/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.processbuilders;

import com.compomics.software.cli.CommandLineUtils;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.mass_spectrometry.proteowizard.MsConvertParameters;
import com.compomics.util.experiment.mass_spectrometry.proteowizard.ProteoWizardFilter;
import com.compomics.util.experiment.mass_spectrometry.proteowizard.ProteoWizardMsFormat;
import com.compomics.util.io.IoUtil;
import com.compomics.util.parameters.UtilitiesUserParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.processbuilders.SearchGUIProcessBuilder;
import java.io.File;
import java.io.IOException;

public class MsConvertProcessBuilder
extends SearchGUIProcessBuilder {
    private File rawFile;
    private File destinationFolder;
    private MsConvertParameters msConvertParameters;
    private static boolean displayProgress = true;

    public MsConvertProcessBuilder(File rawFile, File destinationFolder, MsConvertParameters msConvertParameters, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler) throws IOException, ClassNotFoundException {
        this.rawFile = rawFile;
        this.destinationFolder = destinationFolder;
        this.msConvertParameters = msConvertParameters;
        this.waitingHandler = waitingHandler;
        this.exceptionHandler = exceptionHandler;
        this.setUpProcessBuilder();
    }

    private void setUpProcessBuilder() throws IOException, ClassNotFoundException {
        UtilitiesUserParameters utilitiesUserParameters = UtilitiesUserParameters.loadUserParameters();
        String proteoWizardPath = utilitiesUserParameters.getProteoWizardPath();
        if (proteoWizardPath == null) {
            throw new IllegalArgumentException("ProteoWizard path not set.");
        }
        File proteoWizardFolder = new File(proteoWizardPath, "msconvert");
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument((File)proteoWizardFolder));
        if (IoUtil.getExtension((File)this.rawFile).equalsIgnoreCase(ProteoWizardMsFormat.d.fileNameEnding)) {
            File fileParent = this.rawFile.getParentFile();
            if (this.rawFile.getName().equalsIgnoreCase(fileParent.getName())) {
                this.rawFile = fileParent;
            }
        }
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument((File)this.rawFile));
        ProteoWizardMsFormat msFormat = this.msConvertParameters.getMsFormat();
        if (msFormat == null) {
            msFormat = ProteoWizardMsFormat.mgf;
        }
        this.process_name_array.add("--" + msFormat.commandLineOption);
        this.process_name_array.add("-o");
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument((File)this.destinationFolder));
        if (this.rawFile.getName().lastIndexOf(".") != -1) {
            this.process_name_array.add("--outfile");
            this.process_name_array.add(this.rawFile.getName().substring(0, this.rawFile.getName().lastIndexOf(".")) + msFormat.fileNameEnding);
        }
        if (displayProgress) {
            this.process_name_array.add("-v");
        }
        for (Integer filterId : this.msConvertParameters.getFilters()) {
            ProteoWizardFilter proteoWizardFilter = ProteoWizardFilter.getFilter((Integer)filterId);
            if (proteoWizardFilter == null) {
                throw new IllegalArgumentException("Filter of index " + filterId + " not recognized.");
            }
            String commandLine = "\"" + proteoWizardFilter.name;
            String value = this.msConvertParameters.getValue(filterId.intValue());
            if (value != null) {
                commandLine = commandLine + " " + value;
            }
            commandLine = commandLine + "\"";
            this.process_name_array.add("--filter");
            this.process_name_array.add(commandLine);
        }
        this.process_name_array.trimToSize();
        System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "msconvert command: ");
        for (Object current_entry : this.process_name_array) {
            System.out.print(current_entry + " ");
        }
        System.out.println(System.getProperty("line.separator"));
        this.pb = new ProcessBuilder(this.process_name_array);
        this.pb.redirectErrorStream(true);
    }

    @Override
    public void startProcess() throws IOException {
        if (!this.waitingHandler.isRunCanceled()) {
            this.waitingHandler.appendReport("Processing " + this.rawFile.getName() + " with msconvert.", true, true);
            this.waitingHandler.appendReportEndLine();
            super.startProcess();
        }
    }

    @Override
    public String getType() {
        return "msconvert";
    }

    @Override
    public String getCurrentlyProcessedFileName() {
        return this.rawFile.getName();
    }
}

