/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.processbuilders;

import com.compomics.software.cli.CommandLineUtils;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.modifications.ModificationType;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.identification.tool_specific.MyriMatchParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.processbuilders.SearchGUIProcessBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class MyriMatchProcessBuilder
extends SearchGUIProcessBuilder {
    private ModificationFactory modificationFactory = ModificationFactory.getInstance();
    public static final String EXECUTABLE_FILE_NAME = "myrimatch";
    private File spectrumFile;
    private MyriMatchParameters myriMatchParameters;
    private SearchParameters searchParameters;
    private final int statusUpdateFrecuencyInSeconds = 10;

    public MyriMatchProcessBuilder(File myriMatchDirectory, File mgfFile, File fastaFile, File outputFolder, SearchParameters searchParameters, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler, int nThreads) {
        this.searchParameters = searchParameters;
        this.exceptionHandler = exceptionHandler;
        this.myriMatchParameters = (MyriMatchParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.myriMatch.getIndex());
        this.waitingHandler = waitingHandler;
        this.spectrumFile = mgfFile;
        File myriMatchExecutable = new File(myriMatchDirectory.getAbsolutePath() + File.separator + EXECUTABLE_FILE_NAME);
        myriMatchExecutable.setExecutable(true);
        this.process_name_array.add(myriMatchDirectory.getAbsolutePath() + File.separator + EXECUTABLE_FILE_NAME);
        this.process_name_array.add("-cpus");
        this.process_name_array.add(Integer.toString(nThreads));
        this.process_name_array.add("-ProteinDatabase");
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument((File)fastaFile));
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument((File)this.spectrumFile));
        this.process_name_array.add("-OutputFormat");
        if (this.myriMatchParameters.getOutputFormat().equalsIgnoreCase("mzIdentML")) {
            this.process_name_array.add("mzIdentML");
        } else {
            this.process_name_array.add("pepXML");
        }
        this.process_name_array.add("-workdir");
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument((File)outputFolder));
        this.process_name_array.add("-OutputSuffix");
        this.process_name_array.add(".myrimatch");
        this.process_name_array.add("-DecoyPrefix");
        this.process_name_array.add("\"\"");
        this.process_name_array.add("-MinPeptideLength");
        this.process_name_array.add("" + this.myriMatchParameters.getMinPeptideLength());
        this.process_name_array.add("-MaxPeptideLength");
        this.process_name_array.add("" + this.myriMatchParameters.getMaxPeptideLength());
        this.process_name_array.add("-MaxResultRank");
        this.process_name_array.add("" + this.myriMatchParameters.getNumberOfSpectrumMatches());
        this.process_name_array.add("-SpectrumListFilters");
        this.process_name_array.add("\"\"");
        this.process_name_array.add("-FragmentMzTolerance");
        String fragemtnTolerance = Double.toString(searchParameters.getFragmentIonAccuracy());
        fragemtnTolerance = searchParameters.getFragmentAccuracyType() == SearchParameters.MassAccuracyType.DA ? fragemtnTolerance + " daltons" : fragemtnTolerance + " ppm";
        this.process_name_array.add("\"" + fragemtnTolerance + "\"");
        this.process_name_array.add("-MonoPrecursorMzTolerance");
        String precursorTolerance = Double.toString(searchParameters.getPrecursorAccuracy());
        precursorTolerance = searchParameters.getPrecursorAccuracyType() == SearchParameters.MassAccuracyType.DA ? precursorTolerance + " daltons" : precursorTolerance + " ppm";
        this.process_name_array.add("\"" + precursorTolerance + "\"");
        this.process_name_array.add("-PrecursorMzToleranceRule");
        this.process_name_array.add("\"mono\"");
        HashMap<String, ArrayList<String>> filteredModifications = this.filterFixedModifications();
        if (!filteredModifications.get("Fixed").isEmpty()) {
            this.process_name_array.add("-StaticMods");
            this.process_name_array.add(this.getFixedModificationsAsString(filteredModifications.get("Fixed")));
        }
        if (!filteredModifications.get("Variable").isEmpty()) {
            this.process_name_array.add("-DynamicMods");
            this.process_name_array.add(this.getVariableModificationsAsString(filteredModifications.get("Variable")));
        }
        this.process_name_array.add("-MaxDynamicMods");
        this.process_name_array.add("" + this.myriMatchParameters.getMaxDynamicMods());
        this.process_name_array.add("-StatusUpdateFrequency");
        this.process_name_array.add("10");
        this.process_name_array.add("-NumChargeStates");
        this.process_name_array.add("" + searchParameters.getMaxChargeSearched());
        this.process_name_array.add("-TicCutoffPercentage");
        this.process_name_array.add("" + this.myriMatchParameters.getTicCutoffPercentage());
        this.process_name_array.add("-MinPeptideMass");
        this.process_name_array.add("" + this.myriMatchParameters.getMinPrecursorMass());
        this.process_name_array.add("-MaxPeptideMass");
        this.process_name_array.add("" + this.myriMatchParameters.getMaxPrecursorMass());
        this.process_name_array.add("-UseSmartPlusThreeModel");
        this.process_name_array.add("" + this.myriMatchParameters.getUseSmartPlusThreeModel());
        this.process_name_array.add("-ComputeXCorr");
        this.process_name_array.add("" + this.myriMatchParameters.getComputeXCorr());
        this.process_name_array.add("-NumIntensityClasses");
        this.process_name_array.add("" + this.myriMatchParameters.getNumIntensityClasses());
        this.process_name_array.add("-ClassSizeMultiplier");
        this.process_name_array.add("" + this.myriMatchParameters.getClassSizeMultiplier());
        this.process_name_array.add("-NumBatches");
        this.process_name_array.add("" + this.myriMatchParameters.getNumberOfBatches());
        this.process_name_array.add("-MaxPeakCount");
        this.process_name_array.add("" + this.myriMatchParameters.getMaxPeakCount());
        this.process_name_array.add("-MonoisotopeAdjustmentSet");
        boolean precursorsToleranceWide = false;
        if (searchParameters.getPrecursorAccuracyType() == SearchParameters.MassAccuracyType.DA && searchParameters.getPrecursorAccuracy() >= 0.2 || searchParameters.getPrecursorAccuracyType() == SearchParameters.MassAccuracyType.PPM && searchParameters.getPrecursorAccuracy() >= 200.0) {
            precursorsToleranceWide = true;
        }
        if (precursorsToleranceWide) {
            this.process_name_array.add("0");
        } else {
            this.process_name_array.add("[" + searchParameters.getMinIsotopicCorrection() + "," + searchParameters.getMaxIsotopicCorrection() + "]");
        }
        this.process_name_array.add("-FragmentationAutoRule");
        this.process_name_array.add("false");
        this.process_name_array.add("-FragmentationRule");
        if (this.myriMatchParameters.getFragmentationRule().equalsIgnoreCase("HCD")) {
            this.process_name_array.add("\"manual:b,y\"");
        } else {
            this.process_name_array.add("\"" + this.myriMatchParameters.getFragmentationRule().toLowerCase() + "\"");
        }
        this.process_name_array.add("-CleavageRules");
        DigestionParameters digestionPreferences = searchParameters.getDigestionParameters();
        if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.unSpecific) {
            this.process_name_array.add("\"Trypsin\"");
        } else {
            String myriMatchEnzyme = MyriMatchParameters.enzymeMapping((DigestionParameters)digestionPreferences);
            this.process_name_array.add("\"" + myriMatchEnzyme + "\"");
        }
        this.process_name_array.add("-MinTerminiCleavages");
        if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.unSpecific) {
            this.process_name_array.add("0");
        } else if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.wholeProtein) {
            this.process_name_array.add("0");
        } else {
            boolean semiSpecific = false;
            for (Enzyme enzyme : digestionPreferences.getEnzymes()) {
                if (digestionPreferences.getSpecificity(enzyme.getName()) != DigestionParameters.Specificity.semiSpecific && digestionPreferences.getSpecificity(enzyme.getName()) != DigestionParameters.Specificity.specificCTermOnly && digestionPreferences.getSpecificity(enzyme.getName()) != DigestionParameters.Specificity.specificNTermOnly) continue;
                semiSpecific = true;
                break;
            }
            if (semiSpecific) {
                this.process_name_array.add("1");
            } else {
                this.process_name_array.add("" + this.myriMatchParameters.getMinTerminiCleavages());
            }
        }
        if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme) {
            Integer missedCleavages = null;
            for (Enzyme enzyme : digestionPreferences.getEnzymes()) {
                int enzymeMissedCleavages = digestionPreferences.getnMissedCleavages(enzyme.getName());
                if (missedCleavages != null && enzymeMissedCleavages <= missedCleavages) continue;
                missedCleavages = enzymeMissedCleavages;
            }
            if (missedCleavages != null) {
                this.process_name_array.add("-MaxMissedCleavages");
                this.process_name_array.add("" + missedCleavages);
            }
        }
        this.process_name_array.trimToSize();
        System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "myrimatch command: ");
        for (Object element : this.process_name_array) {
            System.out.print(element + " ");
        }
        System.out.println(System.getProperty("line.separator"));
        this.pb = new ProcessBuilder(this.process_name_array);
        this.pb.directory(myriMatchDirectory);
        this.pb.redirectErrorStream(true);
    }

    private String getFixedModificationsAsString(ArrayList<String> fixedModifications) {
        String fixedModificationsAsString = "";
        for (String modName : fixedModifications) {
            Modification tempModification = this.modificationFactory.getModification(modName);
            if (tempModification.getModificationType() == ModificationType.modaa) {
                for (Character aa : tempModification.getPattern().getAminoAcidsAtTarget()) {
                    fixedModificationsAsString = fixedModificationsAsString + aa + " " + tempModification.getRoundedMass() + " ";
                }
                continue;
            }
            if (tempModification.getModificationType() == ModificationType.modn_peptide) {
                fixedModificationsAsString = fixedModificationsAsString + "( " + tempModification.getRoundedMass() + " ";
                continue;
            }
            if (tempModification.getModificationType() != ModificationType.modc_peptide) continue;
            fixedModificationsAsString = fixedModificationsAsString + ") " + tempModification.getRoundedMass() + " ";
        }
        fixedModificationsAsString = fixedModificationsAsString.trim();
        fixedModificationsAsString = "\"" + fixedModificationsAsString + "\"";
        return fixedModificationsAsString;
    }

    private String getVariableModificationsAsString(ArrayList<String> variableModifications) throws IndexOutOfBoundsException {
        String variableModificationsAsString = "";
        char[] symbols = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '*', '^', '@', '|', '\u00a7', '+', '-', '&', '%', '='};
        int symbolsCounter = 0;
        if (variableModifications.size() > symbols.length) {
            throw new IndexOutOfBoundsException("There are more variable modifications (" + variableModifications.size() + ") than symbols to represent them in MyriMatch (" + symbols.length + "). Search canceled.");
        }
        for (String modName : variableModifications) {
            Modification modification = this.modificationFactory.getModification(modName);
            String nTerm = "";
            String cTerm = "";
            switch (modification.getModificationType()) {
                case modn_peptide: 
                case modn_protein: {
                    nTerm = "(";
                    break;
                }
                case modnaa_peptide: 
                case modnaa_protein: {
                    nTerm = "(!";
                    break;
                }
                case modc_peptide: 
                case modc_protein: 
                case modcaa_peptide: 
                case modcaa_protein: {
                    cTerm = ")";
                    break;
                }
            }
            String aminoAcidsAtTarget = "";
            if (modification.getPattern() != null) {
                for (Character aa : modification.getPattern().getAminoAcidsAtTarget()) {
                    aminoAcidsAtTarget = aminoAcidsAtTarget + aa;
                }
            }
            if (aminoAcidsAtTarget.length() > 1) {
                aminoAcidsAtTarget = "[" + aminoAcidsAtTarget + "]";
            }
            variableModificationsAsString = variableModificationsAsString + nTerm + aminoAcidsAtTarget + cTerm + " " + symbols[symbolsCounter++] + " " + modification.getRoundedMass() + " ";
        }
        variableModificationsAsString = variableModificationsAsString.trim();
        variableModificationsAsString = "\"" + variableModificationsAsString + "\"";
        return variableModificationsAsString;
    }

    @Override
    public String getType() {
        return "MyriMatch";
    }

    @Override
    public String getCurrentlyProcessedFileName() {
        return this.spectrumFile.getName();
    }

    private HashMap<String, ArrayList<String>> filterFixedModifications() {
        HashMap<String, ArrayList<String>> newModifications = new HashMap<String, ArrayList<String>>();
        ArrayList<String> filteredFixedModifications = new ArrayList<String>();
        ArrayList<String> variableModifications = new ArrayList<String>();
        variableModifications.addAll(this.searchParameters.getModificationParameters().getVariableModifications());
        for (String modName : this.searchParameters.getModificationParameters().getFixedModifications()) {
            Modification modification = this.modificationFactory.getModification(modName);
            ModificationType modificationType = modification.getModificationType();
            if (null == modificationType) continue;
            switch (modificationType) {
                case modn_peptide: 
                case modc_peptide: 
                case modaa: {
                    filteredFixedModifications.add(modName);
                    break;
                }
                case modn_protein: 
                case modnaa_peptide: 
                case modnaa_protein: 
                case modc_protein: 
                case modcaa_peptide: 
                case modcaa_protein: {
                    variableModifications.add(modName);
                    break;
                }
            }
        }
        newModifications.put("Fixed", filteredFixedModifications);
        newModifications.put("Variable", variableModifications);
        return newModifications;
    }
}

