/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.processbuilders;

import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidPattern;
import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.modifications.ModificationType;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.identification.tool_specific.XtandemParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.processbuilders.SearchGUIProcessBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.stream.Collectors;

public class TandemProcessBuilder
extends SearchGUIProcessBuilder {
    private final String INPUT_FILE = "input_searchGUI.xml";
    private final String PARAMETER_FILE = "parameters_searchGUI.xml";
    private final String TAXONOMY_FILE = "taxonomy_searchGUI.xml";
    public static final String EXECUTABLE_FILE_NAME = "tandem";
    private File xTandemTempFolder;
    private int nProcessors;
    private File xTandemFile;
    private File inputFile;
    private File parameterFile;
    private File taxonomyFile;
    private File dataBase;
    private File spectrumFile;
    private String outputPath;
    private Double fragmentMassError;
    private Double precursorMassError;
    private String precursorUnit;
    private String fragmentUnit;
    private int maxCharge;
    private ArrayList<String> fixedMod;
    private ArrayList<String> variableMod;
    private ArrayList<String> variableModMotifs;
    private ArrayList<String> refinementFixedMod = null;
    private ArrayList<String> refinementVariableMod;
    private ArrayList<String> refinementVariableModMotif;
    private ArrayList<String> refinementVariableNTermMod;
    private ArrayList<String> refinementVariableCTermMod;
    private double fixedCtermProteinMod = 0.0;
    private double fixedNtermProteinMod = 0.0;
    private String enzymeCleaveSiteAsText;
    private String enzymeIsSemiSpecific;
    private String parentMonoisotopicMassIsotopeError;
    private int missedCleavages;
    private HashSet<Integer> selectedIons;
    private ModificationFactory modificationFactory = ModificationFactory.getInstance();
    private XtandemParameters xtandemParameters;

    public TandemProcessBuilder(File xTandem_directory, File xTandemTempFolder, File mgfFile, File fastaFile, String outputPath, SearchParameters searchParameters, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler, int nThreads) {
        Modification modification;
        this.xtandemParameters = (XtandemParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.xtandem.getIndex());
        this.waitingHandler = waitingHandler;
        this.exceptionHandler = exceptionHandler;
        this.xTandemFile = xTandem_directory;
        this.nProcessors = nThreads;
        this.spectrumFile = mgfFile;
        this.dataBase = fastaFile.getAbsoluteFile();
        this.outputPath = outputPath;
        this.xTandemTempFolder = xTandemTempFolder;
        if (!xTandemTempFolder.exists()) {
            xTandemTempFolder.mkdirs();
        }
        this.fragmentMassError = searchParameters.getFragmentIonAccuracy();
        this.precursorMassError = searchParameters.getPrecursorAccuracy();
        if (searchParameters.getPrecursorAccuracyType() == SearchParameters.MassAccuracyType.PPM) {
            this.precursorUnit = "ppm";
        } else if (searchParameters.getPrecursorAccuracyType() == SearchParameters.MassAccuracyType.DA) {
            this.precursorUnit = "Daltons";
        }
        if (searchParameters.getFragmentAccuracyType() == SearchParameters.MassAccuracyType.PPM) {
            this.fragmentUnit = "ppm";
        } else if (searchParameters.getFragmentAccuracyType() == SearchParameters.MassAccuracyType.DA) {
            this.fragmentUnit = "Daltons";
        }
        this.maxCharge = searchParameters.getMaxChargeSearched();
        ModificationParameters modificationParameters = searchParameters.getModificationParameters();
        this.fixedMod = new ArrayList(modificationParameters.getFixedModifications().size());
        boolean sameFixed = modificationParameters.getFixedModifications().size() == modificationParameters.getRefinementFixedModifications().size();
        for (String modName : modificationParameters.getFixedModifications()) {
            Modification modification2 = this.modificationFactory.getModification(modName);
            if (modification2.getModificationType() == ModificationType.modn_protein) {
                this.fixedNtermProteinMod += modification2.getMass();
            } else if (modification2.getModificationType() == ModificationType.modc_protein) {
                this.fixedCtermProteinMod += modification2.getMass();
            } else {
                this.fixedMod.add(modName);
            }
            if (!sameFixed || modificationParameters.getRefinementFixedModifications().contains(modName)) continue;
            sameFixed = false;
        }
        if (!sameFixed) {
            this.refinementFixedMod = modificationParameters.getRefinementFixedModifications();
        }
        this.variableMod = new ArrayList(modificationParameters.getVariableModifications().size());
        this.variableModMotifs = new ArrayList(0);
        for (String modName : modificationParameters.getVariableModifications()) {
            boolean newModification = true;
            if (this.xtandemParameters.isProteinQuickAcetyl() && modName.equals("Acetylation of protein N-term")) {
                newModification = false;
            }
            if (newModification && this.xtandemParameters.isQuickPyrolidone() && (modName.equals("Pyrolidone from E") || modName.equals("Pyrolidone from Q") || modName.equals("Pyrolidone from carbamidomethylated C"))) {
                newModification = false;
            }
            if (!newModification) continue;
            modification = this.modificationFactory.getModification(modName);
            AminoAcidPattern modificationPattern = modification.getPattern();
            if (modificationPattern == null || modificationPattern.length() == 1 && modificationPattern.getAminoAcidsAtTarget().size() == 1 || modificationPattern.length() == 0 && (modification.getModificationType().isNTerm() || modification.getModificationType().isCTerm())) {
                this.variableMod.add(modName);
                continue;
            }
            this.variableModMotifs.add(modName);
        }
        this.refinementVariableMod = new ArrayList();
        this.refinementVariableModMotif = new ArrayList();
        this.refinementVariableCTermMod = new ArrayList();
        this.refinementVariableNTermMod = new ArrayList();
        block6: for (String modName : modificationParameters.getRefinementVariableModifications()) {
            boolean newModification = true;
            if (this.xtandemParameters.isProteinQuickAcetyl() && modName.equals("Acetylation of protein N-term")) {
                newModification = false;
            }
            if (newModification && this.xtandemParameters.isQuickPyrolidone() && (modName.equals("Pyrolidone from E") || modName.equals("Pyrolidone from Q") || modName.equals("Pyrolidone from carbamidomethylated C"))) {
                newModification = false;
            }
            if (!newModification) continue;
            modification = this.modificationFactory.getModification(modName);
            ModificationType modificationType = modification.getModificationType();
            switch (modificationType) {
                case modc_peptide: 
                case modc_protein: 
                case modcaa_peptide: 
                case modcaa_protein: {
                    this.refinementVariableCTermMod.add(modName);
                    continue block6;
                }
                case modn_peptide: 
                case modn_protein: 
                case modnaa_peptide: 
                case modnaa_protein: {
                    this.refinementVariableNTermMod.add(modName);
                    continue block6;
                }
            }
            AminoAcidPattern modificationPattern = modification.getPattern();
            if (modificationPattern.length() == 1 && modificationPattern.getAminoAcidsAtTarget().size() == 1) {
                this.refinementVariableMod.add(modName);
                continue;
            }
            this.refinementVariableModMotif.add(modName);
        }
        DigestionParameters digestionPreferences = searchParameters.getDigestionParameters();
        this.enzymeCleaveSiteAsText = digestionPreferences.getXTandemFormat();
        if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme) {
            boolean semiSpecific = false;
            for (Object enzyme : digestionPreferences.getEnzymes()) {
                if (digestionPreferences.getSpecificity(enzyme.getName()) != DigestionParameters.Specificity.semiSpecific && digestionPreferences.getSpecificity(enzyme.getName()) != DigestionParameters.Specificity.specificCTermOnly && digestionPreferences.getSpecificity(enzyme.getName()) != DigestionParameters.Specificity.specificNTermOnly) continue;
                semiSpecific = true;
                break;
            }
            this.enzymeIsSemiSpecific = semiSpecific ? "yes" : "no";
            Integer tempMissedCleavages = null;
            for (Enzyme enzyme : digestionPreferences.getEnzymes()) {
                int enzymeMissedCleavages = digestionPreferences.getnMissedCleavages(enzyme.getName());
                if (tempMissedCleavages != null && enzymeMissedCleavages <= tempMissedCleavages) continue;
                tempMissedCleavages = enzymeMissedCleavages;
            }
            this.missedCleavages = tempMissedCleavages;
        } else if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.unSpecific) {
            this.enzymeIsSemiSpecific = "no";
            this.missedCleavages = 50;
        } else {
            this.enzymeIsSemiSpecific = "no";
            this.missedCleavages = 0;
        }
        this.parentMonoisotopicMassIsotopeError = this.xtandemParameters.getParentMonoisotopicMassIsotopeError() ? "yes" : "no";
        this.selectedIons = new HashSet();
        this.selectedIons.addAll(searchParameters.getForwardIons());
        this.selectedIons.addAll(searchParameters.getRewindIons());
        this.createInputFile();
        this.createTaxonomyFile();
        this.createParameterFile();
        File xTandem = new File(this.xTandemFile.getAbsolutePath() + File.separator + EXECUTABLE_FILE_NAME);
        xTandem.setExecutable(true);
        this.process_name_array.add(this.xTandemFile.getAbsolutePath() + File.separator + EXECUTABLE_FILE_NAME);
        this.process_name_array.add(this.inputFile.getAbsolutePath());
        this.process_name_array.trimToSize();
        System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "xtandem command: ");
        for (Object element : this.process_name_array) {
            System.out.print(element + " ");
        }
        System.out.println(System.getProperty("line.separator"));
        this.pb = new ProcessBuilder(this.process_name_array);
        this.pb.directory(xTandem_directory);
        this.pb.redirectErrorStream(true);
    }

    private void createInputFile() {
        this.inputFile = new File(this.xTandemTempFolder, "input_searchGUI.xml");
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.inputFile));
            bw.write("<?xml version=\"1.0\"?>" + System.getProperty("line.separator") + "<bioml>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"list path, default parameters\">" + new File(this.xTandemTempFolder, "parameters_searchGUI.xml").getAbsolutePath() + "</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"list path, taxonomy information\">" + new File(this.xTandemTempFolder, "taxonomy_searchGUI.xml").getAbsolutePath() + "</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"protein, taxon\">all</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"spectrum, path\">" + this.spectrumFile.getAbsolutePath() + "</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"output, path\">" + this.outputPath + "</note>" + System.getProperty("line.separator") + "</bioml>" + System.getProperty("line.separator"));
            bw.flush();
            bw.close();
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Could not create X!Tandem input file. Unable to write file: '" + ioe.getMessage() + "'!");
        }
    }

    private void createTaxonomyFile() throws IllegalArgumentException {
        this.taxonomyFile = new File(this.xTandemTempFolder, "taxonomy_searchGUI.xml");
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.taxonomyFile));
            bw.write("<?xml version=\"1.0\"?>" + System.getProperty("line.separator") + "<bioml label=\"x! taxon-to-file matching list\">" + System.getProperty("line.separator") + "\t<taxon label=\"all\">" + System.getProperty("line.separator") + "\t\t<file format=\"peptide\" URL=\"" + this.dataBase + "\" />" + System.getProperty("line.separator") + "\t</taxon>" + System.getProperty("line.separator") + "</bioml>");
            bw.flush();
            bw.close();
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Could not create X!Tandem taxonomy file. Unable to write file: '" + ioe.getMessage() + "'!");
        }
    }

    private void createParameterFile() throws IllegalArgumentException {
        String modDescription = this.getSearchedModList(this.variableMod, this.fixedMod);
        String noiseSuppression = "no";
        if (this.xtandemParameters.isUseNoiseSuppression()) {
            noiseSuppression = "yes";
        }
        String quickAcetyl = "yes";
        if (!this.xtandemParameters.isProteinQuickAcetyl()) {
            quickAcetyl = "no";
        }
        String quickPyrolidone = "yes";
        if (!this.xtandemParameters.isQuickPyrolidone()) {
            quickPyrolidone = "no";
        }
        String stpBias = "no";
        if (this.xtandemParameters.isStpBias()) {
            stpBias = "yes";
        }
        String outputProtein = "no";
        if (this.xtandemParameters.isOutputProteins()) {
            outputProtein = "yes";
        }
        String outputSequences = "no";
        if (this.xtandemParameters.isOutputSequences()) {
            outputSequences = "yes";
        }
        String outputSpectra = "no";
        if (this.xtandemParameters.isOutputSpectra()) {
            outputSpectra = "yes";
        }
        String outputHistograms = "no";
        if (this.xtandemParameters.isOutputHistograms()) {
            outputHistograms = "yes";
        }
        StringBuilder motifs = new StringBuilder();
        for (String modName : this.variableModMotifs) {
            Modification modification = this.modificationFactory.getModification(modName);
            motifs.append(modification.getMass()).append('@').append(modification.getPattern().getPrositeFormat());
        }
        this.parameterFile = new File(this.xTandemTempFolder, "parameters_searchGUI.xml");
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(this.parameterFile));){
            bw.write("<?xml version=\"1.0\"?>" + System.getProperty("line.separator") + "<?xml-stylesheet type=\"text/xsl\" href=\"tandem-input-style.xsl\"?>" + System.getProperty("line.separator") + "<bioml>" + System.getProperty("line.separator") + "<note>list path parameters</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"list path, default parameters\">default_input.xml</note>" + System.getProperty("line.separator") + "\t\t<note>This value is ignored when it is present in the default parameter" + System.getProperty("line.separator") + "\t\tlist path.</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"list path, taxonomy information\">" + "taxonomy_searchGUI.xml" + "</note>" + System.getProperty("line.separator") + System.getProperty("line.separator") + "<note>spectrum parameters</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"spectrum, fragment monoisotopic mass error\">" + this.fragmentMassError + "</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"spectrum, parent monoisotopic mass error plus\">" + this.precursorMassError + "</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"spectrum, parent monoisotopic mass error minus\">" + this.precursorMassError + "</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"spectrum, parent monoisotopic mass isotope error\">" + this.parentMonoisotopicMassIsotopeError + "</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"spectrum, fragment monoisotopic mass error units\">" + this.fragmentUnit + "</note>" + System.getProperty("line.separator") + "\t<note>The value for this parameter may be 'Daltons' or 'ppm': all other values are ignored</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"spectrum, parent monoisotopic mass error units\">" + this.precursorUnit + "</note>" + System.getProperty("line.separator") + "\t\t<note>The value for this parameter may be 'Daltons' or 'ppm': all other values are ignored</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"spectrum, fragment mass type\">monoisotopic</note>" + System.getProperty("line.separator") + "\t\t<note>values are monoisotopic|average </note>" + System.getProperty("line.separator") + System.getProperty("line.separator") + "<note>spectrum conditioning parameters</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"spectrum, dynamic range\">" + this.xtandemParameters.getDynamicRange() + "</note>" + System.getProperty("line.separator") + "\t\t<note>The peaks read in are normalized so that the most intense peak" + System.getProperty("line.separator") + "\t\tis set to the dynamic range value. All peaks with values of less that" + System.getProperty("line.separator") + "\t\t1, using this normalization, are not used. This normalization has the" + System.getProperty("line.separator") + "\t\toverall effect of setting a threshold value for peak intensities.</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"spectrum, total peaks\">" + this.xtandemParameters.getnPeaks() + "</note> " + System.getProperty("line.separator") + "\t\t<note>If this value is 0, it is ignored. If it is greater than zero (lets say 50)," + System.getProperty("line.separator") + "\t\tthen the number of peaks in the spectrum with be limited to the 50 most intense" + System.getProperty("line.separator") + "\t\tpeaks in the spectrum. X! tandem does not do any peak finding: it only" + System.getProperty("line.separator") + "\t\tlimits the peaks used by this parameter, and the dynamic range parameter.</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"spectrum, maximum parent charge\">" + this.maxCharge + "</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"spectrum, use noise suppression\">" + noiseSuppression + "</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"spectrum, minimum parent m+h\">" + this.xtandemParameters.getMinPrecursorMass() + "</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"spectrum, minimum fragment mz\">" + this.xtandemParameters.getMinFragmentMz() + "</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"spectrum, minimum peaks\">" + this.xtandemParameters.getMinPeaksPerSpectrum() + "</note> " + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"spectrum, threads\">" + this.nProcessors + "</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"spectrum, sequence batch size\">1000</note>" + System.getProperty("line.separator") + "\t" + System.getProperty("line.separator") + "<note>residue modification parameters</note>" + System.getProperty("line.separator") + modDescription + "\t<note type=\"input\" label=\"residue, potential modification motif\">" + motifs + "</note>" + System.getProperty("line.separator") + "\t\t<note>The format of this parameter is similar to residue, modification mass," + System.getProperty("line.separator") + "\t\twith the addition of a modified PROSITE notation sequence motif specification." + System.getProperty("line.separator") + "\t\tFor example, a value of 80@[ST!]PX[KR] indicates a modification" + System.getProperty("line.separator") + "\t\tof either S or T when followed by P, and residue and the a K or an R." + System.getProperty("line.separator") + "\t\tA value of 204@N!{P}[ST]{P} indicates a modification of N by 204, if it" + System.getProperty("line.separator") + "\t\tis NOT followed by a P, then either an S or a T, NOT followed by a P." + System.getProperty("line.separator") + "\t\tPositive and negative values are allowed." + System.getProperty("line.separator") + "\t\t</note>" + System.getProperty("line.separator") + System.getProperty("line.separator") + "<note>protein parameters</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"protein, taxon\">all</note>" + System.getProperty("line.separator") + "\t\t<note>This value is interpreted using the information in taxonomy.xml.</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"protein, cleavage site\">" + this.enzymeCleaveSiteAsText + "</note>" + System.getProperty("line.separator") + "\t\t<note>The first characters in brackets represent residues N-terminal to the " + System.getProperty("line.separator") + "\t\tsite and the second set of characters represent residues C-terminal to the" + System.getProperty("line.separator") + "\t\tsite. The characters must be in square brackets (denoting that only" + System.getProperty("line.separator") + "\t\tthese residues are allowed for a cleavage) or french brackets (denoting" + System.getProperty("line.separator") + "\t\tthat these residues cannot be in that position). Use UPPERCASE characters." + System.getProperty("line.separator") + "\t\tTo denote cleavage at any residue, use [X]|[X] and reset the " + System.getProperty("line.separator") + "\t\tscoring, maximum missed cleavage site parameter (see below) to something like 50." + System.getProperty("line.separator") + "\t\t</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"protein, cleavage semi\">" + this.enzymeIsSemiSpecific + "</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"protein, modified residue mass file\"></note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"protein, cleavage C-terminal mass change\">17.002735</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"protein, cleavage N-terminal mass change\">+1.007825</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"protein, quick acetyl\">" + quickAcetyl + "</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"protein, quick pyrolidone\">" + quickPyrolidone + "</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"protein, stP bias\">" + stpBias + "</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"protein, N-terminal residue modification mass\">" + this.fixedNtermProteinMod + "</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"protein, C-terminal residue modification mass\">" + this.fixedCtermProteinMod + "</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"protein, homolog management\">no</note>" + System.getProperty("line.separator") + "\t\t<note>if yes, an upper limit is set on the number of homologues kept for a particular spectrum</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"protein, ptm complexity\">" + this.xtandemParameters.getProteinPtmComplexity() + "</note>" + System.getProperty("line.separator") + System.getProperty("line.separator") + this.getRefinementParametersSection() + System.getProperty("line.separator") + "<note>scoring parameters</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"scoring, minimum ion count\">4</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"scoring, maximum missed cleavage sites\">" + this.missedCleavages + "</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"scoring, x ions\">" + this.getXSelected() + "</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"scoring, y ions\">" + this.getYSelected() + "</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"scoring, z ions\">" + this.getZSelected() + "</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"scoring, a ions\">" + this.getASelected() + "</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"scoring, b ions\">" + this.getBSelected() + "</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"scoring, c ions\">" + this.getCSelected() + "</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"scoring, cyclic permutation\">no</note>" + System.getProperty("line.separator") + "\t\t<note>if yes, cyclic peptide sequence permutation is used to pad the scoring histograms</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"scoring, include reverse\">no</note>" + System.getProperty("line.separator") + "\t\t<note>if yes, then reversed sequences are searched at the same time as forward sequences</note>" + System.getProperty("line.separator") + System.getProperty("line.separator") + "<note>output parameters</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"output, log path\"></note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"output, message\"></note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"output, one sequence copy\">no</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"output, sequence path\"></note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"output, path\">" + this.outputPath + "</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"output, sort results by\">spectrum</note>" + System.getProperty("line.separator") + "\t\t<note>values = protein|spectrum (spectrum is the default)</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"output, path hashing\">yes</note>" + System.getProperty("line.separator") + "\t\t<note>values = yes|no</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"output, xsl path\">tandem-style.xsl</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"output, parameters\">yes</note>" + System.getProperty("line.separator") + "\t\t<note>values = yes|no</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"output, performance\">yes</note>" + System.getProperty("line.separator") + "\t\t<note>values = yes|no</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"output, spectra\">" + outputSpectra + "</note>" + System.getProperty("line.separator") + "\t\t<note>values = yes|no</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"output, histograms\">" + outputHistograms + "</note>" + System.getProperty("line.separator") + "\t\t<note>values = yes|no</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"output, proteins\">" + outputProtein + "</note>" + System.getProperty("line.separator") + "\t\t<note>values = yes|no</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"output, sequences\">" + outputSequences + "</note>" + System.getProperty("line.separator") + "\t\t<note>values = yes|no</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"output, one sequence copy\">no</note>" + System.getProperty("line.separator") + "\t\t<note>values = yes|no, set to yes to produce only one copy of each protein sequence in the output xml</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"output, results\">" + this.xtandemParameters.getOutputResults() + "</note>" + System.getProperty("line.separator") + "\t\t<note>values = all|valid|stochastic</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"output, maximum valid expectation value\">" + this.xtandemParameters.getMaxEValue() + "</note>" + System.getProperty("line.separator") + "\t\t<note>value is used in the valid|stochastic setting of output, results</note>" + System.getProperty("line.separator") + "\t<note type=\"input\" label=\"output, histogram column width\">50</note>" + System.getProperty("line.separator") + "\t\t<note>values any integer greater than 0. Setting this to '1' makes cutting and pasting histograms" + System.getProperty("line.separator") + "\t\tinto spread sheet programs easier.</note>" + System.getProperty("line.separator") + "<note type=\"description\">ADDITIONAL EXPLANATIONS</note>" + System.getProperty("line.separator") + "\t<note type=\"description\">Each one of the parameters for X! tandem is entered as a labeled note" + System.getProperty("line.separator") + "\t\t\tnode. In the current version of X!, keep those note nodes" + System.getProperty("line.separator") + "\t\t\ton a single line." + System.getProperty("line.separator") + "\t</note>" + System.getProperty("line.separator") + "\t<note type=\"description\">The presence of the type 'input' is necessary if a note is to be considered" + System.getProperty("line.separator") + "\t\t\tan input parameter." + System.getProperty("line.separator") + "\t</note>" + System.getProperty("line.separator") + "\t<note type=\"description\">Any of the parameters that are paths to files may require alteration for a " + System.getProperty("line.separator") + "\t\t\tparticular installation. Full path names usually cause the least trouble," + System.getProperty("line.separator") + "\t\t\tbut there is no reason not to use relative path names, if that is the" + System.getProperty("line.separator") + "\t\t\tmost convenient." + System.getProperty("line.separator") + "\t</note>" + System.getProperty("line.separator") + "\t<note type=\"description\">Any parameter values set in the 'list path, default parameters' file are" + System.getProperty("line.separator") + "\t\t\treset by entries in the normal input file, if they are present. Otherwise," + System.getProperty("line.separator") + "\t\t\tthe default set is used." + System.getProperty("line.separator") + "\t</note>" + System.getProperty("line.separator") + "\t<note type=\"description\">The 'list path, taxonomy information' file must exist." + System.getProperty("line.separator") + "\t\t</note>" + System.getProperty("line.separator") + "\t<note type=\"description\">The directory containing the 'output, path' file must exist: it will not be created." + System.getProperty("line.separator") + "\t\t</note>" + System.getProperty("line.separator") + "\t<note type=\"description\">The 'output, xsl path' is optional: it is only of use if a good XSLT style sheet exists." + System.getProperty("line.separator") + "\t\t</note>" + System.getProperty("line.separator") + System.getProperty("line.separator") + "</bioml>" + System.getProperty("line.separator"));
            bw.flush();
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Could not create X!Tandem parameter file. Unable to write file: '" + ioe.getMessage() + "'!");
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getRefinementParametersSection() {
        void var6_15;
        void var5_8;
        String fixedModsString;
        StringBuilder parametersSection = new StringBuilder();
        parametersSection.append("<note>model refinement parameters</note>").append(System.getProperty("line.separator"));
        if (this.xtandemParameters.isRefine()) {
            parametersSection.append("\t<note type=\"input\" label=\"refine\">yes</note>");
        } else {
            parametersSection.append("\t<note type=\"input\" label=\"refine\">no</note>");
        }
        parametersSection.append(System.getProperty("line.separator"));
        if (this.refinementFixedMod != null) {
            HashMap<Character, ArrayList<Modification>> sortedModifications = this.sortModifications(this.refinementFixedMod);
            fixedModsString = sortedModifications.keySet().stream().sorted().flatMap(target -> ((ArrayList)sortedModifications.get(target)).stream()).map(modification -> modification.getMass() + "@" + modification.getPattern().getPrositeFormat()).collect(Collectors.joining(","));
        } else {
            fixedModsString = "";
        }
        parametersSection.append("\t<note type=\"input\" label=\"refine, modification mass\">").append(fixedModsString).append("</note>").append(System.getProperty("line.separator"));
        parametersSection.append("\t<note type=\"input\" label=\"refine, sequence path\"></note>").append(System.getProperty("line.separator"));
        parametersSection.append("\t<note type=\"input\" label=\"refine, tic percent\">20</note>").append(System.getProperty("line.separator"));
        if (this.xtandemParameters.isRefineSpectrumSynthesis()) {
            parametersSection.append("\t<note type=\"input\" label=\"refine, spectrum synthesis\">yes</note>").append(System.getProperty("line.separator"));
        } else {
            parametersSection.append("\t<note type=\"input\" label=\"refine, spectrum synthesis\">no</note>").append(System.getProperty("line.separator"));
        }
        parametersSection.append("\t<note type=\"input\" label=\"refine, maximum valid expectation value\">").append(this.xtandemParameters.getMaximumExpectationValueRefinement()).append("</note>").append(System.getProperty("line.separator"));
        if (this.xtandemParameters.isRefineUnanticipatedCleavages()) {
            parametersSection.append("\t<note type=\"input\" label=\"refine, unanticipated cleavage\">yes</note>").append(System.getProperty("line.separator"));
        } else {
            parametersSection.append("\t<note type=\"input\" label=\"refine, unanticipated cleavage\">no</note>").append(System.getProperty("line.separator"));
        }
        if (this.xtandemParameters.isRefineSemi()) {
            parametersSection.append("\t<note type=\"input\" label=\"refine, cleavage semi\">yes</note>").append(System.getProperty("line.separator"));
        } else {
            parametersSection.append("\t<note type=\"input\" label=\"refine, cleavage semi\">no</note>").append(System.getProperty("line.separator"));
        }
        if (this.xtandemParameters.isRefinePointMutations()) {
            parametersSection.append("\t<note type=\"input\" label=\"refine, point mutations\">yes</note>").append(System.getProperty("line.separator"));
        } else {
            parametersSection.append("\t<note type=\"input\" label=\"refine, point mutations\">no</note>").append(System.getProperty("line.separator"));
        }
        if (this.xtandemParameters.isRefinePointMutations()) {
            parametersSection.append("\t<note type=\"input\" label=\"refine, saps\">yes</note>").append(System.getProperty("line.separator"));
        } else {
            parametersSection.append("\t<note type=\"input\" label=\"refine, saps\">no</note>").append(System.getProperty("line.separator"));
        }
        if (this.xtandemParameters.isPotentialModificationsForFullRefinment()) {
            parametersSection.append("\t<note type=\"input\" label=\"refine, use potential modifications for full refinement\">yes</note>").append(System.getProperty("line.separator"));
        } else {
            parametersSection.append("\t<note type=\"input\" label=\"refine, use potential modifications for full refinement\">no</note>").append(System.getProperty("line.separator"));
        }
        String nTerm = "";
        for (String string : this.refinementVariableNTermMod) {
            Modification modification2 = this.modificationFactory.getModification(string);
            if (!nTerm.equals("")) {
                nTerm = nTerm + ",";
            }
            nTerm = nTerm + modification2.getMass() + "@[";
        }
        parametersSection.append("\t<note type=\"input\" label=\"refine, potential N-terminus modifications\">").append(nTerm).append("</note>").append(System.getProperty("line.separator"));
        String cTerm = "";
        for (String string : this.refinementVariableCTermMod) {
            Modification modification3 = this.modificationFactory.getModification(string);
            if (!cTerm.equals("")) {
                cTerm = cTerm + ",";
            }
            cTerm = cTerm + modification3.getMass() + "@]";
        }
        parametersSection.append("\t<note type=\"input\" label=\"refine, potential C-terminus modifications\">").append(cTerm).append("</note>").append(System.getProperty("line.separator"));
        String string = "";
        for (String modName : this.refinementVariableMod) {
            Modification modification4 = this.modificationFactory.getModification(modName);
            String string2 = (String)var5_8 + modification4.getMass() + "@" + modification4.getPattern().getAminoAcidsAtTarget().get(0);
        }
        parametersSection.append("\t<note type=\"input\" label=\"refine, potential modification mass\">").append((String)var5_8).append("</note>").append(System.getProperty("line.separator"));
        String string3 = "";
        for (String modName : this.refinementVariableModMotif) {
            Modification modification5 = this.modificationFactory.getModification(modName);
            String string4 = (String)var6_15 + modification5.getMass() + "@" + modification5.getPattern().getPrositeFormat();
        }
        parametersSection.append("\t<note type=\"input\" label=\"refine, potential modification motif\">").append((String)var6_15).append("</note>").append(System.getProperty("line.separator"));
        parametersSection.append("\t<note>The format of this parameter is similar to residue, modification mass,").append(System.getProperty("line.separator"));
        parametersSection.append("\t\twith the addition of a modified PROSITE notation sequence motif specification.").append(System.getProperty("line.separator"));
        parametersSection.append("\t\tFor example, a value of 80@[ST!]PX[KR] indicates a modification").append(System.getProperty("line.separator"));
        parametersSection.append("\t\tof either S or T when followed by P, and residue and the a K or an R.").append(System.getProperty("line.separator"));
        parametersSection.append("\t\tA value of 204@N!{P}[ST]{P} indicates a modification of N by 204, if it").append(System.getProperty("line.separator"));
        parametersSection.append("\t\tis NOT followed by a P, then either an S or a T, NOT followed by a P.").append(System.getProperty("line.separator"));
        parametersSection.append("\t\tPositive and negative values are allowed.").append(System.getProperty("line.separator"));
        parametersSection.append("\t\t</note>").append(System.getProperty("line.separator"));
        return parametersSection.toString();
    }

    private String getSearchedModList(ArrayList<String> variableModifications, ArrayList<String> fixedModifications) throws IllegalArgumentException {
        String completeModificationString = "";
        String variableModsString = "\t<note type=\"input\" label=\"residue, potential modification mass\">";
        String variableModsDescriptionString = "\t\t<note>";
        HashMap<Character, ArrayList<Modification>> allVariableMods = this.sortModifications(variableModifications);
        HashMap<Character, ArrayList<Modification>> allFixedMods = this.sortModifications(fixedModifications);
        HashMap<Character, ArrayList<Modification>> variableFixedModifications = new HashMap<Character, ArrayList<Modification>>();
        for (Character target : allVariableMods.keySet()) {
            if (allVariableMods.get(target).size() == 1) {
                variableModsString = variableModsString + allVariableMods.get(target).get(0).getMass() + "@" + target + ",";
                variableModsDescriptionString = variableModsDescriptionString + allVariableMods.get(target).get(0).getName() + ",";
                continue;
            }
            variableFixedModifications.put(target, allVariableMods.get(target));
        }
        if (variableModsString.endsWith(",")) {
            variableModsString = variableModsString.substring(0, variableModsString.length() - 1);
            variableModsDescriptionString = variableModsDescriptionString.substring(0, variableModsDescriptionString.length() - 1);
        }
        variableModsString = variableModsString + "</note>" + System.getProperty("line.separator");
        variableModsDescriptionString = variableModsDescriptionString + "</note>" + System.getProperty("line.separator");
        String fixedModsStringTemplate = "\t<note type=\"input\" label=\"residue, modification mass";
        String fixedModsStringDescriptionTemplate = "\t\t<note>";
        String fixedModsString = fixedModsStringTemplate + "\">";
        String fixedModsDescriptionString = fixedModsStringDescriptionTemplate;
        String defaultFixedModsString = "";
        String defaultFixedModsDescription = "";
        for (Character target : allFixedMods.keySet()) {
            if (allFixedMods.get(target).size() == 1) {
                fixedModsString = fixedModsString + allFixedMods.get(target).get(0).getMass() + "@" + target + ",";
                fixedModsDescriptionString = fixedModsDescriptionString + allFixedMods.get(target).get(0).getName() + ",";
                defaultFixedModsString = defaultFixedModsString + allFixedMods.get(target).get(0).getMass() + "@" + target + ",";
                defaultFixedModsDescription = defaultFixedModsDescription + allFixedMods.get(target).get(0).getName() + ",";
                continue;
            }
            throw new IllegalArgumentException("More than one fixed modification with the same target was detected! Target: " + target + ". X!Tandem does not support this. Please replace by a single modification and try again.");
        }
        if (fixedModsString.endsWith(",")) {
            fixedModsString = fixedModsString.substring(0, fixedModsString.length() - 1);
            fixedModsDescriptionString = fixedModsDescriptionString.substring(0, fixedModsDescriptionString.length() - 1);
        }
        fixedModsString = fixedModsString + "</note>" + System.getProperty("line.separator");
        fixedModsDescriptionString = fixedModsDescriptionString + "</note>" + System.getProperty("line.separator");
        completeModificationString = completeModificationString + fixedModsString + fixedModsDescriptionString;
        ArrayList fixedSecondaryLines = new ArrayList();
        ArrayList fixedSecondaryLinesDescription = new ArrayList();
        for (Character target : variableFixedModifications.keySet()) {
            ArrayList<String> newLines = new ArrayList<String>();
            ArrayList<String> newDescriptions = new ArrayList<String>();
            Iterator iterator = ((ArrayList)variableFixedModifications.get(target)).iterator();
            while (iterator.hasNext()) {
                Modification modification;
                Modification currentModification = modification = (Modification)iterator.next();
                String tempModsString = currentModification.getMass() + "@" + target;
                String tempModsStringModsDescriptionString = currentModification.getName();
                newLines.add(defaultFixedModsString + tempModsString);
                newDescriptions.add(defaultFixedModsDescription + tempModsStringModsDescriptionString);
                for (String previousLines : fixedSecondaryLines) {
                    newLines.add(previousLines + "," + tempModsString);
                }
                for (String previousLines : fixedSecondaryLinesDescription) {
                    newDescriptions.add(previousLines + "," + tempModsStringModsDescriptionString);
                }
            }
            fixedSecondaryLines.addAll(newLines);
            fixedSecondaryLinesDescription.addAll(newDescriptions);
        }
        for (int i = 0; i < fixedSecondaryLines.size(); ++i) {
            fixedModsString = fixedModsStringTemplate + " " + (i + 1) + "\">" + (String)fixedSecondaryLines.get(i);
            fixedModsDescriptionString = fixedModsStringDescriptionTemplate + (String)fixedSecondaryLinesDescription.get(i);
            fixedModsString = fixedModsString + "</note>" + System.getProperty("line.separator");
            fixedModsDescriptionString = fixedModsDescriptionString + "</note>" + System.getProperty("line.separator");
            completeModificationString = completeModificationString + fixedModsString + fixedModsDescriptionString;
        }
        completeModificationString = completeModificationString + variableModsString + variableModsDescriptionString;
        return completeModificationString;
    }

    private HashMap<Character, ArrayList<Modification>> sortModifications(ArrayList<String> modifications) {
        HashMap<Character, ArrayList<Modification>> sortedMods = new HashMap<Character, ArrayList<Modification>>();
        for (String name : modifications) {
            AminoAcidPattern aminoAcidPattern;
            Modification modification = this.modificationFactory.getSingleAAModification(name);
            ModificationType modificationType = modification.getModificationType();
            if (modificationType == ModificationType.modn_peptide || modificationType == ModificationType.modnaa_peptide || modificationType == ModificationType.modn_protein || modificationType == ModificationType.modnaa_protein) {
                ArrayList<Modification> modificationList = sortedMods.containsKey(Character.valueOf('[')) ? sortedMods.get(Character.valueOf('[')) : new ArrayList<Modification>();
                modificationList.add(modification);
                sortedMods.put(Character.valueOf('['), modificationList);
            }
            if ((aminoAcidPattern = modification.getPattern()) != null) {
                for (Character aa : aminoAcidPattern.getAminoAcidsAtTarget()) {
                    ArrayList<Object> modificationList = sortedMods.containsKey(aa) ? sortedMods.get(aa) : new ArrayList();
                    modificationList.add(modification);
                    sortedMods.put(aa, modificationList);
                }
            }
            if (modificationType != ModificationType.modc_peptide && modificationType != ModificationType.modcaa_peptide && modificationType != ModificationType.modc_protein && modificationType != ModificationType.modcaa_protein) continue;
            ArrayList<Modification> modificationList = sortedMods.containsKey(Character.valueOf(']')) ? sortedMods.get(Character.valueOf(']')) : new ArrayList<Modification>();
            modificationList.add(modification);
            sortedMods.put(Character.valueOf(']'), modificationList);
        }
        return sortedMods;
    }

    @Override
    public String getType() {
        return "X!Tandem";
    }

    @Override
    public String getCurrentlyProcessedFileName() {
        return this.spectrumFile.getName();
    }

    public String getXSelected() {
        return this.selectedIons.contains(3) ? "yes" : "no";
    }

    public String getYSelected() {
        return this.selectedIons.contains(4) ? "yes" : "no";
    }

    public String getZSelected() {
        return this.selectedIons.contains(5) ? "yes" : "no";
    }

    public String getASelected() {
        return this.selectedIons.contains(0) ? "yes" : "no";
    }

    public String getBSelected() {
        return this.selectedIons.contains(1) ? "yes" : "no";
    }

    public String getCSelected() {
        return this.selectedIons.contains(2) ? "yes" : "no";
    }
}

