/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.archive.dataprovider.file;

public enum ProjectFileType {
    RESULT("RESULT", 1),
    PEAK("PEAK", 2),
    SEARCH("SEARCH", 3),
    RAW("RAW", 4),
    QUANT("QUANT", 5),
    GEL("GEL", 6),
    FASTA("FASTA", 7),
    SPECTRUM_LIBRARY("SPECTRUM_LIBRARY", 8),
    MS_IMAGE_DATA("MS_IMAGE_DATA", 9),
    OPTICAL_IMAGE("OPTICAL_IMAGE", 10),
    OTHER("OTHER", 11);

    private String name;
    private int sortOrder;

    private ProjectFileType(String name, int index) {
        this.name = name;
        this.sortOrder = index;
    }

    public String getName() {
        return this.name;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public static ProjectFileType fromString(String fileType) {
        for (ProjectFileType type : ProjectFileType.values()) {
            if (!type.toString().equalsIgnoreCase(fileType.trim())) continue;
            return type;
        }
        return null;
    }
}

